/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.webserver.iis.IISFormatUtil;
import com.manageengine.ela.server.application.webserver.iis.IISServerInfo;
import com.manageengine.ela.server.application.webserver.iis.constants.IISApplicationConstants;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.schedule.application.webserver.IISScheduler;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.common.util.TimeZoneList;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.elasticsearch.common.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IISUtil {
    public static final Logger LOGGER = Logger.getLogger(IISUtil.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final String FTPSITE = "FTP";
    private static final String WEBSITE = "HTTP";
    private static Pattern dynamicDateFilePatternRegex = Pattern.compile("\\$\\{([^\\{]*)\\}");
    private static Matcher dateMatcher = dynamicDateFilePatternRegex.matcher("");
    private static Pattern dynamicKeywordFilePatternRegex = Pattern.compile("\\$\\{\\{([^\\{]*)\\}\\}");
    private static Matcher keywordMatcher = dynamicKeywordFilePatternRegex.matcher("");

    public static Long getIISDicoveryTimeout() throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().get("SystemConfigurations", new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"IIS_DISCOVERY_TIMEOUT", 0));
        return Long.parseLong((String)dobj.getFirstValue("SystemConfigurations", "CONF_VALUE"));
    }

    public static Properties getSitesProperty(IISServerInfo sites, String deviceName) {
        Properties site = new Properties();
        site.setProperty("SERVER_NAME", deviceName);
        site.setProperty("SITE_NAME", sites.getSiteName());
        String encoding = sites.getIsUtf8() ? "UTF-8" : "ANSI";
        site.setProperty("ENCODING", encoding);
        site.setProperty("SITE_TYPE", sites.getHttp() ? WEBSITE : FTPSITE);
        site.setProperty("SITE_IDENTITY", sites.getSiteId());
        site.setProperty("LOG_FILE_DIRECTORY", sites.getLogFileDirectory());
        site.setProperty("ROTATION_INTERVAL", sites.getLogCollectionPeriod());
        site.setProperty("IS_LOCAL_TIME", sites.getUseLocalTime() ? "true" : "false");
        site.setProperty("IS_HTTP_CUSTOM_FIELDS", sites.isHttpCustomFields() ? "true" : "false");
        site.setProperty("FILE_SIZE", sites.getTruncateSize());
        site.setProperty("FORMAT_NAME", sites.getFormat());
        return site;
    }

    public static Long getAppidFromWebServerId(Long webServerId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("WebServerConfiguration");
            return (Long)row.get("APPID");
        }
        return -1L;
    }

    public static Long getNumberOfDiscoveredSites(Long serverId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"IISDiscoveredSites", (String)"SERVER_ID"), (Object)serverId, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISDiscoveredSites", criteria);
            if (!dataObject.isEmpty()) {
                Long i = 0L;
                Iterator rowIterator = dataObject.getRows("IISDiscoveredSites");
                while (rowIterator.hasNext()) {
                    rowIterator.next();
                    Long l = i;
                    Long l2 = i = Long.valueOf(i + 1L);
                }
                return i;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return 0L;
        }
        return 0L;
    }

    public static Long addDiscoveredIISServer(String deviceName) throws DataAccessException, BaseStatusCode, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADiscoveredIISServers", (String)"SERVER_NAME"), (Object)deviceName, 0);
        DataObject dObj = PERSISTENCELITE.get("ELADiscoveredIISServers", criteria);
        if (!dObj.isEmpty()) {
            Row iisServerRow = dObj.getRow("ELADiscoveredIISServers");
            Long serverID = (Long)iisServerRow.get("SERVER_ID");
            Criteria delCriteria = new Criteria(Column.getColumn((String)"IISDiscoveredSites", (String)"SERVER_ID"), (Object)serverID, 0);
            DBUtil.deleteExistingRows("IISDiscoveredSites", delCriteria, new boolean[0]);
            return serverID;
        }
        Row iisServerRow = new Row("ELADiscoveredIISServers");
        JSONObject json = new JSONObject();
        json.put("DEVICE_NAME", (Object)deviceName);
        json = DeviceUtil.isDeviceDiscovered(json);
        iisServerRow.set("SERVER_NAME", (Object)deviceName);
        if (json.has("DOMAIN_ID")) {
            iisServerRow.set("DOMAIN_ID", json.get("DOMAIN_ID"));
        }
        if (json.has("WORKGROUP_ID")) {
            iisServerRow.set("WORKGROUP_ID", json.get("WORKGROUP_ID"));
        }
        dObj.addRow(iisServerRow);
        PERSISTENCELITE.add(dObj);
        iisServerRow = dObj.getRow("ELADiscoveredIISServers");
        return (Long)iisServerRow.get("SERVER_ID");
    }

    public static Long getServerID(String serverName) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADiscoveredIISServers", (String)"SERVER_NAME"), (Object)serverName, 0);
        try {
            DataObject dObj = PERSISTENCELITE.get("ELADiscoveredIISServers", criteria);
            if (!dObj.isEmpty()) {
                Row row = dObj.getRow("ELADiscoveredIISServers");
                return (Long)row.get("SERVER_ID");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static String getDynamicFileName(String rotationPeriod, boolean isUtf8) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(isUtf8 ? "u_ex" : "ex");
        switch (rotationPeriod) {
            case "Daily": {
                fileName.append("${yy}${MM}${dd}.log");
                break;
            }
            case "Weekly": {
                fileName.append("${yy}${MM}${WW}.log");
                break;
            }
            case "Hourly": {
                fileName.append("${yy}${MM}${dd}${HH}.log");
                break;
            }
            case "Monthly": {
                fileName.append("${yy}${MM}.log");
                break;
            }
            default: {
                return null;
            }
        }
        return fileName.toString();
    }

    public static int getRotationType(String rotationPeriod) {
        switch (rotationPeriod) {
            case "Daily": 
            case "Monthly": 
            case "Weekly": 
            case "Hourly": {
                return 1;
            }
        }
        return 2;
    }

    public static Long getDeviceIDFromAPPID(Long appID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appID, 0);
        DataObject dObj = PERSISTENCELITE.get("AppResources", criteria);
        if (!dObj.isEmpty()) {
            Row appResourceRow = dObj.getRow("AppResources");
            return (Long)appResourceRow.get("HOSTID");
        }
        return -1L;
    }

    public static synchronized Long addAndGetIISAppId(Long deviceId) throws DataAccessException {
        Row row;
        Criteria criteria;
        DataObject dObj;
        if (deviceId == -1L) {
            return null;
        }
        Long formatId = FormatIdentifier.getReportID("iis_w3cweb");
        Long ftpFormatId = FormatIdentifier.getReportID("iis_w3cftp");
        Criteria ftpcriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)deviceId, 0).and(new Criteria(Column.getColumn((String)"AppResources", (String)"FORMATID"), (Object)ftpFormatId, 0));
        DataObject ftpDobj = PERSISTENCELITE.get("AppResources", ftpcriteria);
        if (ftpDobj.isEmpty()) {
            Row row2 = new Row("AppResources");
            row2.set("HOSTID", (Object)deviceId);
            row2.set("FORMATID", (Object)ftpFormatId);
            row2.set("FGROUP", (Object)IISUtil.getReportName(ftpFormatId));
            ftpDobj.addRow(row2);
            PERSISTENCELITE.add(ftpDobj);
        }
        if ((dObj = PERSISTENCELITE.get("AppResources", criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)deviceId, 0).and(new Criteria(Column.getColumn((String)"AppResources", (String)"FORMATID"), (Object)formatId, 0)))).isEmpty()) {
            row = new Row("AppResources");
            row.set("HOSTID", (Object)deviceId);
            row.set("FORMATID", (Object)formatId);
            row.set("FGROUP", (Object)IISUtil.getReportName(formatId));
            row.set("LOG_COLLECTION_STATUS", (Object)IISApplicationConstants.ENABLED);
            dObj.addRow(row);
            PERSISTENCELITE.add(dObj);
        }
        row = dObj.getRow("AppResources");
        return (Long)row.get("APPID");
    }

    public static String getReportName(long formatId) throws DataAccessException {
        Iterator iterator;
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)formatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("FormatDetails", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("FormatDetails")).hasNext()) {
            Row row = (Row)iterator.next();
            String formatName = (String)row.get("FORMATNAME");
            return formatName;
        }
        return "unsupported_apps";
    }

    public static Long getStatus(Long appId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
        DataObject dObj = PERSISTENCELITE.get("AppResources", criteria);
        if (!dObj.isEmpty()) {
            Row row = dObj.getRow("AppResources");
            return (Long)row.get("LOG_COLLECTION_STATUS");
        }
        return IISApplicationConstants.DISABLED;
    }

    public static void setStatus(Long[] appId, boolean status) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 8);
        DataObject dObj = PERSISTENCELITE.get("AppResources", criteria);
        if (!dObj.isEmpty()) {
            Iterator iterator = dObj.getRows("AppResources");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (status) {
                    row.set("LOG_COLLECTION_STATUS", (Object)IISApplicationConstants.ENABLED);
                } else {
                    row.set("LOG_COLLECTION_STATUS", (Object)IISApplicationConstants.DISABLED);
                }
                dObj.updateRow(row);
            }
            PERSISTENCELITE.update(dObj);
        }
    }

    public static JSONArray getSummaryInfo(Long webServerId) throws DataAccessException, JSONException {
        Long appId = IISUtil.addAndGetIISUniqueId(webServerId);
        JSONArray summary = new JSONArray();
        Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"APPID"), (Object)appId, 0);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("IISConfiguredSites", "IISLogFIleInfo", "IISLogAuditDetails"), criteria);
        Iterator iterator = dataObject.getRows("IISLogAuditDetails");
        Iterator siteIterator = dataObject.getRows("IISConfiguredSites");
        for (int i = 0; iterator.hasNext() && i < 4; ++i) {
            JSONObject auditDetails = new JSONObject();
            Row auditRow = (Row)iterator.next();
            Row siteRow = (Row)siteIterator.next();
            auditDetails.put("SITE_NAME", siteRow.get("SITE_NAME"));
            auditDetails.put("START_TIME", auditRow.get("START_TIME"));
            auditDetails.put("END_TIME", auditRow.get("END_TIME"));
            summary.put((Object)auditDetails);
        }
        return summary;
    }

    public static Long addAndGetAuditId(Long fileId, String fileName, Long appId) throws DataAccessException {
        Row auditRow;
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"FILE_ID"), (Object)fileId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        if (dataObject.isEmpty()) {
            auditRow = new Row("IISLogAuditDetails");
            auditRow.set("APPID", (Object)appId);
            auditRow.set("FILE_ID", (Object)fileId);
            auditRow.set("FILE_NAME", (Object)fileName);
            auditRow.set("ALREADY_READ_COUNT", (Object)0L);
            dataObject = PERSISTENCELITE.constructDataObject();
            dataObject.addRow(auditRow);
            PERSISTENCELITE.add(dataObject);
        }
        auditRow = dataObject.getRow("IISLogAuditDetails");
        return (Long)auditRow.get("AUDIT_ID");
    }

    public static Long getAlreadyReadCount(Long auditId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)auditId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Row auditRow = dataObject.getRow("IISLogAuditDetails");
        return (Long)auditRow.get("ALREADY_READ_COUNT");
    }

    public static String getFileName(Long auditId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)auditId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Row auditRow = dataObject.getRow("IISLogAuditDetails");
        return (String)auditRow.get("FILE_NAME");
    }

    public static void setAuditStatus(Long auditId, Long status, boolean updateEndTime) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)auditId, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
            Row auditRow = dataObject.getRow("IISLogAuditDetails");
            auditRow.set("STATUS", (Object)status);
            if (auditRow.get("START_TIME") == null) {
                auditRow.set("START_TIME", (Object)System.currentTimeMillis());
            }
            if (updateEndTime) {
                auditRow.set("END_TIME", (Object)System.currentTimeMillis());
            } else {
                auditRow.set("END_TIME", null);
            }
            dataObject.updateRow(auditRow);
            PERSISTENCELITE.update(dataObject);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static String getHeaderLine(Long auditId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"AUDIT_ID"), (Object)auditId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Row auditRow = dataObject.getRow("IISLogAuditDetails");
        return (String)auditRow.get("HEADER_FIELDS");
    }

    public static Credential getCredential(Long credentialId, Long deviceId) throws DataAccessException {
        try {
            String deviceName = DeviceUtil.getDeviceName(deviceId).getDeviceName();
            if (credentialId == null) {
                Credential credential = DeviceUtil.getDeviceCredential(deviceId);
                if (credential == null || credential.getUserName() == null) {
                    Long domainId = DeviceUtil.getDomainIdFromDeviceName(deviceName);
                    Credential domainCredential = CredentialHandler.getCredentialFromDomainID(domainId);
                    if (domainCredential.getUserName() == null) {
                        return null;
                    }
                    return domainCredential;
                }
                return credential;
            }
            Credential credential = CredentialHandler.getELACredential(credentialId, false);
            String userName = credential.getUserName();
            if (userName != null && !userName.contains("\\") && !userName.contains("@")) {
                userName = deviceName + "\\" + userName;
                String password = credential.getPassword();
                return CredentialHandler.getCustomCredential(userName, password, null, null);
            }
            return credential;
        }
        catch (BaseStatusCode | JSONException e) {
            return null;
        }
    }

    public static Long addSchedule(int monInt, String appId) throws BaseStatusCode {
        try {
            JSONObject request = IISUtil.getScheduleParamsJson(Long.valueOf(monInt), appId);
            DataObject scheduleDataObject = ScheduleUtil.getNewScheduleDO(request, TechnicianUtil.getDefaultAdminUserID(), ResourceBundleMgr.getInstance().getLocale());
            PersistenceDBUtil.getScheduler().updateSchedule(scheduleDataObject);
            return (Long)scheduleDataObject.getFirstValue("ELATableExportSchedules", "SCHEDULE_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(1);
        }
    }

    public static void updateMonitorInterval(JSONObject reqJsonObject, ResponseBuilder response) {
        try {
            int monInt = reqJsonObject.getInt("MONITOR_INTERVAL");
            if (monInt < 10) {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            JSONArray webServerIdJsonArray = reqJsonObject.getJSONArray("SERVER_ID");
            Long[] webServerId = JSONUtil.toLongArray(webServerIdJsonArray);
            Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 8);
            DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
            if (!dataObject.isEmpty()) {
                Iterator webServerConfigRowIterator = dataObject.getRows("WebServerConfiguration");
                ArrayList<Long> scheduleIdList = new ArrayList<Long>();
                while (webServerConfigRowIterator.hasNext()) {
                    Row webServerConfigRow = (Row)webServerConfigRowIterator.next();
                    Long scheduleId = (Long)webServerConfigRow.get("SCHEDULE_ID");
                    scheduleIdList.add(scheduleId);
                    webServerConfigRow.set("MONITOR_INTERVAL", (Object)monInt);
                    dataObject.updateRow(webServerConfigRow);
                }
                PERSISTENCELITE.update(dataObject);
                Long[] scheduleId = scheduleIdList.toArray(new Long[scheduleIdList.size()]);
                Criteria periodicCriteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"), (Object)scheduleId, 8);
                DataObject scheduleDataObject = PERSISTENCELITE.get("ELATableExportSchedules", periodicCriteria);
                if (!scheduleDataObject.isEmpty()) {
                    Iterator scheduleRowIterator = scheduleDataObject.getRows("ELATableExportSchedules");
                    while (scheduleRowIterator.hasNext()) {
                        Row scheduleRow = (Row)scheduleRowIterator.next();
                        Long exportId = (Long)scheduleRow.get("EXPORT_ID");
                        JSONObject request = IISUtil.getScheduleParamsJson(Long.valueOf(monInt), null);
                        request.put("EXPORT_ID", (Object)exportId);
                        DataObject updateDataObject = ScheduleUtil.getUpdatedScheduleDO(request);
                        PersistenceDBUtil.getScheduler().updateSchedule(updateDataObject);
                    }
                    response.setStatus(BaseStatusCode.getBaseStatusCode(0));
                }
            } else {
                response.setStatus(BaseStatusCode.getBaseStatusCode(7428));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(BaseStatusCode.getBaseStatusCode(7938));
        }
    }

    public static void setScheduleTime(Long scheduleId, int monInt) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Task_Input", criteria);
        Row taskInputRow = dataObject.getRow("Task_Input");
        taskInputRow.set("SCHEDULE_TIME", (Object)String.valueOf(System.currentTimeMillis() + (long)(monInt * 60000)));
        dataObject.updateRow(taskInputRow);
        PERSISTENCELITE.update(dataObject);
    }

    public static Long updateAndGetStatus(Long appId) {
        Long status = IISApplicationConstants.ENABLED;
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
        try {
            DataObject dataObject = PERSISTENCELITE.get("AppResources", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AppResources");
                if (row.get("LOG_COLLECTION_STATUS") != null) {
                    status = (Long)row.get("LOG_COLLECTION_STATUS");
                }
                if (status.equals(IISApplicationConstants.ENABLED)) {
                    row.set("LAST_MESSAGE_TIME", (Object)System.currentTimeMillis());
                    dataObject.updateRow(row);
                    PERSISTENCELITE.update(dataObject);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return status;
    }

    public static Long addAndGetWebServerId(Long appId, Credential credential, int monInt, String timeZone, Long credentialSource, boolean createSchedule) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"APPID"), (Object)appId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("WebServerConfiguration");
            if (createSchedule && row.get("SCHEDULE_ID") == null) {
                row.set("SCHEDULE_ID", (Object)IISUtil.addSchedule(monInt, String.valueOf(appId)));
                dataObject.updateRow(row);
                PERSISTENCELITE.update(dataObject);
            }
            return (Long)row.get("WEBSERVER_ID");
        }
        Row row = new Row("WebServerConfiguration");
        row.set("APPID", (Object)appId);
        row.set("MONITOR_INTERVAL", (Object)monInt);
        if (credentialSource.equals(IISApplicationConstants.CONFIGURED_CREDENTIAL)) {
            CredentialHandler.createNewCredentialEntry(credential, false);
            row.set("CREDENTIAL_ID", (Object)credential.getCredentialID());
        }
        if (createSchedule) {
            row.set("SCHEDULE_ID", (Object)IISUtil.addSchedule(monInt, String.valueOf(appId)));
        }
        row.set("TIME_ZONE", (Object)timeZone);
        row.set("CREDENTIAL_SOURCE_ID", (Object)credentialSource);
        dataObject.addRow(row);
        PERSISTENCELITE.add(dataObject);
        row = dataObject.getRow("WebServerConfiguration");
        return (Long)row.get("WEBSERVER_ID");
    }

    public static Long addAndGetWebServerId(Long appId, Credential credential, int monInt, String timeZone, Long credentialSource) throws Exception {
        return IISUtil.addAndGetWebServerId(appId, credential, monInt, timeZone, credentialSource, true);
    }

    public static Long getCredentialIdFromWebServerId(Long webServerId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("WebServerConfiguration");
            return (Long)row.get("CREDENTIAL_ID");
        }
        return null;
    }

    public static String generateNewFileName(String dynamicPattern, String timeZone) throws BaseStatusCode {
        try {
            int count;
            dateMatcher = dateMatcher.reset(dynamicPattern);
            for (count = 0; dateMatcher.find() && count < 100; ++count) {
                String key = dateMatcher.group(1);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(key);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
                String param = simpleDateFormat.format(new Date());
                dynamicPattern = dynamicPattern.replaceAll("\\$\\{" + key + "\\}", param);
                dateMatcher.reset(dynamicPattern);
            }
            if (count >= 100) {
                throw BaseStatusCode.getBaseStatusCode(12035);
            }
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(12035);
        }
        return dynamicPattern;
    }

    public static Long addAndGetIISUniqueId(Long webServerId) throws DataAccessException {
        Row row;
        Criteria criteria = new Criteria(Column.getColumn((String)"IISApplicationInfo", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISApplicationInfo", criteria);
        if (dataObject.isEmpty()) {
            row = new Row("IISApplicationInfo");
            row.set("WEBSERVER_ID", (Object)webServerId);
            row.set("NUMBER_OF_SITES", (Object)0);
            dataObject.addRow(row);
            PERSISTENCELITE.add(dataObject);
        }
        row = dataObject.getRow("IISApplicationInfo");
        return (Long)row.get("UNIQUE_ID");
    }

    public static Long getScheduleIdFromWebServerId(Long webServerId) throws DataAccessException, BaseStatusCode, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("WebServerConfiguration");
            Long scheduleId = (Long)row.get("SCHEDULE_ID");
            if (scheduleId == null) {
                scheduleId = IISUtil.addSchedule(10, String.valueOf(IISUtil.getAppidFromWebServerId(webServerId)));
                row.set("SCHEDULE_ID", (Object)scheduleId);
                dataObject.updateRow(row);
                PERSISTENCELITE.update(dataObject);
            }
            return scheduleId;
        }
        return null;
    }

    public static ArrayList<Long> getDeviceIdArrayFromWebserverIdArray(Long[] webServerIdAraray) throws DataAccessException {
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerIdAraray, 8);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("WebServerConfiguration", "AppResources"), criteria);
        Iterator rows = dataObject.getRows("AppResources");
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            deviceIdList.add((Long)row.get("HOSTID"));
        }
        return deviceIdList;
    }

    public static Long getDeviceIdFromWebserverId(Long webServerId) throws DataAccessException {
        return IISUtil.getDeviceIdArrayFromWebserverIdArray(new Long[]{webServerId}).get(0);
    }

    public static String getFileNameForMaxSize(String directory, Long formatId, String deviceName, Long webServerId) throws DataAccessException {
        Long deviceId = DeviceUtil.getDeviceId(deviceName);
        boolean isLocal = ImportProtocolUtils.isIpAddressLocal(deviceName);
        String fileName = IISFormatUtil.getPrefix(formatId);
        String suffix = IISFormatUtil.getSuffix(formatId);
        Credential credential = IISUtil.getCredential(IISUtil.getCredentialIdFromWebServerId(webServerId), deviceId);
        String offset = "";
        int i = 0;
        if (credential == null || Strings.isNullOrEmpty((String)credential.getUserName())) {
            File file;
            if (!isLocal) {
                directory = "\\\\" + deviceName + "\\" + directory.replaceAll("/", "\\\\").replace(':', '$');
            }
            if ((file = new File(directory)).exists() && file.isDirectory()) {
                String filePath = directory + File.separator + fileName + "0" + suffix;
                filePath = filePath.replaceAll("\\\\", "/");
                file = new File(filePath);
                while (!file.exists()) {
                    offset = String.valueOf(++i) + suffix;
                    filePath = directory + File.separator + fileName + offset;
                    file = new File(filePath);
                    if (i != 99) continue;
                }
                if (file.exists()) {
                    return fileName + offset;
                }
            }
        } else {
            try {
                String deviceIp;
                try {
                    deviceIp = InetAddress.getByName(deviceName).getHostAddress();
                }
                catch (UnknownHostException e) {
                    deviceIp = deviceName;
                }
                String userName = "";
                String password = "";
                String domain = "";
                if (credential != null) {
                    userName = credential.getUserName();
                    password = credential.getPassword();
                }
                if (!Strings.isNullOrEmpty((String)userName) && userName.contains("\\") && !userName.endsWith("\\")) {
                    domain = userName.substring(0, userName.lastIndexOf("\\"));
                    userName = userName.substring(userName.lastIndexOf("\\") + 1);
                } else if (!Strings.isNullOrEmpty((String)userName) && userName.contains("@") && !userName.endsWith("@")) {
                    domain = userName.substring(userName.lastIndexOf("@") + 1);
                    userName = userName.substring(0, userName.lastIndexOf("@"));
                }
                String path = "smb://" + deviceIp + "/" + directory.replace(':', '$').replaceAll("\\\\", "/");
                NtlmPasswordAuthentication passwordAuthentication = new NtlmPasswordAuthentication(domain, userName, password);
                SmbFile file = new SmbFile(path, passwordAuthentication);
                if (file.exists() && file.isDirectory()) {
                    String filePath = path + "/" + fileName + "0" + suffix;
                    file = new SmbFile(filePath, passwordAuthentication);
                    while (!file.exists()) {
                        offset = String.valueOf(++i) + suffix;
                        filePath = path + "/" + fileName + offset;
                        file = new SmbFile(filePath, passwordAuthentication);
                        if (i != 99) continue;
                    }
                    if (file.exists()) {
                        return fileName + offset;
                    }
                }
            }
            catch (MalformedURLException | SmbException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConfigFileExists(String deviceName, String userName, String password) {
        boolean isLocal = ImportProtocolUtils.isIpAddressLocal(deviceName);
        try {
            if (Strings.isNullOrEmpty((String)userName)) {
                FileInputStream reDirectionFile = null;
                if (!isLocal) {
                    reDirectionFile = new FileInputStream("\\\\" + deviceName + "\\" + "C$/Windows/System32/inetsrv/config/redirection.config".replaceAll("/", "\\\\"));
                    String path = IISUtil.getConfigFilePath(reDirectionFile);
                    if (path == null) {
                        File configFile = new File("\\\\" + deviceName + "\\" + "C$/Windows/System32/inetsrv/config/applicationHost.config".replaceAll("/", "\\\\"));
                        return configFile.exists();
                    }
                    path = "\\\\" + deviceName + "\\" + path.replaceAll("/", "\\\\") + "applicationHost.config";
                    File configFile = new File(path.replace(':', '$'));
                    return configFile.exists();
                }
                try {
                    reDirectionFile = new FileInputStream("C$/Windows/System32/inetsrv/config/redirection.config".replace('$', ':'));
                    String path = IISUtil.getConfigFilePath(reDirectionFile);
                    if (path == null) {
                        File configFile = new File("C$/Windows/System32/inetsrv/config/applicationHost.config".replace('$', ':'));
                        boolean bl = configFile.exists();
                        return bl;
                    }
                    path = path.replaceAll("\\\\", "/") + "applicationHost.config";
                    File configFile = new File(path.replace('$', ':'));
                    boolean bl = configFile.exists();
                    return bl;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                finally {
                    try {
                        reDirectionFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String domain = "";
            if (!Strings.isNullOrEmpty((String)userName) && userName.contains("\\") && !userName.endsWith("\\")) {
                domain = userName.substring(0, userName.lastIndexOf("\\"));
                userName = userName.substring(userName.lastIndexOf("\\") + 1);
            } else if (!Strings.isNullOrEmpty((String)userName) && userName.contains("@") && !userName.endsWith("@")) {
                domain = userName.substring(userName.lastIndexOf("@") + 1);
                userName = userName.substring(0, userName.lastIndexOf("@"));
            }
            NtlmPasswordAuthentication passwordAuthentication = new NtlmPasswordAuthentication(domain, userName, password);
            SmbFile reDirectionFile = new SmbFile("smb://" + deviceName + "/" + "C$/Windows/System32/inetsrv/config/redirection.config", passwordAuthentication);
            String path = IISUtil.getConfigFilePath(reDirectionFile.getInputStream());
            if (path == null) {
                SmbFile smbFile = new SmbFile("smb://" + deviceName + "/" + "C$/Windows/System32/inetsrv/config/applicationHost.config", passwordAuthentication);
                return smbFile.exists();
            }
            path = path.replaceAll("\\\\", "/") + "applicationHost.config";
            SmbFile smbFile = new SmbFile("smb://" + deviceName + "/" + path.replace(':', '$'), passwordAuthentication);
            return smbFile.exists();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getConfigFilePath(InputStream inputStream) throws Exception {
        Element element;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("configurationRedirection");
        if (nList.getLength() > 0 && (element = (Element)nList.item(0)).hasAttribute("enabled") && element.getAttribute("enabled").equals("true") && element.hasAttribute("path")) {
            String path = element.getAttribute("path");
            if (path.endsWith("\\") || path.endsWith("/")) {
                return path;
            }
            return path + "\\";
        }
        return null;
    }

    public static Long getNumberOfSites(Long serverId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"IISApplicationInfo", (String)"WEBSERVER_ID"), (Object)serverId, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISApplicationInfo", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("IISApplicationInfo");
                return (Long)row.get("NUMBER_OF_SITES");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static void setNumberOfSites(Long serverId, Long numberOfSites) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISApplicationInfo", (String)"WEBSERVER_ID"), (Object)serverId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISApplicationInfo", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("IISApplicationInfo");
            row.set("NUMBER_OF_SITES", (Object)numberOfSites);
            dataObject.updateRow(row);
            PERSISTENCELITE.update(dataObject);
        }
    }

    public static void getServerDetails(Long serverId, ResponseBuilder responseBuilder) throws DataAccessException, JSONException, BaseStatusCode {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)serverId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        Row webserverRow = dataObject.getRow("WebServerConfiguration");
        Long credentialSource = (Long)webserverRow.get("CREDENTIAL_SOURCE_ID");
        Long appId = (Long)webserverRow.get("APPID");
        Long deviceId = IISUtil.getDeviceIDFromAPPID(appId);
        String deviceName = DeviceUtil.getDeviceName(deviceId).getDeviceName();
        Long domainId = DeviceUtil.getDomainIdFromDeviceName(deviceName);
        JSONObject response = new JSONObject();
        if (credentialSource.equals(IISApplicationConstants.CONFIGURED_CREDENTIAL)) {
            Long credentialId = (Long)webserverRow.get("CREDENTIAL_ID");
            Criteria criteria1 = new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)credentialId, 0);
            DataObject dataObject1 = PERSISTENCELITE.get("ELACredentials", criteria1);
            Row credentialRow = dataObject1.getRow("ELACredentials");
            response.put("USERNAME", credentialRow.get("USERNAME"));
            response.put("IS_DEFAULT_AUTHENTICATION", false);
        } else {
            response.put("IS_DEFAULT_AUTHENTICATION", true);
        }
        response.put("MONITOR_INTERVAL", webserverRow.get("MONITOR_INTERVAL"));
        response.put("DEVICE_NAME", (Object)deviceName);
        String timeZone = IISUtil.getTimeZone(serverId);
        response.put("TIME_ZONE", (Object)timeZone);
        response.put("TIME_ZONE_KEY", IISUtil.getTimeZoneKey(timeZone));
        responseBuilder.setResponse(response);
        Credential deviceCredential = null;
        Credential domainCredential = null;
        Credential credential = null;
        if (deviceId > 0L) {
            credential = deviceCredential = DeviceUtil.getDeviceCredential(deviceId);
        }
        if ((deviceCredential != null && deviceCredential.getUserName() == null || deviceCredential == null) && (domainCredential = CredentialHandler.getCredentialFromDomainID(domainId)).getUserName() != null) {
            credential = domainCredential;
        }
        if (credential != null && credential.getUserName() != null) {
            response.put("AUTH_USERNAME", (Object)credential.getUserName());
            response.put("LOGON_TYPE", 1);
        } else {
            String logOnUserName = System.getProperty("user.name");
            response.put("AUTH_USERNAME", (Object)logOnUserName);
            response.put("LOGON_TYPE", 2);
        }
    }

    public static int getTimeZoneKey(String timeZone) {
        JSONArray tzList = TimeZoneList.getTimeZoneListJsonArray();
        try {
            for (int value = 0; value < tzList.length(); ++value) {
                JSONObject temp = tzList.getJSONObject(value);
                if (!temp.getString("key").equals(timeZone)) continue;
                return value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getTimeZone(Long webServerId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        Row webserverRow = dataObject.getRow("WebServerConfiguration");
        return (String)webserverRow.get("TIME_ZONE");
    }

    public static JSONObject getServerStatus(JSONObject reqJsonObject) throws DataAccessException, JSONException {
        Long[] serverIdList = JSONUtil.toLongArray(reqJsonObject.getJSONArray("WEBSERVER_ID"));
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)serverIdList, 8);
        DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
        JSONArray response = new JSONArray();
        Iterator configIterator = dataObject.getRows("WebServerConfiguration");
        while (configIterator.hasNext()) {
            Row configRow = (Row)configIterator.next();
            JSONObject temp = new JSONObject();
            temp.put("STATUS", (Object)IISUtil.getAuditStatus((Long)configRow.get("APPID")));
            temp.put("LAST_MESSAGE_TIME", (Object)IISUtil.getLastScanTime((Long)configRow.get("APPID")));
            temp.put("WEBSERVER_ID", configRow.get("WEBSERVER_ID"));
            temp.put("SCHEDULE_TIME", IISUtil.getScheduleTime((Long)configRow.get("SCHEDULE_ID")));
            temp.put("LOG_COLLECTION_STATUS", (Object)IISUtil.getStatus((Long)configRow.get("APPID")));
            temp.put("NUMBER_OF_SITES", (Object)IISUtil.getNumberOfSites((Long)configRow.get("WEBSERVER_ID")));
            temp.put("MONITOR_INTERVAL", configRow.get("MONITOR_INTERVAL"));
            response.put((Object)temp);
        }
        JSONObject returnJsonObject = new JSONObject();
        returnJsonObject.put("RESPONSE", (Object)response);
        return returnJsonObject;
    }

    public static Object getScheduleTime(Long scheduleId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Task_Input", criteria);
        if (!dataObject.isEmpty()) {
            Row row = dataObject.getRow("Task_Input");
            Object scheduleTime = row.get("SCHEDULE_TIME");
            try {
                SimpleDateFormat formatSrc = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                SimpleDateFormat formatDest = new SimpleDateFormat("MMM dd yyyy HH:mm");
                return formatDest.format(formatSrc.parse(scheduleTime.toString()));
            }
            catch (Exception e) {
                return scheduleTime;
            }
        }
        return null;
    }

    public static String getLastScanTime(Long appId) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
        DataObject dataObject = PERSISTENCELITE.get("AppResources", criteria);
        Row row = dataObject.getRow("AppResources");
        SimpleDateFormat format = new SimpleDateFormat("MMM dd yyyy HH:mm");
        if (row.get("LAST_MESSAGE_TIME") == null) {
            return null;
        }
        Long timeInMillisec = Long.parseLong((String)row.get("LAST_MESSAGE_TIME"));
        return format.format(new Date(timeInMillisec));
    }

    public static JSONObject getAuditStatus(Long appId) throws DataAccessException, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"APPID"), (Object)appId, 0);
        DataObject dataObject = PERSISTENCELITE.get("IISLogAuditDetails", criteria);
        Iterator iterator = dataObject.getRows("IISLogAuditDetails");
        JSONObject retjson = new JSONObject();
        int i = 0;
        int j = 0;
        while (iterator.hasNext()) {
            Row auditRow = (Row)iterator.next();
            if (auditRow.get("STATUS") == null) {
                ++i;
            } else {
                if ((Long)auditRow.get("STATUS") == 12145L || (Long)auditRow.get("STATUS") == 12194L || (Long)auditRow.get("STATUS") == 12195L) {
                    retjson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_SCANNING);
                    retjson.put("STATUS_MESSAGE", (Object)"ember_scanning");
                    return retjson;
                }
                if ((Long)auditRow.get("STATUS") == 12196L) {
                    ++i;
                }
            }
            ++j;
        }
        if (i == 0) {
            retjson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_FAILED);
            retjson.put("STATUS_MESSAGE", (Object)"ember_failed");
            return retjson;
        }
        if (i == j) {
            retjson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_SUCCESS);
            retjson.put("STATUS_MESSAGE", (Object)"ember_success");
            return retjson;
        }
        retjson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_FAILED);
        retjson.put("STATUS_MESSAGE", (Object)"ember_failed");
        retjson.put("FAILED_SITES", j - i);
        return retjson;
    }

    public static Long getWebserverIdFromDeviceName(String deviceName) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        selectQuery.addJoin(new Join("Hosts", "AppResources", new String[]{"HOST_ID"}, new String[]{"HOSTID"}, 2));
        selectQuery.addJoin(new Join("AppResources", "WebServerConfiguration", new String[]{"APPID"}, new String[]{"APPID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WebServerConfiguration", (String)"*"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)deviceName, 0));
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty() && dataObject.containsTable("WebServerConfiguration")) {
            Row row = dataObject.getRow("WebServerConfiguration");
            return (Long)row.get("WEBSERVER_ID");
        }
        return -1L;
    }

    public static void updateDiscoveryStatus(long b, JSONObject reqJsonObject) {
        try {
            String deviceName = reqJsonObject.optString("DEVICE_NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)"IISDiscoveryStatus", (String)"DEVICE_NAME"), (Object)deviceName, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISDiscoveryStatus", criteria);
            if (dataObject.isEmpty()) {
                Row row = new Row("IISDiscoveryStatus");
                row.set("DEVICE_NAME", (Object)deviceName);
                row.set("DISCOVERY_STATUS", (Object)b);
                dataObject.addRow(row);
                PERSISTENCELITE.add(dataObject);
            } else {
                Row row = dataObject.getRow("IISDiscoveryStatus");
                row.set("DISCOVERY_STATUS", (Object)b);
                dataObject.updateRow(row);
                PERSISTENCELITE.update(dataObject);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getScheduleParamsJson(Long monInt, String uniqueId) throws JSONException {
        JSONObject request = new JSONObject();
        if (uniqueId != null) {
            String scheduleName = "IISSchedule_" + uniqueId;
            request.put("SCHEDULE_DISPLAY_NAME", (Object)scheduleName);
        }
        request.put("SCHEDULE_CLASS", (Object)IISScheduler.class.getCanonicalName());
        JSONObject time = new JSONObject();
        request.put("FREQUENCY", ScheduleUtil.Frequency.EVERY.getValue());
        time.put("EVERY_MINUTES", (Object)monInt);
        time.put("TYPE", 0);
        request.put("TIME", (Object)time);
        return request;
    }

    public static long getDiscoveryStatus(String deviceName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"IISDiscoveryStatus", (String)"DEVICE_NAME"), (Object)deviceName, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISDiscoveryStatus", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("IISDiscoveryStatus");
                return (Long)row.get("DISCOVERY_STATUS");
            }
            return 16145L;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return 16128L;
        }
    }

    public static BaseStatusCode getDiscoveryStatus(JSONObject reqJsonObject) throws DataAccessException, JSONException {
        return BaseStatusCode.getBaseStatusCode(IISUtil.getDiscoveryStatus(reqJsonObject.getString("DEVICE_NAME")));
    }

    public static SelectQuery getDefaultSelectQuery() {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"WebServerConfiguration"));
        selectQuery.addJoin(new Join("WebServerConfiguration", "IISApplicationInfo", new String[]{"WEBSERVER_ID"}, new String[]{"WEBSERVER_ID"}, 2));
        selectQuery.addJoin(new Join("IISApplicationInfo", "IISConfiguredSites", new String[]{"UNIQUE_ID"}, new String[]{"APPID"}, 2));
        selectQuery.addJoin(new Join("IISConfiguredSites", "IISLogFIleInfo", new String[]{"SITE_ID"}, new String[]{"SITE_ID"}, 2));
        selectQuery.addJoin(new Join("IISLogFIleInfo", "ELADynamicPatterns", new String[]{"PATTERN_ID"}, new String[]{"PATTERN_ID"}, 2));
        selectQuery.addJoin(new Join("IISLogFIleInfo", "IISLogAuditDetails", new String[]{"FILE_ID"}, new String[]{"FILE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"WebServerConfiguration", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"IISApplicationInfo", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"IISConfiguredSites", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"IISLogFIleInfo", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELADynamicPatterns", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"IISLogAuditDetails", (String)"*"));
        return selectQuery;
    }

    public static void updateFileInfoAfterTimeZoneUpdate(Long webServerId, String tz) throws DataAccessException, BaseStatusCode {
        SelectQuery selectQuery = IISUtil.getDefaultSelectQuery();
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCELITE.get(selectQuery);
        Iterator filesRowIterator = dataObject.getRows("IISLogFIleInfo");
        Iterator patternsRowIterator = dataObject.getRows("ELADynamicPatterns");
        Iterator auditRowIterator = dataObject.getRows("IISLogAuditDetails");
        while (filesRowIterator.hasNext() && patternsRowIterator.hasNext()) {
            Row filesRow = (Row)filesRowIterator.next();
            Row patternsRow = (Row)patternsRowIterator.next();
            Row auditRow = (Row)auditRowIterator.next();
            Long rotationType = (Long)filesRow.get("ROTATION_TYPE");
            if (rotationType != 1L) continue;
            String dynamicPattern = (String)patternsRow.get("DYNAMIC_PATTERN");
            String newFileName = IISUtil.generateNewFileName(dynamicPattern, tz);
            filesRow.set("FILE_NAME", (Object)newFileName);
            auditRow.set("FILE_NAME", (Object)newFileName);
            auditRow.set("ALREADY_READ_COUNT", (Object)0);
            dataObject.updateRow(filesRow);
            dataObject.updateRow(auditRow);
        }
        PERSISTENCELITE.update(dataObject);
    }
}

