/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.webserver.iis.IISFormatUtil;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.constants.IISApplicationConstants;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.schedule.application.webserver.IISScheduler;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Logger;
import jcifs.smb.SmbException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IISConfigHandler {
    public static final Logger LOGGER = Logger.getLogger(IISConfigHandler.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public static void addNewIISServer(JSONObject reqJsonObject, ResponseBuilder response) throws Exception {
        try {
            Credential credential;
            Long credentialSource;
            String deviceName = reqJsonObject.getString("DEVICE_NAME");
            Long deviceStatus = Long.parseLong(reqJsonObject.getString("DEVICE_STATUS"), 16);
            Long deviceID = DeviceUtil.addAndGetDeviceId(deviceName, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
            if (deviceStatus == 0L) {
                AddOrUpdateEventlogDevice.enableOrDisableDevice(new Long[]{deviceID}, LogCollectionStatus.DISABLED.getStatus(), ResourceBundleMgr.getInstance().getServerLocale());
            }
            int monInt = reqJsonObject.getInt("MONITOR_INTERVAL");
            String timeZone = reqJsonObject.getString("TIMEZONE");
            boolean isDefaultAuthentication = reqJsonObject.getBoolean("IS_DEFAULT_AUTHENTICATION");
            if (!isDefaultAuthentication) {
                credentialSource = IISApplicationConstants.CONFIGURED_CREDENTIAL;
                String username = reqJsonObject.getString("USERNAME");
                String password = reqJsonObject.getString("PASSWORD");
                credential = CredentialHandler.getCustomCredential(username, password, null, null);
            } else {
                credential = DeviceUtil.getDeviceCredential(deviceID);
                credentialSource = credential == null || credential.getUserName() == null ? IISApplicationConstants.LOGON_CREDENTIAL : IISApplicationConstants.DEVICE_CREDENTIAL;
            }
            Long appId = IISUtil.addAndGetIISAppId(deviceID);
            Long webServerId = IISUtil.addAndGetWebServerId(appId, credential, monInt, timeZone, credentialSource);
            Long uID = IISUtil.addAndGetIISUniqueId(webServerId);
            IISConfigHandler.configureSitesInfo(reqJsonObject, response, uID, webServerId);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(BaseStatusCode.getBaseStatusCode(7937));
        }
    }

    public static void deleteIISServer(JSONArray webServerIdArray, ResponseBuilder response) {
        try {
            Long[] webServerIdList = JSONUtil.toLongArray(webServerIdArray);
            Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerIdList, 8);
            DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("WebServerConfiguration", "AppResources"), criteria);
            JSONArray scheduleIdList = new JSONArray();
            ArrayList<Long> hostIdList = new ArrayList<Long>();
            ArrayList<String> hostNameList = new ArrayList<String>();
            Iterator iterator = dataObject.getRows("WebServerConfiguration");
            Iterator appResIterator = dataObject.getRows("AppResources");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Row appResRow = (Row)appResIterator.next();
                Long scheduleId = (Long)row.get("SCHEDULE_ID");
                if (scheduleId != null) {
                    scheduleIdList.put((Object)scheduleId);
                }
                hostIdList.add((Long)appResRow.get("HOSTID"));
                hostNameList.add(DeviceUtil.getDeviceName((Long)appResRow.get("HOSTID")).getDeviceName());
            }
            Criteria delCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{"iis_w3cftp", "iis_w3cweb", "iis"}, 8);
            delCriteria = delCriteria.and(new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)hostIdList.toArray(), 8));
            Criteria discoveryDelCrit = new Criteria(Column.getColumn((String)"ELADiscoveredIISServers", (String)"SERVER_NAME"), (Object)hostNameList.toArray(), 8);
            Criteria statusDelCrit = new Criteria(Column.getColumn((String)"IISDiscoveryStatus", (String)"DEVICE_NAME"), (Object)hostNameList.toArray(), 8);
            DBUtil.deleteExistingRows("WebServerConfiguration", criteria, new boolean[0]);
            DBUtil.deleteExistingRows("AppResources", delCriteria, new boolean[0]);
            DBUtil.deleteExistingRows("ELADiscoveredIISServers", discoveryDelCrit, new boolean[0]);
            DBUtil.deleteExistingRows("IISDiscoveryStatus", statusDelCrit, new boolean[0]);
            if (scheduleIdList.length() > 0) {
                ScheduleUtil.deleteSchedule(scheduleIdList);
            }
            response.setStatus(BaseStatusCode.getBaseStatusCode(0));
        }
        catch (Exception e) {
            response.setStatus(BaseStatusCode.getBaseStatusCode(7939));
            e.printStackTrace();
        }
    }

    public static void updateIISServer(JSONObject reqJsonObject, ResponseBuilder response) {
        try {
            Criteria criteria1;
            DataObject dataObject1;
            Long webServerId = reqJsonObject.getLong("WEBSERVER_ID");
            String timeZone = reqJsonObject.getString("TIMEZONE");
            boolean isDefaultAuthentication = reqJsonObject.getBoolean("IS_DEFAULT_AUTHENTICATION");
            Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
            DataObject dataObject = PERSISTENCELITE.get("WebServerConfiguration", criteria);
            Row webserverRow = dataObject.getRow("WebServerConfiguration");
            Long credentialId = (Long)webserverRow.get("CREDENTIAL_ID");
            if (!isDefaultAuthentication) {
                Credential credential;
                String userName = reqJsonObject.getString("USERNAME");
                String password = reqJsonObject.getString("PASSWORD");
                webserverRow.set("CREDENTIAL_SOURCE_ID", (Object)IISApplicationConstants.CONFIGURED_CREDENTIAL);
                if (credentialId != null) {
                    credential = CredentialHandler.getCustomCredential(userName, EnDecryptImplSingleton.getInstance().encrypt(password), null, null);
                    credential.setCredentialID(credentialId);
                    CredentialHandler.updateCredentialEntry(credential);
                } else {
                    credential = CredentialHandler.getCustomCredential(userName, password, null, null);
                    CredentialHandler.createNewCredentialEntry(credential, false);
                }
                credentialId = credential.getCredentialID();
                webserverRow.set("CREDENTIAL_ID", (Object)credentialId);
            } else {
                webserverRow.set("CREDENTIAL_SOURCE_ID", (Object)IISApplicationConstants.DEVICE_CREDENTIAL);
                webserverRow.set("CREDENTIAL_ID", null);
                dataObject.updateRow(webserverRow);
                PERSISTENCELITE.update(dataObject);
                if (credentialId != null) {
                    DBUtil.deleteExistingRows("ELACredentials", new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)credentialId, 0), new boolean[0]);
                }
            }
            Long monInt = reqJsonObject.getLong("MONITOR_INTERVAL");
            Long scheduleId = (Long)webserverRow.get("SCHEDULE_ID");
            if (scheduleId != null && !(dataObject1 = PERSISTENCELITE.get("ELATableExportSchedules", criteria1 = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"), (Object)scheduleId, 0))).isEmpty()) {
                Row periodicRow = dataObject1.getRow("ELATableExportSchedules");
                Long exportId = (Long)periodicRow.get("EXPORT_ID");
                JSONObject request = IISUtil.getScheduleParamsJson(monInt, null);
                request.put("EXPORT_ID", (Object)exportId);
                DataObject updateDataObject = ScheduleUtil.getUpdatedScheduleDO(request);
                PersistenceDBUtil.getScheduler().updateSchedule(updateDataObject);
            }
            webserverRow.set("TIME_ZONE", (Object)timeZone);
            webserverRow.set("MONITOR_INTERVAL", (Object)monInt);
            dataObject.updateRow(webserverRow);
            IISUtil.updateFileInfoAfterTimeZoneUpdate(webServerId, timeZone);
            PERSISTENCELITE.update(dataObject);
        }
        catch (Exception e) {
            response.setStatus(BaseStatusCode.getBaseStatusCode(7938));
            e.printStackTrace();
        }
    }

    public static synchronized void configureSitesInfo(JSONObject reqJsonObject, ResponseBuilder response, Long appId, Long webServerId, boolean executeScheduleNow) throws Exception {
        Long scheduleId = IISUtil.getScheduleIdFromWebServerId(webServerId);
        JSONArray siteDetails = reqJsonObject.getJSONArray("SITE_DETAILS");
        long duplicate = 0L;
        Long numberOfSites = IISUtil.getNumberOfSites(webServerId);
        String tz = IISUtil.getTimeZone(webServerId);
        Long iisAppId = IISUtil.getAppidFromWebServerId(webServerId);
        String deviceName = reqJsonObject.getString("DEVICE_NAME");
        if (deviceName.equalsIgnoreCase(InetAddress.getLoopbackAddress().getHostName()) || deviceName.equals(InetAddress.getLoopbackAddress().getHostAddress())) {
            deviceName = InetAddress.getLocalHost().getHostName();
        }
        try {
            DataObject dataObject = PERSISTENCELITE.constructDataObject();
            for (int i = 0; i < siteDetails.length(); ++i) {
                try {
                    JSONObject site = siteDetails.getJSONObject(i);
                    Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"APPID"), (Object)appId, 0).and(new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_NAME"), (Object)site.getString("SITE_NAME"), 0)).and(new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_TYPE"), (Object)site.getString("SITE_TYPE"), 0));
                    if (PERSISTENCELITE.get("IISConfiguredSites", criteria).isEmpty()) {
                        String fileName;
                        String pattern;
                        TimeZone timeZone;
                        Row iisSiteConfigRow = new Row("IISConfiguredSites");
                        Row iisFileConfigRow = new Row("IISLogFIleInfo");
                        Row iisFileAuditRow = new Row("IISLogAuditDetails");
                        int roationType = IISUtil.getRotationType(site.getString("ROLLOVER"));
                        String encoding = site.getString("ENCODING");
                        String format = site.has("FORMAT_NAME") ? site.getString("FORMAT_NAME") : "W3C";
                        boolean isHttpCustomFields = site.has("IS_HTTP_CUSTOM_FIELDS") && site.getBoolean("IS_HTTP_CUSTOM_FIELDS");
                        Long formatId = IISFormatUtil.getIISFormatId(encoding, roationType, format, isHttpCustomFields);
                        TimeZone timeZone2 = timeZone = site.getBoolean("USE_LOCAL_TIME") ? TimeZone.getTimeZone(tz) : TimeZone.getTimeZone("UTC");
                        if (roationType == 1) {
                            pattern = IISFormatUtil.getFilePattern(formatId, site.getString("ROLLOVER"));
                            fileName = IISUtil.generateNewFileName(pattern, timeZone.getID());
                        } else {
                            pattern = IISFormatUtil.getFilePattern(formatId, site.getString("ROLLOVER"));
                            fileName = IISUtil.getFileNameForMaxSize(site.getString("DIRECTORY"), formatId, deviceName, webServerId);
                            if (fileName == null) {
                                fileName = IISFormatUtil.getDefaultFileNameForFileSizeRollover(formatId);
                            }
                            if (site.has("MAX_FILE_SIZE")) {
                                iisFileConfigRow.set("FILE_SIZE", site.get("MAX_FILE_SIZE"));
                            } else {
                                iisFileConfigRow.set("FILE_SIZE", (Object)0xFFFFFFFFL);
                            }
                        }
                        DataObject patternDataObject = PERSISTENCELITE.constructDataObject();
                        DynamicPattern dynamicPattern = new DynamicPattern(pattern, timeZone);
                        Row dynamicPatternRow = new Row("ELADynamicPatterns");
                        dynamicPatternRow.set("RESOLVER_ID", (Object)PatternUtils.getDynamicPatternResolverId(dynamicPattern.getDynamicPattern()));
                        dynamicPatternRow.set("DYNAMIC_PATTERN", (Object)dynamicPattern.getDynamicPattern());
                        dynamicPatternRow.set("TIME_ZONE", (Object)dynamicPattern.getTimeZone().getID());
                        patternDataObject.addRow(dynamicPatternRow);
                        PERSISTENCELITE.update(patternDataObject);
                        dynamicPatternRow = patternDataObject.getRow("ELADynamicPatterns");
                        Long patternId = (Long)dynamicPatternRow.get("PATTERN_ID");
                        iisSiteConfigRow.set("APPID", (Object)appId);
                        iisSiteConfigRow.set("SITE_NAME", (Object)site.getString("SITE_NAME"));
                        iisSiteConfigRow.set("SITE_TYPE", (Object)site.getString("SITE_TYPE"));
                        iisSiteConfigRow.set("STATUS", (Object)IISUtil.getStatus(iisAppId));
                        iisFileConfigRow.set("DIRECTORY", (Object)site.getString("DIRECTORY"));
                        iisFileConfigRow.set("PATTERN_ID", (Object)patternId);
                        iisFileConfigRow.set("FILE_NAME", (Object)fileName);
                        iisFileConfigRow.set("USE_LOCAL_TIME", (Object)site.getBoolean("USE_LOCAL_TIME"));
                        iisFileConfigRow.set("SITE_ID", iisSiteConfigRow.get("SITE_ID"));
                        iisFileConfigRow.set("ROTATION_TYPE", (Object)roationType);
                        iisFileConfigRow.set("ENCODING", (Object)site.getString("ENCODING"));
                        iisFileConfigRow.set("ROLL_OVER", (Object)site.getString("ROLLOVER"));
                        iisFileConfigRow.set("FORMAT_ID", (Object)formatId);
                        iisFileAuditRow.set("FILE_ID", iisFileConfigRow.get("FILE_ID"));
                        iisFileAuditRow.set("FILE_NAME", (Object)fileName);
                        iisFileAuditRow.set("APPID", (Object)iisAppId);
                        iisFileAuditRow.set("ALREADY_READ_COUNT", (Object)0L);
                        dataObject.addRow(iisSiteConfigRow);
                        dataObject.addRow(iisFileConfigRow);
                        dataObject.addRow(iisFileAuditRow);
                        Long l = numberOfSites;
                        Long l2 = numberOfSites = Long.valueOf(numberOfSites + 1L);
                        continue;
                    }
                    ++duplicate;
                    continue;
                }
                catch (DataAccessException e) {
                    response.setStatus(BaseStatusCode.getBaseStatusCode(16136));
                }
            }
            if (duplicate > 0L && duplicate == (long)siteDetails.length()) {
                throw BaseStatusCode.getBaseStatusCode(7937);
            }
            IISUtil.setNumberOfSites(webServerId, numberOfSites);
            PERSISTENCELITE.add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(BaseStatusCode.getBaseStatusCode(16135L));
        }
        if (executeScheduleNow) {
            new IISScheduler().executeSchedule(scheduleId);
        }
    }

    public static void configureSitesInfo(JSONObject reqJsonObject, ResponseBuilder response, Long appId, Long webServerId) throws Exception {
        IISConfigHandler.configureSitesInfo(reqJsonObject, response, appId, webServerId, true);
    }

    public static void deleteSite(Long siteId, Long webServerId, ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_ID"), (Object)siteId, 0);
        Long numberOfSites = IISUtil.getNumberOfSites(webServerId);
        DBUtil.deleteExistingRows("IISConfiguredSites", criteria, new boolean[0]);
        Long l = numberOfSites;
        Long l2 = numberOfSites = Long.valueOf(numberOfSites - 1L);
        if (numberOfSites == 0L) {
            Criteria criteria1 = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerId, 0);
            DataObject delDobj = PERSISTENCELITE.get(Arrays.asList("WebServerConfiguration", "AppResources"), criteria1);
            Row delRow = delDobj.getRow("WebServerConfiguration");
            Long scheduleId = (Long)delRow.get("SCHEDULE_ID");
            JSONArray scheduleIdList = new JSONArray();
            scheduleIdList.put((Object)scheduleId);
            Row appResRow = delDobj.getRow("AppResources");
            appResRow.set("LAST_MESSAGE_TIME", null);
            appResRow.set("LOG_COLLECTION_STATUS", (Object)IISApplicationConstants.ENABLED);
            delRow.set("SCHEDULE_ID", null);
            delDobj.updateRow(delRow);
            delDobj.updateRow(appResRow);
            PERSISTENCELITE.update(delDobj);
            ScheduleUtil.deleteSchedule(scheduleIdList);
        }
        IISUtil.setNumberOfSites(webServerId, numberOfSites);
        responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(0));
        responseBuilder.setResponse(numberOfSites);
    }

    public static void enableOrdisableIISServer(JSONArray webServerIdArray, ResponseBuilder response, boolean status) throws JSONException {
        Long[] webServerIdList = JSONUtil.toLongArray(webServerIdArray);
        Criteria criteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)webServerIdList, 8);
        try {
            DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("WebServerConfiguration", "IISApplicationInfo", "IISConfiguredSites"), criteria);
            Iterator webServerIdIterator = dataObject.getRows("WebServerConfiguration");
            Iterator configuredSitesIterator = dataObject.getRows("IISConfiguredSites");
            ArrayList<Long> appIdList = new ArrayList<Long>();
            while (webServerIdIterator.hasNext()) {
                Row webServerConfigRow = (Row)webServerIdIterator.next();
                Long appId = (Long)webServerConfigRow.get("APPID");
                appIdList.add(appId);
            }
            while (configuredSitesIterator.hasNext()) {
                Row configuredSitesRow = (Row)configuredSitesIterator.next();
                configuredSitesRow.set("STATUS", (Object)status);
                dataObject.updateRow(configuredSitesRow);
            }
            PERSISTENCELITE.update(dataObject);
            IISUtil.setStatus(appIdList.toArray(new Long[appIdList.size()]), status);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            response.setStatus(BaseStatusCode.getBaseStatusCode(1));
        }
    }

    public static synchronized void updateSiteDetails(JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws DataAccessException, JSONException, BaseStatusCode, MalformedURLException, SmbException {
        Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_ID"), (Object)reqJsonObject.getLong("SITE_ID"), 0);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("IISConfiguredSites", "IISLogFIleInfo"), criteria);
        String deviceName = reqJsonObject.getString("DEVICE_NAME");
        Long webServerId = reqJsonObject.getLong("WEBSERVER_ID");
        if (!dataObject.isEmpty()) {
            String fileName;
            String dynamicPattern;
            String timeZone;
            Row sitesRow = dataObject.getRow("IISConfiguredSites");
            Row filesRow = dataObject.getRow("IISLogFIleInfo");
            Long fileId = (Long)filesRow.get("FILE_ID");
            Criteria delCrit = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"FILE_ID"), (Object)fileId, 0);
            DataObject auditDobj = PERSISTENCELITE.get("IISLogAuditDetails", delCrit);
            Row auditRow = auditDobj.getRow("IISLogAuditDetails");
            String oldFileName = (String)auditRow.get("FILE_NAME");
            String oldDirectory = (String)filesRow.get("DIRECTORY");
            Long alreadyReadCount = (Long)auditRow.get("ALREADY_READ_COUNT");
            if (alreadyReadCount == null) {
                alreadyReadCount = 0L;
            }
            sitesRow.set("SITE_TYPE", reqJsonObject.get("SITE_TYPE"));
            filesRow.set("DIRECTORY", reqJsonObject.get("DIRECTORY"));
            int roationType = IISUtil.getRotationType(reqJsonObject.getString("ROLLOVER"));
            String format = reqJsonObject.has("FORMAT_NAME") ? reqJsonObject.getString("FORMAT_NAME") : "W3C";
            String encoding = reqJsonObject.getString("ENCODING");
            boolean isHttpCustomFields = reqJsonObject.has("IS_HTTP_CUSTOM_FIELDS") && reqJsonObject.getBoolean("IS_HTTP_CUSTOM_FIELDS");
            Long formatId = IISFormatUtil.getIISFormatId(encoding, roationType, format, isHttpCustomFields);
            String string = timeZone = reqJsonObject.getBoolean("USE_LOCAL_TIME") ? IISUtil.getTimeZone(webServerId) : "UTC";
            if (roationType == 1) {
                dynamicPattern = IISFormatUtil.getFilePattern(formatId, reqJsonObject.getString("ROLLOVER"));
                fileName = IISUtil.generateNewFileName(dynamicPattern, timeZone);
                if (!oldDirectory.equals(reqJsonObject.get("DIRECTORY")) || !oldFileName.equals(fileName)) {
                    alreadyReadCount = 0L;
                }
            } else {
                dynamicPattern = IISFormatUtil.getFilePattern(formatId, reqJsonObject.getString("ROLLOVER"));
                if (roationType == ((Long)filesRow.get("ROTATION_TYPE")).intValue() && encoding.equals(filesRow.get("ENCODING")) && oldDirectory.equals(reqJsonObject.get("DIRECTORY"))) {
                    fileName = oldFileName;
                } else {
                    fileName = IISUtil.getFileNameForMaxSize(reqJsonObject.getString("DIRECTORY"), formatId, deviceName, webServerId);
                    alreadyReadCount = 0L;
                }
                if (fileName == null) {
                    fileName = IISFormatUtil.getDefaultFileNameForFileSizeRollover(formatId);
                }
                if (reqJsonObject.has("MAX_FILE_SIZE")) {
                    filesRow.set("FILE_SIZE", reqJsonObject.get("MAX_FILE_SIZE"));
                } else {
                    filesRow.set("FILE_SIZE", (Object)IISApplicationConstants.MAX_FILE_SIZE);
                }
            }
            auditRow.set("FILE_NAME", (Object)fileName);
            auditRow.set("ALREADY_READ_COUNT", (Object)alreadyReadCount);
            auditDobj.updateRow(auditRow);
            PERSISTENCELITE.update(auditDobj);
            filesRow.set("ROTATION_TYPE", (Object)roationType);
            filesRow.set("ROLL_OVER", (Object)reqJsonObject.getString("ROLLOVER"));
            filesRow.set("ENCODING", (Object)reqJsonObject.getString("ENCODING"));
            filesRow.set("FORMAT_ID", (Object)formatId);
            Long patternId = (Long)filesRow.get("PATTERN_ID");
            Criteria patternCriteria = new Criteria(Column.getColumn((String)"ELADynamicPatterns", (String)"PATTERN_ID"), (Object)patternId, 0);
            DataObject dataObject1 = PERSISTENCELITE.get("ELADynamicPatterns", patternCriteria);
            Row patternRow = dataObject1.getRow("ELADynamicPatterns");
            patternRow.set("DYNAMIC_PATTERN", (Object)dynamicPattern);
            patternRow.set("RESOLVER_ID", (Object)PatternUtils.getDynamicPatternResolverId(dynamicPattern));
            dataObject1.updateRow(patternRow);
            PERSISTENCELITE.update(dataObject1);
            filesRow.set("FILE_NAME", (Object)fileName);
            filesRow.set("USE_LOCAL_TIME", reqJsonObject.get("USE_LOCAL_TIME"));
            dataObject.updateRow(filesRow);
            dataObject.updateRow(sitesRow);
            PERSISTENCELITE.update(dataObject);
            responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(0));
        } else {
            responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(7938));
        }
    }

    public static synchronized void addDiscoveredSites(JSONObject reqJsonObject, boolean executeScheduleNow) throws JSONException, DataAccessException, BaseStatusCode, SmbException, MalformedURLException, IllegalAccessException {
        Long[] siteIdList = JSONUtil.toLongArray(reqJsonObject.getJSONArray("SITE_LIST"));
        Criteria criteria = new Criteria(Column.getColumn((String)"IISDiscoveredSites", (String)"SITE_ID"), (Object)siteIdList, 8);
        Long webServerId = reqJsonObject.getLong("WEBSERVER_ID");
        Long scheduleId = IISUtil.getScheduleIdFromWebServerId(webServerId);
        Long numberOfSites = IISUtil.getNumberOfSites(webServerId);
        Long appId = IISUtil.addAndGetIISUniqueId(webServerId);
        Long iisAppId = IISUtil.getAppidFromWebServerId(webServerId);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("IISDiscoveredSites", "IISDiscoveredFilesInfo"), criteria);
        DataObject confDataObject = PERSISTENCELITE.constructDataObject();
        Iterator iisSitesRowIterator = dataObject.getRows("IISDiscoveredSites");
        Iterator iisFilesRowIterator = dataObject.getRows("IISDiscoveredFilesInfo");
        while (iisSitesRowIterator.hasNext()) {
            String fileName;
            String pattern;
            String timeZone;
            Row iisSitesRow = (Row)iisSitesRowIterator.next();
            Row iisFilesRow = (Row)iisFilesRowIterator.next();
            Criteria crit = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"APPID"), (Object)appId, 0).and(new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_NAME"), iisSitesRow.get("SITE_NAME"), 0)).and(new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"SITE_TYPE"), iisSitesRow.get("SITE_TYPE"), 0));
            DataObject dObj = PERSISTENCELITE.get("IISConfiguredSites", crit);
            if (!dObj.isEmpty()) continue;
            Row iisSiteconfRow = new Row("IISConfiguredSites");
            Row iisFileconfRow = new Row("IISLogFIleInfo");
            Row iisAuditRow = new Row("IISLogAuditDetails");
            int roationType = IISUtil.getRotationType((String)iisFilesRow.get("ROLL_OVER"));
            String format = (String)iisFilesRow.get("FORMAT_NAME");
            String encoding = (String)iisFilesRow.get("ENCODING");
            boolean isHttpCustomFields = (Boolean)iisFilesRow.get("IS_HTTP_CUSTOM_FIELDS");
            Long formatId = IISFormatUtil.getIISFormatId(encoding, roationType, format, isHttpCustomFields);
            String string = timeZone = (Boolean)iisFilesRow.get("USE_LOCAL_TIME") != false ? IISUtil.getTimeZone(webServerId) : "UTC";
            if (roationType == 1) {
                pattern = IISFormatUtil.getFilePattern(formatId, (String)iisFilesRow.get("ROLL_OVER"));
                fileName = IISUtil.generateNewFileName(pattern, timeZone);
            } else {
                pattern = IISFormatUtil.getFilePattern(formatId, (String)iisFilesRow.get("ROLL_OVER"));
                fileName = IISUtil.getFileNameForMaxSize((String)iisFilesRow.get("DIRECTORY"), formatId, reqJsonObject.getString("DEVICE_NAME"), webServerId);
                if (fileName == null) {
                    fileName = IISFormatUtil.getDefaultFileNameForFileSizeRollover(formatId);
                }
                iisFileconfRow.set("FILE_SIZE", iisFilesRow.get("FILE_SIZE"));
            }
            DataObject patternDataObject = PERSISTENCELITE.constructDataObject();
            DynamicPattern dynamicPattern = new DynamicPattern(pattern, TimeZone.getTimeZone(timeZone));
            Row dynamicPatternRow = new Row("ELADynamicPatterns");
            dynamicPatternRow.set("RESOLVER_ID", (Object)PatternUtils.getDynamicPatternResolverId(dynamicPattern.getDynamicPattern()));
            dynamicPatternRow.set("DYNAMIC_PATTERN", (Object)dynamicPattern.getDynamicPattern());
            dynamicPatternRow.set("TIME_ZONE", (Object)dynamicPattern.getTimeZone().getID());
            patternDataObject.addRow(dynamicPatternRow);
            PERSISTENCELITE.update(patternDataObject);
            dynamicPatternRow = patternDataObject.getRow("ELADynamicPatterns");
            Long patternId = (Long)dynamicPatternRow.get("PATTERN_ID");
            iisSiteconfRow.set("APPID", (Object)appId);
            iisSiteconfRow.set("SITE_NAME", iisSitesRow.get("SITE_NAME"));
            iisSiteconfRow.set("SITE_TYPE", iisSitesRow.get("SITE_TYPE"));
            iisSiteconfRow.set("STATUS", (Object)IISUtil.getStatus(iisAppId));
            iisFileconfRow.set("DIRECTORY", iisFilesRow.get("DIRECTORY"));
            iisFileconfRow.set("PATTERN_ID", (Object)patternId);
            iisFileconfRow.set("FILE_NAME", (Object)fileName);
            iisFileconfRow.set("USE_LOCAL_TIME", iisFilesRow.get("USE_LOCAL_TIME"));
            iisFileconfRow.set("SITE_ID", iisSiteconfRow.get("SITE_ID"));
            iisFileconfRow.set("ROTATION_TYPE", (Object)roationType);
            iisFileconfRow.set("ENCODING", iisFilesRow.get("ENCODING"));
            iisFileconfRow.set("ROLL_OVER", iisFilesRow.get("ROLL_OVER"));
            iisFileconfRow.set("FORMAT_ID", (Object)formatId);
            iisAuditRow.set("FILE_ID", iisFileconfRow.get("FILE_ID"));
            iisAuditRow.set("APPID", (Object)iisAppId);
            iisAuditRow.set("FILE_NAME", (Object)fileName);
            iisAuditRow.set("ALREADY_READ_COUNT", (Object)0L);
            confDataObject.addRow(iisSiteconfRow);
            confDataObject.addRow(iisFileconfRow);
            confDataObject.addRow(iisAuditRow);
            Long l = numberOfSites;
            Long l2 = numberOfSites = Long.valueOf(numberOfSites + 1L);
        }
        PERSISTENCELITE.add(confDataObject);
        IISUtil.setNumberOfSites(webServerId, numberOfSites);
        if (executeScheduleNow) {
            new IISScheduler().executeSchedule(scheduleId);
        }
    }

    public static synchronized void addDiscoveredSites(JSONObject reqJsonObject) throws JSONException, DataAccessException, BaseStatusCode, SmbException, MalformedURLException, IllegalAccessException {
        IISConfigHandler.addDiscoveredSites(reqJsonObject, false);
    }

    public static void handleIISImport(Long deviceId) {
        try {
            String timeZone = TimeZone.getDefault().getID();
            int monInt = 10;
            Long appId = IISUtil.addAndGetIISAppId(deviceId);
            Long webServerId = IISUtil.addAndGetWebServerId(appId, null, monInt, timeZone, IISApplicationConstants.DEVICE_CREDENTIAL, false);
            Long uniqueId = IISUtil.addAndGetIISUniqueId(webServerId);
            Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
            DataObject dataObject = PERSISTENCELITE.get("AppResources", criteria);
            Row appResRow = dataObject.getRow("AppResources");
            appResRow.set("LAST_MESSAGE_TIME", (Object)System.currentTimeMillis());
            appResRow.set("LOG_COLLECTION_STATUS", (Object)IISApplicationConstants.ENABLED);
            dataObject.updateRow(appResRow);
            PERSISTENCELITE.update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

