/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.discovery;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.constants.IISApplicationConstants;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscoveryListener;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscoveryManager;
import com.manageengine.ela.server.application.webserver.iis.discovery.JDKIISDiscoveryHandler;
import com.manageengine.ela.server.application.webserver.iis.discovery.NativeIISDiscoveryHandler;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class IISDiscoveryHandler {
    public static final Logger LOGGER = Logger.getLogger(IISDiscoveryHandler.class.getName());
    public static IISDiscoveryManager iisDiscoveryManager = null;

    public IISDiscoveryHandler() throws IllegalAccessException {
        if (iisDiscoveryManager == null) {
            iisDiscoveryManager = IISDiscoveryManager.getInstance();
        }
    }

    public void addToDiscoveryQueue(JSONObject requestJsonObject) throws Exception {
        iisDiscoveryManager.discoverSites(requestJsonObject);
    }

    public static BaseStatusCode discoverSites(JSONObject requestJsonObject) throws DataAccessException, JSONException {
        BaseStatusCode b;
        Credential credential;
        boolean isDefaultAuthentication = requestJsonObject.getBoolean("IS_DEFAULT_AUTHENTICATION");
        String userName = null;
        String password = null;
        String domain = null;
        String deviceName = requestJsonObject.optString("DEVICE_NAME");
        Long serverID = IISUtil.getServerID(deviceName);
        if (serverID != -1L) {
            Criteria delCriteria = new Criteria(Column.getColumn((String)"ELADiscoveredIISServers", (String)"SERVER_ID"), (Object)serverID, 0);
            DBUtil.deleteExistingRows("ELADiscoveredIISServers", delCriteria, new boolean[0]);
        }
        Long deviceID = DeviceUtil.getDeviceId(deviceName);
        if (!isDefaultAuthentication) {
            credential = CredentialHandler.getCustomCredential(requestJsonObject);
            credential.resolveDomainAndUserName();
            userName = credential.getUserName();
            password = credential.getPassword();
            domain = credential.getDomain();
            if (domain == null) {
                domain = deviceName;
            }
        } else {
            if (requestJsonObject.has("WEBSERVER_ID")) {
                Long confWebServerId = requestJsonObject.getLong("WEBSERVER_ID");
                Criteria credCriteria = new Criteria(Column.getColumn((String)"WebServerConfiguration", (String)"WEBSERVER_ID"), (Object)confWebServerId, 0);
                DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("WebServerConfiguration", credCriteria);
                Row row = dataObject.getRow("WebServerConfiguration");
                Long credentialId = (Long)row.get("CREDENTIAL_ID");
                Credential credential2 = IISUtil.getCredential(credentialId, deviceID);
                if (credential2 != null) {
                    userName = credential2.getUserName();
                    password = credential2.getPassword();
                    domain = credential2.getDomain();
                }
            }
            if (deviceID != null && userName == null) {
                credential = DeviceUtil.getDeviceCredential(deviceID);
                if (credential != null && credential.getUserName() != null) {
                    userName = credential.getUserName();
                    password = credential.getPassword();
                    domain = credential.getDomain();
                } else {
                    Long domainId = DeviceUtil.getDomainIdFromDeviceName(deviceName);
                    credential = CredentialHandler.getCredentialFromDomainID(domainId);
                    userName = credential.getUserName();
                    password = credential.getPassword();
                }
                if (userName == null && !ServerDetailsBean.getInstance().isDefaultAuthenticationAllowed()) {
                    return BaseStatusCode.getBaseStatusCode(7426);
                }
            }
        }
        if (userName != null) {
            isDefaultAuthentication = false;
            if (!userName.contains("\\")) {
                userName = domain == null ? deviceName + "\\" + userName : domain + "\\" + userName;
            }
        }
        try {
            boolean ftpSite;
            try {
                if (!CommonUtil.isPingable(InetAddress.getByName(deviceName))) {
                    throw BaseStatusCode.getBaseStatusCode(16137L);
                }
            }
            catch (UnknownHostException e) {
                throw BaseStatusCode.getBaseStatusCode(16137L);
            }
            NativeIISDiscoveryHandler nativeHandler = new NativeIISDiscoveryHandler(deviceName, userName, password);
            boolean httpSite = nativeHandler.discoverSites(1, null);
            boolean bl = ftpSite = !httpSite ? nativeHandler.discoverSites(2, null) : nativeHandler.discoverSites(2, IISApplicationConstants.TABLE_UPDATED);
            if (!httpSite && !ftpSite) {
                int retVal = IISDiscoveryHandler.getIISStatus(deviceName, userName, password, isDefaultAuthentication);
                switch (retVal) {
                    case 1: {
                        LOGGER.log(Level.INFO, "Sites cannot be discovered for " + deviceName + " Invalid Credentials");
                        throw BaseStatusCode.getBaseStatusCode(16132L);
                    }
                    case 2: {
                        LOGGER.log(Level.INFO, "IIS not installed in " + deviceName);
                        throw BaseStatusCode.getBaseStatusCode(16133L);
                    }
                    case 4: {
                        LOGGER.log(Level.INFO, "unable to connect registry : " + deviceName);
                        if (!IISUtil.isConfigFileExists(deviceName, userName, password)) {
                            throw BaseStatusCode.getBaseStatusCode(16137L);
                        }
                    }
                    case 5: {
                        LOGGER.log(Level.INFO, "IIS is running. Fetching site details..");
                        if (!IISUtil.isConfigFileExists(deviceName, userName, password)) {
                            throw BaseStatusCode.getBaseStatusCode(16129L);
                        }
                        serverID = IISUtil.addDiscoveredIISServer(deviceName);
                        break;
                    }
                    case 0: {
                        LOGGER.log(Level.INFO, "Access Denied");
                        throw BaseStatusCode.getBaseStatusCode(7426);
                    }
                    default: {
                        LOGGER.log(Level.INFO, "Unable to Query the Registry To check for IIS");
                        throw BaseStatusCode.getBaseStatusCode(16134L);
                    }
                }
            } else {
                serverID = IISUtil.getServerID(deviceName);
            }
            IISDiscoveryListener listener = new IISDiscoveryListener();
            if (IISUtil.isConfigFileExists(deviceName, userName, password)) {
                boolean temp;
                JDKIISDiscoveryHandler jdkIISDiscoveryHandler;
                try {
                    jdkIISDiscoveryHandler = new JDKIISDiscoveryHandler(deviceName, userName, password, listener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (serverID >= 0L) {
                        return BaseStatusCode.getBaseStatusCode(16146L);
                    }
                    return BaseStatusCode.getBaseStatusCode(7683);
                }
                if (!httpSite && !(temp = jdkIISDiscoveryHandler.discoverSites(1, serverID))) {
                    throw BaseStatusCode.getBaseStatusCode(16129L);
                }
                if (!ftpSite && !(temp = jdkIISDiscoveryHandler.discoverSites(2, serverID))) {
                    throw BaseStatusCode.getBaseStatusCode(16129L);
                }
            }
            b = IISUtil.getNumberOfDiscoveredSites(serverID) == 0L ? BaseStatusCode.getBaseStatusCode(16144L) : BaseStatusCode.getBaseStatusCode(0);
        }
        catch (BaseStatusCode e) {
            e.printStackTrace();
            b = e;
        }
        catch (Exception e) {
            e.printStackTrace();
            b = BaseStatusCode.getBaseStatusCode(7683);
        }
        return b;
    }

    private static int getIISStatus(String deviceName, String userName, String password, boolean isDefaultAuthentication) {
        Properties registryVal = ELANativeHandler.queryRegistry(deviceName, userName, password, isDefaultAuthentication, "SOFTWARE\\Microsoft\\InetStp", "versionstring");
        return NumberUtils.toInt((String)registryVal.getProperty("QUERY_STATUS_CODE"));
    }
}

