/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.discovery;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscoveryListenerInterface;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;

public class IISDiscoveryListener
implements IISDiscoveryListenerInterface {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private DataObject dataObject = PERSISTENCELITE.constructDataObject();
    private static final int COUNT_THRESHOLD = 100;
    private int count = 0;

    @Override
    public boolean addDiscoveredServer(String deviceName) {
        try {
            IISUtil.addDiscoveredIISServer(deviceName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addRow(Properties adProperties) {
        adProperties.setProperty("ROTATION_INTERVAL", adProperties.containsKey("ROTATION_INTERVAL") ? adProperties.getProperty("ROTATION_INTERVAL") : "Daily");
        boolean isUtf8 = adProperties.containsKey("IS_UTF8") && adProperties.get("IS_UTF8").equals("true");
        String encoding = isUtf8 ? "UTF-8" : "ANSI";
        adProperties.setProperty("ENCODING", encoding);
        String logFileDirectory = adProperties.containsKey("LOG_FILE_DIRECTORY") ? adProperties.getProperty("LOG_FILE_DIRECTORY") + "\\" + (adProperties.getProperty("SITE_TYPE").equals("HTTP") ? "W3SVC" : "FTPSVC") + adProperties.getProperty("SITE_IDENTITY") : "c:\\inetpub\\logs\\LogFiles\\" + (adProperties.getProperty("SITE_TYPE").equals("HTTP") ? "W3SVC" : "FTPSVC") + adProperties.getProperty("SITE_IDENTITY");
        adProperties.setProperty("LOG_FILE_DIRECTORY", logFileDirectory);
        Long serverID = IISUtil.getServerID((String)adProperties.get("SERVER_NAME"));
        String formatName = adProperties.containsKey("FORMAT_NAME") ? adProperties.getProperty("FORMAT_NAME") : "W3C";
        adProperties.setProperty("FORMAT_NAME", formatName);
        this.addSite(adProperties, serverID);
    }

    public void addSite(Properties adProperties, Long serverId) {
        try {
            if (IISUtil.getDiscoveryStatus(adProperties.getProperty("SERVER_NAME")) != 16130L) {
                adProperties.setProperty("LOG_FILE_DIRECTORY", adProperties.getProperty("LOG_FILE_DIRECTORY").replaceAll("%SystemDrive%", System.getenv("SystemDrive")));
                if (this.count < 100) {
                    this.updateDataObject(adProperties, serverId);
                    ++this.count;
                } else if (this.count == 100) {
                    this.count = 0;
                    PERSISTENCELITE.add(this.dataObject);
                    this.dataObject = PERSISTENCELITE.constructDataObject();
                    this.updateDataObject(adProperties, serverId);
                    ++this.count;
                }
            } else {
                this.dataObject = PERSISTENCELITE.constructDataObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addDiscoveredSites() {
        try {
            if (!this.dataObject.isEmpty()) {
                PERSISTENCELITE.add(this.dataObject);
                this.dataObject = PERSISTENCELITE.constructDataObject();
            }
            this.count = 0;
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isCompleted() {
        return false;
    }

    private void updateDataObject(Properties site, Long serverId) {
        Row iisSiteRow = new Row("IISDiscoveredSites");
        Row iisFilesRow = new Row("IISDiscoveredFilesInfo");
        iisSiteRow.set("SERVER_ID", (Object)serverId);
        iisSiteRow.set("SITE_NAME", site.get("SITE_NAME"));
        iisSiteRow.set("SITE_TYPE", site.get("SITE_TYPE"));
        iisSiteRow.set("SITE_IDENTITY", site.get("SITE_IDENTITY"));
        iisFilesRow.set("SITE_ID", iisSiteRow.get("SITE_ID"));
        iisFilesRow.set("DIRECTORY", site.get("LOG_FILE_DIRECTORY"));
        iisFilesRow.set("ENCODING", site.get("ENCODING"));
        iisFilesRow.set("ROLL_OVER", site.get("ROTATION_INTERVAL"));
        iisFilesRow.set("FORMAT_NAME", site.get("FORMAT_NAME"));
        if (site.containsKey("FILE_SIZE")) {
            iisFilesRow.set("FILE_SIZE", (Object)NumberUtils.toLong((String)site.getProperty("FILE_SIZE")));
        }
        boolean isLocalTime = site.containsKey("IS_LOCAL_TIME") && site.getProperty("IS_LOCAL_TIME").equals("true");
        boolean isHttpCustomFields = site.containsKey("IS_HTTP_CUSTOM_FIELDS") && site.getProperty("IS_HTTP_CUSTOM_FIELDS").equals("true");
        iisFilesRow.set("USE_LOCAL_TIME", (Object)isLocalTime);
        iisFilesRow.set("IS_HTTP_CUSTOM_FIELDS", (Object)isHttpCustomFields);
        try {
            this.dataObject.addRow(iisSiteRow);
            this.dataObject.addRow(iisFilesRow);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }
}

