/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.discovery;

import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.discovery.processor.IISDiscoveryProcessor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.logging.Logger;
import org.json.JSONObject;

public class IISDiscoveryManager {
    private static final Logger LOGGER = Logger.getLogger(IISDiscoveryManager.class.getName());
    private static CommonQueueImpl<JSONObject> discoveryCommonQueue = new CommonQueueImpl();
    private static IISDiscoveryManager iisDiscoveryManager = null;
    private static IISDiscoveryProcessor iisDiscoveryProcessor = new IISDiscoveryProcessor((ConcurrentQueue<JSONObject>)discoveryCommonQueue);
    private static ProcessorPoolExecutor poolExecutor = new ProcessorPoolExecutorImpl<JSONObject>(iisDiscoveryProcessor, 10);

    public static IISDiscoveryManager getInstance() throws IllegalAccessException {
        if (iisDiscoveryManager == null) {
            iisDiscoveryManager = new IISDiscoveryManager();
        }
        poolExecutor.addProcessor();
        return iisDiscoveryManager;
    }

    public void discoverSites(JSONObject reqJsonObject) throws Exception {
        LOGGER.info("New Discovery Started");
        IISUtil.updateDiscoveryStatus(7682L, reqJsonObject);
        discoveryCommonQueue.add(reqJsonObject);
    }

    public void shutdown() throws InterruptedException {
        poolExecutor.waitForCompletion();
        iisDiscoveryProcessor.stopIfQueueIsEmpty();
    }
}

