/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.discovery;

import com.manageengine.ela.server.application.webserver.iis.IISServerInfo;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscovery;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscoveryListener;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.elasticsearch.common.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDKIISDiscoveryHandler
implements IISDiscovery {
    private static final Logger LOGGER = Logger.getLogger(JDKIISDiscoveryHandler.class.getName());
    private final String devicename;
    private final Document doc;
    private String defaultFtpDirectory = null;
    private String defaultHttpDirectory = null;
    private String defaultFtpPeriod = null;
    private String defaultHttpPeriod = null;
    private boolean isHttpCustomFields = false;
    private boolean defaultFtpLocalTimeRollover = false;
    private boolean defaultHttpLocalTimeRollover = false;
    private String defaultFtpTruncateSize = null;
    private String defaultHttpTruncateSize = null;
    private String defaultHttpLogFormat = null;
    private IISDiscoveryListener listener;
    private String configFilePath;

    public JDKIISDiscoveryHandler(String deviceName, String userName, String password, IISDiscoveryListener listener) throws Exception {
        this.listener = listener;
        this.devicename = deviceName;
        boolean isLocal = ImportProtocolUtils.isIpAddressLocal(deviceName);
        this.configFilePath = this.getConfigFilePath(deviceName, userName, password);
        this.configFilePath = this.configFilePath == null ? "C$/Windows/System32/inetsrv/config/applicationHost.config" : this.configFilePath.replace(':', '$').replaceAll("\\\\", "/") + "applicationHost.config";
        this.doc = this.getDocument(deviceName, userName, password);
        if (this.doc == null) {
            throw BaseStatusCode.getBaseStatusCode(16129L);
        }
        this.setDefaults();
    }

    public String getConfigFilePath(String devicename, String username, String password) throws Exception {
        InputStream inputStream = this.getInputStream(devicename, username, password, "C$/Windows/System32/inetsrv/config/redirection.config");
        return IISUtil.getConfigFilePath(inputStream);
    }

    @Override
    public boolean discoverSites(int siteType, Long serverID) {
        try {
            NodeList nList = this.doc.getElementsByTagName("site");
            int numberOfSites = 0;
            if (nList != null) {
                numberOfSites = nList.getLength();
            }
            if (siteType == 1) {
                for (int temp = 0; temp < numberOfSites; ++temp) {
                    Node nNode = nList.item(temp);
                    IISServerInfo site = this.extractHttpSitePropertiesFromConfigFile(nNode);
                    if (site == null) continue;
                    Properties siteProperty = IISUtil.getSitesProperty(site, this.devicename);
                    this.listener.addSite(siteProperty, serverID);
                }
            } else if (siteType == 2) {
                for (int temp = 0; temp < numberOfSites; ++temp) {
                    Node nNode = nList.item(temp);
                    IISServerInfo site = this.extractFtpSitePropertiesFromConfigFile(nNode);
                    if (site == null) continue;
                    Properties siteProperty = IISUtil.getSitesProperty(site, this.devicename);
                    this.listener.addSite(siteProperty, serverID);
                }
            }
            this.listener.addDiscoveredSites();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private InputStream getInputStream(String devicename, String user, String pass, String fileName) throws Exception {
        if (user == null) {
            return new FileInputStream("\\\\" + devicename + "\\" + fileName.replaceAll("/", "\\\\"));
        }
        String path = "smb://" + devicename + "/" + fileName;
        String domain = "";
        if (!Strings.isNullOrEmpty((String)user) && user.contains("\\") && !user.endsWith("\\")) {
            domain = user.substring(0, user.lastIndexOf("\\"));
            user = user.substring(user.lastIndexOf("\\") + 1);
        } else if (!Strings.isNullOrEmpty((String)user) && user.contains("@") && !user.endsWith("@")) {
            domain = user.substring(user.lastIndexOf("@") + 1);
            user = user.substring(0, user.lastIndexOf("@"));
        } else {
            domain = devicename;
        }
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, user, pass);
        SmbFile smbFile = new SmbFile(path, auth);
        return smbFile.getInputStream();
    }

    private IISServerInfo extractHttpSitePropertiesFromConfigFile(Node nNode) {
        IISServerInfo site = new IISServerInfo();
        if (nNode.getNodeType() == 1) {
            Element eElement = (Element)nNode;
            site.setSiteName(eElement.getAttribute("name"));
            site.setSiteId(eElement.getAttribute("id"));
            site.setHttp(false);
            Node node = eElement.getElementsByTagName("bindings").item(0);
            if (node != null) {
                Element el = (Element)node;
                int i = 0;
                do {
                    Element element;
                    if ((element = (Element)el.getElementsByTagName("binding").item(i++)) == null || !element.getAttribute("protocol").contains("http")) continue;
                    site.setHttp(true);
                } while (i < eElement.getElementsByTagName("binding").getLength());
            }
            if (site.getHttp()) {
                site.setHttpCustomFields(this.isHttpCustomFields);
                Element element = eElement.getElementsByTagName("ftpServer").getLength() > 0 && ((Element)eElement.getElementsByTagName("ftpServer").item(0)).getElementsByTagName("logFile").getLength() > 0 && eElement.getElementsByTagName("logFile").getLength() > 1 ? (Element)eElement.getElementsByTagName("logFile").item(1) : (Element)eElement.getElementsByTagName("logFile").item(0);
                site.setDeviceName(this.devicename);
                if (element != null) {
                    site.setLogFileDirectory(element.getAttribute("directory"));
                    site.setLogCollectionPeriod(element.getAttribute("period"));
                    site.setFormat(element.getAttribute("logFormat"));
                    site.setTruncateSize(element.getAttribute("truncateSize"));
                    site.setUseLocalTime(Strings.isNullOrEmpty((String)element.getAttribute("localTimeRollover")) ? this.defaultHttpLocalTimeRollover : element.getAttribute("localTimeRollover").equals("true"));
                    NodeList nList = element.getElementsByTagName("customFields");
                    if (nList.getLength() == 0) {
                        site.setHttpCustomFields(this.isHttpCustomFields);
                    } else {
                        site.setHttpCustomFields(((Element)nList.item(0)).getElementsByTagName("add").getLength() > 0);
                    }
                }
                if (Strings.isNullOrEmpty((String)site.getLogFileDirectory())) {
                    site.setLogFileDirectory(this.defaultHttpDirectory);
                } else if (site.getLogFileDirectory().charAt(site.getLogFileDirectory().length() - 1) == '\\') {
                    site.setLogFileDirectory(site.getLogFileDirectory().substring(0, site.getLogFileDirectory().length() - 1));
                }
                if (Strings.isNullOrEmpty((String)site.getFormat())) {
                    site.setFormat(this.defaultHttpLogFormat);
                }
                if (Strings.isNullOrEmpty((String)site.getLogCollectionPeriod())) {
                    site.setLogCollectionPeriod(this.defaultHttpPeriod);
                }
                if (Strings.isNullOrEmpty((String)site.getTruncateSize())) {
                    site.setTruncateSize(this.defaultHttpTruncateSize);
                }
                site.setIsUtf8(this.logInUtf8Http());
                site.setLogFileDirectory(site.getLogFileDirectory() + File.separator + "W3SVC" + site.getSiteId());
            } else {
                site = null;
            }
        }
        return site;
    }

    private IISServerInfo extractFtpSitePropertiesFromConfigFile(Node nNode) {
        IISServerInfo site = new IISServerInfo();
        if (nNode.getNodeType() == 1) {
            Element eElement = (Element)nNode;
            site.setSiteName(eElement.getAttribute("name"));
            site.setSiteId(eElement.getAttribute("id"));
            site.setHttp(true);
            Node node = eElement.getElementsByTagName("bindings").item(0);
            if (node != null) {
                Element el = (Element)node;
                int i = 0;
                do {
                    Element element;
                    if ((element = (Element)el.getElementsByTagName("binding").item(i++)) == null || !element.getAttribute("protocol").contains("ftp")) continue;
                    site.setHttp(false);
                } while (i < eElement.getElementsByTagName("binding").getLength());
            }
            if (!site.getHttp()) {
                Element element = null;
                if (eElement.getElementsByTagName("ftpServer").getLength() > 0) {
                    element = (Element)((Element)eElement.getElementsByTagName("ftpServer").item(0)).getElementsByTagName("logFile").item(0);
                }
                site.setDeviceName(this.devicename);
                if (element != null) {
                    site.setLogFileDirectory(element.getAttribute("directory"));
                    site.setLogCollectionPeriod(element.getAttribute("period"));
                    site.setFormat(element.getAttribute("logFormat"));
                    site.setTruncateSize(element.getAttribute("truncateSize"));
                    site.setUseLocalTime(Strings.isNullOrEmpty((String)element.getAttribute("localTimeRollover")) ? this.defaultFtpLocalTimeRollover : element.getAttribute("localTimeRollover").equals("true"));
                }
                if (Strings.isNullOrEmpty((String)site.getLogFileDirectory())) {
                    site.setLogFileDirectory(this.defaultFtpDirectory);
                } else if (site.getLogFileDirectory().charAt(site.getLogFileDirectory().length() - 1) == '\\') {
                    site.setLogFileDirectory(site.getLogFileDirectory().substring(0, site.getLogFileDirectory().length() - 1));
                }
                if (Strings.isNullOrEmpty((String)site.getFormat())) {
                    site.setFormat(this.defaultHttpLogFormat);
                }
                if (Strings.isNullOrEmpty((String)site.getLogCollectionPeriod())) {
                    site.setLogCollectionPeriod(this.defaultFtpPeriod);
                }
                if (Strings.isNullOrEmpty((String)site.getTruncateSize())) {
                    site.setTruncateSize(this.defaultFtpTruncateSize);
                }
                site.setIsUtf8(this.logInUtf8Ftp());
                site.setLogFileDirectory(site.getLogFileDirectory() + File.separator + "FTPSVC" + site.getSiteId());
            } else {
                site = null;
            }
        }
        return site;
    }

    private Document getDocument(String deviceName, String userName, String pwd) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        InputStream is = this.getInputStream(deviceName, userName, pwd, this.configFilePath);
        if (is == null) {
            return null;
        }
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private boolean logInUtf8Ftp() {
        Element element;
        NodeList nList1 = this.doc.getElementsByTagName("system.ftpServer");
        if (nList1.getLength() > 0 && ((Element)nList1.item(0)).getElementsByTagName("log").getLength() > 0 && (element = (Element)((Element)nList1.item(0)).getElementsByTagName("log").item(0)).hasAttribute("logInUTF8")) {
            return element.getAttribute("logInUTF8").equals("true");
        }
        return true;
    }

    private boolean logInUtf8Http() {
        Element element;
        NodeList nList1 = this.doc.getElementsByTagName("system.ftpServer");
        NodeList nList2 = this.doc.getElementsByTagName("log");
        if ((nList1.getLength() > 0 && ((Element)nList1.item(0)).getElementsByTagName("log").getLength() > 0 && nList2.getLength() > 1 || nList2.getLength() > 0) && (element = (Element)nList2.item(0)).hasAttribute("logInUTF8")) {
            return element.getAttribute("logInUTF8").equals("true");
        }
        return true;
    }

    private void setFtpDefaults(Element element, int index) {
        this.defaultFtpDirectory = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("directory") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("directory") : "c:/inetpub/logs/LogFiles";
        this.defaultFtpPeriod = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("period") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("period") : "Daily";
        this.defaultFtpTruncateSize = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("truncateSize") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("truncateSize") : "4294967295";
        this.defaultFtpLocalTimeRollover = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("localTimeRollover") && ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("localTimeRollover").equals("true");
    }

    private void setWebDefaults(Element element, int index) {
        this.defaultHttpDirectory = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("directory") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("directory") : "c:/inetpub/logs/LogFiles";
        this.defaultHttpLogFormat = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("logFormat") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("logFormat") : "W3C";
        this.defaultHttpPeriod = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("period") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("period") : "Daily";
        this.defaultHttpTruncateSize = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("truncateSize") ? ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("truncateSize") : "4294967295";
        this.defaultHttpLocalTimeRollover = ((Element)element.getElementsByTagName("logFile").item(index)).hasAttribute("localTimeRollover") && ((Element)element.getElementsByTagName("logFile").item(index)).getAttribute("localTimeRollover").equals("true");
        this.isHttpCustomFields = this.isHttpCustomFields((Element)element.getElementsByTagName("logFile").item(index));
    }

    private boolean isHttpCustomFields(Element element) {
        NodeList nList = element.getElementsByTagName("customFields");
        return nList.getLength() != 0 && ((Element)nList.item(0)).getElementsByTagName("add").getLength() > 0;
    }

    private void setDefaults() {
        NodeList nList = this.doc.getElementsByTagName("siteDefaults");
        if (nList.getLength() > 0) {
            Element element = (Element)nList.item(0);
            if (element.getElementsByTagName("logFile").getLength() == 2) {
                this.setWebDefaults(element, 0);
                this.setFtpDefaults(element, 1);
            } else if (element.getElementsByTagName("logFile").getLength() == 1) {
                if (element.getElementsByTagName("ftpServer").getLength() == 1) {
                    if (((Element)element.getElementsByTagName("ftpServer").item(0)).getElementsByTagName("logFile").getLength() > 0) {
                        this.setFtpDefaults(element, 0);
                    } else {
                        this.setWebDefaults(element, 0);
                    }
                } else {
                    this.setWebDefaults(element, 0);
                }
            }
        }
        if (Strings.isNullOrEmpty((String)this.defaultFtpDirectory)) {
            this.defaultFtpDirectory = "c:/inetpub/logs/LogFiles";
        }
        if (Strings.isNullOrEmpty((String)this.defaultHttpDirectory)) {
            this.defaultHttpDirectory = "c:/inetpub/logs/LogFiles";
        }
        if (Strings.isNullOrEmpty((String)this.defaultHttpTruncateSize)) {
            this.defaultHttpTruncateSize = "4294967295";
        }
        if (Strings.isNullOrEmpty((String)this.defaultFtpTruncateSize)) {
            this.defaultFtpTruncateSize = "4294967295";
        }
        if (Strings.isNullOrEmpty((String)this.defaultHttpPeriod)) {
            this.defaultHttpPeriod = "Daily";
        }
        if (Strings.isNullOrEmpty((String)this.defaultFtpPeriod)) {
            this.defaultFtpPeriod = "Daily";
        }
        if (Strings.isNullOrEmpty((String)this.defaultHttpLogFormat)) {
            this.defaultHttpLogFormat = "W3C";
        }
    }
}

