/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.discovery.processor;

import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.discovery.IISDiscoveryHandler;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.processor.extended.CommonTimerTask;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.json.JSONObject;

public class IISDiscoveryProcessor
extends ConcurrentQueueProcessor<JSONObject> {
    private static final Logger LOGGER = Logger.getLogger(IISDiscoveryProcessor.class.getName());

    public IISDiscoveryProcessor(ConcurrentQueue<JSONObject> queue) {
        super(queue);
    }

    @Override
    public void process(final JSONObject requestJsonObject) {
        try {
            CommonTimerTask.execute(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BaseStatusCode b = IISDiscoveryHandler.discoverSites(requestJsonObject);
                    if (IISUtil.getDiscoveryStatus(requestJsonObject.getString("DEVICE_NAME")) != 16130L) {
                        IISUtil.updateDiscoveryStatus(b.getOrgStatusCode(), requestJsonObject);
                    }
                    return null;
                }
            }, IISUtil.getIISDicoveryTimeout());
        }
        catch (TimeoutException e) {
            LOGGER.info("Unable to discover sites. Request timed out");
            IISUtil.updateDiscoveryStatus(16147L, requestJsonObject);
        }
        catch (Exception e) {
            IISUtil.updateDiscoveryStatus(16133L, requestJsonObject);
            e.printStackTrace();
        }
    }
}

