/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.application.webserver.iis.processor;

import com.manageengine.ela.server.application.webserver.iis.IISLogCollector;
import com.manageengine.ela.server.application.webserver.iis.IISLogProperties;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.io.file.parser.FileParser;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.elasticsearch.common.Strings;

public class IISLogProcessor
extends ConcurrentQueueProcessor<IISLogProperties> {
    public IISLogProcessor(ConcurrentQueue<IISLogProperties> queue) {
        super(queue);
    }

    @Override
    public void process(IISLogProperties logProperty) {
        block17: {
            String deviceIp;
            FileParser fileParser = logProperty.getFileParser();
            IISLogCollector collector = (IISLogCollector)fileParser.getResultHandlerInterface();
            Long rotationType = collector.getRotationType();
            Long alreadyReadCount = logProperty.getLineCount();
            ArrayList<DynamicPattern> dynamicPatterns = logProperty.getDynamicPatternDetails().getDynamicPatterns();
            String filePath = logProperty.getCompleteFilePath();
            Long maxFileSize = logProperty.getSize();
            Long auditId = collector.getAuditId();
            String deviceName = logProperty.getAttachedDeviceName();
            try {
                deviceIp = InetAddress.getByName(deviceName).getHostAddress();
            }
            catch (UnknownHostException e) {
                deviceIp = deviceName;
            }
            try {
                boolean flag;
                ImportFile importFile = new ImportFile(logProperty.getCompleteFilePath(), 0);
                if (rotationType == 1L) {
                    fileParser.parseFile(logProperty, alreadyReadCount, dynamicPatterns);
                    break block17;
                }
                if (rotationType != 2L) break block17;
                String prevFile = logProperty.getFileName();
                boolean isLocal = ImportProtocolUtils.isIpAddressLocal(deviceIp);
                if (Strings.isNullOrEmpty((String)logProperty.getImportProtocolBean().getUsername())) {
                    boolean flag2;
                    do {
                        if (!isLocal) {
                            filePath = "\\\\" + logProperty.getImportProtocolBean().getDeviceName() + "\\" + filePath.replaceAll("/", "\\\\").replace(':', '$');
                        }
                        if (new File(filePath).length() > maxFileSize) {
                            fileParser.parseFile(logProperty, alreadyReadCount, dynamicPatterns);
                            String fileName = IISUtil.getFileName(auditId);
                            if (fileName != null && !prevFile.equals(fileName)) {
                                prevFile = fileName;
                                importFile.setFilename(fileName);
                                logProperty.setImportFile(importFile);
                                filePath = logProperty.getCompleteFilePath();
                                alreadyReadCount = IISUtil.getAlreadyReadCount(auditId);
                                logProperty.setLineCount(alreadyReadCount);
                                flag2 = false;
                                continue;
                            }
                            break block17;
                        }
                        fileParser.parseFile(logProperty, alreadyReadCount, null);
                        flag2 = true;
                    } while (!flag2);
                    break block17;
                }
                ImportProtocolBean importProtocolBean = logProperty.getImportProtocolBean();
                String user = importProtocolBean.getUsername();
                String password = importProtocolBean.getPassword();
                String domain = "";
                if (!Strings.isNullOrEmpty((String)user) && user.contains("\\") && !user.endsWith("\\")) {
                    domain = user.substring(0, user.lastIndexOf("\\"));
                    user = user.substring(user.lastIndexOf("\\") + 1);
                } else if (!Strings.isNullOrEmpty((String)user) && user.contains("@") && !user.endsWith("@")) {
                    domain = user.substring(user.lastIndexOf("@") + 1);
                    user = user.substring(0, user.lastIndexOf("@"));
                } else {
                    domain = deviceIp;
                }
                NtlmPasswordAuthentication passwordAuthentication = new NtlmPasswordAuthentication(domain, user, password);
                String path = "smb://" + deviceIp + "/" + logProperty.getCompleteFilePath().replace(':', '$').replaceAll("\\\\", "/");
                do {
                    if (new SmbFile(path, passwordAuthentication).length() > 0L) {
                        fileParser.parseFile(logProperty, alreadyReadCount, dynamicPatterns);
                        String fileName = IISUtil.getFileName(auditId);
                        if (fileName != null && !prevFile.equals(fileName)) {
                            prevFile = fileName;
                            importFile.setFilename(fileName);
                            logProperty.setImportFile(importFile);
                            filePath = logProperty.getCompleteFilePath();
                            alreadyReadCount = IISUtil.getAlreadyReadCount(auditId);
                            logProperty.setLineCount(alreadyReadCount);
                            path = "smb://" + deviceIp + "/" + filePath.replace(':', '$').replaceAll("\\\\", "/");
                            flag = false;
                            continue;
                        }
                        break;
                    }
                    flag = true;
                } while (!flag);
            }
            catch (Exception e) {
                e.printStackTrace();
                IISUtil.setAuditStatus(auditId, 12197L, true);
            }
        }
    }
}

