/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.AS400LogPreProcessor;
import com.adventnet.sa.server.nf.IncidentToolConstants;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.parser.DbUtil;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.correlation.config.CorrelationConfigHandler;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertProfileActionHandler {
    private Persistence persistence = null;
    private String[] timerangeConstants = new String[]{"working", "nonworking", "custom"};
    private Integer triggerTime = 0;
    private Integer customHourStart = 1;
    private Integer customHourEnd = 1;
    private String tableName = "EventLog";
    private boolean isDefaultThreat = false;
    private boolean addHostsDefThreatStatus = false;
    private boolean isCorrelationThreat = false;
    private Long notifid = null;
    private String name = null;
    private String criticality = null;
    private String selectedDevices = null;
    private String selectedGroups = null;
    private String criteria = null;
    private String selectedAlert = null;
    private JSONObject alertText = null;
    private String customCriteria = null;
    private String type = null;
    private JSONObject jsonadvAlert = null;
    private boolean isThreshold = false;
    private String occurance = "1";
    private String timeLimit = "1";
    private boolean isTimeRange = false;
    private String timeRange = null;
    private Integer notificationType = null;
    private String days = null;
    private String hours = null;
    private String minutes = null;
    private boolean isMail = false;
    private String mailTo = null;
    private String mailSubject = null;
    private String mailBody = null;
    private String mailBodyPlain = null;
    private String mailNotes = null;
    private boolean isSms = false;
    private String number = null;
    private String smsMessage = null;
    private boolean isScript = false;
    private String scriptLocation = null;
    private String scriptArguments = null;
    private String logtypeApp = null;
    private String hosttypeApp = null;
    private ArrayList<Long> hostIds = new ArrayList();
    private ArrayList<Long> groupIds = new ArrayList();
    boolean isSeverity = false;
    private String severityString = null;
    private String eventids = null;
    private String logMessageContains = null;
    private String logMessageSource = null;
    private String logMessageUser = null;
    private String excludeEventIds = null;
    private String messageID = null;
    private String jobname = null;
    private String alertMessageType = null;
    private String as400Severity = null;
    private boolean isAS400 = false;
    private boolean isFim = false;

    public static AlertProfileActionHandler getInstance() {
        return new AlertProfileActionHandler();
    }

    public void saveAlert(JSONObject reqJsonObject, ResponseBuilder responseBuilder, Long userId, boolean isAdmin, Locale locale) {
        try {
            this.persistence = PersistenceDBUtil.getPersistence();
            JSONObject alertDetails = reqJsonObject.getJSONObject("ALERTDETAILS");
            this.name = alertDetails.getString("name");
            this.isDefaultThreat = alertDetails.getBoolean("isDefaultProfile");
            if (this.isDefaultThreat) {
                this.addHostsDefThreatStatus = alertDetails.getBoolean("addHostsDefaultProfile");
            }
            this.isCorrelationThreat = alertDetails.getBoolean("isCorrelationProfile");
            if (alertDetails.has("isAS400")) {
                this.isAS400 = alertDetails.getBoolean("isAS400");
            }
            if (alertDetails.has("isFim")) {
                this.isFim = alertDetails.getBoolean("isFim");
            }
            this.criticality = alertDetails.getString("severity");
            this.selectedDevices = alertDetails.getString("selectedDevice");
            this.selectedGroups = alertDetails.getString("selectedGroups");
            this.selectedAlert = alertDetails.getString("selectedAlert");
            this.customCriteria = alertDetails.has("customCriteria") ? alertDetails.getString("customCriteria") : "";
            this.isThreshold = alertDetails.getBoolean("isThreshold");
            this.occurance = alertDetails.getString("events");
            this.timeLimit = alertDetails.getString("period");
            this.isTimeRange = alertDetails.getBoolean("isTimerange");
            this.timeRange = alertDetails.getString("timeRange");
            this.notificationType = Integer.parseInt(alertDetails.getString("sendNotification"));
            if (this.notificationType == 4) {
                this.days = alertDetails.getString("days");
                this.hours = alertDetails.getString("hours");
                this.minutes = alertDetails.getString("minutes");
            }
            this.isMail = alertDetails.getBoolean("isMail");
            if (this.isMail) {
                this.mailTo = alertDetails.getString("emailTo");
                this.mailSubject = alertDetails.getString("emailSubject");
                this.mailBody = alertDetails.getString("emailBody");
                if (this.mailBody == null || this.mailBody.replaceAll("<div><br><\\/div>", "").trim().length() == 0) {
                    responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(7428));
                    return;
                }
                this.mailBodyPlain = alertDetails.getString("emailBodyPlain");
                if (this.mailBodyPlain == null || this.mailBodyPlain.trim().isEmpty()) {
                    responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(7428));
                    return;
                }
                this.mailNotes = "";
            }
            this.isSms = alertDetails.getBoolean("isSMS");
            if (this.isSms) {
                this.number = alertDetails.getString("smsNumber");
                JSONArray message = alertDetails.getJSONArray("smsMessage");
                for (int i = 0; i < message.length(); ++i) {
                    this.smsMessage = this.smsMessage == null ? message.getString(i) : this.smsMessage + message.getString(i);
                    if (i == message.length() - 1) continue;
                    this.smsMessage = this.smsMessage + ",";
                }
            }
            boolean bl = this.isScript = alertDetails.has("isScript") ? alertDetails.getBoolean("isScript") : false;
            if (this.isScript) {
                this.scriptLocation = alertDetails.getString("scriptLocation");
                this.scriptArguments = alertDetails.getString("scriptArguments");
            }
            ArrayList<String> hosttypelist = new ArrayList<String>();
            this.tableName = "EventLog";
            if (!"".equals(this.selectedDevices)) {
                DataObject hostDO = this.persistence.get("HostDetails", new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)this.selectedDevices.split(","), 8));
                Iterator hostItr = hostDO.getRows("HostDetails");
                while (hostItr.hasNext()) {
                    Row hostRow = (Row)hostItr.next();
                    this.hostIds.add((Long)hostRow.get("HOST_ID"));
                    hosttypelist.add((String)hostRow.get("TYPE"));
                }
            }
            StringTokenizer groupst = new StringTokenizer(this.selectedGroups, ",");
            while (groupst.hasMoreTokens()) {
                String groupId = groupst.nextToken();
                this.groupIds.add(new Long(groupId));
                ArrayList temp = AlertUtil.getHostIDs(new Long(groupId));
                if (temp == null) continue;
                DataObject hostDO = this.persistence.get("HostDetails", new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)temp.toArray(), 8));
                Iterator hostItr = hostDO.getRows("HostDetails");
                while (hostItr.hasNext()) {
                    Row hostRow = (Row)hostItr.next();
                    hosttypelist.add((String)hostRow.get("TYPE"));
                }
            }
            if (hosttypelist != null && hosttypelist.size() > 0 && !hosttypelist.contains("Windows")) {
                this.tableName = "SysLog";
            }
            this.jsonadvAlert = new JSONObject();
            Long time = new Date().getTime();
            this.jsonadvAlert.put("advlimitreachd", false);
            String notifType = "any";
            switch (this.notificationType) {
                case 0: {
                    this.jsonadvAlert.put("notifstatus", false);
                    notifType = "all";
                    break;
                }
                case 1: {
                    this.jsonadvAlert.put("notifstatus", true);
                    notifType = "day";
                    break;
                }
                case 2: {
                    this.jsonadvAlert.put("notifstatus", true);
                    notifType = "week";
                    break;
                }
                case 3: {
                    this.jsonadvAlert.put("notifstatus", true);
                    notifType = "month";
                    break;
                }
                case 4: {
                    this.jsonadvAlert.put("notifstatus", true);
                    notifType = "custom";
                    this.jsonadvAlert.put("notifdays", (Object)this.days);
                    this.jsonadvAlert.put("notifhours", (Object)this.hours);
                    this.jsonadvAlert.put("notifminutes", (Object)this.minutes);
                    time = time + (long)(Integer.parseInt(this.days) * 24 * 60 * 60 * 1000 + Integer.parseInt(this.hours) * 60 * 60 * 1000 + Integer.parseInt(this.minutes) * 60 * 1000);
                }
            }
            this.jsonadvAlert.put("profiletime", (Object)time);
            this.jsonadvAlert.put("notiftimertype", (Object)notifType);
            if (this.isTimeRange) {
                for (int i = 0; i < this.timerangeConstants.length; ++i) {
                    if (!this.timeRange.equalsIgnoreCase(this.timerangeConstants[i])) continue;
                    this.triggerTime = i + 1;
                }
                if (this.triggerTime == 3) {
                    this.customHourStart = Integer.parseInt(alertDetails.getString("customHourStart"));
                    this.customHourEnd = Integer.parseInt(alertDetails.getString("customHourEnd"));
                }
            } else {
                this.triggerTime = 0;
            }
            boolean status = false;
            if (reqJsonObject.getString("OPERATION").equals("SAVEALERT")) {
                if (this.checkBeforeSave(locale)) {
                    responseBuilder.setStatus(BaseStatusCode.getBaseStatusCode(7432));
                    return;
                }
                status = this.addAlert(alertDetails, userId);
            } else {
                status = this.editAlert(alertDetails, userId, isAdmin);
            }
            JSONObject returnObject = new JSONObject();
            returnObject.put("status", status);
            responseBuilder.setResponse(returnObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean addAlert(JSONObject alertDetails, Long userID) {
        try {
            DataObject db = null;
            db = this.persistence.constructDataObject();
            if (this.selectedAlert.equals("1")) {
                this.type = "257";
                this.criteria = alertDetails.getString("criteria");
                this.criteria = this.criteria.replaceAll("'", "\"");
                this.alertText = alertDetails.getJSONObject("alertText");
                this.logtypeApp = this.alertText.getString("logtype");
                this.hosttypeApp = this.alertText.getString("hosttype");
                db = this.addDataObject(db, this.selectedAlert, "Eventlog", userID);
                this.persistence.update(db);
            } else if (this.selectedAlert.equals("2")) {
                if (this.isAS400) {
                    if (alertDetails.has("as400MessageID")) {
                        this.messageID = alertDetails.getString("as400MessageID");
                    }
                    if (alertDetails.has("as400jobname")) {
                        this.jobname = alertDetails.getString("as400jobname");
                    }
                    if (alertDetails.has("severityString")) {
                        this.as400Severity = alertDetails.getString("severityString");
                    }
                    if (alertDetails.has("logMessageContains") && !alertDetails.getString("logMessageContains").trim().isEmpty()) {
                        this.logMessageContains = alertDetails.getString("logMessageContains");
                    }
                    if (alertDetails.has("logMessageExcept") && !alertDetails.getString("logMessageExcept").trim().isEmpty()) {
                        this.logMessageContains = this.logMessageContains == null ? "|" + alertDetails.getString("logMessageExcept") : this.logMessageContains + "|" + alertDetails.getString("logMessageExcept");
                    }
                    if (alertDetails.has("logMessageSource")) {
                        this.logMessageSource = alertDetails.getString("logMessageSource");
                    }
                    if (alertDetails.has("logMessageUser")) {
                        this.logMessageUser = alertDetails.getString("logMessageUser");
                    }
                    if (alertDetails.has("excludeEvents")) {
                        this.excludeEventIds = alertDetails.getString("excludeEvents");
                    }
                    this.type = "-1";
                    db = this.addDataObject(db, this.selectedAlert, "Eventlog", userID);
                    this.persistence.update(db);
                } else {
                    this.type = "1";
                    this.excludeEventIds = alertDetails.getString("excludeEvents");
                    db = this.addDataObject(db, this.selectedAlert, "Eventlog", userID);
                    this.persistence.update(db);
                }
            } else {
                this.type = "-1";
                if (this.isFim) {
                    this.type = "256";
                }
                db = this.addDataObject(db, this.selectedAlert, "Eventlog", userID);
                this.persistence.update(db);
            }
            Row r = db.getRow("NotificationType");
            Long notifId = (Long)r.get("NOTIFID");
            Long expid = AlertProfileActionHandler.getExpId(db);
            IncidentToolConstants.getInstance().refreshToolSettings();
            NotificationManager.getInstance().addProfile(notifId, expid, this.jsonadvAlert);
            if (this.isAS400) {
                AS400LogPreProcessor.resetAlertVariables();
            }
            NotificationManager.getInstance().addCustomAlertProfile(db, r);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean editAlert(JSONObject alertDetails, Long userId, boolean isAdmin) {
        this.persistence = PersistenceDBUtil.getPersistence();
        boolean status = false;
        try {
            Row hRow;
            this.notifid = Long.parseLong(alertDetails.getString("notifid"));
            DataObject db = AlertUtil.getDOForProfileID(this.notifid);
            if (!AlertUtil.validateProfiles(this.notifid, userId, isAdmin)) {
                return false;
            }
            Long expid = null;
            ArrayList<Long> dbHosts = new ArrayList<Long>();
            Iterator iterator = db.getRows("HostNotification");
            while (iterator.hasNext()) {
                hRow = (Row)iterator.next();
                dbHosts.add((Long)hRow.get("HOSTID"));
            }
            iterator = db.getRows("HostGroupNotification");
            while (iterator.hasNext()) {
                hRow = (Row)iterator.next();
                ArrayList hosts = AlertUtil.getHostIDs((Long)hRow.get("GROUPID"));
                Iterator iterator2 = hosts.iterator();
                while (iterator2.hasNext()) {
                    dbHosts.add((Long)iterator2.next());
                }
            }
            if (this.selectedAlert.equals("1")) {
                this.type = "257";
                this.criteria = alertDetails.getString("criteria");
                this.criteria = this.criteria.replaceAll("'", "\"");
                this.alertText = alertDetails.getJSONObject("alertText");
                this.logtypeApp = this.alertText.getString("logtype");
                this.hosttypeApp = this.alertText.getString("hosttype");
            } else if (this.selectedAlert.equals("2")) {
                boolean editComp;
                this.type = "1";
                boolean bl = editComp = alertDetails.has("isComplianceEdit") ? alertDetails.getBoolean("isComplianceEdit") : false;
                if (editComp) {
                    boolean bl2 = this.isSeverity = alertDetails.has("isSeverity") ? alertDetails.getBoolean("isSeverity") : false;
                    if (this.isSeverity) {
                        this.severityString = alertDetails.getString("severityOptions");
                    } else {
                        this.eventids = alertDetails.getString("eventIds");
                    }
                    if (alertDetails.has("logMessageContains") && !alertDetails.getString("logMessageContains").trim().isEmpty()) {
                        this.logMessageContains = alertDetails.getString("logMessageContains");
                    }
                    if (alertDetails.has("logMessageExcept") && !alertDetails.getString("logMessageExcept").trim().isEmpty()) {
                        this.logMessageContains = this.logMessageContains == null ? "|" + alertDetails.getString("logMessageExcept") : this.logMessageContains + "|" + alertDetails.getString("logMessageExcept");
                    }
                    if (alertDetails.has("logMessageSource")) {
                        this.logMessageSource = alertDetails.getString("logMessageSource");
                    }
                    if (alertDetails.has("logMessageUser")) {
                        this.logMessageUser = alertDetails.getString("logMessageUser");
                    }
                    if (alertDetails.has("excludeEvents")) {
                        this.excludeEventIds = alertDetails.getString("excludeEvents");
                    }
                } else if (this.isAS400) {
                    this.type = "-1";
                    if (alertDetails.has("as400MessageID")) {
                        this.messageID = alertDetails.getString("as400MessageID");
                    }
                    if (alertDetails.has("as400jobname")) {
                        this.jobname = alertDetails.getString("as400jobname");
                    }
                    if (alertDetails.has("severityString")) {
                        this.as400Severity = alertDetails.getString("severityString");
                    }
                    if (alertDetails.has("logMessageContains") && !alertDetails.getString("logMessageContains").trim().isEmpty()) {
                        this.logMessageContains = alertDetails.getString("logMessageContains");
                    }
                    if (alertDetails.has("logMessageExcept") && !alertDetails.getString("logMessageExcept").trim().isEmpty()) {
                        this.logMessageContains = this.logMessageContains == null ? "|" + alertDetails.getString("logMessageExcept") : this.logMessageContains + "|" + alertDetails.getString("logMessageExcept");
                    }
                    if (alertDetails.has("logMessageSource")) {
                        this.logMessageSource = alertDetails.getString("logMessageSource");
                    }
                    if (alertDetails.has("logMessageUser")) {
                        this.logMessageUser = alertDetails.getString("logMessageUser");
                    }
                    if (alertDetails.has("excludeEvents")) {
                        this.excludeEventIds = alertDetails.getString("excludeEvents");
                    }
                }
            } else {
                this.type = "-1";
                if (this.isFim) {
                    this.type = "256";
                }
                this.criteria = alertDetails.has("customCriteria") ? alertDetails.getString("customCriteria") : "";
            }
            db = this.editDataObject(db, this.tableName);
            this.persistence.update(db);
            expid = AlertProfileActionHandler.getExpId(db);
            if (this.isAS400) {
                AS400LogPreProcessor.resetAlertVariables();
            }
            IncidentToolConstants.getInstance().refreshToolSettings();
            NotificationManager.getInstance().updateProfile(this.notifid, expid, this.jsonadvAlert);
            NotificationManager.getInstance().addCustomAlertProfile(db, db.getRow("NotificationType"));
            status = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return status;
    }

    private DataObject editDataObject(DataObject db, String tableName) throws Exception {
        Row trRow;
        Row ncRow;
        Row row2;
        Row lcRow = db.getRow("LACriteria");
        Iterator iter = null;
        boolean isLAExpUpdated = false;
        lcRow.set("CRITERIA_NAME", (Object)this.name);
        db.updateRow(lcRow);
        if (this.type == "257") {
            Row jsonStrRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONAlertCrit", 0));
            if (jsonStrRow != null) {
                jsonStrRow.set("VALUE", (Object)this.criteria);
                db.updateRow(jsonStrRow);
            }
            if ((jsonStrRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONAlertCritCustom", 0))) != null) {
                jsonStrRow.set("VALUE", (Object)this.customCriteria);
                db.updateRow(jsonStrRow);
            } else {
                jsonStrRow = new Row("LAExpression");
                jsonStrRow.set("TABLE_NAME", (Object)tableName);
                jsonStrRow.set("COLUMN_NAME", (Object)"JSONAlertCritCustom");
                jsonStrRow.set("COMPARATOR", (Object)"=");
                jsonStrRow.set("VALUE", (Object)this.customCriteria);
                db.addRow(jsonStrRow);
                row2 = new Row("LACriteria2Expressions");
                row2.set("CRIT_ID", lcRow.get("CRIT_ID"));
                row2.set("EXP_ID", jsonStrRow.get("EXP_ID"));
                row2.set("MATCH_ALL", (Object)Boolean.TRUE);
                db.addRow(row2);
            }
            jsonStrRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONAlertTxtVal", 0));
            if (jsonStrRow != null) {
                jsonStrRow.set("VALUE", (Object)this.alertText);
                db.updateRow(jsonStrRow);
            }
            if (this.hosttypeApp != null && "app".equals(this.hosttypeApp)) {
                Long formatId = DbUtil.get_instance().getFormatId(this.logtypeApp);
                jsonStrRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONAlertFormat", 0));
                if (jsonStrRow != null) {
                    jsonStrRow.set("VALUE", (Object)formatId.toString());
                    db.updateRow(jsonStrRow);
                }
            }
        } else if (this.isDefaultThreat) {
            Row defThreatRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"EnableHostsStatus", 0));
            if (defThreatRow != null) {
                defThreatRow.set("VALUE", (Object)this.addHostsDefThreatStatus);
                db.updateRow(defThreatRow);
            }
        } else if (this.isCorrelationThreat) {
            this.type = "-1002";
        } else if (!this.type.equals("257") && this.criteria != null && !this.criteria.isEmpty()) {
            Row jsonStrRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONAlertCrit", 0));
            if (jsonStrRow != null) {
                jsonStrRow.set("VALUE", (Object)this.criteria);
                db.updateRow(jsonStrRow);
            } else {
                iter = db.getRows("LAExpression");
                while (iter.hasNext()) {
                    Row rem = (Row)iter.next();
                    iter.remove();
                }
                jsonStrRow = new Row("LAExpression");
                jsonStrRow.set("TABLE_NAME", (Object)tableName);
                jsonStrRow.set("COLUMN_NAME", (Object)"JSONAlertCrit");
                jsonStrRow.set("COMPARATOR", (Object)"=");
                jsonStrRow.set("VALUE", (Object)this.criteria);
                db.addRow(jsonStrRow);
                row2 = new Row("LACriteria2Expressions");
                row2.set("CRIT_ID", lcRow.get("CRIT_ID"));
                row2.set("EXP_ID", jsonStrRow.get("EXP_ID"));
                row2.set("MATCH_ALL", (Object)Boolean.TRUE);
                db.addRow(row2);
            }
        } else {
            Row editeventidRow;
            Row expRow;
            iter = db.getRows("LAExpression");
            int count = db.size("LAExpression");
            if (this.isSeverity && this.severityString != null) {
                String[] sev = this.severityString.split(",");
                int i = 0;
                for (i = 0; i < sev.length; ++i) {
                    Row c2eRow;
                    Row expRow2;
                    if (iter.hasNext()) {
                        expRow2 = (Row)iter.next();
                        expRow2.set("TABLE_NAME", (Object)tableName);
                        expRow2.set("COLUMN_NAME", (Object)"SEVERITY");
                        expRow2.set("COMPARATOR", (Object)"=");
                        expRow2.set("VALUE", (Object)sev[i].trim());
                        db.updateRow(expRow2);
                        c2eRow = new Row("LACriteria2Expressions");
                        c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                        c2eRow.set("EXP_ID", expRow2.get("EXP_ID"));
                        c2eRow.set("MATCH_ALL", (Object)(sev.length < count ? (i < sev.length - 1 ? Boolean.FALSE : Boolean.TRUE) : Boolean.FALSE));
                        db.updateRow(c2eRow);
                        continue;
                    }
                    expRow2 = new Row("LAExpression");
                    expRow2.set("TABLE_NAME", (Object)tableName);
                    expRow2.set("COLUMN_NAME", (Object)"SEVERITY");
                    expRow2.set("COMPARATOR", (Object)"=");
                    expRow2.set("VALUE", (Object)sev[i].trim());
                    db.addRow(expRow2);
                    c2eRow = new Row("LACriteria2Expressions");
                    c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow.set("EXP_ID", expRow2.get("EXP_ID"));
                    c2eRow.set("MATCH_ALL", (Object)(i < sev.length - 1 ? Boolean.FALSE : Boolean.TRUE));
                    db.addRow(c2eRow);
                }
                while (iter.hasNext()) {
                    Row r = (Row)iter.next();
                    iter.remove();
                }
                isLAExpUpdated = true;
            } else if (this.eventids != null) {
                expRow = (Row)iter.next();
                expRow.set("TABLE_NAME", (Object)tableName);
                expRow.set("COLUMN_NAME", (Object)"EVENTID");
                expRow.set("COMPARATOR", (Object)"=");
                expRow.set("VALUE", (Object)this.eventids);
                db.updateRow(expRow);
                isLAExpUpdated = true;
            }
            while (iter.hasNext()) {
                expRow = (Row)iter.next();
                iter.remove();
            }
            isLAExpUpdated = true;
            if (this.logMessageContains != null && this.logMessageContains.length() != 0) {
                Row expRow2 = null;
                Row c2eRow2 = null;
                if (isLAExpUpdated) {
                    expRow2 = new Row("LAExpression");
                    expRow2.set("TABLE_NAME", (Object)tableName);
                    expRow2.set("COLUMN_NAME", (Object)"MESSAGE");
                    expRow2.set("COMPARATOR", (Object)"=");
                    expRow2.set("VALUE", (Object)this.logMessageContains);
                    db.addRow(expRow2);
                    c2eRow2 = new Row("LACriteria2Expressions");
                    c2eRow2.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow2.set("EXP_ID", expRow2.get("EXP_ID"));
                    c2eRow2.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow2);
                } else {
                    iter = db.getRows("LAExpression");
                    expRow2 = (Row)iter.next();
                    expRow2.set("COLUMN_NAME", (Object)"MESSAGE");
                    expRow2.set("COMPARATOR", (Object)"=");
                    expRow2.set("VALUE", (Object)this.logMessageContains);
                    db.updateRow(expRow2);
                    c2eRow2 = db.getRow("LACriteria2Expressions");
                    c2eRow2.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow2.set("EXP_ID", expRow2.get("EXP_ID"));
                    c2eRow2.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.updateRow(c2eRow2);
                    while (iter.hasNext()) {
                        expRow2 = (Row)iter.next();
                        iter.remove();
                    }
                }
                isLAExpUpdated = true;
            }
            if (this.logMessageSource != null && this.logMessageSource.length() != 0) {
                Row expRow4 = null;
                Row c2eRow4 = null;
                if (!isLAExpUpdated) {
                    iter = db.getRows("LAExpression");
                    expRow4 = (Row)iter.next();
                    expRow4.set("TABLE_NAME", (Object)tableName);
                    expRow4.set("COLUMN_NAME", (Object)"SOURCE");
                    expRow4.set("COMPARATOR", (Object)"=");
                    expRow4.set("VALUE", (Object)this.logMessageSource);
                    db.updateRow(expRow4);
                    c2eRow4 = db.getRow("LACriteria2Expressions");
                    c2eRow4.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow4.set("EXP_ID", expRow4.get("EXP_ID"));
                    c2eRow4.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.updateRow(c2eRow4);
                    while (iter.hasNext()) {
                        expRow4 = (Row)iter.next();
                        iter.remove();
                    }
                } else {
                    expRow4 = new Row("LAExpression");
                    expRow4.set("TABLE_NAME", (Object)tableName);
                    expRow4.set("COLUMN_NAME", (Object)"SOURCE");
                    expRow4.set("COMPARATOR", (Object)"=");
                    expRow4.set("VALUE", (Object)this.logMessageSource);
                    db.addRow(expRow4);
                    c2eRow4 = new Row("LACriteria2Expressions");
                    c2eRow4.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow4.set("EXP_ID", expRow4.get("EXP_ID"));
                    c2eRow4.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow4);
                }
                isLAExpUpdated = true;
            }
            if (this.logMessageUser != null && this.logMessageUser.length() != 0) {
                Row expRow7 = null;
                Row c2eRow7 = null;
                if (!isLAExpUpdated) {
                    iter = db.getRows("LAExpression");
                    expRow7 = (Row)iter.next();
                    expRow7.set("TABLE_NAME", (Object)tableName);
                    expRow7.set("COLUMN_NAME", (Object)"USERNAME");
                    expRow7.set("COMPARATOR", (Object)"=");
                    expRow7.set("VALUE", (Object)this.logMessageUser);
                    db.updateRow(expRow7);
                    c2eRow7 = db.getRow("LACriteria2Expressions");
                    c2eRow7.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow7.set("EXP_ID", expRow7.get("EXP_ID"));
                    c2eRow7.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.updateRow(c2eRow7);
                    while (iter.hasNext()) {
                        expRow7 = (Row)iter.next();
                        iter.remove();
                    }
                } else {
                    expRow7 = new Row("LAExpression");
                    expRow7.set("TABLE_NAME", (Object)tableName);
                    expRow7.set("COLUMN_NAME", (Object)"USERNAME");
                    expRow7.set("COMPARATOR", (Object)"=");
                    expRow7.set("VALUE", (Object)this.logMessageUser);
                    db.addRow(expRow7);
                    c2eRow7 = new Row("LACriteria2Expressions");
                    c2eRow7.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow7.set("EXP_ID", expRow7.get("EXP_ID"));
                    c2eRow7.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow7);
                }
                isLAExpUpdated = true;
            }
            if (this.excludeEventIds != null && this.excludeEventIds.length() != 0) {
                editeventidRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"EXCLUDEEVENTID", 0));
                editeventidRow = new Row("LAExpression");
                editeventidRow.set("TABLE_NAME", (Object)tableName);
                editeventidRow.set("COLUMN_NAME", (Object)"EXCLUDEEVENTID");
                editeventidRow.set("COMPARATOR", (Object)"=");
                editeventidRow.set("VALUE", (Object)this.excludeEventIds);
                db.addRow(editeventidRow);
                Row c2eRow = new Row("LACriteria2Expressions");
                c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                c2eRow.set("EXP_ID", editeventidRow.get("EXP_ID"));
                c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                db.addRow(c2eRow);
            } else {
                editeventidRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"EXCLUDEEVENTID", 0));
                if (editeventidRow != null) {
                    db.deleteRow(editeventidRow);
                }
            }
            if (this.as400Severity != null) {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"AS400SEVERITY", 0));
                if (expRow != null) {
                    expRow.set("VALUE", (Object)this.as400Severity);
                    db.updateRow(expRow);
                } else {
                    expRow = new Row("LAExpression");
                    expRow.set("TABLE_NAME", (Object)tableName);
                    expRow.set("COLUMN_NAME", (Object)"AS400SEVERITY");
                    expRow.set("COMPARATOR", (Object)"=");
                    expRow.set("VALUE", (Object)this.as400Severity);
                    db.addRow(expRow);
                    Row c2eRow = new Row("LACriteria2Expressions");
                    c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
                    c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow);
                }
            } else {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"AS400SEVERITY", 0));
                if (expRow != null) {
                    db.deleteRow(expRow);
                }
            }
            if (this.messageID != null && this.messageID.length() != 0) {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"MESSAGEID", 0));
                if (expRow != null) {
                    expRow.set("VALUE", (Object)this.messageID);
                    db.updateRow(expRow);
                } else {
                    expRow = new Row("LAExpression");
                    expRow.set("TABLE_NAME", (Object)tableName);
                    expRow.set("COLUMN_NAME", (Object)"MESSAGEID");
                    expRow.set("COMPARATOR", (Object)"=");
                    expRow.set("VALUE", (Object)this.messageID);
                    db.addRow(expRow);
                    Row c2eRow = new Row("LACriteria2Expressions");
                    c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
                    c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow);
                }
            } else {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"MESSAGEID", 0));
                if (expRow != null) {
                    db.deleteRow(expRow);
                }
            }
            if (this.jobname != null && this.jobname.length() != 0) {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JOBNAME", 0));
                if (expRow != null) {
                    expRow.set("VALUE", (Object)this.jobname);
                    db.updateRow(expRow);
                } else {
                    expRow = new Row("LAExpression");
                    expRow.set("TABLE_NAME", (Object)tableName);
                    expRow.set("COLUMN_NAME", (Object)"JOBNAME");
                    expRow.set("COMPARATOR", (Object)"=");
                    expRow.set("VALUE", (Object)this.jobname);
                    db.addRow(expRow);
                    Row c2eRow = new Row("LACriteria2Expressions");
                    c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
                    c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow);
                }
            } else {
                expRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JOBNAME", 0));
                if (expRow != null) {
                    db.deleteRow(expRow);
                }
            }
        }
        if (this.jsonadvAlert != null) {
            Row alertRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONNotifTimer", 0));
            if (alertRow != null) {
                alertRow.set("VALUE", (Object)this.jsonadvAlert.toString());
                db.updateRow(alertRow);
            } else {
                Row expalertRow = new Row("LAExpression");
                expalertRow.set("TABLE_NAME", (Object)tableName);
                expalertRow.set("COLUMN_NAME", (Object)"JSONNotifTimer");
                expalertRow.set("COMPARATOR", (Object)"=");
                expalertRow.set("VALUE", (Object)this.jsonadvAlert.toString());
                db.addRow(expalertRow);
                Row c2ealertRow = new Row("LACriteria2Expressions");
                c2ealertRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                c2ealertRow.set("EXP_ID", expalertRow.get("EXP_ID"));
                c2ealertRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                db.addRow(c2ealertRow);
            }
        }
        if (!this.isDefaultThreat && !this.isCorrelationThreat) {
            if (this.excludeEventIds != null && this.excludeEventIds.length() != 0) {
                Row editeventidRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"EXCLUDEEVENTID", 0));
                if (editeventidRow != null) {
                    db.updateRow(editeventidRow);
                } else {
                    editeventidRow = new Row("LAExpression");
                    editeventidRow.set("TABLE_NAME", (Object)tableName);
                    editeventidRow.set("COLUMN_NAME", (Object)"EXCLUDEEVENTID");
                    editeventidRow.set("COMPARATOR", (Object)"=");
                    editeventidRow.set("VALUE", (Object)this.excludeEventIds);
                    db.addRow(editeventidRow);
                    Row c2eRow = new Row("LACriteria2Expressions");
                    c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
                    c2eRow.set("EXP_ID", editeventidRow.get("EXP_ID"));
                    c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
                    db.addRow(c2eRow);
                }
            } else {
                Row editeventidRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"EXCLUDEEVENTID", 0));
                if (editeventidRow != null) {
                    db.deleteRow(editeventidRow);
                }
            }
        }
        Row ntRow = db.getRow("NotificationType");
        ntRow.set("NOTIFID", lcRow.get("CRIT_ID"));
        ntRow.set("NOTIFNAME", (Object)this.name);
        ntRow.set("CRITICALITY", (Object)this.criticality);
        ntRow.set("TRIGGERTIME", (Object)this.triggerTime);
        if (this.triggerTime == 3) {
            Row customTriggerRow = db.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"CustomTriggerStartEnd", 0));
            if (customTriggerRow != null) {
                customTriggerRow.set("VALUE", (Object)(this.customHourStart + "," + this.customHourEnd));
                db.updateRow(customTriggerRow);
            } else {
                AlertProfileActionHandler.addToExpressionTables(db, lcRow.get("CRIT_ID"), "CustomTriggerStartEnd", "=", this.customHourStart + "," + this.customHourEnd, true, tableName);
            }
        }
        ntRow.set("STATUS", (Object)1);
        if (!this.isDefaultThreat && !this.isCorrelationThreat) {
            ntRow.set("TYPE", (Object)new Long(this.type));
            if (this.isThreshold) {
                ntRow.set("NOOFOCCURRENCE", (Object)Integer.valueOf(this.occurance));
                if (this.timeLimit.length() != 0) {
                    int timeInMinutes = Integer.valueOf(this.timeLimit);
                    int timeInSeconds = timeInMinutes * 60;
                    ntRow.set("NOTIFINTERVAL", (Object)timeInSeconds);
                }
            } else {
                ntRow.set("NOOFOCCURRENCE", (Object)1);
                ntRow.set("NOTIFINTERVAL", (Object)0);
            }
        }
        db.updateRow(ntRow);
        ArrayList<Object> DOhostlist = new ArrayList<Object>();
        Iterator hIt = db.getRows("HostNotification");
        while (hIt.hasNext()) {
            Row hRow = (Row)hIt.next();
            DOhostlist.add(hRow.get("HOSTID"));
        }
        int UIhostlength = this.hostIds.size();
        int DOhostlength = DOhostlist.size();
        this.editHostGroup(db, "HostNotification", "HOSTID", UIhostlength, DOhostlength, this.hostIds, ntRow);
        ArrayList<Object> DOgrouplist = new ArrayList<Object>();
        Iterator hgIt = db.getRows("HostGroupNotification");
        while (hgIt.hasNext()) {
            Row hgRow = (Row)hgIt.next();
            DOgrouplist.add(hgRow.get("GROUPID"));
        }
        int UIgrouplength = this.groupIds.size();
        int DOgrouplength = DOgrouplist.size();
        this.editHostGroup(db, "HostGroupNotification", "GROUPID", UIgrouplength, DOgrouplength, this.groupIds, ntRow);
        Row nctRow = null;
        if (db.containsTable("NotfnConfigType")) {
            nctRow = db.getRow("NotfnConfigType");
            if (this.isMail && this.isSms) {
                ncRow = null;
                Row ncRows = null;
                if (db.containsTable("NotfnConfiguration") && db.containsTable("NotfnConfigurationSms")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    ncRows = db.getRow("NotfnConfigurationSms");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("MAILID", (Object)this.mailTo);
                    ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                    ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                    ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                    ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                    ncRows.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRows.set("SMSID", (Object)this.number);
                    ncRows.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                    db.updateRow(ncRow);
                    db.updateRow(ncRows);
                } else {
                    ncRow = new Row("NotfnConfiguration");
                    ncRows = new Row("NotfnConfigurationSms");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("MAILID", (Object)this.mailTo);
                    ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                    ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                    ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                    ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                    ncRows.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRows.set("SMSID", (Object)this.number);
                    ncRows.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                    db.deleteRows("NotfnConfigurationSms", new Criteria(Column.getColumn((String)"NotfnConfigurationSms", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    db.deleteRows("NotfnConfiguration", new Criteria(Column.getColumn((String)"NotfnConfiguration", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    db.addRow(ncRow);
                    db.addRow(ncRows);
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"MAIL,SMS");
                db.updateRow(nctRow);
            } else if (this.isMail) {
                ncRow = null;
                if (db.containsTable("NotfnConfiguration")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("MAILID", (Object)this.mailTo);
                    ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                    ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                    ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                    ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                    db.updateRow(ncRow);
                    if (db.containsTable("NotfnConfigurationSms")) {
                        db.deleteRows("NotfnConfigurationSms", new Criteria(Column.getColumn((String)"NotfnConfigurationSms", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    }
                } else {
                    ncRow = new Row("NotfnConfiguration");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("MAILID", (Object)this.mailTo);
                    ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                    ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                    ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                    ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                    db.addRow(ncRow);
                    if (db.containsTable("NotfnConfigurationSms")) {
                        db.deleteRows("NotfnConfigurationSms", new Criteria(Column.getColumn((String)"NotfnConfigurationSms", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    }
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"MAIL");
                db.updateRow(nctRow);
            } else if (this.isSms) {
                ncRow = null;
                if (db.containsTable("NotfnConfigurationSms")) {
                    ncRow = db.getRow("NotfnConfigurationSms");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("SMSID", (Object)this.number);
                    ncRow.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                    db.updateRow(ncRow);
                    if (db.containsTable("NotfnConfiguration")) {
                        db.deleteRows("NotfnConfiguration", new Criteria(Column.getColumn((String)"NotfnConfiguration", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    }
                } else {
                    ncRow = new Row("NotfnConfigurationSms");
                    ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                    ncRow.set("SMSID", (Object)this.number);
                    ncRow.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                    db.addRow(ncRow);
                    if (db.containsTable("NotfnConfiguration")) {
                        db.deleteRows("NotfnConfiguration", new Criteria(Column.getColumn((String)"NotfnConfiguration", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                    }
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"SMS");
                db.updateRow(nctRow);
            } else {
                ncRow = null;
                Row ncRows = null;
                if (db.containsTable("NotfnConfiguration") && db.containsTable("NotfnConfigurationSms")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    ncRows = db.getRow("NotfnConfigurationSms");
                    db.deleteRow(ncRow);
                    db.deleteRow(ncRows);
                }
                if (db.containsTable("NotfnConfiguration")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    db.deleteRow(ncRow);
                }
                if (db.containsTable("NotfnConfigurationSms")) {
                    ncRows = db.getRow("NotfnConfigurationSms");
                    db.deleteRow(ncRows);
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"POPUP");
                db.updateRow(nctRow);
            }
        } else {
            nctRow = new Row("NotfnConfigType");
            if (this.isMail && this.isSms) {
                ncRow = new Row("NotfnConfiguration");
                Row ncRows = new Row("NotfnConfigurationSms");
                ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRow.set("MAILID", (Object)this.mailTo);
                ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                ncRows.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRows.set("SMSID", (Object)this.number);
                ncRow.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                db.addRow(ncRow);
                db.addRow(ncRows);
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"MAIL,SMS");
                db.addRow(nctRow);
            } else if (this.isMail) {
                ncRow = new Row("NotfnConfiguration");
                ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRow.set("MAILID", (Object)this.mailTo);
                ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                db.addRow(ncRow);
                if (db.containsTable("NotfnConfigurationSms")) {
                    db.deleteRows("NotfnConfigurationSms", new Criteria(Column.getColumn((String)"NotfnConfigurationSms", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"MAIL");
                db.addRow(nctRow);
            } else if (this.isSms) {
                ncRow = new Row("NotfnConfigurationSms");
                ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRow.set("SMSID", (Object)this.number);
                ncRow.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                db.addRow(ncRow);
                if (db.containsTable("NotfnConfiguration")) {
                    db.deleteRows("NotfnConfiguration", new Criteria(Column.getColumn((String)"NotfnConfiguration", (String)"NOTIFID"), (Object)new Long(String.valueOf(lcRow.get("CRIT_ID"))), 0));
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"SMS");
                db.addRow(nctRow);
            } else {
                ncRow = null;
                Row ncRows = null;
                if (db.containsTable("NotfnConfiguration") && db.containsTable("NotfnConfigurationSms")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    ncRows = db.getRow("NotfnConfigurationSms");
                    db.deleteRow(ncRow);
                    db.deleteRow(ncRows);
                }
                if (db.containsTable("NotfnConfiguration")) {
                    ncRow = db.getRow("NotfnConfiguration");
                    db.deleteRow(ncRow);
                }
                if (db.containsTable("NotfnConfigurationSms")) {
                    ncRows = db.getRow("NotfnConfigurationSms");
                    db.deleteRow(ncRows);
                }
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"POPUP");
                db.addRow(nctRow);
            }
        }
        if (this.isScript) {
            if (db.containsTable("ScriptDetails")) {
                trRow = db.getRow("ScriptDetails");
                trRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                trRow.set("LOCATION", (Object)this.scriptLocation);
                trRow.set("ARGUMENTS", (Object)this.scriptArguments);
                db.updateRow(trRow);
            } else {
                trRow = new Row("ScriptDetails");
                trRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                trRow.set("LOCATION", (Object)this.scriptLocation);
                trRow.set("ARGUMENTS", (Object)this.scriptArguments);
                db.addRow(trRow);
            }
        } else if (this.scriptArguments != null && this.scriptArguments.length() != 0) {
            trRow = db.getRow("ScriptDetails");
            trRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            trRow.set("ARGUMENTS", (Object)this.scriptArguments);
            db.updateRow(trRow);
        } else if (db.containsTable("ScriptDetails")) {
            trRow = db.getRow("ScriptDetails");
            db.deleteRow(trRow);
        }
        return db;
    }

    private void editHostGroup(DataObject db, String rowname, String columnname, int uLength, int dataLength, ArrayList list, Row ntRow) throws Exception {
        if (dataLength == 0) {
            if (uLength > 0) {
                for (int i = 0; i < uLength; ++i) {
                    Long UIId = (Long)list.get(i);
                    Row aRow = new Row(rowname);
                    aRow.set(columnname, (Object)UIId);
                    aRow.set("NOTIFID", ntRow.get("NOTIFID"));
                    db.addRow(aRow);
                }
            }
        } else {
            for (int i = 0; i < uLength; ++i) {
                Long UIId = (Long)list.get(i);
                boolean addRow = true;
                Iterator aIt = db.getRows(rowname, new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)this.notifid, 0));
                while (aIt.hasNext()) {
                    Row rRow = (Row)aIt.next();
                    Long DOId = (Long)rRow.get(columnname);
                    if (UIId.longValue() != DOId.longValue()) continue;
                    addRow = false;
                }
                if (!addRow) continue;
                Row aRow = new Row(rowname);
                aRow.set(columnname, (Object)UIId);
                aRow.set("NOTIFID", ntRow.get("NOTIFID"));
                db.addRow(aRow);
            }
            Iterator dIt = db.getRows(rowname, new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)this.notifid, 0));
            while (dIt.hasNext()) {
                Row dRow = (Row)dIt.next();
                Long DOId = (Long)dRow.get(columnname);
                if (list.contains(DOId)) continue;
                db.deleteRow(dRow);
            }
        }
        this.persistence.update(db);
    }

    private boolean checkBeforeSave(Locale locale) {
        boolean result = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFNAME"), (Object)this.name, 0));
            DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (!doo.isEmpty() || CorrelationUtil.checkIfRuleAvailable(this.name, locale)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private DataObject addDataObject(DataObject db, String alertType, String tableName, Long userId) throws Exception {
        Row ncRow;
        int i;
        Row c2eRow;
        Row expRow;
        Row c2eRow4;
        Row expRow4;
        Row lcRow = new Row("LACriteria");
        lcRow.set("CRITERIA_NAME", (Object)this.name);
        db.addRow(lcRow);
        Object critId = lcRow.get("CRIT_ID");
        if (this.jsonadvAlert != null) {
            AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONNotifTimer", "=", this.jsonadvAlert.toString(), true, tableName);
        }
        if (alertType.equals("1")) {
            AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONAlertCrit", "=", this.criteria, true, tableName);
            AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONAlertCritCustom", "=", this.customCriteria, true, tableName);
            AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONAlertTxtVal", "=", this.alertText.toString(), true, tableName);
            if (this.hosttypeApp != null && "app".equals(this.hosttypeApp)) {
                Long formatId = DbUtil.get_instance().getFormatId(this.logtypeApp);
                AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONAlertFormat", "=", formatId.toString(), true, tableName);
            }
        } else if (alertType.equals("2") && !this.isAS400) {
            db = this.compLAExpression(db, lcRow.get("CRIT_ID"), tableName);
        } else if (alertType.equals("3")) {
            AlertProfileActionHandler.addToExpressionTables(db, critId, "JSONAlertCrit", "=", this.customCriteria, true, tableName);
        }
        if (this.logMessageSource != null && this.logMessageSource.length() != 0) {
            expRow4 = new Row("LAExpression");
            expRow4.set("TABLE_NAME", (Object)tableName);
            expRow4.set("COLUMN_NAME", (Object)"SOURCE");
            expRow4.set("COMPARATOR", (Object)"=");
            expRow4.set("VALUE", (Object)this.logMessageSource);
            db.addRow(expRow4);
            c2eRow4 = new Row("LACriteria2Expressions");
            c2eRow4.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow4.set("EXP_ID", expRow4.get("EXP_ID"));
            c2eRow4.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow4);
        }
        if (this.logMessageContains != null && this.logMessageContains.length() != 0) {
            expRow4 = new Row("LAExpression");
            expRow4.set("TABLE_NAME", (Object)tableName);
            expRow4.set("COLUMN_NAME", (Object)"MESSAGE");
            expRow4.set("COMPARATOR", (Object)"1");
            expRow4.set("VALUE", (Object)this.logMessageContains);
            db.addRow(expRow4);
            c2eRow4 = new Row("LACriteria2Expressions");
            c2eRow4.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow4.set("EXP_ID", expRow4.get("EXP_ID"));
            c2eRow4.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow4);
        }
        if (this.logMessageUser != null && this.logMessageUser.length() != 0) {
            Row expRow7 = new Row("LAExpression");
            expRow7.set("TABLE_NAME", (Object)tableName);
            expRow7.set("COLUMN_NAME", (Object)"USERNAME");
            expRow7.set("COMPARATOR", (Object)"=");
            expRow7.set("VALUE", (Object)this.logMessageUser);
            db.addRow(expRow7);
            Row c2eRow7 = new Row("LACriteria2Expressions");
            c2eRow7.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow7.set("EXP_ID", expRow7.get("EXP_ID"));
            c2eRow7.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow7);
        }
        if (this.alertMessageType != null && this.alertMessageType.length() != 0) {
            Row expRow5 = new Row("LAExpression");
            expRow5.set("TABLE_NAME", (Object)tableName);
            expRow5.set("COLUMN_NAME", (Object)"AlertMsgType");
            expRow5.set("COMPARATOR", (Object)"=");
            expRow5.set("VALUE", (Object)this.alertMessageType);
            db.addRow(expRow5);
            Row c2eRow5 = new Row("LACriteria2Expressions");
            c2eRow5.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow5.set("EXP_ID", expRow5.get("EXP_ID"));
            c2eRow5.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow5);
        }
        if (this.as400Severity != null) {
            expRow = new Row("LAExpression");
            expRow.set("TABLE_NAME", (Object)tableName);
            expRow.set("COLUMN_NAME", (Object)"AS400SEVERITY");
            expRow.set("COMPARATOR", (Object)"=");
            expRow.set("VALUE", (Object)this.as400Severity);
            db.addRow(expRow);
            c2eRow = new Row("LACriteria2Expressions");
            c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
            c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow);
        }
        if (this.messageID != null && this.messageID.length() != 0) {
            expRow = new Row("LAExpression");
            expRow.set("TABLE_NAME", (Object)tableName);
            expRow.set("COLUMN_NAME", (Object)"MESSAGEID");
            expRow.set("COMPARATOR", (Object)"=");
            expRow.set("VALUE", (Object)this.messageID);
            db.addRow(expRow);
            c2eRow = new Row("LACriteria2Expressions");
            c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
            c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow);
        }
        if (this.jobname != null && this.jobname.length() != 0) {
            expRow = new Row("LAExpression");
            expRow.set("TABLE_NAME", (Object)tableName);
            expRow.set("COLUMN_NAME", (Object)"JOBNAME");
            expRow.set("COMPARATOR", (Object)"=");
            expRow.set("VALUE", (Object)this.jobname);
            db.addRow(expRow);
            c2eRow = new Row("LACriteria2Expressions");
            c2eRow.set("CRIT_ID", lcRow.get("CRIT_ID"));
            c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
            c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(c2eRow);
        }
        if (this.excludeEventIds != null && this.excludeEventIds.length() != 0) {
            Row expeventid = new Row("LAExpression");
            expeventid.set("TABLE_NAME", (Object)tableName);
            expeventid.set("COLUMN_NAME", (Object)"EXCLUDEEVENTID");
            expeventid.set("COMPARATOR", (Object)"=");
            expeventid.set("VALUE", (Object)this.excludeEventIds);
            db.addRow(expeventid);
            Row criteventid = new Row("LACriteria2Expressions");
            criteventid.set("CRIT_ID", lcRow.get("CRIT_ID"));
            criteventid.set("EXP_ID", expeventid.get("EXP_ID"));
            criteventid.set("MATCH_ALL", (Object)Boolean.TRUE);
            db.addRow(criteventid);
        }
        Row ntRow = new Row("NotificationType");
        ntRow.set("NOTIFID", lcRow.get("CRIT_ID"));
        ntRow.set("NOTIFNAME", (Object)this.name);
        ntRow.set("CRITICALITY", (Object)this.criticality);
        ntRow.set("TRIGGERTIME", (Object)this.triggerTime);
        if (this.triggerTime == 3) {
            AlertProfileActionHandler.addToExpressionTables(db, critId, "CustomTriggerStartEnd", "=", this.customHourStart + "," + this.customHourEnd, true, tableName);
        }
        ntRow.set("STATUS", (Object)1);
        if (this.isThreshold) {
            ntRow.set("NOOFOCCURRENCE", (Object)Integer.valueOf(this.occurance));
            if (this.timeLimit.length() != 0) {
                int timeInMinutes = Integer.valueOf(this.timeLimit);
                int timeInSeconds = timeInMinutes * 60;
                ntRow.set("NOTIFINTERVAL", (Object)timeInSeconds);
            }
        }
        ntRow.set("TYPE", (Object)new Long(this.type));
        db.addRow(ntRow);
        Row userTonf = new Row("UserToNotificationType");
        userTonf.set("NOTIFID", ntRow.get("NOTIFID"));
        if (userId != null) {
            userTonf.set("USER_ID", (Object)userId);
            db.addRow(userTonf);
        }
        if (this.hostIds != null) {
            for (i = 0; i < this.hostIds.size(); ++i) {
                Row hnRow = new Row("HostNotification");
                hnRow.set("HOSTID", (Object)this.hostIds.get(i));
                hnRow.set("NOTIFID", ntRow.get("NOTIFID"));
                db.addRow(hnRow);
            }
        }
        if (this.groupIds != null) {
            for (i = 0; i < this.groupIds.size(); ++i) {
                Row hgnRow = new Row("HostGroupNotification");
                hgnRow.set("GROUPID", (Object)this.groupIds.get(i));
                hgnRow.set("NOTIFID", ntRow.get("NOTIFID"));
                db.addRow(hgnRow);
            }
        }
        Row nctRow = new Row("NotfnConfigType");
        if (this.isMail && this.isSms) {
            if (!(this.mailTo.equals("") || this.number.equals("0") || this.number.equals(""))) {
                ncRow = new Row("NotfnConfiguration");
                Row ncRows = new Row("NotfnConfigurationSms");
                ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRow.set("MAILID", (Object)this.mailTo);
                ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
                ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
                ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
                ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
                ncRows.set("NOTIFID", lcRow.get("CRIT_ID"));
                ncRows.set("SMSID", (Object)this.number);
                ncRows.set("SMS_DESCRIPTION", (Object)this.smsMessage);
                db.addRow(ncRow);
                db.addRow(ncRows);
                nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
                nctRow.set("NOTIFTYPE", (Object)"MAIL,SMS");
                db.addRow(nctRow);
            }
        } else if (this.isMail) {
            ncRow = new Row("NotfnConfiguration");
            ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            ncRow.set("MAILID", (Object)this.mailTo);
            ncRow.set("MAIL_SUBJECT", (Object)this.mailSubject);
            ncRow.set("MAIL_DESCRIPTION", (Object)this.mailNotes);
            ncRow.set("MAIL_CONTENT", (Object)this.mailBody);
            ncRow.set("MAIL_CONTENT_PLAIN", (Object)this.mailBodyPlain);
            db.addRow(ncRow);
            nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            nctRow.set("NOTIFTYPE", (Object)"MAIL");
            db.addRow(nctRow);
        } else if (this.isSms) {
            ncRow = new Row("NotfnConfigurationSms");
            ncRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            ncRow.set("SMSID", (Object)this.number);
            ncRow.set("SMS_DESCRIPTION", (Object)this.smsMessage);
            db.addRow(ncRow);
            nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            nctRow.set("NOTIFTYPE", (Object)"SMS");
            db.addRow(nctRow);
        } else {
            nctRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            nctRow.set("NOTIFTYPE", (Object)"POPUP");
            db.addRow(nctRow);
        }
        if (this.isScript) {
            Row trRow = new Row("ScriptDetails");
            trRow.set("NOTIFID", lcRow.get("CRIT_ID"));
            trRow.set("LOCATION", (Object)this.scriptLocation);
            trRow.set("ARGUMENTS", (Object)this.scriptArguments);
            db.addRow(trRow);
        }
        return db;
    }

    private DataObject compLAExpression(DataObject db, Object critId, String tableName) throws Exception {
        String compEvtid = "529,612,628,629,517,4625,4719,4724,4725,1102";
        Row compExpRow1 = new Row("LAExpression");
        compExpRow1.set("TABLE_NAME", (Object)tableName);
        compExpRow1.set("COLUMN_NAME", (Object)"EVENTID");
        compExpRow1.set("COMPARATOR", (Object)"=");
        compExpRow1.set("VALUE", (Object)compEvtid);
        db.addRow(compExpRow1);
        Row c2eRow = new Row("LACriteria2Expressions");
        c2eRow.set("CRIT_ID", critId);
        c2eRow.set("EXP_ID", compExpRow1.get("EXP_ID"));
        c2eRow.set("MATCH_ALL", (Object)Boolean.TRUE);
        db.addRow(c2eRow);
        return db;
    }

    private static void addToExpressionTables(DataObject db, Object critId, String columnName, String comparatorStr, String value, boolean matchAllCrit, String tableName) throws Exception {
        Row expRow = new Row("LAExpression");
        expRow.set("TABLE_NAME", (Object)tableName);
        expRow.set("COLUMN_NAME", (Object)columnName);
        expRow.set("COMPARATOR", (Object)comparatorStr);
        expRow.set("VALUE", (Object)value);
        db.addRow(expRow);
        Row c2eRow = new Row("LACriteria2Expressions");
        c2eRow.set("CRIT_ID", critId);
        c2eRow.set("EXP_ID", expRow.get("EXP_ID"));
        c2eRow.set("MATCH_ALL", (Object)matchAllCrit);
        db.addRow(c2eRow);
    }

    private static Long getExpId(DataObject dobj) {
        Long expid = null;
        try {
            Criteria jsontimeralertCrit = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONNotifTimer", 0);
            Row jsonadvrow = dobj.getRow("LAExpression", jsontimeralertCrit);
            if (jsonadvrow != null) {
                expid = (Long)jsonadvrow.get("EXP_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return expid;
    }

    public boolean deleteAlert(Long notifID) throws JSONException, DataAccessException {
        Row r1;
        Iterator itr;
        this.persistence = PersistenceDBUtil.getPersistence();
        DataObject doo = AlertUtil.getDOForProfileID(notifID);
        Long tempLogtype = (Long)doo.getFirstValue("NotificationType", "TYPE");
        if (tempLogtype == -1000L) {
            return false;
        }
        if (tempLogtype == -1002L || tempLogtype == -1001L) {
            return false;
        }
        if (tempLogtype == -1L) {
            AS400LogPreProcessor.resetAlertVariables();
        }
        if (doo.containsTable("HostNotification")) {
            itr = doo.getRows("HostNotification");
            while (itr.hasNext()) {
                r1 = (Row)itr.next();
                this.persistence.delete(r1);
            }
        } else if (doo.containsTable("HostGroupNotification")) {
            itr = doo.getRows("HostGroupNotification");
            while (itr.hasNext()) {
                r1 = (Row)itr.next();
                this.persistence.delete(r1);
            }
        }
        Row r2 = new Row("LACriteria");
        r2.set("CRIT_ID", (Object)notifID);
        this.persistence.delete(r2);
        SelectQueryImpl sql2 = new SelectQueryImpl(Table.getTable((String)"NotfnConfigType"));
        Column col2 = Column.getColumn((String)"NotfnConfigType", (String)"NOTIFID");
        Criteria cri2 = new Criteria(col2, (Object)notifID, 0);
        sql2.setCriteria(cri2);
        sql2.addSelectColumn(Column.getColumn((String)"NotfnConfigType", (String)"*"));
        DataObject doo2 = this.persistence.get((SelectQuery)sql2);
        Iterator itr2 = doo2.getRows("NotfnConfigType");
        while (itr2.hasNext()) {
            Row r4 = (Row)itr2.next();
            this.persistence.delete(r4);
        }
        Row r3 = new Row("NotfnConfiguration");
        Row rs3 = new Row("NotfnConfigurationSms");
        r3.set("NOTIFID", (Object)notifID);
        rs3.set("NOTIFID", (Object)notifID);
        this.persistence.delete(r3);
        this.persistence.delete(rs3);
        NotificationManager.getInstance().deleteProfile(notifID);
        IncidentToolConstants.getInstance().refreshToolSettings();
        return true;
    }

    public void deleteAlert(JSONObject reqJsonObject, ResponseBuilder responseBuilder, Long userId, boolean isAdmin) throws JSONException, DataAccessException {
        ArrayList<Long> notifIDList = new ArrayList<Long>();
        JSONArray notifIds = reqJsonObject.getJSONArray("LIST");
        StringBuilder notifIDString = new StringBuilder();
        notifIDString.append("(");
        boolean deleteAlerts = reqJsonObject.optBoolean("DELETE_ALERTS");
        String status = "success";
        for (int i = 0; i < notifIds.length(); ++i) {
            try {
                Long nid = notifIds.getLong(i);
                notifIDList.add(nid);
                notifIDString.append(String.valueOf(nid));
                notifIDString.append(",");
                if (this.deleteAlert(nid)) continue;
                responseBuilder.setResponse(BaseStatusCode.getBaseStatusCode(7426));
                return;
            }
            catch (Exception e) {
                status = "failure";
                e.printStackTrace();
            }
        }
        notifIDString.deleteCharAt(notifIDString.length() - 1);
        notifIDString.append(")");
        if (deleteAlerts) {
            this.deleteAlertsforProfile(notifIDString, notifIDList);
        }
        JSONObject result = new JSONObject();
        result.put("status", (Object)status);
        responseBuilder.setResponse(result);
    }

    private void deleteAlertsforProfile(StringBuilder notifIDString, List<Long> notifIDList) throws DataAccessException {
        DeleteQueryImpl deleteQuery = new DeleteQueryImpl("LAAlertAudit");
        deleteQuery.setCriteria(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NF_ID"), (Object)notifIDList.toArray(), 8));
        PersistenceDBUtil.getPersistence().delete((DeleteQuery)deleteQuery);
        this.deleteAlertFromSplitTables(notifIDString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlertFromSplitTables(StringBuilder notifIDString) throws DataAccessException {
        Connection conn = null;
        Statement stat = null;
        StringBuilder notifID = new StringBuilder();
        ArrayList templ = new ArrayList();
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"MetaTable"));
        sql.addSelectColumn(Column.getColumn((String)"MetaTable", (String)"*"));
        sql.setCriteria(new Criteria(Column.getColumn((String)"MetaTable", (String)"LOOKUP_TABLENAME"), (Object)"LAAlertAudit_*", 2));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        Iterator itr = dobj.getRows("MetaTable");
        try {
            String deleteQuery = null;
            Object finalQuery = null;
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            conn.setAutoCommit(false);
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String table = (String)r.get("LOOKUP_TABLENAME");
                deleteQuery = "Delete from " + table + " Where NF_ID IN " + notifIDString.toString();
                stat.addBatch(deleteQuery);
            }
            stat.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
            stat = null;
        }
    }

    public void enableOrDisableAlert(JSONObject reqJsonObject, ResponseBuilder responseBuilder, Long userId, boolean isAdmin) {
        String status = "success";
        this.persistence = PersistenceDBUtil.getPersistence();
        try {
            JSONArray profiles = reqJsonObject.getJSONArray("LIST");
            for (int i = 0; i < profiles.length(); ++i) {
                Long notifId = new Long(profiles.getString(i));
                Table t = Table.getTable((String)"NotificationType");
                SelectQueryImpl sql = new SelectQueryImpl(t);
                Column col = Column.getColumn((String)"NotificationType", (String)"NOTIFID");
                Criteria cri = new Criteria(col, (Object)notifId, 0);
                sql.setCriteria(cri);
                sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
                sql.addSelectColumn(Column.getColumn((String)"HostNotification", (String)"*"));
                sql.addSelectColumn(Column.getColumn((String)"HostGroupNotification", (String)"*"));
                Join j = new Join(t, Table.getTable((String)"HostNotification"), new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1);
                Join j1 = new Join(t, Table.getTable((String)"HostGroupNotification"), new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1);
                sql.addJoin(j);
                sql.addJoin(j1);
                DataObject doo = this.persistence.get((SelectQuery)sql);
                Row r = doo.getFirstRow("NotificationType");
                Long tempLogtype = (Long)doo.getFirstValue("NotificationType", "TYPE");
                if (!AlertUtil.validateProfiles(notifId, userId, isAdmin)) {
                    responseBuilder.setResponse(BaseStatusCode.getBaseStatusCode(7426));
                    return;
                }
                if (tempLogtype == -1002L) {
                    if (reqJsonObject.getString("ACTION").equals("ENABLEALERT")) {
                        CorrelationConfigHandler.enableDisableCorrelationNotification(AlertUtil.getRuleIDForNotifID(notifId), true);
                        continue;
                    }
                    CorrelationConfigHandler.enableDisableCorrelationNotification(AlertUtil.getRuleIDForNotifID(notifId), false);
                    continue;
                }
                Integer newStatusInt = null;
                newStatusInt = reqJsonObject.getString("ACTION").equals("ENABLEALERT") ? new Integer(1) : new Integer(0);
                r.set("STATUS", (Object)newStatusInt);
                doo.updateRow(r);
                NotificationManager.getInstance().changeNotificationStatus(notifId, newStatusInt);
                this.persistence.update(doo);
            }
        }
        catch (Exception e) {
            status = "failure";
            e.printStackTrace();
        }
        JSONObject returnJson = new JSONObject();
        try {
            returnJson.put("status", (Object)status);
            responseBuilder.setResponse(returnJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

