/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LaUtil;
import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.settings.notification.util.NotificationSettingsUtil;
import com.manageengine.ela.server.correlation.notification.CorrelationNotificationHandler;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import com.zoho.za.ela.logsearch.criteria.ConvertToLuceneSyntax;
import com.zoho.za.ela.logsearch.criteria.JSONCriteriaHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlertProfileDataRetriever {
    private static ProductBundle bundle = ProductBundle.getInstance();

    public static void getDetails(JSONObject requestJsonObject, ResponseBuilder responseBuilder, Long userID, Locale locale) throws Exception {
        JSONArray as400messageID = new JSONArray();
        as400messageID.put((Object)"SI");
        as400messageID.put((Object)"EI");
        as400messageID.put((Object)"AF");
        as400messageID.put((Object)"CA");
        as400messageID.put((Object)"CP");
        as400messageID.put((Object)"DO");
        as400messageID.put((Object)"JS");
        as400messageID.put((Object)"OW");
        as400messageID.put((Object)"PW");
        as400messageID.put((Object)"SV");
        JSONArray as400messages = new JSONArray();
        as400messages.put((Object)"Logons");
        as400messages.put((Object)"Logoffs");
        as400messages.put((Object)"Authorization Failure");
        as400messages.put((Object)"Change Authority");
        as400messages.put((Object)"Change User Profile");
        as400messages.put((Object)"Delete Object");
        as400messages.put((Object)"Job Change");
        as400messages.put((Object)"Ownership Change");
        as400messages.put((Object)"Invalid Password");
        as400messages.put((Object)"System Value Changes");
        boolean isHTMLFormat = AlertUtil.getAlertMailFormat().equalsIgnoreCase("html");
        boolean isFim = false;
        boolean isAs400 = false;
        boolean fromSearch = false;
        boolean isEdit = requestJsonObject.getString("OPERATION").equalsIgnoreCase("get_edit_data");
        JSONObject returnJson = new JSONObject();
        if (isEdit && requestJsonObject.has("PROFILE") && requestJsonObject.get("PROFILE") != null) {
            JSONObject editObject = AlertProfileDataRetriever.getEditAlertData(requestJsonObject.getString("PROFILE"), locale, isHTMLFormat);
            if (editObject.has("isAS400")) {
                isAs400 = true;
            }
            if (editObject.has("isFim")) {
                isFim = true;
            }
            returnJson.put("editData", (Object)editObject);
        }
        if (requestJsonObject.has("isFim") && !isFim) {
            isFim = requestJsonObject.getBoolean("isFim");
        }
        if (requestJsonObject.has("isAS400") || isAs400) {
            returnJson.put("as400messageID", (Object)as400messageID);
            returnJson.put("as400message", (Object)as400messages);
            if (!isAs400) {
                isAs400 = requestJsonObject.getBoolean("isAS400");
            }
        }
        if (requestJsonObject.has("isFromSearch")) {
            JSONArray hostids;
            fromSearch = requestJsonObject.getBoolean("isFromSearch");
            JSONArray jSONArray = hostids = requestJsonObject.has("hostID") ? requestJsonObject.getJSONArray("hostID") : null;
            if (fromSearch && requestJsonObject.has("userCriteraForSearch")) {
                try {
                    String userCriteria = requestJsonObject.getString("userCriteraForSearch");
                    if (userCriteria != null && !userCriteria.isEmpty()) {
                        userCriteria = userCriteria.replace("&quot;", "\"");
                        userCriteria = ConvertToLuceneSyntax.getInstance().convert(userCriteria);
                        JSONCriteriaHandler jsonCritStr = new JSONCriteriaHandler(userCriteria);
                        String critStr = jsonCritStr.getJSONString();
                        returnJson.put("criteriaForSearch", (Object)new JSONObject(critStr));
                    }
                }
                catch (Exception e) {
                    returnJson.put("testSearch", (Object)"");
                }
            }
            if (hostids != null && hostids.length() > 0) {
                JSONObject countObject = new JSONObject();
                for (int i = 0; i < hostids.length(); ++i) {
                    Long groupID = AlertUtil.getGroupIDForDeviceID(hostids.getLong(i));
                    if (countObject.has(String.valueOf(groupID))) {
                        int count = countObject.getInt(String.valueOf(groupID));
                        countObject.remove(String.valueOf(groupID));
                        countObject.put(String.valueOf(groupID), count + 1);
                        continue;
                    }
                    countObject.put(String.valueOf(groupID), 1);
                }
                returnJson.put("deviceGroupCount", (Object)countObject);
            }
        }
        JSONArray severity = new JSONArray();
        severity.put((Object)bundle.getString("AddAlert.High"));
        severity.put((Object)bundle.getString("AddAlert.Medium"));
        severity.put((Object)bundle.getString("AddAlert.Low"));
        returnJson.put("severityList", (Object)severity);
        JSONObject serverSettings = NotificationSettingsUtil.getServerConfigurationSettings();
        String mailID = LaUtil.getInstance().getUserMailId((Object)userID);
        if (mailID != null && (mailID == null || !mailID.equalsIgnoreCase("domain@domain.com") && !mailID.equalsIgnoreCase("aaaadmin@adventnet.com"))) {
            returnJson.put("adminMailID", (Object)mailID);
        }
        returnJson.put("mail", serverSettings.get("mail"));
        returnJson.put("sms", serverSettings.get("sms"));
        JSONArray arr = new JSONArray();
        for (int i = 0; i < 24; ++i) {
            arr.put(i);
        }
        returnJson.put("time", (Object)arr);
        String workingHours = LaUtil.getRanges((ArrayList)DepartmentUtil.getWorkHourList());
        String nonWorkingHours = LaUtil.getRanges((ArrayList)DepartmentUtil.getNonWorkHourList());
        JSONObject workingHourDetails = new JSONObject();
        workingHourDetails.put("workingHours", (Object)workingHours);
        workingHourDetails.put("nonWorkingHours", (Object)nonWorkingHours);
        returnJson.put("workHourDetails", (Object)workingHourDetails);
        JSONArray body = new JSONArray();
        String[] bodyContent = new String[]{"IENAME", "MESSAGE"};
        for (int i = 0; i < bodyContent.length; ++i) {
            JSONObject obj = new JSONObject();
            obj.put("title", (Object)bundle.getString(bodyContent[i]));
            obj.put("value", (Object)bodyContent[i]);
            body.put((Object)obj);
        }
        returnJson.put("bodyContent", (Object)body);
        returnJson.put("IS_HTML_FORMAT", isHTMLFormat);
        if (!isEdit) {
            returnJson.put("defMailContent", (Object)AlertUtil.getDefaultAlertMailContent(null, isHTMLFormat));
        }
        responseBuilder.setResponse(returnJson);
    }

    public static void getReportData(JSONObject requestJson, Long userID, ResponseBuilder responseBuilder) {
        boolean isFim = requestJson.has("isFim");
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"Report_LogTypes"));
        sql.addSelectColumn(Column.getColumn((String)"Report_LogTypes", (String)"*"));
        sql.setCriteria(new Criteria(Column.getColumn((String)"Report_LogTypes", (String)"ALERT_TAB_REPORT"), (Object)true, 0));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"Report_LogTypes", (String)"ORDER_NO"), true);
        sql.addSortColumn(sortColumn);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator itr = dobj.getRows("Report_LogTypes");
            JSONArray logTypelist = new JSONArray();
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String name = (String)r.get("REPORTNAME");
                logTypelist.put((Object)name);
            }
            SelectQueryImpl rql = new SelectQueryImpl(Table.getTable((String)"ImportantReports"));
            String[] notinAlerts = new String[]{"dhcp_linux", "iis_w3cftp", "apache_logs", "iis_w3cweb", "dhcp_windows"};
            Criteria cr1 = new Criteria(Column.getColumn((String)"ImportantReportsGroup", (String)"GROUP_LOGTYPE"), (Object)notinAlerts, 9);
            Criteria cr2 = new Criteria(Column.getColumn((String)"ImportantReportsGroup", (String)"GROUP_CREATED_BY"), (Object)"SYSTEM", 0).and(cr1);
            Criteria cr3 = new Criteria(Column.getColumn((String)"ImportantReports", (String)"REP_TYPE"), (Object)"normal", 0).and(cr2);
            Criteria cr4 = new Criteria(Column.getColumn((String)"ImportantReports", (String)"SQLTYPE"), (Object)"lucene", 0).and(cr3);
            if (!Boolean.valueOf(System.getProperty("IS_SERVERREPORTS_SHOW")).booleanValue()) {
                cr4 = cr4.and(new Criteria(Column.getColumn((String)"ImportantReports", (String)"ISADREPORT"), (Object)false, 0));
            }
            JSONObject obbb = new JSONObject();
            rql.addJoin(new Join("ImportantReports", "ImportantReportsGroup", new String[]{"IMP_GROUP_NAME"}, new String[]{"IMP_GROUP_NAME"}, 1));
            rql.addSelectColumn(Column.getColumn((String)"ImportantReportsGroup", (String)"*"));
            JSONArray newFields = new JSONArray();
            for (int ii = 0; ii < logTypelist.length(); ++ii) {
                String logtypeString = logTypelist.getString(ii);
                JSONArray js = new JSONArray();
                String logType = logTypelist.getString(ii);
                rql.setCriteria(cr4.and(new Criteria(Column.getColumn((String)"ImportantReportsGroup", (String)"GROUP_TYPE"), (Object)logType, 0)));
                DataObject obje = PersistenceDBUtil.getPersistence().get((SelectQuery)rql);
                Iterator itt = obje.getRows("ImportantReportsGroup");
                while (itt.hasNext()) {
                    Row r = (Row)itt.next();
                    String repname = (String)r.get("IMP_GROUP_NAME");
                    js.put((Object)repname);
                }
                obbb.put(logType.toUpperCase().replaceAll(" ", ""), (Object)js);
                JSONObject fieldObj = new JSONObject();
                Map<String, List<List>> map = FieldRepository.get_instance().getAllTypeVsColsMap();
                if (!map.containsKey(logtypeString)) continue;
                ArrayList tempList = (ArrayList)map.get(logtypeString);
                fieldObj.put("key", (Object)logtypeString);
                LinkedHashSet temp = (LinkedHashSet)tempList.get(1);
                temp.remove("MESSAGE");
                temp.remove("IENAME");
                temp.remove("TIME");
                fieldObj.put("value", (Object)new JSONArray((Collection)temp));
                newFields.put((Object)fieldObj);
            }
            if (isFim) {
                LinkedHashSet fimFields = (LinkedHashSet)((Object)FieldRepository.get_instance().getAllTypeVsColsMap().get("FIM").get(0));
                fimFields.remove("MESSAGE");
                fimFields.remove("TIME");
                JSONObject tempObj = new JSONObject();
                tempObj.put("key", (Object)"FIM");
                tempObj.put("value", (Object)new JSONArray((Collection)fimFields));
                newFields = new JSONArray();
                newFields.put((Object)tempObj);
            }
            JSONArray complianceArray = new JSONArray();
            Criteria crit = new Criteria(Column.getColumn((String)"AuditPolicyNames", (String)"POLICY_STATUS"), (Object)new Long("1"), 0);
            DataObject policyDO = PersistenceDBUtil.getPersistence().get("AuditPolicyNames", crit);
            Iterator policyItr = policyDO.getRows("AuditPolicyNames");
            while (policyItr.hasNext()) {
                Row policyRow = (Row)policyItr.next();
                String policyName = (String)policyRow.get("POLICY_NAME");
                if ("SecurityEvents".equals(policyName)) continue;
                complianceArray.put((Object)policyName);
            }
            JSONObject finaljsonobj = new JSONObject();
            finaljsonobj.put("logTypeList", (Object)logTypelist);
            finaljsonobj.put("report", (Object)obbb);
            finaljsonobj.put("complianceList", (Object)complianceArray);
            finaljsonobj.put("newFields", (Object)newFields);
            responseBuilder.setResponse(finaljsonobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map getLogTypeMap(boolean fim, ResourceBundle bundle) {
        Row r;
        DataObject dobj;
        SelectQueryImpl sql;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            sql = new SelectQueryImpl(Table.getTable((String)"Search_LogTypes"));
            sql.addSelectColumn(Column.getColumn((String)"Search_LogTypes", (String)"*"));
            Criteria fimCriteria = !fim ? new Criteria(Column.getColumn((String)"Search_LogTypes", (String)"LOGTYPE"), (Object)"FIM", 1) : new Criteria(Column.getColumn((String)"Search_LogTypes", (String)"LOGTYPE"), (Object)"FIM", 0);
            sql.setCriteria(fimCriteria);
            dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator itr = dobj.getRows("Search_LogTypes");
            while (itr.hasNext()) {
                r = (Row)itr.next();
                String logType = (String)r.get("LOGTYPE");
                String viewName = (String)r.get("VIEW_NAME");
                map.put(AlertProfileDataRetriever.getI18NJString(viewName, bundle), logType);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        if (EAService.showPremiumFeatures()) {
            String type;
            SelectQueryImpl query;
            try {
                sql = new SelectQueryImpl(Table.getTable((String)"FormatDetails"));
                sql.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
                String[] excludeFormats = new String[]{"sys_archive", "win_archive", "cisco_archive", "syslog"};
                Criteria excludeCriteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)excludeFormats, 9);
                sql.setCriteria(excludeCriteria);
                String[] joinCol = new String[]{"FORMATID"};
                Join j = new Join("FormatDetails", "FormatFields", joinCol, joinCol, 2);
                sql.addJoin(j);
                DataObject dobj2 = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
                Iterator itr = dobj2.getRows("FormatDetails");
                while (itr.hasNext()) {
                    Row r2 = (Row)itr.next();
                    Long formatId = (Long)r2.get("FORMATID");
                    String formatDesc = (String)r2.get("FORMATDESC");
                    map.put(AlertProfileDataRetriever.getI18NJString(formatDesc, bundle), String.valueOf(formatId));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            List customFormats = CustomLogTypePatterns.getAllCustomLogTypeNames();
            for (String name : customFormats) {
                long formatId = SystemCustomPatternHandler.getInstance().getFormatIdForName(name);
                if (formatId <= -1L) continue;
                map.put(name, String.valueOf(formatId));
            }
            try {
                query = new SelectQueryImpl(Table.getTable((String)"AddOnHostGroup"));
                query.addSelectColumn(Column.getColumn((String)"AddOnHostGroup", (String)"*"));
                dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                Iterator itr = dobj.getRows("AddOnHostGroup");
                while (itr.hasNext()) {
                    r = (Row)itr.next();
                    type = (String)r.get("NAME");
                    map.put(type, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                query = new SelectQueryImpl(Table.getTable((String)"SyslogAddons"));
                query.addSelectColumn(Column.getColumn((String)"SyslogAddons", (String)"*"));
                dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                Iterator itr = dobj.getRows("SyslogAddons");
                while (itr.hasNext()) {
                    r = (Row)itr.next();
                    type = (String)r.get("SECAPPTYPE");
                    if (type.indexOf("Symantec") != -1) {
                        type = type.indexOf("DLP") != -1 ? "SYMANTEC_DLP" : "SYMANTEC";
                    }
                    map.put(type, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static String getI18NJString(String input, ResourceBundle bundle) {
        String toReturn = input;
        try {
            toReturn = bundle.getString(input);
        }
        catch (Exception exp) {
            toReturn = input;
        }
        return toReturn;
    }

    public static void getCustomFields(ResponseBuilder responseBuilder) throws Exception {
        ResourceBundle bundle = ProductBundle.getInstance().getBundle();
        Map logTypeDescVsTypeOrId = AlertProfileDataRetriever.getLogTypeMap(false, bundle);
        Map<String, List<List>> logTypeVsFieldsMap = FieldRepository.get_instance().getAllTypeVsColsMap();
        List FimlogTypeVsFieldsMap = FieldRepository.get_instance().getIndexedFields("FIM");
        Iterator logTypeMapItr = logTypeDescVsTypeOrId.entrySet().iterator();
        JSONArray crtArray = new JSONArray();
        JSONArray logTypeArray = new JSONArray();
        ArrayList<String> checkList = new ArrayList<String>();
        while (logTypeMapItr.hasNext()) {
            JSONObject crtFld = new JSONObject();
            Map.Entry entry = logTypeMapItr.next();
            String logTypeI18NStr = (String)entry.getKey();
            String logTypeOrFormatId = (String)entry.getValue();
            crtFld.put("key", (Object)logTypeI18NStr);
            crtFld.put("value", (Object)logTypeOrFormatId);
            logTypeArray.put((Object)crtFld);
            crtFld = new JSONObject();
            List<List> fieldNameList = logTypeVsFieldsMap.get(logTypeOrFormatId);
            if (fieldNameList == null) continue;
            ArrayList<String> fieldNames = new ArrayList<String>(fieldNameList.get(0));
            fieldNameList = null;
            fieldNames.remove("TIME");
            String[] missingFields = new String[]{"MESSAGE", "LOGTYPE"};
            for (int i = 0; i < missingFields.length; ++i) {
                fieldNames.remove(missingFields[i]);
                fieldNames.add(i, missingFields[i]);
            }
            JSONArray arr = new JSONArray();
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = (String)fieldNames.get(i);
                if (checkList.contains(fieldName)) continue;
                checkList.add(fieldName);
                JSONObject obj = new JSONObject();
                obj.put("value", (Object)fieldName);
                obj.put("title", (Object)AlertProfileDataRetriever.getI18NJString(fieldName, bundle));
                arr.put((Object)obj);
            }
            crtFld.put(logTypeI18NStr, (Object)arr);
            crtArray.put((Object)crtFld);
        }
        JSONObject retObject = new JSONObject();
        retObject.put("customFields", (Object)crtArray);
        retObject.put("customLogTypes", (Object)logTypeArray);
        responseBuilder.setResponse(retObject);
    }

    public static JSONObject getEditAlertData(String profile, Locale locale, boolean isHTMLFormat) throws Exception {
        Long tempLogtype;
        long groupcount;
        boolean isDefaultThreat = false;
        boolean isFim = false;
        boolean isAS400 = false;
        boolean isCorrelationProfile = false;
        JSONObject returnJSON = new JSONObject();
        Long notifId = new Long(profile);
        JSONArray groupList = new JSONArray();
        JSONArray deviceList = new JSONArray();
        JSONArray displayList = new JSONArray();
        DataObject predoo = AlertUtil.getDOForProfileID(notifId);
        String alertName = (String)predoo.getFirstValue("NotificationType", "NOTIFNAME");
        if (((Boolean)predoo.getFirstValue("NotificationType", "ISRESOLVENEEDED")).booleanValue()) {
            alertName = bundle.getString(alertName);
        }
        returnJSON.put("alertName", (Object)alertName);
        String criticality = (String)predoo.getFirstValue("NotificationType", "CRITICALITY");
        if (criticality.equalsIgnoreCase("high")) {
            returnJSON.put("criticality", 0);
        } else if (criticality.equalsIgnoreCase("medium")) {
            returnJSON.put("criticality", 1);
        } else {
            returnJSON.put("criticality", 2);
        }
        Iterator hgIt = predoo.getRows("HostGroup");
        while (hgIt.hasNext()) {
            Row hgRow = (Row)hgIt.next();
            if ((Long)DeviceGroupUtil.getDeviceCount(hgRow.get("ID")) == 0L) continue;
            groupList.put(hgRow.get("ID"));
            displayList.put((Object)((String)hgRow.get("NAME")));
        }
        returnJSON.put("groups", (Object)groupList);
        JSONObject countObject = new JSONObject();
        Iterator hIt = predoo.getRows("Hosts");
        while (hIt.hasNext()) {
            Row hRow = (Row)hIt.next();
            Long hostID = (Long)hRow.get("HOST_ID");
            deviceList.put((Object)hostID);
            displayList.put((Object)((String)hRow.get("DISPLAY_NAME")));
            Long groupID = AlertUtil.getGroupIDForDeviceID((long)hostID);
            if (countObject.has(String.valueOf(groupID))) {
                int count = countObject.getInt(String.valueOf(groupID));
                countObject.remove(String.valueOf(groupID));
                countObject.put(String.valueOf(groupID), count + 1);
                continue;
            }
            countObject.put(String.valueOf(groupID), 1);
        }
        returnJSON.put("devices", (Object)deviceList);
        returnJSON.put("displayText", (Object)displayList);
        returnJSON.put("deviceGroupCount", (Object)countObject);
        if (isDefaultThreat && (groupcount = AlertUtil.getGroupCount()) == (long)groupList.length()) {
            returnJSON.put("selectAll", true);
        }
        if ((tempLogtype = (Long)predoo.getFirstValue("NotificationType", "TYPE")) == -1000L) {
            isDefaultThreat = true;
            returnJSON.put("isDefaultProfile", true);
        } else if (tempLogtype == -1002L) {
            returnJSON.put("isCorrelationProfile", true);
            isCorrelationProfile = true;
            JSONObject correlationData = new JSONObject();
            correlationData.put("BODY_MACROS", (Object)CorrelationUtil.getCorrelationActionsAndFieldsList(notifId, locale, false));
            correlationData.put("SUBJECT_MACROS", (Object)CorrelationUtil.getCorrelationActionsAndFieldsList(notifId, locale, true));
            returnJSON.put("CorrelationData", (Object)correlationData);
        }
        NotificationManager nfManager = NotificationManager.getInstance();
        if (tempLogtype == -1L && nfManager.isAS400Profile(notifId)) {
            isAS400 = true;
            returnJSON.put("isAS400", true);
        }
        String alertType = "";
        if (tempLogtype == 1L) {
            alertType = "compliance";
        } else if (tempLogtype == 257L) {
            alertType = "predefined";
        } else if (tempLogtype == 256L) {
            returnJSON.put("isFim", true);
            alertType = "fim";
        } else {
            alertType = isAS400 ? "as400" : "custom";
        }
        returnJSON.put("alertType", (Object)alertType);
        ArrayList<String> startEndArray = new ArrayList<String>();
        Integer occurrances = (Integer)predoo.getFirstValue("NotificationType", "NOOFOCCURRENCE");
        Integer interval = (Integer)predoo.getFirstValue("NotificationType", "NOTIFINTERVAL");
        Integer triggerTime = (Integer)predoo.getFirstValue("NotificationType", "TRIGGERTIME");
        int timeint = interval / 60;
        if (occurrances == 1) {
            returnJSON.put("isThreshold", false);
        } else {
            returnJSON.put("isThreshold", true);
            returnJSON.put("occurances", (Object)occurrances);
            returnJSON.put("interval", timeint);
        }
        if (triggerTime == 0) {
            returnJSON.put("isTimeRange", false);
        } else if (triggerTime == 1) {
            returnJSON.put("isTimeRange", true);
            returnJSON.put("timeRangeType", (Object)"Working");
        } else if (triggerTime == 2) {
            returnJSON.put("isTimeRange", true);
            returnJSON.put("timeRangeType", (Object)"Non Working");
        } else if (triggerTime == 3) {
            returnJSON.put("isTimeRange", true);
            returnJSON.put("timeRangeType", (Object)"Custom");
            Iterator itr = predoo.getRows("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"CustomTriggerStartEnd", 0));
            while (itr.hasNext()) {
                Row rw = (Row)itr.next();
                String colName = (String)rw.get("COLUMN_NAME");
                if (!colName.equalsIgnoreCase("CustomTriggerStartEnd")) continue;
                String startEndValue = (String)rw.get("VALUE");
                startEndArray.add(startEndValue.split(",")[0]);
                startEndArray.add(startEndValue.split(",")[1]);
            }
            returnJSON.put("startFrom", startEndArray.get(0));
            returnJSON.put("endAt", startEndArray.get(1));
        }
        Iterator jsonNotifItr = predoo.getRows("LAExpression");
        String advnotifAlert = "";
        String notiftimertype = "";
        String notifdays = "";
        String notifhours = "";
        String notifminutes = "";
        Boolean notifstatus = false;
        while (jsonNotifItr.hasNext()) {
            Row alertrow = (Row)jsonNotifItr.next();
            String column = (String)alertrow.get("COLUMN_NAME");
            if (!column.equals("JSONNotifTimer")) continue;
            advnotifAlert = (String)alertrow.get("VALUE");
            JSONObject jsonNotifAlert = new JSONObject(advnotifAlert);
            notifstatus = (Boolean)jsonNotifAlert.get("notifstatus");
            returnJSON.put("notifStatus", (Object)notifstatus);
            notiftimertype = (String)jsonNotifAlert.get("notiftimertype");
            returnJSON.put("notificationtype", (Object)notiftimertype);
            if (!notifstatus.booleanValue()) {
                returnJSON.put("notificationtype", (Object)"all");
            }
            if (!"custom".equals(notiftimertype) || !notifstatus.booleanValue()) break;
            notifdays = (String)jsonNotifAlert.get("notifdays");
            notifhours = (String)jsonNotifAlert.get("notifhours");
            notifminutes = (String)jsonNotifAlert.get("notifminutes");
            returnJSON.put("notifdays", (Object)notifdays);
            returnJSON.put("notifhours", (Object)notifhours);
            returnJSON.put("notifminutes", (Object)notifminutes);
            break;
        }
        Iterator itr = predoo.getRows("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONNotifTimer", 1));
        String colName = null;
        StringBuffer sb = new StringBuffer();
        JSONArray severityArray = new JSONArray();
        String advJsonCritStr = "";
        String jsonStrCustom = "";
        String jsonAlertTxtVal = "";
        String eventids = "";
        boolean sevCount = false;
        while (itr.hasNext()) {
            Row rw = (Row)itr.next();
            colName = (String)rw.get("COLUMN_NAME");
            if ("JSONAlertCrit".equals(colName) || "JSONAlertCritCustom".equalsIgnoreCase(colName) || "JSONAlertTxtVal".equalsIgnoreCase(colName)) {
                if ("JSONAlertCrit".equals(colName)) {
                    advJsonCritStr = (String)rw.get("VALUE");
                    if (returnJSON.has("isFim") && returnJSON.getBoolean("isFim")) {
                        if (advJsonCritStr.toLowerCase().indexOf("logtype") == -1) {
                            returnJSON.put("logtypeForFim", false);
                        } else {
                            returnJSON.put("logtypeForFim", true);
                        }
                    }
                    returnJSON.put("alertCriteria", (Object)new JSONObject(advJsonCritStr));
                }
                if ("JSONAlertCritCustom".equalsIgnoreCase(colName) && !(jsonStrCustom = (String)rw.get("VALUE")).equals("")) {
                    returnJSON.put("customCrit", (Object)new JSONObject(jsonStrCustom));
                }
                if ("".equals(jsonStrCustom)) {
                    jsonStrCustom = "''";
                }
                if (!"JSONAlertTxtVal".equalsIgnoreCase(colName)) continue;
                jsonAlertTxtVal = (String)rw.get("VALUE");
                JSONObject alertTxtVal = new JSONObject(jsonAlertTxtVal);
                returnJSON.put("alertTextVal", (Object)alertTxtVal);
                String reportName = alertTxtVal.getString("hostID");
                SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"ImportantReports"));
                sql.setCriteria(new Criteria(Column.getColumn((String)"ImportantReports", (String)"IMP_REPORTNAME"), (Object)reportName, 0));
                sql.addSelectColumn(Column.getColumn((String)"ImportantReports", (String)"*"));
                DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
                Iterator repItr = obj.getRows("ImportantReports");
                if (!repItr.hasNext()) continue;
                Row r = (Row)repItr.next();
                String val = (String)r.get("ALERTFIELDS");
                String i18nName = bundle.getString((String)r.get("IMP_ALERTNAME"));
                returnJSON.put("alertFields", (Object)val);
                returnJSON.put("selectedPredefinedAlert", (Object)((Long)r.get("IMPID")));
                returnJSON.put("predefinedAlertName", (Object)i18nName);
                continue;
            }
            if (colName.equals("EXCLUDEEVENTID")) {
                eventids = (String)rw.get("VALUE");
                returnJSON.put("excludeEventIds", (Object)eventids);
            }
            if (colName.equals("SEVERITY")) {
                severityArray.put((Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("EVENTID")) {
                returnJSON.put("isSeverity", false);
                returnJSON.put("eventids", (Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("AlertMsgType")) {
                returnJSON.put("alertMessageType", (Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("MESSAGE")) {
                String mes = (String)rw.get("VALUE");
                String comparator = (String)rw.get("COMPARATOR");
                if (mes.indexOf("|") >= 0) {
                    returnJSON.put("logMessageContains", (Object)mes.substring(0, mes.indexOf("|")).replaceAll("\"", "&quot;"));
                    returnJSON.put("logMessageExcept", (Object)mes.substring(mes.indexOf("|") + 1).replaceAll("\"", "&quot;"));
                } else {
                    returnJSON.put("logMessageContains", (Object)mes);
                }
            }
            if (colName.equals("SOURCE")) {
                returnJSON.put("logMessageSource", (Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("USERNAME")) {
                returnJSON.put("logMessageUser", (Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("EnableHostsStatus") && isDefaultThreat) {
                returnJSON.put("enableHostsForDefault", (Object)((String)rw.get("VALUE")));
            }
            if (colName.equals("AS400SEVERITY")) {
                String value = (String)rw.get("VALUE");
                JSONArray sevArr = new JSONArray();
                String[] sevVal = value.split(",");
                block25: for (int i = 0; i < sevVal.length; ++i) {
                    switch (sevVal[i]) {
                        case "0": {
                            sevArr.put((Object)"Emergency");
                            continue block25;
                        }
                        case "1": {
                            sevArr.put((Object)"Alert");
                            continue block25;
                        }
                        case "2": {
                            sevArr.put((Object)"Critical");
                            continue block25;
                        }
                        case "3": {
                            sevArr.put((Object)"Error");
                            continue block25;
                        }
                        case "4": {
                            sevArr.put((Object)"Warning");
                            continue block25;
                        }
                        case "5": {
                            sevArr.put((Object)"Notice");
                            continue block25;
                        }
                        case "6": {
                            sevArr.put((Object)"Information");
                            continue block25;
                        }
                        case "7": {
                            sevArr.put((Object)"Debug");
                            continue block25;
                        }
                        default: {
                            sevArr.put((Object)sevVal[i]);
                        }
                    }
                }
                returnJSON.put("severityList", (Object)sevArr);
            }
            if (colName.equals("MESSAGEID")) {
                returnJSON.put("messageID", (Object)((String)rw.get("VALUE")));
            }
            if (!colName.equals("JOBNAME")) continue;
            returnJSON.put("jobname", (Object)((String)rw.get("VALUE")));
        }
        if (severityArray.length() > 0) {
            returnJSON.put("isSeverity", true);
            returnJSON.put("severityList", (Object)severityArray);
        }
        Iterator mailItr = predoo.getRows("NotfnConfiguration");
        JSONArray corrRuleIds = AlertUtil.getRuleIDForNotifID(notifId);
        if (mailItr.hasNext()) {
            Row r = (Row)mailItr.next();
            returnJSON.put("isMail", true);
            returnJSON.put("mailTo", (Object)((String)r.get("MAILID")));
            returnJSON.put("mailSubject", (Object)((String)r.get("MAIL_SUBJECT")));
            returnJSON.put("mailDescription", (Object)((String)r.get("MAIL_DESCRIPTION")));
            String mailContent = isHTMLFormat ? (String)r.get("MAIL_CONTENT") : (String)r.get("MAIL_CONTENT_PLAIN");
            String mailDesc = (String)r.get("MAIL_DESCRIPTION");
            if (mailContent == null || mailContent.isEmpty() || mailContent.equals("-")) {
                if (isCorrelationProfile) {
                    mailContent = CorrelationNotificationHandler.getInstance().getDefaultCorrEmailMessage(corrRuleIds.getLong(0), isHTMLFormat);
                    if (!mailDesc.isEmpty() && !mailDesc.equals("-")) {
                        mailContent = mailContent.concat("\n" + mailDesc);
                    }
                } else {
                    mailContent = AlertUtil.getDefaultAlertMailContent(mailDesc, isHTMLFormat);
                }
            }
            returnJSON.put("mailContent", (Object)mailContent);
        } else {
            if (isCorrelationProfile) {
                returnJSON.put("mailContent", (Object)CorrelationNotificationHandler.getInstance().getDefaultCorrEmailMessage(corrRuleIds.getLong(0), isHTMLFormat));
            } else {
                returnJSON.put("mailContent", (Object)AlertUtil.getDefaultAlertMailContent(null, isHTMLFormat));
            }
            returnJSON.put("isMail", false);
        }
        Iterator smsItr = predoo.getRows("NotfnConfigurationSms");
        if (smsItr.hasNext()) {
            Row r = (Row)smsItr.next();
            returnJSON.put("isSMS", true);
            returnJSON.put("smsNumber", (Object)((String)r.get("SMSID")));
            returnJSON.put("smsDescription", (Object)((String)r.get("SMS_DESCRIPTION")));
        } else {
            returnJSON.put("isSMS", false);
        }
        Iterator scriptItr = predoo.getRows("ScriptDetails");
        if (scriptItr.hasNext()) {
            Row r = (Row)scriptItr.next();
            returnJSON.put("isScript", true);
            returnJSON.put("scriptLocation", (Object)((String)r.get("LOCATION")));
            returnJSON.put("scriptArguments", (Object)((String)r.get("ARGUMENTS")));
        } else {
            returnJSON.put("isScript", false);
        }
        return returnJSON;
    }

    public static void getUserName(String value, ResponseBuilder responseBuilder) {
        try {
            SelectQueryImpl uSql = new SelectQueryImpl(Table.getTable((String)"Users"));
            uSql.addSelectColumn(Column.getColumn((String)"Users", (String)"*"));
            Column uCol = Column.getColumn((String)"Users", (String)"USERNAME");
            uSql.addSelectColumn(uCol);
            uSql.setCriteria(new Criteria(Column.getColumn((String)"Users", (String)"USERNAME"), (Object)value.trim(), 12));
            LinkedHashSet<String> userListSet = new LinkedHashSet<String>();
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)uSql);
            Iterator uItr = dobj.getRows("Users");
            while (uItr.hasNext()) {
                Row r = (Row)uItr.next();
                userListSet.add((String)r.get("USERNAME"));
            }
            responseBuilder.setResponse(new JSONArray(userListSet));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

