/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.alerts.AlertsConstants;
import com.manageengine.ela.server.common.alerts.AlertsReportHandler;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertsReport {
    public static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static void getReport(JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws Exception {
        String reportType = reqJsonObject.getString("REPORT_TYPE");
    }

    public static void getGraph(HttpServletRequest request, Long userId, boolean isAdmin, boolean isAdminServer, JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws Exception {
        Long profile = AlertsConstants.PROFILE_ALL;
        if (reqJsonObject.has("PROFILEID")) {
            profile = reqJsonObject.getLong("PROFILEID");
        }
        Long startDate = reqJsonObject.getLong("startTime");
        Long endDate = reqJsonObject.getLong("endTime");
        AlertsReportHandler alertH = new AlertsReportHandler();
        alertH.setProfile(profile);
        alertH.setUserId(userId);
        alertH.setIsAdmin(isAdmin);
        alertH.setStartDate(startDate);
        alertH.setEndDate(endDate);
        Locale locale = (Locale)request.getSession().getAttribute("USER_LOCALE");
        alertH.process(responseBuilder, locale);
    }

    public static void getProfiles(Long userId, boolean isAdmin, boolean isAdminServer, boolean isTechnician, ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        JSONObject result = new JSONObject();
        JSONArray fullgroup = new JSONArray();
        JSONObject tempJSON = null;
        ProductBundle i18n = ProductBundle.getInstance();
        if (!isTechnician) {
            tempJSON = new JSONObject();
            tempJSON.put("hasDropdown", false);
            tempJSON.put("routeName", (Object)"alerts.alert");
            tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_MYALERT);
            tempJSON.put("name", (Object)i18n.getString("alert.default.myalerts"));
            fullgroup.put((Object)tempJSON);
            result.put("LEFTTREEDATA", (Object)fullgroup);
            result.put("SELECTEDID", (Object)AlertsConstants.PROFILE_MYALERT);
            responseBuilder.setResponse(result);
            return;
        }
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", false);
        tempJSON.put("routeName", (Object)"alerts.alert");
        tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_ALL);
        tempJSON.put("name", (Object)i18n.getString("alert.default.allalerts"));
        fullgroup.put((Object)tempJSON);
        if (!isAdminServer) {
            tempJSON = new JSONObject();
            tempJSON.put("hasDropdown", false);
            tempJSON.put("routeName", (Object)"alerts.alert");
            tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_MYALERT);
            tempJSON.put("name", (Object)i18n.getString("alert.default.myalerts"));
            fullgroup.put((Object)tempJSON);
            tempJSON = new JSONObject();
            tempJSON.put("hasDropdown", false);
            tempJSON.put("routeName", (Object)"alerts.alert");
            tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_ASSIGNED);
            tempJSON.put("name", (Object)i18n.getString("alert.default.allassigned"));
            fullgroup.put((Object)tempJSON);
            tempJSON = new JSONObject();
            tempJSON.put("hasDropdown", false);
            tempJSON.put("routeName", (Object)"alerts.alert");
            tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_UNSSIGNED);
            tempJSON.put("name", (Object)i18n.getString("alert.default.allunassigned"));
            fullgroup.put((Object)tempJSON);
        }
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", false);
        tempJSON.put("routeName", (Object)"alerts.alert");
        tempJSON.put("modelId", (Object)AlertsConstants.PROFILE_CRITICAL);
        tempJSON.put("name", (Object)i18n.getString("alert.default.critical"));
        fullgroup.put((Object)tempJSON);
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", false);
        tempJSON.put("breaker", true);
        fullgroup.put((Object)tempJSON);
        JSONObject alertJSON = AlertsReport.getAlertProfiles(userId, isAdmin, isAdminServer);
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", true);
        tempJSON.put("needScroll", true);
        tempJSON.put("name", (Object)i18n.getString("alert.group.alertprofiles"));
        tempJSON.put("list", (Object)alertJSON.getJSONArray("alertList"));
        fullgroup.put((Object)tempJSON);
        if (alertJSON.getJSONArray("correlationAlertList").length() != 0) {
            tempJSON = new JSONObject();
            tempJSON.put("hasDropdown", true);
            tempJSON.put("needScroll", true);
            tempJSON.put("name", (Object)i18n.getString("alert.group.correlationalertprofiles"));
            tempJSON.put("list", (Object)alertJSON.getJSONArray("correlationAlertList"));
            fullgroup.put((Object)tempJSON);
        }
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", false);
        tempJSON.put("breaker", true);
        fullgroup.put((Object)tempJSON);
        JSONArray confList = new JSONArray();
        JSONObject confJSON = null;
        confJSON = new JSONObject();
        confJSON.put("hasDropdown", false);
        confJSON.put("routeName", (Object)"alerts.managealert");
        confJSON.put("modelId", (Object)"managealert");
        confJSON.put("name", (Object)i18n.getString("alert.config.managealert"));
        confJSON.put("status", true);
        confList.put((Object)confJSON);
        if (isAdmin && !isAdminServer) {
            confJSON = new JSONObject();
            confJSON.put("hasDropdown", false);
            confJSON.put("routeName", (Object)"alerts.ticket");
            confJSON.put("modelId", (Object)"ticket");
            confJSON.put("name", (Object)i18n.getString("alert.config.ticket"));
            confJSON.put("status", true);
            confList.put((Object)confJSON);
            confJSON = new JSONObject();
            confJSON.put("hasDropdown", false);
            confJSON.put("routeName", (Object)"alerts.assign");
            confJSON.put("modelId", (Object)"assign");
            confJSON.put("name", (Object)i18n.getString("alert.config.assignrules"));
            confJSON.put("status", true);
            confList.put((Object)confJSON);
        }
        tempJSON = new JSONObject();
        tempJSON.put("hasDropdown", true);
        tempJSON.put("needScroll", false);
        tempJSON.put("name", (Object)i18n.getString("alert.group.configurations"));
        tempJSON.put("imageClass", (Object)"ui-inline-icon icn-alert-configuration");
        tempJSON.put("list", (Object)confList);
        fullgroup.put((Object)tempJSON);
        result.put("LEFTTREEDATA", (Object)fullgroup);
        result.put("SELECTEDID", (Object)AlertsConstants.PROFILE_ALL);
        responseBuilder.setResponse(result);
    }

    private static JSONObject getAlertProfiles(Long userId, boolean isAdmin, boolean isAdminServer) throws DataAccessException, JSONException {
        JSONArray alertList = new JSONArray();
        JSONArray correlationAlertList = new JSONArray();
        JSONObject tempJSON = null;
        Table ntTable = Table.getTable((String)"NotificationType");
        Table unctTable = Table.getTable((String)"UserToNotificationType");
        SelectQueryImpl query = new SelectQueryImpl(ntTable);
        Column first = Column.getColumn((String)"NotificationType", (String)"NOTIFNAME");
        Column second = Column.getColumn((String)"NotificationType", (String)"NOTIFID");
        Column third = Column.getColumn((String)"NotificationType", (String)"ISRESOLVENEEDED");
        Column fourth = Column.getColumn((String)"NotificationType", (String)"TYPE");
        Column fifth = Column.getColumn((String)"NotificationType", (String)"STATUS");
        query.addSelectColumn(first);
        query.addSelectColumn(second);
        query.addSelectColumn(third);
        query.addSelectColumn(fourth);
        query.addSelectColumn(fifth);
        String[] ntId = new String[]{"NOTIFID"};
        query.addJoin(new Join(ntTable, unctTable, ntId, ntId, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)new long[]{-1001L, -1003L}, 9);
        crit = crit.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)CorrelationUtil.getOmitedAlertProfiles(), 9));
        if (!isAdmin) {
            crit = crit.and(new Criteria(Column.getColumn((String)"UserToNotificationType", (String)"USER_ID"), (Object)userId, 0));
        }
        query.setCriteria(crit);
        DataObject doo = DataAccess.get((SelectQuery)query);
        if (doo != null && !doo.isEmpty()) {
            Iterator it = doo.getRows("NotificationType");
            while (it.hasNext()) {
                tempJSON = new JSONObject();
                Row r = (Row)it.next();
                tempJSON.put("hasDropdown", false);
                tempJSON.put("routeName", (Object)"alerts.alert");
                tempJSON.put("modelId", (Object)((Long)r.get("NOTIFID")));
                Integer status = (Integer)r.get("STATUS");
                tempJSON.put("status", !status.equals(new Integer(0)));
                String notifName = (String)r.get("NOTIFNAME");
                Boolean isResolveNeeded = (Boolean)r.get("ISRESOLVENEEDED");
                if (isResolveNeeded != null && isResolveNeeded.booleanValue()) {
                    notifName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), notifName);
                }
                tempJSON.put("name", (Object)notifName);
                if ((Long)r.get("TYPE") != -1002L) {
                    alertList.put((Object)tempJSON);
                    continue;
                }
                correlationAlertList.put((Object)tempJSON);
            }
        }
        JSONObject alertJSON = new JSONObject();
        alertJSON.put("alertList", (Object)alertList);
        alertJSON.put("correlationAlertList", (Object)correlationAlertList);
        return alertJSON;
    }

    public static void updateAlert(Long userId, JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        JSONArray alertIdList = reqJsonObject.getJSONArray("ALERTID");
        String[] arr = new String[alertIdList.length()];
        for (int i = 0; i < alertIdList.length(); ++i) {
            arr[i] = alertIdList.getString(i);
        }
        DataObject doo = AlertsReport.getAlertDO(arr);
        if (doo == null || doo.isEmpty()) {
            return;
        }
        Long assignTo = -1L;
        if (reqJsonObject.has("USER_ID")) {
            assignTo = reqJsonObject.getLong("USER_ID");
        }
        String comment = null;
        if (reqJsonObject.has("COMMENT")) {
            comment = reqJsonObject.getString("COMMENT");
        }
        if (reqJsonObject.has("STATUS")) {
            int status = reqJsonObject.getInt("STATUS");
            Iterator it = doo.getRows("LAAlertAudit");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                row.set("STATE", (Object)status);
                Long audit_id = (Long)row.get("AUDIT_ID");
                doo.updateRow(row);
                Iterator itas = doo.getRows("ELA_AlertAssignMapping", new Criteria(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"AUDIT_ID"), (Object)audit_id, 0));
                Row r = null;
                if (itas.hasNext()) {
                    r = (Row)itas.next();
                }
                if (assignTo < 0L) {
                    if (r != null) {
                        doo.deleteRow(r);
                    }
                } else if (r == null) {
                    r = new Row("ELA_AlertAssignMapping");
                    r.set("USER_ID", (Object)assignTo);
                    r.set("AUDIT_ID", (Object)audit_id);
                    doo.addRow(r);
                } else {
                    r.set("USER_ID", (Object)assignTo);
                    doo.updateRow(r);
                }
                Iterator itcom = doo.getRows("ELA_AlertComments", new Criteria(Column.getColumn((String)"ELA_AlertComments", (String)"AUDIT_ID"), (Object)audit_id, 0));
                r = null;
                if (itcom.hasNext()) {
                    r = (Row)itcom.next();
                }
                if (comment != null && comment.trim().equals("")) {
                    if (r == null) continue;
                    doo.deleteRow(r);
                    continue;
                }
                if (r == null) {
                    r = new Row("ELA_AlertComments");
                    r.set("COMMENT", (Object)comment);
                    r.set("ADDED_TIME", (Object)System.currentTimeMillis());
                    r.set("AUDIT_ID", (Object)audit_id);
                    r.set("USER_ID", (Object)userId);
                    doo.addRow(r);
                    continue;
                }
                r.set("COMMENT", (Object)comment);
                doo.updateRow(r);
            }
        }
        DataAccess.update((DataObject)doo);
    }

    private static DataObject getAlertDO(String[] arr) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit"));
        query.addSelectColumn(Column.getColumn((String)"LAAlertAudit", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AlertComments", (String)"*"));
        query.addJoin(new Join("LAAlertAudit", "ELA_AlertAssignMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
        query.addJoin(new Join("LAAlertAudit", "ELA_AlertComments", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
        Criteria crit = new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"AUDIT_ID"), (Object)arr, 8);
        query.setCriteria(crit);
        return DataAccess.get((SelectQuery)query);
    }

    private static DataObject getAlertDO(Long alertId) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit"));
        query.addSelectColumn(Column.getColumn((String)"LAAlertAudit", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ELA_AlertComments", (String)"*"));
        query.addJoin(new Join("LAAlertAudit", "ELA_AlertAssignMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
        query.addJoin(new Join("LAAlertAudit", "ELA_AlertComments", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
        Criteria crit = new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"AUDIT_ID"), (Object)alertId, 0);
        query.setCriteria(crit);
        return DataAccess.get((SelectQuery)query);
    }

    public static void getUsers(boolean isAdmin, Long userId, boolean isAdminServer, ResponseBuilder responseBuilder) throws DataAccessException, JSONException {
        JSONArray result = null;
        result = isAdmin ? AlertsReport.getUsersJSON() : AlertsReport.getCurrentUserJSON(userId);
        responseBuilder.setResponse(result);
    }

    public static JSONArray getCurrentUserJSON(Long userId) throws DataAccessException, JSONException {
        Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userId, 0);
        DataObject doo = DataAccess.get((String)"AaaLogin", (Criteria)crit);
        JSONArray result = new JSONArray();
        if (doo != null && !doo.isEmpty()) {
            Iterator it = doo.getRows("AaaLogin");
            Row r = null;
            JSONObject json = null;
            while (it.hasNext()) {
                r = (Row)it.next();
                json = new JSONObject();
                json.put("value", (Object)((String)r.get("NAME")));
                json.put("id", (Object)((Long)r.get("USER_ID")));
                result.put((Object)json);
            }
        }
        return result;
    }

    public static JSONArray getUsersJSON() throws DataAccessException, JSONException {
        DataObject doo = AlertsReport.getNonGuestUsersDO();
        JSONArray result = new JSONArray();
        if (doo != null && !doo.isEmpty()) {
            Iterator it = doo.getRows("AaaLogin");
            Row r = null;
            JSONObject json = null;
            while (it.hasNext()) {
                r = (Row)it.next();
                json = new JSONObject();
                json.put("value", (Object)((String)r.get("NAME")));
                json.put("id", (Object)((Long)r.get("USER_ID")));
                result.put((Object)json);
            }
        }
        return result;
    }

    private static DataObject getNonGuestUsersDO() {
        try {
            SelectQueryImpl selectqueryimpl = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            selectqueryimpl.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"*"));
            selectqueryimpl.addSelectColumn(Column.getColumn((String)"AaaAccount", (String)"*"));
            selectqueryimpl.addSelectColumn(Column.getColumn((String)"AaaAuthorizedRole", (String)"*"));
            selectqueryimpl.addSelectColumn(Column.getColumn((String)"AaaRole", (String)"*"));
            String[] rolIDcol = new String[]{"ROLE_ID"};
            String[] loginIDCol = new String[]{"LOGIN_ID"};
            String[] accIDCol = new String[]{"ACCOUNT_ID"};
            Join loginJoin = new Join("AaaLogin", "AaaAccount", loginIDCol, loginIDCol, 2);
            Join authJoin = new Join("AaaAccount", "AaaAuthorizedRole", accIDCol, accIDCol, 2);
            Join accJoin = new Join("AaaAuthorizedRole", "AaaRole", rolIDcol, rolIDcol, 2);
            selectqueryimpl.addJoin(loginJoin);
            selectqueryimpl.addJoin(authJoin);
            selectqueryimpl.addJoin(accJoin);
            Criteria c1 = new Criteria(Column.getColumn((String)"AaaRole", (String)"NAME"), (Object)"Administrator", 0);
            c1 = c1.or(new Criteria(Column.getColumn((String)"AaaRole", (String)"NAME"), (Object)"Operator", 0));
            selectqueryimpl.setCriteria(c1);
            selectqueryimpl.addSortColumn(new SortColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"), true));
            return PersistenceDBUtil.getPersistence().get((SelectQuery)selectqueryimpl);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getAlert(Long userId, JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        JSONArray alertIdList = reqJsonObject.getJSONArray("ALERTID");
        JSONObject json = new JSONObject();
        if (alertIdList.length() == 1) {
            Long alertId = alertIdList.getLong(0);
            DataObject doo = AlertsReport.getAlertDO(alertId);
            if (doo == null || doo.isEmpty()) {
                return;
            }
            Iterator it = doo.getRows("ELA_AlertAssignMapping");
            Row r = null;
            if (it.hasNext()) {
                r = (Row)it.next();
            }
            if (r == null) {
                json.put("USERID", -1L);
            } else {
                json.put("USERID", (Object)((Long)r.get("USER_ID")));
            }
            it = doo.getRows("ELA_AlertComments");
            r = null;
            if (it.hasNext()) {
                r = (Row)it.next();
            }
            if (r != null) {
                json.put("COMMENT", (Object)((String)r.get("COMMENT")));
            }
            r = doo.getFirstRow("LAAlertAudit");
            json.put("STATUS", (Object)((Integer)r.get("STATE")));
        } else {
            json.put("USERID", (Object)userId);
            json.put("STATUS", 1);
        }
        responseBuilder.setResponse(json);
    }

    public static void getAlertProfile(ResponseBuilder responseBuilder) throws DataAccessException, JSONException {
        JSONArray alertList = new JSONArray();
        JSONObject tempJSON = null;
        Table ntTable = Table.getTable((String)"NotificationType");
        Table unctTable = Table.getTable((String)"UserToNotificationType");
        SelectQueryImpl query = new SelectQueryImpl(ntTable);
        Column first = Column.getColumn((String)"NotificationType", (String)"NOTIFNAME");
        Column second = Column.getColumn((String)"NotificationType", (String)"NOTIFID");
        Column third = Column.getColumn((String)"NotificationType", (String)"ISRESOLVENEEDED");
        query.addSelectColumn(first);
        query.addSelectColumn(second);
        query.addSelectColumn(third);
        String[] ntId = new String[]{"NOTIFID"};
        query.addJoin(new Join(ntTable, unctTable, ntId, ntId, 2));
        Criteria crit1 = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1001L, 1);
        crit1 = crit1.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 1));
        Criteria crit2 = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 0);
        crit2 = crit2.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"STATUS"), (Object)1, 0));
        crit1 = crit1.or(crit2);
        query.setCriteria(crit1);
        DataObject doo = DataAccess.get((SelectQuery)query);
        if (doo != null && !doo.isEmpty()) {
            Iterator it = doo.getRows("NotificationType");
            while (it.hasNext()) {
                tempJSON = new JSONObject();
                Row r = (Row)it.next();
                tempJSON.put("id", (Object)((Long)r.get("NOTIFID")));
                String notifName = (String)r.get("NOTIFNAME");
                Boolean isResolveNeeded = (Boolean)r.get("ISRESOLVENEEDED");
                if (isResolveNeeded != null && isResolveNeeded.booleanValue()) {
                    notifName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), notifName);
                }
                tempJSON.put("value", (Object)notifName);
                alertList.put((Object)tempJSON);
            }
        }
        responseBuilder.setResponse(alertList);
    }
}

