/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.alerts.AlertsConstants;
import com.manageengine.ela.server.common.alerts.GraphDataBuilder;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.sql.Connection;
import java.util.Locale;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertsReportHandler {
    private static final Logger LOGGER = Logger.getLogger(AlertsReportHandler.class.getName());
    private Long profile = AlertsConstants.PROFILE_ALL;
    private Long startDate = null;
    private Long endDate = null;
    private Long userId = null;
    private boolean isAdmin = false;

    public void setStartDate(Long startDate) {
        this.startDate = startDate != null ? startDate : Long.valueOf(System.currentTimeMillis() - 86400000L);
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate != null ? endDate : Long.valueOf(System.currentTimeMillis());
    }

    public void setProfile(Long profile) {
        this.profile = profile;
    }

    public void process(ResponseBuilder responseBuilder, Locale locale) throws DataAccessException, JSONException {
        GraphDataBuilder gdb = new GraphDataBuilder();
        if (this.profile == AlertsConstants.PROFILE_ALL) {
            gdb.setChartType("pie");
            gdb.setChartTitle("Severity");
            this.getCount(gdb, "LAAlertAudit", "CRITICALITY");
        } else if (this.profile == AlertsConstants.PROFILE_MYALERT) {
            gdb.setChartType("pie");
            gdb.setChartTitle("Severity");
            this.getCount(gdb, "LAAlertAudit", "CRITICALITY");
        } else if (this.profile == AlertsConstants.PROFILE_ASSIGNED) {
            this.getCount(gdb, "AaaLogin", "NAME");
        } else if (this.profile == AlertsConstants.PROFILE_UNSSIGNED) {
            this.getCount(gdb, "LAAlertAudit", "SOURCE");
            this.getCorrelationAlertCount(gdb, locale);
        } else if (this.profile == AlertsConstants.PROFILE_CRITICAL) {
            this.getCount(gdb, "LAAlertAudit", "SOURCE");
            this.getCorrelationAlertCount(gdb, locale);
        } else if (this.profile > 0L) {
            this.getCount(gdb, "LAAlertAudit", "SOURCE");
            this.getCorrelationAlertCount(gdb, locale);
        }
        responseBuilder.setResponse(gdb.getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCount(GraphDataBuilder gdb, String table, String selectcolumn) throws DataAccessException {
        SelectQueryImpl query = this.getSelectQueryImp();
        query.setCriteria(this.getCriteria(1));
        Column first = Column.getColumn((String)table, (String)selectcolumn);
        Column second = Column.getColumn((String)table, (String)selectcolumn).count();
        second.setColumnAlias("COUNT");
        query.addSelectColumn(first);
        query.addSelectColumn(second);
        query.addGroupByColumn(first);
        Connection conn = null;
        DataSet ds = null;
        try {
            RelationalAPI relApi = RelationalAPI.getInstance();
            conn = relApi.getConnection();
            ds = relApi.executeQuery((Query)query, conn);
            LOGGER.fine("Formed Query : " + ds.toString());
            JSONObject json = new JSONObject();
            while (ds.next()) {
                String apId = ds.getAsString(selectcolumn);
                Long count = ds.getAsLong("COUNT");
                gdb.addData(apId, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCorrelationAlertCount(GraphDataBuilder gdb, Locale locale) throws DataAccessException {
        String selectcolumn = "NF_ID";
        SelectQueryImpl query = this.getSelectQueryImp();
        Criteria crit = this.setDateCriteria();
        crit = this.setCustomCriteria(crit, 3);
        if (!this.isAdmin) {
            crit = this.setUserViewCriteria(crit);
        }
        query.setCriteria(crit);
        Column first = Column.getColumn((String)"LAAlertAudit", (String)selectcolumn);
        Column second = Column.getColumn((String)"LAAlertAudit", (String)selectcolumn).count();
        second.setColumnAlias("COUNT");
        query.addSelectColumn(first);
        query.addSelectColumn(second);
        query.addGroupByColumn(first);
        Connection conn = null;
        DataSet ds = null;
        try {
            RelationalAPI relApi = RelationalAPI.getInstance();
            conn = relApi.getConnection();
            ds = relApi.executeQuery((Query)query, conn);
            while (ds.next()) {
                String apId = this.getCorrelationGraphTitle(ds.getAsLong(selectcolumn), locale);
                Long count = ds.getAsLong("COUNT");
                gdb.addData(apId, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getCorrelationGraphTitle(Long notifID, Locale locale) {
        String title = "";
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFID"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFNAME"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"ISRESOLVENEEDED"));
            query.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifID, 0));
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            title = (String)dObj.getFirstValue("NotificationType", "NOTIFNAME");
            if (((Boolean)dObj.getFirstValue("NotificationType", "ISRESOLVENEEDED")).booleanValue()) {
                title = ProductBundle.getInstance().getString(locale, title);
            }
            return title;
        }
        catch (Exception e) {
            e.printStackTrace();
            return title;
        }
    }

    private SelectQueryImpl getSelectQueryImp() {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit"));
        query.addJoin(new Join("LAAlertAudit", "ELA_AlertAssignMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
        query.addJoin(new Join("ELA_AlertAssignMapping", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 1));
        query.addJoin(new Join("LAAlertAudit", "NotificationType", new String[]{"NF_ID"}, new String[]{"NOTIFID"}, 1));
        if (!this.isAdmin) {
            query.addJoin(new Join("NotificationType", "UserToNotificationType", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        }
        return query;
    }

    public Criteria getCriteria(int dataFor) {
        Criteria crit = this.setDateCriteria();
        switch (dataFor) {
            case 1: {
                crit = this.setCustomCriteria(crit, 2);
                break;
            }
            case 2: {
                crit = this.setCustomCriteria(crit, 1);
            }
        }
        if (!this.isAdmin) {
            crit = this.setUserViewCriteria(crit);
        }
        return crit;
    }

    private Criteria setUserViewCriteria(Criteria crit) {
        if (this.profile != AlertsConstants.PROFILE_MYALERT) {
            crit = crit.and(new Criteria(Column.getColumn((String)"UserToNotificationType", (String)"USER_ID"), (Object)this.userId, 0));
        }
        return crit;
    }

    private Criteria setCustomCriteria(Criteria crit, int alertCondn) {
        if (this.profile == AlertsConstants.PROFILE_MYALERT) {
            crit = crit.and(new Criteria(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"USER_ID"), (Object)this.userId, 0));
        } else if (this.profile == AlertsConstants.PROFILE_ASSIGNED) {
            crit = crit.and(new Criteria(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"USER_ID"), null, 3));
        } else if (this.profile != AlertsConstants.PROFILE_ALL) {
            switch (alertCondn) {
                case 2: {
                    crit = crit.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 1));
                    break;
                }
                case 3: {
                    crit = crit.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 0));
                }
            }
            if (this.profile > 0L) {
                crit = crit.and(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NF_ID"), (Object)this.profile, 0));
            } else if (this.profile == AlertsConstants.PROFILE_UNSSIGNED) {
                crit = crit.and(new Criteria(Column.getColumn((String)"ELA_AlertAssignMapping", (String)"USER_ID"), null, 2));
            } else if (this.profile == AlertsConstants.PROFILE_CRITICAL) {
                crit = crit.and(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"CRITICALITY"), (Object)"High", 0));
            }
        }
        return crit;
    }

    private Criteria setDateCriteria() {
        Criteria crit = new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NOTIFIEDTIME"), (Object)this.startDate, 4);
        crit = crit.and(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NOTIFIEDTIME"), (Object)this.endDate, 6));
        return crit;
    }

    public void setUserId(Long userID) {
        this.userId = userID;
    }

    public void setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }
}

