/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts.incident;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.IncidentToolConstants;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class IncidentDataProvider {
    public static int getConfiguration(ResponseBuilder responseBuilder) {
        DataObject obj;
        JSONObject returnObject;
        block9: {
            returnObject = new JSONObject();
            SelectQuery query = IncidentDataProvider.getSelectQuery();
            query.setCriteria(null);
            obj = PersistenceDBUtil.getPersistence().get(query);
            if (obj != null && !obj.isEmpty() && obj.containsTable("ADSIncidentManagementCenter") && obj.containsTable("ADSIncidentToolConfiguration")) break block9;
            return 7428;
        }
        try {
            Iterator itr = obj.getRows("ADSIncidentToolConfiguration");
            Row toolRow = obj.getFirstRow("ADSIncidentManagementCenter");
            if (itr.hasNext()) {
                Row r = (Row)itr.next();
                String serverName = (String)r.get("SERVER_NAME");
                String regex = "(.*?)\\..*?\\.?com";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(serverName);
                if (matcher.find()) {
                    serverName = matcher.group(1);
                }
                returnObject.put("INCIDENT_SELECTED", (Object)((String)toolRow.get("TOOL_NAME")));
                returnObject.put("SELECTED_SERVER", (Object)serverName);
                if (((Boolean)r.get("CONNECTION_STATUS")).booleanValue()) {
                    returnObject.put("SERVER_STATUS", (Object)ProductBundle.getInstance().getString("SuccCount"));
                } else {
                    returnObject.put("SERVER_STATUS", (Object)ProductBundle.getInstance().getString("ConnectionFailure"));
                }
                returnObject.put("SELECTED_LABEL", (Object)((String)toolRow.get("TOOL_DISPLAY_KEY")));
            }
            responseBuilder.setResponse(returnObject);
            return 0;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return 7426;
    }

    public static int getProfileDetails(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        try {
            JSONObject response = new JSONObject();
            String selectedTool = reqJsonObject.getString("INCIDENT_TOOL");
            Long toolID = IncidentDataProvider.getProductIDForTool(selectedTool);
            JSONArray resultArray = IncidentDataProvider.getAllProfiles();
            JSONArray selectedArray = new JSONArray();
            try {
                DataObject doo = PersistenceDBUtil.getPersistence().get("IncidentToProfileMapping", new Criteria(Column.getColumn((String)"IncidentToProfileMapping", (String)"CONFIG_ID"), (Object)toolID, 0));
                Iterator it = doo.getRows("IncidentToProfileMapping");
                Row r = null;
                while (it.hasNext()) {
                    r = (Row)it.next();
                    if (((Boolean)r.get("NOTIFY_ALL")).booleanValue()) {
                        response.put("NOTIFY_ALL", true);
                        break;
                    }
                    selectedArray.put((Object)((Long)r.get("NOTIF_ID")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.put("PROFILE_LIST", (Object)resultArray);
            response.put("SELECTED_PROFILE_LIST", (Object)selectedArray);
            responseBuilder.setResponse(response);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 7426;
        }
    }

    public static JSONArray getAllProfiles() {
        JSONArray resultArray = new JSONArray();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
            query.addJoin(new Join(Table.getTable((String)"NotificationType"), Table.getTable((String)"UserToNotificationType"), new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 2));
            Criteria crit1 = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1001L, 1);
            crit1 = crit1.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 1));
            Criteria crit2 = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1002L, 0);
            crit2 = crit2.and(new Criteria(Column.getColumn((String)"NotificationType", (String)"STATUS"), (Object)1, 0));
            crit1 = crit1.or(crit2);
            query.setCriteria(crit1);
            DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (obj != null && !obj.isEmpty()) {
                Iterator itr = obj.getRows("NotificationType");
                while (itr.hasNext()) {
                    Row r = (Row)itr.next();
                    JSONObject tempObject = new JSONObject();
                    tempObject.put("NOTIF_ID", r.get("NOTIFID"));
                    Boolean isResolveNeeded = (Boolean)r.get("ISRESOLVENEEDED");
                    String notifName = (String)r.get("NOTIFNAME");
                    if (isResolveNeeded != null && isResolveNeeded.booleanValue()) {
                        notifName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), notifName);
                    }
                    tempObject.put("NOTIF_NAME", (Object)notifName);
                    tempObject.put("SEVERITY_ICON", (Object)IncidentDataProvider.getSeverityIcon(r.get("CRITICALITY").toString()));
                    resultArray.put((Object)tempObject);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultArray;
    }

    public static int saveProfileDetails(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        try {
            String selectedTool = reqJsonObject.getString("INCIDENT_TOOL");
            Long productID = IncidentDataProvider.getProductIDForTool(selectedTool);
            DataObject doo = PersistenceDBUtil.getPersistence().get("IncidentToProfileMapping", new Criteria(Column.getColumn((String)"IncidentToProfileMapping", (String)"CONFIG_ID"), (Object)productID, 0));
            doo.deleteRows("IncidentToProfileMapping", (Criteria)null);
            Row row = null;
            if (reqJsonObject.has("NOTIFY_ALL")) {
                row = new Row("IncidentToProfileMapping");
                row.set("CONFIG_ID", (Object)productID);
                Long defaultThreatID = AlertUtil.getDefaultThreatNotifID();
                row.set("NOTIF_ID", (Object)defaultThreatID);
                row.set("NOTIFY_ALL", (Object)true);
                doo.addRow(row);
            } else {
                JSONArray json = reqJsonObject.getJSONArray("LIST");
                for (int i = 0; i < json.length(); ++i) {
                    row = new Row("IncidentToProfileMapping");
                    row.set("CONFIG_ID", (Object)productID);
                    row.set("NOTIF_ID", (Object)json.getLong(i));
                    doo.addRow(row);
                }
            }
            PersistenceDBUtil.getPersistence().update(doo);
            IncidentToolConstants.getInstance().refreshToolSettings();
            NotificationManager.getInstance().refreshAllNotifiers();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 7426;
        }
    }

    private static String getSeverityIcon(String severity) {
        if ("High".equalsIgnoreCase(severity)) {
            return "danger-circle";
        }
        if ("Medium".equalsIgnoreCase(severity)) {
            return "warning-circle";
        }
        if ("Low".equalsIgnoreCase(severity)) {
            return "healthy-circle";
        }
        return null;
    }

    private static SelectQuery getSelectQuery() {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSIncidentManagementCenter"));
        query.addSelectColumn(Column.getColumn((String)"ADSIncidentManagementCenter", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADSIncidentToolVsConfig", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"*"));
        query.addJoin(new Join("ADSIncidentManagementCenter", "ADSIncidentToolVsConfig", new String[]{"TOOL_ID"}, new String[]{"TOOL_ID"}, 2));
        query.addJoin(new Join("ADSIncidentToolVsConfig", "ADSIncidentToolConfiguration", new String[]{"CONFIG_ID"}, new String[]{"CONFIG_ID"}, 2));
        return query;
    }

    private static Long getProductIDForTool(String selectedTool) throws Exception {
        Long productID = null;
        SelectQuery toolQuery = IncidentDataProvider.getSelectQuery();
        toolQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSIncidentManagementCenter", (String)"TOOL_NAME"), (Object)selectedTool, 0));
        DataObject toolObject = PersistenceDBUtil.getPersistence().get(toolQuery);
        if (toolObject != null && !toolObject.isEmpty() && toolObject.containsTable("ADSIncidentToolConfiguration")) {
            productID = (Long)toolObject.getFirstValue("ADSIncidentToolConfiguration", "CONFIG_ID");
        }
        return productID;
    }
}

