/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.alerts.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NewHTMLTemplate;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.alerts.AlertsConstants;
import com.manageengine.ela.server.common.export.utils.TableExportUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlertUtil {
    private static final String ALERT_MAIL_FORMAT_KEY = "EC_AlertMailFormat";

    public static Object getDeviceList(Object notifID) {
        String name;
        Row r;
        Iterator itr;
        DataObject dobj;
        ArrayList<String> resultList = new ArrayList<String>();
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"HostNotification"));
        sql.addJoin(new Join("HostNotification", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
        sql.addSelectColumn(Column.getColumn((String)"HostNotification", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        Criteria crit = new Criteria(Column.getColumn((String)"HostNotification", (String)"NOTIFID"), (Object)((Long)notifID), 0);
        sql.setCriteria(crit);
        try {
            dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            itr = dobj.getRows("Hosts");
            while (itr.hasNext()) {
                r = (Row)itr.next();
                name = (String)r.get("DISPLAY_NAME");
                resultList.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sql = new SelectQueryImpl(Table.getTable((String)"HostGroupNotification"));
        sql.addJoin(new Join("HostGroupNotification", "HostGroup", new String[]{"GROUPID"}, new String[]{"ID"}, 1));
        sql.addSelectColumn(Column.getColumn((String)"HostGroupNotification", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"*"));
        crit = new Criteria(Column.getColumn((String)"HostGroupNotification", (String)"NOTIFID"), (Object)((Long)notifID), 0);
        sql.setCriteria(crit);
        try {
            dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            itr = dobj.getRows("HostGroup");
            while (itr.hasNext()) {
                r = (Row)itr.next();
                name = (String)r.get("NAME");
                resultList.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resultList.size() > 0) {
            return StringUtils.join(resultList, (char)',');
        }
        return "-";
    }

    public static long getAlertCount(Long notifID, Long startDate, Long endDate) {
        long count = 0L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NOTIFIEDTIME"), (Object)startDate, 4);
            crit = crit.and(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NOTIFIEDTIME"), (Object)endDate, 6));
            crit = crit.and(new Criteria(Column.getColumn((String)"LAAlertAudit", (String)"NF_ID"), (Object)notifID, 0));
            count = DBUtil.getCountLong("LAAlertAudit", crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static ArrayList getHostIDs(Long gId) {
        ArrayList<Long> hostIDList = new ArrayList<Long>();
        try {
            DataObject doo = AlertUtil.fetchHostDetailsDO();
            Iterator hgmIt = doo.getRows("HostGroupMapping", new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), (Object)gId, 0));
            while (hgmIt.hasNext()) {
                Row hgmRow = (Row)hgmIt.next();
                hostIDList.add((Long)hgmRow.get("HOSTID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostIDList;
    }

    public static long getGroupCount() {
        long count = 0L;
        try {
            count = DBUtil.getCountLong("HostGroup", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static ArrayList getFimDevices() {
        ArrayList<Long> agentList = new ArrayList<Long>();
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"FIM_AgentRequest"));
        sql.addSelectColumn(Column.getColumn((String)"FIM_AgentRequest", (String)"*"));
        sql.setCriteria(null);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator itr = dobj.getRows("FIM_AgentRequest");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                agentList.add((Long)r.get("AGENT_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return agentList;
    }

    public static String getNotificationType(Object notifID) {
        Iterator itr;
        ProductBundle i18n = ProductBundle.getInstance();
        String tablename = "NotfnConfigType";
        DataObject obj = AlertUtil.fetchNotificationDO((Long)notifID, tablename);
        String result = "";
        try {
            itr = obj.getRows(tablename);
            if (itr.hasNext()) {
                String value;
                Row r = (Row)itr.next();
                result = value = (String)r.get("NOTIFTYPE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tablename = "ScriptDetails";
        obj = AlertUtil.fetchNotificationDO((Long)notifID, tablename);
        try {
            itr = obj.getRows(tablename);
            if (itr.hasNext()) {
                result = result + ", SCRIPT";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = result.replaceAll("POPUP", "");
        String[] temp = result.split(",");
        result = "";
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].trim().isEmpty()) continue;
            result = result + i18n.getString("NewAlert." + temp[i].toUpperCase().trim());
            result = result + ",";
        }
        result = result.length() > 0 ? result.substring(0, result.length() - 1) : "-";
        return result;
    }

    private static DataObject fetchHostDetailsDO() {
        DataObject hostDO = null;
        try {
            Table table = Table.getTable((String)"HostGroup");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column colHG = Column.getColumn((String)"HostGroup", (String)"*");
            Column colHM = Column.getColumn((String)"HostGroupMapping", (String)"*");
            Column colH = Column.getColumn((String)"Hosts", (String)"*");
            Column colHD = Column.getColumn((String)"HostDetails", (String)"*");
            sql.addSelectColumn(colHG);
            sql.addSelectColumn(colHM);
            sql.addSelectColumn(colH);
            sql.addSelectColumn(colHD);
            String[] hgCols = new String[]{"ID"};
            String[] hmgCols = new String[]{"GROUPID"};
            String[] hmhCols = new String[]{"HOSTID"};
            String[] hCols = new String[]{"HOST_ID"};
            Join j = new Join(table, Table.getTable((String)"HostGroupMapping"), hgCols, hmgCols, 1);
            Join j1 = new Join(Table.getTable((String)"HostGroupMapping"), Table.getTable((String)"Hosts"), hmhCols, hCols, 1);
            Join j2 = new Join(Table.getTable((String)"Hosts"), Table.getTable((String)"HostDetails"), hCols, hCols, 1);
            sql.addJoin(j);
            sql.addJoin(j1);
            sql.addJoin(j2);
            hostDO = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostDO;
    }

    private static DataObject fetchNotificationDO(Long notifid, String tableName) {
        DataObject notifObject = null;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)tableName));
            sql.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            sql.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"NOTIFID"), (Object)notifid, 0));
            notifObject = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifObject;
    }

    public static String getAlertName(long profileID) {
        if (profileID == AlertsConstants.PROFILE_ALL) {
            return "All Alerts";
        }
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
        sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        sql.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)profileID, 0));
        try {
            DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Row r = obj.getFirstRow("NotificationType");
            return (String)r.get("NOTIFNAME");
        }
        catch (Exception e) {
            return "-";
        }
    }

    public static JSONArray getRuleIDForNotifID(Long notifId) {
        JSONArray ruleIDArray = new JSONArray();
        try {
            SelectQueryImpl select = new SelectQueryImpl(Table.getTable((String)"CorrNotificationMapping"));
            select.addSelectColumn(Column.getColumn((String)"CorrNotificationMapping", (String)"*"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)select);
            Iterator iterator = dobj.getRows("CorrNotificationMapping", new Criteria(Column.getColumn((String)"CorrNotificationMapping", (String)"NOTIFID"), (Object)notifId, 0));
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (row == null) continue;
                ruleIDArray.put(row.get("RULE_ID"));
            }
            return ruleIDArray;
        }
        catch (Exception e) {
            return ruleIDArray;
        }
    }

    public static DataObject getDOForProfileID(Long notifid) {
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
        sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"HostNotification", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"HostGroupNotification", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"LACriteria", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"LACriteria2Expressions", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"NotfnConfigType", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"NotfnConfiguration", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"NotfnConfigurationSms", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"ScriptDetails", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"*"));
        sql.addJoin(new Join("NotificationType", "HostNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("NotificationType", "HostGroupNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("NotificationType", "LACriteria", new String[]{"NOTIFID"}, new String[]{"CRIT_ID"}, 1));
        sql.addJoin(new Join("LACriteria", "LACriteria2Expressions", new String[]{"CRIT_ID"}, new String[]{"CRIT_ID"}, 1));
        sql.addJoin(new Join("LACriteria2Expressions", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1));
        sql.addJoin(new Join("LACriteria", "NotfnConfigType", new String[]{"CRIT_ID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("LACriteria", "NotfnConfiguration", new String[]{"CRIT_ID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("LACriteria", "NotfnConfigurationSms", new String[]{"CRIT_ID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("LACriteria", "ScriptDetails", new String[]{"CRIT_ID"}, new String[]{"NOTIFID"}, 1));
        sql.addJoin(new Join("HostNotification", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
        sql.addJoin(new Join("HostGroupNotification", "HostGroup", new String[]{"GROUPID"}, new String[]{"ID"}, 1));
        sql.addJoin(new Join("Hosts", "HostGroupMapping", new String[]{"HOST_ID"}, new String[]{"HOSTID"}, 1));
        sql.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifid, 0));
        DataObject dob = null;
        try {
            dob = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        }
        catch (Exception e) {
            return dob;
        }
        return dob;
    }

    public static boolean isDefaultProfile(Long notifid) throws Exception {
        Row r;
        Long type;
        boolean result = false;
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
        sql.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifid, 0));
        sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        Iterator it = obj.getRows("NotificationType");
        if (it.hasNext() && (type = (Long)(r = (Row)it.next()).get("TYPE")) == -1000L) {
            result = true;
        }
        return result;
    }

    public static boolean isCorrelationProfile(Long notifid) throws Exception {
        Row r;
        Long type;
        boolean result = false;
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
        sql.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifid, 0));
        sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
        Iterator it = obj.getRows("NotificationType");
        if (it.hasNext() && ((type = (Long)(r = (Row)it.next()).get("TYPE")) == -1002L || type == -1001L)) {
            result = true;
        }
        return result;
    }

    public static boolean validateProfiles(Long notifid, Long userId, boolean isAdmin) {
        boolean result = true;
        if (!isAdmin && !AlertUtil.checkIsValidAlertForOperator(notifid, userId)) {
            result = false;
        }
        if (!AlertUtil.checkIsPredefinedAlert(notifid)) {
            result = false;
        }
        return result;
    }

    private static boolean checkIsValidAlertForOperator(Long notifID, Long userID) {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"UserToNotificationType"));
            sql.addSelectColumn(Column.getColumn((String)"UserToNotificationType", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"UserToNotificationType", (String)"USER_ID"), (Object)userID, 0);
            sql.setCriteria(new Criteria(Column.getColumn((String)"UserToNotificationType", (String)"NOTIFID"), (Object)notifID, 0).and(crit));
            DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator itt = obj.getRows("UserToNotificationType");
            if (!itt.hasNext()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean checkIsPredefinedAlert(Long notifID) {
        String[] ntId = new String[]{"NOTIFID"};
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
        sql.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        sql.addJoin(new Join("NotificationType", "UserToNotificationType", ntId, ntId, 2));
        sql.setCriteria(new Criteria(Column.getColumn((String)"UserToNotificationType", (String)"NOTIFID"), (Object)notifID, 0));
        try {
            DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator itr = obj.getRows("NotificationType");
            if (itr.hasNext()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Long getGroupIDForDeviceID(Long deviceID) {
        Long groupID = 0L;
        Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceID, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get(Arrays.asList("Hosts", "HostDetails", "HostGroupMapping"), criteria);
            Row group = dobj.getRow("HostGroupMapping");
            groupID = (Long)group.get("GROUPID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupID;
    }

    public static void raiseReportExportRequest(JSONObject request, String format) throws BaseStatusCode {
        try {
            String displayName = AlertUtil.getProfileName(request.getLong("PROFILEID"));
            request.put("IS_SCHEDULED", false);
            switch (format) {
                case "CSV": {
                    TableExportUtil.exportToCSV(displayName, request);
                    break;
                }
                case "PDF": {
                    TableExportUtil.exportToPDF(displayName, request);
                    break;
                }
                default: {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static String getProfileName(long profileID) {
        try {
            return AlertUtil.getAlertName(profileID);
        }
        catch (Exception e) {
            return "-";
        }
    }

    public static List getProductIDForNotifID(Long notifId) throws Exception {
        LinkedHashSet<Long> apiIDSet = new LinkedHashSet<Long>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSIncidentToolConfiguration"));
        query.addSelectColumn(Column.getColumn((String)"IncidentToProfileMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"*"));
        Criteria cr1 = new Criteria(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"CUSTOM_CLASS_NAME"), (Object)"NONE", 0);
        query.setCriteria(new Criteria(Column.getColumn((String)"IncidentToProfileMapping", (String)"NOTIF_ID"), (Object)notifId, 0));
        query.addJoin(new Join("ADSIncidentToolConfiguration", "IncidentToProfileMapping", new String[]{"CONFIG_ID"}, new String[]{"CONFIG_ID"}, 2));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        if (dobj != null) {
            Iterator itr = dobj.getRows("IncidentToProfileMapping");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                apiIDSet.add((Long)r.get("CONFIG_ID"));
            }
        }
        return new ArrayList(apiIDSet);
    }

    public static Long getDefaultThreatNotifID() {
        Long notifID = 52L;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
            query.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1000L, 0));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
            DataObject obj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Row r = obj.getFirstRow("NotificationType");
            notifID = (Long)r.get("NOTIFID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifID;
    }

    public static String getDefaultAlertMailContent(String mailDesc, boolean isHTMLFormat) {
        String mailContent = "";
        try {
            String migratedFields = AlertUtil.getMigratedFieldsFromNotes(mailDesc);
            NewHTMLTemplate nht = isHTMLFormat ? new NewHTMLTemplate("AlertMailContent.html", migratedFields.isEmpty() ? null : migratedFields, true) : new NewHTMLTemplate("AlertMailContentPlain.txt", migratedFields.isEmpty() ? null : migratedFields, false);
            mailContent = nht.getContent();
            if (mailDesc != null && !mailDesc.isEmpty() && !mailDesc.equals("-")) {
                mailDesc = mailDesc.replaceAll("~~[\\S\\s]+~~", "");
                mailContent = mailContent.concat("\n" + ProductBundle.getInstance().getString("AlertMail.Head12") + " : " + mailDesc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailContent;
    }

    private static String getMigratedFieldsFromNotes(String mailDesc) {
        String fields = "";
        try {
            Pattern pattern;
            Matcher matcher;
            if (mailDesc != null && !mailDesc.isEmpty() && !mailDesc.equals("-") && (matcher = (pattern = Pattern.compile("~~[\\S\\s]+~~")).matcher(mailDesc)).find()) {
                String extrafields = matcher.group(0);
                fields = extrafields.substring(2, extrafields.length() - 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fields;
    }

    public static String getAlertMailFormat() {
        return System.getProperty(ALERT_MAIL_FORMAT_KEY, "html");
    }

    public static List getArchivedTablesInfo(Long dateOlderThanDWS) {
        ArrayList<String> archivedTables = new ArrayList<String>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AlertArchivedTablesInfo"));
        query.addJoin(new Join(Table.getTable((String)"AlertArchivedTablesInfo"), Table.getTable((String)"ArchiveTableDetails"), new String[]{"ARCHIVE_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        Criteria criteria = new Criteria(Column.getColumn((String)"AlertArchivedTablesInfo", (String)"CREATED_TIME"), (Object)dateOlderThanDWS, 6);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"AlertArchivedTablesInfo", (String)"ARCHIVE_TABLE_ID"), true));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (dobj.isEmpty()) {
                return archivedTables;
            }
            Iterator itr = dobj.getRows("AlertArchivedTablesInfo");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                Criteria archiveTable = new Criteria(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVE_TABLE_ID"), r.get("ARCHIVE_TABLE_ID"), 0);
                Row archiveRow = dobj.getRow("ArchiveTableDetails", archiveTable);
                archivedTables.add((String)archiveRow.get("ARCHIVED_TABLENAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return archivedTables;
    }

    public static Criteria getTimeBasedAlertCriteria(String tableName, Long startTime, Long endTime) {
        Criteria criteria = null;
        if (startTime != null) {
            criteria = new Criteria(Column.getColumn((String)tableName, (String)"NOTIFIEDTIME"), (Object)startTime, 5);
        }
        if (endTime != null) {
            criteria = criteria == null ? new Criteria(Column.getColumn((String)tableName, (String)"NOTIFIEDTIME"), (Object)endTime, 6) : criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"NOTIFIEDTIME"), (Object)endTime, 6));
        }
        return criteria;
    }
}

