/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.application.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.application.webserver.iis.config.IISConfigHandler;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import org.apache.commons.lang3.math.NumberUtils;

public class ApplicationUtil {
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistence();

    public static synchronized Long addAndGetAppId(Long deviceId, Long formatId) throws DataAccessException {
        Criteria deviceIdCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)deviceId, 0);
        Criteria finalCriteria = deviceIdCriteria.and(new Criteria(Column.getColumn((String)"AppResources", (String)"FORMATID"), (Object)formatId, 0));
        DataObject dataObject = PERSISTENCE.get("AppResources", finalCriteria);
        if (!dataObject.isEmpty()) {
            return (Long)dataObject.getFirstValue("AppResources", "APPID");
        }
        Row appResourcesRow = new Row("AppResources");
        appResourcesRow.set("HOSTID", (Object)deviceId);
        appResourcesRow.set("FORMATID", (Object)formatId);
        appResourcesRow.set("FGROUP", (Object)FormatIdentifier.getReportName(formatId));
        dataObject = PERSISTENCE.constructDataObject();
        dataObject.addRow(appResourcesRow);
        dataObject = PERSISTENCE.add(dataObject);
        Long appId = NumberUtils.toLong((String)String.valueOf(dataObject.getFirstValue("AppResources", "APPID")));
        if (FormatIdentifier.getReportID("iis_w3cweb") == formatId || FormatIdentifier.getReportID("iis_w3cftp") == formatId) {
            IISConfigHandler.handleIISImport(deviceId);
        }
        return appId;
    }
}

