/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.audit;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AuditEntry {
    private static final String ELA_AUDIT_TABLE = "EventLogUserAudit";
    private static final String DEFAULT_USER = "EventLog_System";
    private ResourceType type;
    private ActionType action;
    private String userName;
    private List<String> resourceNames;

    public AuditEntry(ResourceType type, ActionType action) {
        this(type, action, new ArrayList<String>());
    }

    public AuditEntry(ResourceType type, ActionType action, String resourceName) {
        this(type, action, new ArrayList<String>());
        this.addResource(resourceName);
    }

    public AuditEntry(ResourceType type, ActionType action, List<String> resourceNames) {
        Credential cred = AuthUtil.getUserCredential();
        this.userName = cred == null ? DEFAULT_USER : cred.getLoginName();
        this.setResourceNames(resourceNames);
        this.setResourceType(type);
        this.setActionType(action);
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = Objects.requireNonNull(resourceNames);
    }

    public void addResource(String resourceName) {
        this.resourceNames.add(Objects.requireNonNull(resourceName));
    }

    public void setActionType(ActionType action) {
        this.action = Objects.requireNonNull(action);
    }

    public void setResourceType(ResourceType resourceType) {
        this.type = Objects.requireNonNull(resourceType);
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public ResourceType getResourceType() {
        return this.type;
    }

    public ActionType getActionType() {
        return this.action;
    }

    public void commitEntry() {
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
            for (String resource : this.getResourceNames()) {
                Row row = new Row(ELA_AUDIT_TABLE);
                row.set("USERNAME", (Object)this.getUserName());
                row.set("TIMESTAMP", (Object)System.currentTimeMillis());
                row.set("TYPE", (Object)this.getResourceType().name());
                row.set("RESOURCENAME", (Object)resource);
                row.set("ACTION", (Object)this.getActionType().name());
                row.set("STATUS", (Object)1L);
                dobj.addRow(row);
            }
            PersistenceDBUtil.getPersistence().add(dobj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static enum ActionType {
        ADDED,
        DELETED,
        MODIFIED,
        DOWNLOADED;

    }

    public static enum ResourceType {
        DEVICE,
        TECHNICIAN,
        ALERT,
        CORRELATION_RULE,
        REPORT,
        FILTER,
        EXPORT;

    }
}

