/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.authentication.LoginCrdCacheHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticationUtil {
    private static final String AD_LOGIN_ENABLED = "ActiveDirectoryEnabled";
    private static final String RADIUS_LOGIN_ENABLED = "RadiusServerConfigured";
    public static final String RADIUS_AUTHENTICATION = "Radius Authentication";
    public static final String USERNAME_KEY = "USERNAME";
    public static final String PASSWORD_KEY = "PASSWORD";

    public static boolean isValidAccount(DataObject accountDO, Locale locale) throws LoginException {
        Row userStatusRow = null;
        Row accountStatusRow = null;
        ProductBundle bundle = ProductBundle.getInstance();
        try {
            if (accountDO == null) {
                throw new PAMException(bundle.getString(locale, "ela.login.statmsg_accnt_do_fetched_null"));
            }
            if (!accountDO.containsTable("AaaAccount")) {
                throw new PAMException(bundle.getString(locale, "ela.login.statmsg_no_such_accnt_configured_for_user"));
            }
            if (!accountDO.containsTable("AaaPassword")) {
                throw new PAMException(bundle.getString(locale, "ela.login.statmsg_no_pwd_configured_for_ths_accnt"));
            }
            if (!accountDO.containsTable("AaaUserStatus")) {
                throw new PAMException(bundle.getString(locale, "ela.login.statmsg_no_such_user_configured"));
            }
            if (!accountDO.containsTable("AaaAccountStatus")) {
                throw new PAMException(bundle.getString(locale, "ela.login.statmsg_no_such_accnt_configured"));
            }
            userStatusRow = accountDO.getFirstRow("AaaUserStatus");
            accountStatusRow = accountDO.getFirstRow("AaaAccountStatus");
        }
        catch (DataAccessException dae) {
            throw new PAMException(bundle.getString(locale, "ela.login.statmsg_dataaccessexcep_occured_fetching_dataobj"), (Exception)((Object)dae));
        }
        String userStatus = (String)userStatusRow.get("STATUS");
        if ("DISABLED".equals(userStatus)) {
            throw new LoginException(bundle.getString(locale, "ela.login.statmsg_user_disabled_in_ela"));
        }
        String accountStatus = (String)accountStatusRow.get("STATUS");
        if ("DEACTIVATED".equals(accountStatus)) {
            throw new LoginException(bundle.getString(locale, "ela.login.statmsg_user_accnt_disabled_in_ela"));
        }
        if ("LOCKED".equals(accountStatus)) {
            throw new LoginException(bundle.getString(locale, "ela.login.statmsg_user_accnt_locked_in_ela"));
        }
        return true;
    }

    public static JSONObject getCredentialCookie(HttpServletRequest request) {
        JSONObject loginCookie = null;
        request.setAttribute("INITIAL_LOAD_TOKEN", (Object)"Initialized");
        if (request.getSession().getAttribute("fromKeepMeSignedIn") != null && request.getSession().getAttribute("fromKeepMeSignedIn").toString().equals("true")) {
            loginCookie = LoginCrdCacheHandler.getLoginCookieFromRequest(request);
        }
        return loginCookie;
    }

    public static void checkAndHandleKeepMeSignedIn(HttpServletRequest request, boolean result) {
        if (result) {
            LoginCrdCacheHandler.addKeepMeSignedIn(request);
        } else {
            LoginCrdCacheHandler.removeKeepMeSignedIn(request);
        }
    }

    public static boolean isValidAccount(DataObject accountDO, HttpServletRequest request) throws LoginException {
        try {
            Locale locale = ResourceBundleMgr.getInstance().getLocale(request);
            return AuthenticationUtil.isValidAccount(accountDO, locale);
        }
        catch (PAMException e) {
            throw e;
        }
        catch (LoginException e) {
            request.setAttribute("ERROR_MSG", (Object)e.getMessage());
            throw e;
        }
    }

    public static boolean isADAuthEnabled() {
        Object enableStatus = CommonUtil.getSysConfiguration(AD_LOGIN_ENABLED);
        return enableStatus != null ? Boolean.valueOf(enableStatus.toString()) : false;
    }

    public static boolean isRadiusEnabled() {
        Object enableStatus = CommonUtil.getSysConfiguration(RADIUS_LOGIN_ENABLED);
        return enableStatus != null ? Boolean.valueOf(enableStatus.toString()) : false;
    }

    private static void changeADConfig(String state) {
        CommonUtil.updateSysConfiguration(AD_LOGIN_ENABLED, state, true);
    }

    private static void changeRadiusConfig(String state) {
        CommonUtil.updateSysConfiguration(RADIUS_LOGIN_ENABLED, state, true);
    }

    public static void enableADAuth() {
        AuthenticationUtil.changeADConfig("true");
    }

    public static boolean isADuserImported() {
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)"EventLog Authentication", 1);
        return DBUtil.getCountLong("AaaLogin", criteria) > 0L;
    }

    public static void disableADAuth() {
        AuthenticationUtil.changeADConfig("false");
    }

    public static void enableRadiusAuth() {
        AuthenticationUtil.changeRadiusConfig("true");
    }

    public static void disableRadiusAuth() {
        AuthenticationUtil.changeRadiusConfig("false");
    }

    public static JSONObject getRadiusServerConfiguration() throws JSONException, DataAccessException {
        Row row;
        JSONObject radiusDetails = null;
        DataObject dataObject = PersistenceDBUtil.getPersistence().get("AAARadiusConfig", (Criteria)null);
        if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("AAARadiusConfig")) != null) {
            radiusDetails = new JSONObject();
            radiusDetails.put("SERVER_NAME", (Object)((String)row.get("SERVER_NAME")));
            radiusDetails.put("SERVER_PORT", (Object)((Integer)row.get("SERVER_PORT")));
            radiusDetails.put("SERVER_PROTOCOL", (Object)((String)row.get("SERVER_PROTOCOL")));
            radiusDetails.put("RETRIES", (Object)((Integer)row.get("RETRIES")));
        }
        return radiusDetails;
    }

    public static boolean addOrUpdateRadiusConfig(JSONObject radiusDetails) throws DataAccessException, BaseStatusCode {
        DataObject dataObject = PersistenceDBUtil.getPersistence().get("AAARadiusConfig", (Criteria)null);
        Row row = null;
        try {
            if (dataObject.isEmpty()) {
                row = new Row("AAARadiusConfig");
                AuthenticationUtil.setRadiusRowValues(row, radiusDetails);
                dataObject.addRow(row);
                PersistenceDBUtil.getPersistence().add(dataObject);
            } else {
                row = dataObject.getFirstRow("AAARadiusConfig");
                AuthenticationUtil.setRadiusRowValues(row, radiusDetails);
                dataObject.updateRow(row);
                PersistenceDBUtil.getPersistence().update(dataObject);
            }
            AuthenticationUtil.enableRadiusAuth();
        }
        catch (JSONException ex) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return true;
    }

    public static boolean deleteRadiusConfig() throws DataAccessException, BaseStatusCode {
        DataObject dobj = PersistenceDBUtil.getPersistence().get("AAARadiusConfig", (Criteria)null);
        if (dobj.isEmpty()) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        PersistenceDBUtil.getPersistence().delete(dobj.getFirstRow("AAARadiusConfig"));
        AuthenticationUtil.disableRadiusAuth();
        return true;
    }

    public static void setRadiusRowValues(Row row, JSONObject radiusDetails) throws JSONException {
        row.set("SERVER_NAME", (Object)radiusDetails.getString("SERVER_NAME"));
        row.set("SERVER_PORT", (Object)radiusDetails.getInt("SERVER_PORT"));
        row.set("SERVER_PROTOCOL", (Object)radiusDetails.getString("SERVER_PROTOCOL"));
        row.set("SERVER_SECRET", (Object)radiusDetails.getString("SERVER_SECRET"));
        row.set("RETRIES", (Object)radiusDetails.getInt("RETRIES"));
    }

    public static JSONObject getExternalAuthDetails() throws JSONException, DataAccessException {
        JSONObject externAuthDetails = new JSONObject();
        externAuthDetails.put("AD_LOGIN_ENABLED", AuthenticationUtil.isADAuthEnabled());
        externAuthDetails.put("RADIUS_LOGIN_ENABLED", AuthenticationUtil.isRadiusEnabled());
        externAuthDetails.put("RADIUS_SERVER_CONFIGURATION", (Object)AuthenticationUtil.getRadiusServerConfiguration());
        externAuthDetails.put("AD_USER_CONFIGURED", AuthenticationUtil.isADuserImported());
        return externAuthDetails;
    }
}

