/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.authentication;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.security.ELASecretKeyHandler;
import com.manageengine.ela.server.common.security.SecretKeyInfo;
import com.manageengine.ela.server.common.security.crypto.EnDecryptionHandler;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class LoginCrdCacheHandler {
    private static final Map<String, Row> TEMP_SKEYCACHE = new HashMap<String, Row>();
    private static final String KEEPMESIGNEDIN_COOKIE = "KEEPMESIGNEDINCOOKIE";

    private static void setTempSkeyCache(Row row, String uniqueID) {
        TEMP_SKEYCACHE.put(uniqueID, row);
    }

    private static Row getTempSkeyCache(String jsessionID) {
        return TEMP_SKEYCACHE.get(jsessionID);
    }

    private static void removeSkeyCache(String jsessionID) {
        TEMP_SKEYCACHE.remove(jsessionID);
    }

    public static void addKeepMeSignedIn(HttpServletRequest request) {
        try {
            Row row;
            String cookie = LoginCrdCacheHandler.getKeepMeSignedINuniqueID(request);
            if (cookie != null && (row = LoginCrdCacheHandler.getTempSkeyCache(cookie)) != null) {
                DBUtil.createNewRow(row, new boolean[0]);
                LoginCrdCacheHandler.removeSkeyCache(cookie);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeKeepMeSignedIn(HttpServletRequest request) {
        try {
            JSONObject loginHash = LoginCrdCacheHandler.getLoginCookieFromRequest(request);
            if (loginHash != null && loginHash.has("UNIQUE_ID")) {
                ELASecretKeyHandler.deleteKey(Long.parseLong(loginHash.getString("UNIQUE_ID")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JSONObject getLoginOriginalData(JSONObject json) {
        JSONObject response = null;
        try {
            SecretKeyInfo info;
            if (!(json.isNull("U_KEY") || json.isNull("P_KEY") || json.isNull("D_KEY") || json.isNull("UNIQUE_ID") || (info = ELASecretKeyHandler.getKeyInfo(json.getLong("UNIQUE_ID"))) == null)) {
                if (info.isValid()) {
                    response = new JSONObject();
                    String pOkey = EnDecryptionHandler.decrypt(json.getString("P_KEY"), info.getKey(), 1);
                    String uOkey = EnDecryptionHandler.decrypt(json.getString("U_KEY"), info.getKey(), 1);
                    String dOkey = EnDecryptionHandler.decrypt(json.getString("D_KEY"), info.getKey(), 1);
                    response.put("DOMAIN", (Object)dOkey);
                    response.put("USERNAME", (Object)uOkey);
                    response.put("PASSWORD", (Object)pOkey);
                    response.put("UNIQUE_ID", json.getLong("UNIQUE_ID"));
                } else {
                    ELASecretKeyHandler.deleteKey(info.getKeyID());
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return response;
    }

    public static JSONObject getLoginCookieFromRequest(HttpServletRequest request) {
        JSONObject loginHash;
        block4: {
            Cookie[] cookies = request.getCookies();
            loginHash = null;
            try {
                if (cookies == null) break block4;
                for (Cookie cookie : cookies) {
                    if (!"LOGIN_HASH".equals(cookie.getName())) continue;
                    if (cookie.getValue().length() > 2) {
                        loginHash = LoginCrdCacheHandler.getLoginOriginalData(new JSONObject(cookie.getValue()));
                    }
                    break;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return loginHash;
    }

    public static JSONObject getLoginSkeyJSON(Row skeyInfo, String userName, String password, String domain) {
        JSONObject resposne = new JSONObject();
        try {
            SecretKeyInfo keyInfo = SecretKeyInfo.getKeyInfo(skeyInfo);
            if (keyInfo != null) {
                String key = keyInfo.getKey();
                String pskey = EnDecryptionHandler.encrypt(password, key, 1);
                String uskey = EnDecryptionHandler.encrypt(userName, key, 1);
                String dskey = EnDecryptionHandler.encrypt(domain, key, 1);
                resposne.put("U_KEY", (Object)uskey);
                resposne.put("P_KEY", (Object)pskey);
                resposne.put("D_KEY", (Object)dskey);
                resposne.put("UNIQUE_ID", (Object)keyInfo.getKeyID());
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return resposne;
    }

    public static String getKeepMeSignedINuniqueID(HttpServletRequest servelt) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = servelt.getCookies()) {
            if (!KEEPMESIGNEDIN_COOKIE.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void handleKeepMesignedINFlag(HttpServletRequest request, HttpServletResponse response) throws DataAccessException {
        long interval = 604800000L;
        Row row = ELASecretKeyHandler.geKeyInfoAsTempRow(interval);
        Cookie loginHash = LoginCrdCacheHandler.prepareLoginHashCookie(604800, row, request);
        Cookie loginIdentity = LoginCrdCacheHandler.prepareLoginHashIdentity(360, row);
        response.addCookie(loginIdentity);
        response.addCookie(loginHash);
    }

    private static Cookie prepareLoginHashIdentity(int maxAge, Row row) {
        String uniqueID = EnDecryptionHandler.getUniqueKey();
        Cookie cookie = new Cookie(KEEPMESIGNEDIN_COOKIE, uniqueID);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        cookie.setVersion(1);
        LoginCrdCacheHandler.setTempSkeyCache(row, uniqueID);
        return cookie;
    }

    private static Cookie prepareLoginHashCookie(int maxAge, Row row, HttpServletRequest request) {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String domain = request.getParameter("domain");
        JSONObject skey = LoginCrdCacheHandler.getLoginSkeyJSON(row, username, password, domain);
        Cookie cookie = new Cookie("LOGIN_HASH", skey.toString());
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        cookie.setVersion(1);
        return cookie;
    }
}

