/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.cache;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<E, T> {
    private final Map<E, SoftReference<T>> cache = new ConcurrentHashMap<E, SoftReference<T>>();

    public T get(E key) {
        SoftReference<T> softRef = this.cache.get(key);
        if (softRef != null && softRef.get() != null) {
            return softRef.get();
        }
        return null;
    }

    public void put(E key, T value) {
        if (key != null && value != null) {
            SoftReference<T> softRef = new SoftReference<T>(value);
            this.cache.put(key, softRef);
        }
    }

    public void remove(E key) {
        if (key != null) {
            this.cache.remove(key);
        }
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsKey(E key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(T value) {
        return this.cache.containsValue(value);
    }
}

