/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.cache;

import com.manageengine.ela.server.common.cache.CacheConstants;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class OffHeapCache<E, T> {
    private static final Logger LOGGER = Logger.getLogger(OffHeapCache.class.getName());
    private static final Map<String, Map> LOADED_MAPS = new ConcurrentHashMap<String, Map>();
    private static final Map<String, DB> ACTIVE_STORES = new ConcurrentHashMap<String, DB>();
    private static final String STORE_NAME_FORMAT = "%s_%d";
    private String customStore = null;

    private static void compactStores() {
        for (Map.Entry<String, DB> entry : ACTIVE_STORES.entrySet()) {
            File storeFile = new File(entry.getKey());
            if (!storeFile.exists() || storeFile.length() <= CacheConstants.MAPDB_CACHE_COMPACTION_SIZE_LIMIT) continue;
            DB store = entry.getValue();
            store.commit();
            store.getStore().compact();
        }
    }

    public static OffHeapCache getInstance() {
        return new OffHeapCache();
    }

    public OffHeapCache<E, T> setCustomStore(String fileName) {
        this.customStore = fileName;
        return this;
    }

    public Map<E, T> get(String cacheIdentity) {
        Map<E, T> map = LOADED_MAPS.get(cacheIdentity);
        if (map == null) {
            map = this.loadMap(cacheIdentity);
            LOADED_MAPS.put(cacheIdentity, map);
        }
        return map;
    }

    public Map<E, T> remove(String cacheIdentity) {
        return LOADED_MAPS.remove(cacheIdentity);
    }

    public DB getMapDBStore() {
        DB mapDB = ACTIVE_STORES.get(this.getStoreFile().getAbsolutePath());
        if (mapDB == null) {
            File store = this.getStoreFile();
            if (!this.checkMapDBConsistency(store)) {
                store = this.getFreshStore();
            }
            mapDB = DBMaker.fileDB((File)store).make();
            ACTIVE_STORES.put(store.getAbsolutePath(), mapDB);
        }
        return mapDB;
    }

    private Map<E, T> loadMap(String cacheIdentity) {
        DB mapDB = this.getMapDBStore();
        HTreeMap map = mapDB.hashMap(cacheIdentity, (Serializer)Serializer.ELSA, (Serializer)Serializer.ELSA).counterEnable().createOrOpen();
        LOADED_MAPS.put(cacheIdentity, (Map)map);
        return map;
    }

    private File getStoreFile() {
        File baseDir = new File(CacheConstants.DEFAULT_OFF_HEAP_CACHE_DIRECTORY);
        String storeName = this.customStore != null ? this.customStore : "cache";
        String expectedFileName = storeName + "_";
        File[] files = baseDir.listFiles((file, fileName) -> fileName.startsWith(expectedFileName));
        if (files == null || files.length == 0) {
            return this.getFreshStore();
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.getValidFileFromList(files);
    }

    private File getValidFileFromList(File[] files) {
        File selectedFile = files[0];
        long timeFromName = 0L;
        for (File file : files) {
            String[] array = FilenameUtils.getName((String)file.getName()).split("_");
            if (array.length != 2) continue;
            try {
                long temp_time = Long.valueOf(FilenameUtils.removeExtension((String)array[1]));
                if (temp_time <= timeFromName) continue;
                timeFromName = temp_time;
                selectedFile = file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return selectedFile;
    }

    private boolean checkMapDBConsistency(File store) {
        try {
            DBMaker.fileDB((File)store).fileLockDisable().make().close();
            return true;
        }
        catch (DBException.DataCorruption exception) {
            LOGGER.log(Level.WARNING, "MapDB header checksum broken. Wasn't closed properly.");
            return this.recoverFromCorruption(store);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error occurred during MapDB init", exception.getMessage());
            return false;
        }
    }

    private File getFreshStore() {
        String storeName = this.customStore != null ? this.customStore : "cache";
        return new File(CacheConstants.DEFAULT_OFF_HEAP_CACHE_DIRECTORY + String.format(STORE_NAME_FORMAT, storeName, System.currentTimeMillis()));
    }

    private boolean recoverFromCorruption(File store) {
        try {
            DB mapDB = DBMaker.fileDB((File)store).fileLockDisable().checksumHeaderBypass().make();
            mapDB.commit();
            mapDB.close();
            return true;
        }
        catch (Exception exp) {
            return false;
        }
    }

    static {
        File defaultDirectory = new File(CacheConstants.DEFAULT_OFF_HEAP_CACHE_DIRECTORY);
        if (!defaultDirectory.exists()) {
            defaultDirectory.mkdirs();
        }
        ScheduledThreadPoolExecutor storeOptimizer = new ScheduledThreadPoolExecutor(1);
        storeOptimizer.scheduleWithFixedDelay(OffHeapCache::compactStores, 0L, CacheConstants.MAPDB_CACHE_COMPACTION_DELAY, TimeUnit.MILLISECONDS);
    }
}

