/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.cache;

import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.common.license.LicenseComponents;
import com.manageengine.ela.server.common.license.LicenseHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerDetailsBean {
    private Map<String, String> details = new HashMap<String, String>();
    private static volatile ServerDetailsBean instance = null;
    private static final String DEFAULT_LINESEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_FIELDSEPARATOR = "\t";
    private static final String DEFAULT_DATEFORMAT = "MMM dd yyyy HH:mm";
    private Long sysEvtColID = null;
    private boolean isWindows = true;
    private boolean isWorkstationFormADAPallowed = true;
    private boolean doaminDiscoveryStatus = false;
    private boolean isDistributedSetup = false;
    private boolean isAdminServer = false;
    private boolean isDefaultAuthenticationAllowed = true;
    private String currentDataBase = null;
    private String systemOS = null;
    private String urlEncoding = "UTF-8";
    private String productName = null;
    private String productVersion = null;
    private String productbuildNumber = null;
    private String productBaseBuildVersion = null;
    private boolean is64BitMachine = false;
    private static final Logger LOGGER = Logger.getLogger(ServerDetailsBean.class.getName());

    public static String getLineSeparator() {
        return DEFAULT_LINESEPARATOR;
    }

    public static String getFieldSeparator() {
        return DEFAULT_FIELDSEPARATOR;
    }

    public static String getDefaultDateformat() {
        return DEFAULT_DATEFORMAT;
    }

    private ServerDetailsBean() {
        LOGGER.info("ServerDetailsBean initialization started");
        this.init();
        LOGGER.info("ServerDetailsBean initialization completed");
    }

    private void init() {
        Properties installProps = this.loadEnterpriseProperties();
        Properties productProperties = this.loadProductProperties();
        String arch = System.getProperty("os.arch");
        Object status = CommonUtil.getSysConfiguration("DOAMIN_DISCOVERY_STATUS");
        this.doaminDiscoveryStatus = status != null ? Boolean.valueOf(status.toString()) : false;
        this.systemOS = System.getProperty("os.name").trim().toUpperCase(Locale.ENGLISH);
        this.isWindows = this.systemOS != null ? this.systemOS.contains("WINDOWS") : false;
        this.currentDataBase = CommonUtil.getCurrentDataBaseName();
        this.productName = productProperties.getProperty("product.name");
        this.productVersion = productProperties.getProperty("product.version");
        this.productbuildNumber = productProperties.getProperty("product.build_number");
        this.productBaseBuildVersion = (String)CommonUtil.getSysConfiguration("basebuildversion");
        this.productBaseBuildVersion = this.productBaseBuildVersion == null ? this.productVersion : this.productBaseBuildVersion;
        this.is64BitMachine = arch != null && arch.contains("64");
        Object defAuthAllowed = CommonUtil.getSysConfiguration("isDefaultAuthenticationAllowed");
        boolean bl = this.isDefaultAuthenticationAllowed = defAuthAllowed == null || defAuthAllowed.equals("true");
        if (installProps != null && installProps.containsKey("server.type")) {
            String serverType = installProps.getProperty("server.type");
            if ("AS".equalsIgnoreCase(serverType)) {
                this.isAdminServer = true;
                this.isDistributedSetup = true;
            } else if ("DS".equalsIgnoreCase(serverType)) {
                this.isDistributedSetup = true;
            }
        }
    }

    private Properties loadEnterpriseProperties() {
        File buildProperties = new File(System.getProperty("server.home"), "enterprise.txt");
        return FileHandler.fileToProperties(buildProperties);
    }

    private Properties loadProductProperties() {
        File buildProperties = new File(System.getProperty("server.home") + File.separator + "conf", "product.conf");
        return FileHandler.fileToProperties(buildProperties);
    }

    public static synchronized ServerDetailsBean getInstance() {
        if (instance == null) {
            instance = new ServerDetailsBean();
        }
        return instance;
    }

    public String get(String key) {
        String value = null;
        if (this.details.containsKey(key)) {
            value = this.details.get(key);
        }
        return value;
    }

    public void set(String key, String value) {
        this.details.put(key, value);
    }

    public String getCurrentDataBase() {
        return this.currentDataBase;
    }

    public boolean isWorkstationFormADAPallowed() {
        return this.isWorkstationFormADAPallowed;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public String getSystemOS() {
        return this.systemOS;
    }

    public Long getSysEvtColID() {
        if (this.sysEvtColID == null) {
            LOGGER.info("sysEvtColID is null, reloading from database");
            this.sysEvtColID = CommonUtil.getSysEvtColID();
            if (this.sysEvtColID == null) {
                LOGGER.info("Unable to collect SysEvtcol returing default id");
                return 1L;
            }
        }
        return this.sysEvtColID;
    }

    public boolean getDoaminDiscoveryStatus() {
        return this.doaminDiscoveryStatus;
    }

    public void setDoaminDiscoveryStatus(boolean doaminDiscoveryStatus) {
        this.doaminDiscoveryStatus = doaminDiscoveryStatus;
    }

    public boolean isPremium() {
        return LicenseHandler.getInstance().getLicenseCategory() == LicenseComponents.LicenseCategory.PREMIUM;
    }

    public boolean isPremiumFeatureAllowed() {
        return LicenseHandler.getInstance().getLicenseCategory() == LicenseComponents.LicenseCategory.PREMIUM || LicenseHandler.getInstance().getLicenseType() == LicenseComponents.LicenseType.TRIAL;
    }

    public boolean isAdminServer() {
        return this.isAdminServer;
    }

    public String getURLEncoding() {
        return this.urlEncoding;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductBaseBuildVersion() {
        return this.productBaseBuildVersion;
    }

    public Boolean isUpgraded() {
        return !this.productVersion.equals(this.productBaseBuildVersion);
    }

    public String getProductbuildNumber() {
        return this.productbuildNumber;
    }

    public boolean isDistributedSetup() {
        return this.isDistributedSetup;
    }

    public String getResponseEncoding() {
        return this.urlEncoding;
    }

    public boolean is64BitMachine() {
        return this.is64BitMachine;
    }

    public boolean isDefaultAuthenticationAllowed() {
        return this.isDefaultAuthenticationAllowed;
    }
}

