/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.adapters;

import com.adventnet.la.TimePack;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.manageengine.ela.server.common.client.adapters.ClientIndexTableDataAdapter;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.json.JSONArray;

public abstract class ClientAggIndexTableDataAdapter
extends ClientIndexTableDataAdapter {
    private static LoadingCache<String, SearchResponse> tempCache;
    protected Long hitCount = 0L;
    private BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().queryName(this.getClass().getName());
    private List<AbstractAggregationBuilder> aggregations;
    private boolean isCacheEnabled;
    private String uniqueID;

    public ClientAggIndexTableDataAdapter(TableUniqueIdentifier tableIdentifier, Locale locale, TimeZone timeZone, Long userID) throws BaseStatusCode {
        super(tableIdentifier, locale, timeZone, userID);
    }

    private JSONArray loadData(int start, int pageLength, TimePack timePack) {
        SearchResponse response = this.getCacheEntry(start + pageLength);
        if (response == null) {
            response = DefaultDataSource.getAggregateResult(this.aggregations, (QueryBuilder)this.queryBuilder, timePack.getStartTimeInLong(), timePack.getEndTimeInLong());
        }
        this.updateCacheEntry(response);
        return this.normalizeData(response, start, pageLength);
    }

    protected abstract JSONArray normalizeData(SearchResponse var1, int var2, int var3);

    public void setCacheEnabled(String uniqueKey) {
        this.isCacheEnabled = true;
        this.uniqueID = uniqueKey;
        if (tempCache == null) {
            tempCache = CacheBuilder.newBuilder().maximumSize(2L).expireAfterWrite(60000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, SearchResponse>(){

                public SearchResponse load(String key) {
                    return null;
                }
            });
        }
    }

    public SearchResponse getCacheEntry(int maxNeeded) {
        if (this.isCacheEnabled) {
            SearchResponse response = (SearchResponse)tempCache.getIfPresent((Object)this.uniqueID);
            return this.checkAndGetResponse(response, maxNeeded);
        }
        return null;
    }

    protected abstract SearchResponse checkAndGetResponse(SearchResponse var1, int var2);

    public void addAggregation(AbstractAggregationBuilder aggregationEntry) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<AbstractAggregationBuilder>();
        }
        this.aggregations.add(aggregationEntry);
    }

    public void setTimeRange(Long startTime, Long endTime) {
        RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)"TIME").from((Object)startTime).to((Object)endTime);
        this.queryBuilder = this.queryBuilder.must((QueryBuilder)timeRange);
    }

    @Override
    public void addCriteria(String field, Object value, ClientIndexTableDataAdapter.SearchCondition condn) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)field, (Object)value);
        switch (condn) {
            case EQUAL: {
                this.queryBuilder.must((QueryBuilder)query);
                break;
            }
            case NOTEQUAL: {
                this.queryBuilder.mustNot((QueryBuilder)query);
                break;
            }
            case CONTAINS: {
                this.queryBuilder.should((QueryBuilder)query);
                break;
            }
            case EQUALS_REGEX: {
                String fieldVal = String.format("*%s*", StringUtil.escapeString(String.valueOf(value)));
                query = QueryBuilders.queryStringQuery((String)fieldVal).field(field).allowLeadingWildcard(true).analyzeWildcard(true);
                this.queryBuilder.must((QueryBuilder)query);
                break;
            }
            case EXISTS: {
                query = QueryBuilders.existsQuery((String)field);
                this.queryBuilder.must((QueryBuilder)query);
            }
        }
    }

    @Override
    public JSONArray page(int start, int pageLength, TimePack timePack) {
        return this.loadData(start, pageLength, timePack);
    }

    @Override
    public long getTotalCount() {
        return this.hitCount;
    }

    private void updateCacheEntry(SearchResponse response) {
        if (this.isCacheEnabled) {
            tempCache.put((Object)this.uniqueID, (Object)response);
        }
    }
}

