/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.adapters;

import com.adventnet.la.TimePack;
import com.adventnet.logsearch.index.util.LuceneConstants;
import com.adventnet.logsearch.search.BaseSearchHandler;
import com.adventnet.logsearch.search.CombinedCriteria;
import com.adventnet.logsearch.search.CombinedResult;
import com.adventnet.logsearch.search.CombinedSearchHandler;
import com.adventnet.logsearch.search.LogSearchAPI;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.client.datasource.ClientIndexDataFormatter;
import com.manageengine.ela.server.common.client.datasource.FieldInfo;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;

public class ClientIndexTableDataAdapter {
    private static final Cache<Long, Map<String, Long>> SEARCHCRITERIA_CACHE = new Cache();
    private static final Random UNIQUEID = new Random();
    private TableUniqueIdentifier tableIdentifier = null;
    private Locale locale = null;
    private TimeZone timeZone = null;
    private boolean isCacheNeeded = false;
    private boolean isForwardSearch = true;
    private long startTime = -1L;
    private long endTime = -1L;
    private int previousStartIndex = -1;
    private int previousEndIndex = -1;
    private CombinedResult result = null;
    private List<FieldInfo<String>> selectFields = null;
    private Long userId = null;
    private Map<String, Collection<?>> accessMap = null;
    private List<FieldInfo<String>> dummyColumn = null;
    private HashMap<String, ArrayList<String>> docIDMap = null;
    private StringBuilder defaultQueryString = new StringBuilder("-FORMATID:0");

    public ClientIndexTableDataAdapter(TableUniqueIdentifier tableIdentifier, Locale locale, TimeZone timeZone, Long userID) throws BaseStatusCode {
        this.tableIdentifier = tableIdentifier;
        this.userId = userID;
        this.locale = locale;
        this.timeZone = timeZone;
        this.selectFields = ClientIndexDataFormatter.getInstence().getColumnList(tableIdentifier);
    }

    public void setFields(List<FieldInfo<String>> fieldList) {
        if (fieldList != null) {
            this.selectFields.addAll(fieldList);
        }
    }

    public void addField(FieldInfo<String> field) {
        if (field != null) {
            this.selectFields.add(field);
        }
    }

    public void setStartTime(long strt) {
        this.startTime = strt;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setAccessMap(Map<String, Collection<?>> accessMap) {
        this.accessMap = accessMap;
    }

    public void setCacheNeeded(boolean isCacheNeeded) {
        this.isCacheNeeded = isCacheNeeded;
    }

    public void setPreviousStartIndex(int previousStartIndex) {
        this.previousStartIndex = previousStartIndex;
    }

    public void setPreviousEndIndex(int previousEndIndex) {
        this.previousEndIndex = previousEndIndex;
    }

    public void setForwardSearch(boolean frwdSearch) {
        this.isForwardSearch = frwdSearch;
    }

    public void setDocIDMap(HashMap<String, ArrayList<String>> docIDMap) {
        this.docIDMap = docIDMap;
    }

    public void setDummyFields(List<FieldInfo<String>> dummyColumn) {
        this.dummyColumn = dummyColumn;
    }

    public List<FieldInfo<String>> getAllColumns() {
        ArrayList<FieldInfo<String>> cols = new ArrayList<FieldInfo<String>>(this.selectFields);
        if (this.dummyColumn != null) {
            cols.addAll(this.dummyColumn);
        }
        return cols;
    }

    public void addCriteria(String field, Object value, SearchCondition condn) throws BaseStatusCode {
        if (condn == SearchCondition.EQUAL) {
            this.addKeyvaluePair(field, value);
        } else if (condn == SearchCondition.NOTEQUAL) {
            this.addKeyvaluePair("-" + field, value);
        } else {
            this.addKeyvaluePair(field, "");
        }
    }

    private void addKeyvaluePair(String key, Object value) {
        if (this.defaultQueryString.length() == 0) {
            this.defaultQueryString.append("(").append(key).append(":").append(value).append(")");
        } else {
            this.defaultQueryString.append(" AND (").append(key).append(value).append(")");
        }
    }

    public JSONArray page(int pageLength, int indexType, TimePack timePack) {
        if (this.docIDMap != null) {
            return this.pageDocIDResult(pageLength, indexType);
        }
        return this.pageCommonCriteriaResult(pageLength, indexType);
    }

    private JSONArray pageDocIDResult(int pageLength, int indexType) {
        try {
            List searchResult = LogSearchAPI.getDocsForUUID(this.docIDMap);
            LinkedList<HashMap<FieldInfo<String>, Object>> resultFromIndex = this.getRequestedFields(searchResult);
            return this.getTransformedData(resultFromIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONArray pageCommonCriteriaResult(int pageLength, int indexType) {
        try {
            CombinedCriteria criteria = this.getCombinedCriteria(pageLength);
            if (this.userId != null && this.isCacheNeeded) {
                criteria.setCacheEnabled(true);
                Map<String, Long> tableCache = SEARCHCRITERIA_CACHE.get(this.userId);
                if (tableCache != null) {
                    Long cacheID = tableCache.get(this.tableIdentifier.getUniqueId());
                    if (cacheID == null) {
                        cacheID = UNIQUEID.nextLong();
                    }
                    criteria.setCacheId(cacheID.longValue());
                } else {
                    tableCache = new HashMap<String, Long>();
                    tableCache.put(this.tableIdentifier.getUniqueId(), UNIQUEID.nextLong());
                    SEARCHCRITERIA_CACHE.put(this.userId, tableCache);
                }
            }
            LinkedList<HashMap<FieldInfo<String>, Object>> rslt = this.getDefaultQuerySearchResult(indexType, criteria);
            return this.getTransformedData(rslt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected JSONArray getTransformedData(LinkedList<HashMap<FieldInfo<String>, Object>> result) throws JSONException {
        if (this.dummyColumn == null) {
            return ClientIndexDataFormatter.getInstence().getTransformedData(result, this.locale, this.timeZone);
        }
        return ClientIndexDataFormatter.getInstence().getTransformedDataWithDummyValue(result, this.dummyColumn, this.locale, this.timeZone);
    }

    private CombinedCriteria getCombinedCriteria(int pageLength) {
        LuceneConstants.ResultFormat resultFormat = LuceneConstants.ResultFormat.LIST_OF_MAP;
        CombinedCriteria criteria = new CombinedCriteria(this.defaultQueryString.toString(), new String[0], "HOSTID", this.previousStartIndex, this.previousEndIndex, new long[]{this.startTime, this.endTime}, Collections.EMPTY_LIST, resultFormat, pageLength, this.isForwardSearch, true);
        if (this.timeZone != null) {
            criteria.setTimeZoneID(this.timeZone.getID());
        }
        if (this.accessMap != null) {
            criteria.setAccessMap(this.accessMap);
        }
        return criteria;
    }

    private LinkedList<HashMap<FieldInfo<String>, Object>> getDefaultQuerySearchResult(int intdexType, CombinedCriteria criteria) {
        CombinedResult result = intdexType == 1 ? new BaseSearchHandler().getCorrelSearchResults(criteria) : new CombinedSearchHandler().getSearchResults(criteria);
        List results = result.getSearchResultList();
        if (results.size() > 0) {
            return this.getRequestedFields((List)results.get(0));
        }
        return new LinkedList<HashMap<FieldInfo<String>, Object>>();
    }

    private LinkedList<HashMap<FieldInfo<String>, Object>> getRequestedFields(List<?> subContainer) {
        LinkedList<HashMap<FieldInfo<String>, Object>> resultFromIndex = new LinkedList<HashMap<FieldInfo<String>, Object>>();
        for (int index = 0; index < subContainer.size(); ++index) {
            Map searchData = (Map)subContainer.get(index);
            HashMap map = new HashMap();
            for (FieldInfo<String> field : this.selectFields) {
                map.put(field, searchData.get(field.getFieldKey()));
            }
            resultFromIndex.push(map);
        }
        return resultFromIndex;
    }

    public long getTotalCount() throws BaseStatusCode {
        if (this.result != null) {
            return this.result.getTotalCount();
        }
        throw BaseStatusCode.getBaseStatusCode(7429);
    }

    public static enum SearchCondition {
        EQUAL,
        NOTEQUAL,
        CONTAINS,
        EQUALS_REGEX,
        EXISTS;

    }
}

