/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.adapters;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.client.adapters.ClientDBArchiveAdapter;
import com.manageengine.ela.server.common.client.datasource.ClientDBDataFormatter;
import com.manageengine.ela.server.common.client.datasource.KeyBasedSearchResult;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;

public class ClinetDBTableDataAdapter {
    private SelectQuery selectQuery = null;
    private Integer tableID = null;
    private Criteria criteria = null;
    private Locale locale = null;
    private TimeZone timeZone = null;
    private List<Column> dummyColumn = null;
    private ClientDBArchiveAdapter archiveAdapter = null;
    private Long directCount = null;
    private Long archivedCount = null;

    public ClinetDBTableDataAdapter(TableUniqueIdentifier tableIdentifier, Locale locale, TimeZone timeZone, int tableType) {
        this.tableID = tableIdentifier.getTableId();
        this.locale = locale;
        this.timeZone = timeZone;
        switch (this.tableID) {
            case 1: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
                this.selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID", (String)"DEVICE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_NAME", (String)"HOST_NAME"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID", (String)"DEVICEDETAILS_ID"));
                break;
            }
            case 2: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
                this.selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID", (String)"DEVICE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID", (String)"DEVICEDETAILS_ID"));
                break;
            }
            case 3: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADomainComputerDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADomainComputerDetails", (String)"OBJECT_GUID", (String)"OBJECT_GUID"));
                break;
            }
            case 4: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
                this.selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID", (String)"DEVICE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID", (String)"DEVICEDETAILS_ID"));
                break;
            }
            case 5: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAWorkgroupComputerDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAWorkgroupComputerDetails", (String)"WORKGROUP_ID", (String)"WORKGROUP_ID"));
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 1001: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"HostGroup"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"ID", (String)"GROUP_ID"));
                break;
            }
            case 7: 
            case 8: 
            case 1002: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"HostGroup"));
                this.selectQuery.addJoin(new Join("HostGroup", "HostGroupMapping", new String[]{"ID"}, new String[]{"GROUPID"}, 1));
                this.selectQuery.addJoin(new Join("HostGroupMapping", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
                this.selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"ID", (String)"GROUP_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID", (String)"GROUPMAPPING_GROUP_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID", (String)"DEVICE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_NAME", (String)"HOST_NAME"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID", (String)"DEVICEDETAILS_ID"));
                break;
            }
            case 101: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"AaaUser"));
                this.selectQuery.addJoin(new Join("AaaUser", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaLogin", "AaaUserStatus", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaLogin", "AaaAccount", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaUser", "AaaUserContactInfo", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaUserContactInfo", "AaaContactInfo", new String[]{"CONTACTINFO_ID"}, new String[]{"CONTACTINFO_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"USER_ID", (String)"AAAUSERID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID", (String)"AAALOGINID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaAccount", (String)"ACCOUNT_ID", (String)"AAAACCOUNTID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaUserStatus", (String)"USER_ID", (String)"AAALOGINUSERID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaUserContactInfo", (String)"CONTACTINFO_ID", (String)"AAAUSERCONTACTINFOID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaContactInfo", (String)"CONTACTINFO_ID", (String)"AAACONTACTINFOID"));
                break;
            }
            case 108: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"AaaUser"));
                this.selectQuery.addJoin(new Join("AaaUser", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaUser", "ELAUserScheduleImportHistory", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"USER_ID", (String)"AAAUSERID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID", (String)"AAALOGINID"));
                break;
            }
            case 102: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADomainUserDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADomainUserDetails", (String)"OBJECT_GUID", (String)"OBJECT_GUID"));
                break;
            }
            case 103: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"AaaUser"));
                this.selectQuery.addJoin(new Join("AaaUser", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaLogin", "AaaAccount", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
                this.selectQuery.addJoin(new Join("AaaAccount", "AaaAccSession", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"USER_ID", (String)"AAAUSERID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"USER_ID", (String)"AAALOGINUSERID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID", (String)"AAALOGINID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaAccount", (String)"ACCOUNT_ID", (String)"USERACCOUNTID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaAccSession", (String)"ACCOUNT_ID", (String)"USERSESACCOUNTID"));
                break;
            }
            case 104: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADomainGroupDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADomainGroupDetails", (String)"OBJECT_GUID", (String)"OBJECT_GUID"));
                break;
            }
            case 105: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAOuContainerGeneralDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAOuContainerGeneralDetails", (String)"OBJECT_GUID", (String)"OBJECT_GUID"));
                break;
            }
            case 106: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"Schedule"));
                this.selectQuery.addJoin(new Join("Schedule", "ELADiscoveryScheduleConfig", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("Scheduled_Task", "Task_Input", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELADiscoveryScheduleConfig", "ELADiscoveryCriteriaConfig", new String[]{"SCHEDULE_CONFIG_ID"}, new String[]{"SCHEDULE_CONFIG_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID", (String)"SCHEDULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID", (String)"INSTANCE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADiscoveryScheduleConfig", (String)"SCHEDULE_CONFIG_ID", (String)"SCHEDULE_CONFIG_ID"));
                break;
            }
            case 107: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADiscoveryScheduleHistory"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADiscoveryScheduleHistory", (String)"SCHEDULE_HISTORY_ID", (String)"SCHEDULE_HISTORY_ID"));
                break;
            }
            case 501: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)ADSDomainHandler.tableName));
                this.selectQuery.addSelectColumn(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_ID", (String)"DOMAIN_ID"));
                break;
            }
            case 502: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAWorkgroupConfiguration"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAWorkgroupConfiguration", (String)"WORKGROUP_ID", (String)"WORKGROUP_ID"));
                break;
            }
            case 10: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"SysLogListenerPorts"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SysLogListenerPorts", (String)"ID", (String)"ID"));
                break;
            }
            case 35: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit"));
                this.selectQuery.addJoin(new Join("LAAlertAudit", "ELA_AlertAssignMapping", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
                this.selectQuery.addJoin(new Join("ELA_AlertAssignMapping", "AaaLogin", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 1));
                this.selectQuery.addJoin(new Join("LAAlertAudit", "ELA_AlertComments", new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 1));
                this.selectQuery.addJoin(new Join("LAAlertAudit", "NotificationType", new String[]{"NF_ID"}, new String[]{"NOTIFID"}, 1));
                this.selectQuery.addJoin(new Join("NotificationType", "UserToNotificationType", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"LAAlertAudit", (String)"AUDIT_ID", (String)"AUDIT_ID_PK1"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELA_AlertComments", (String)"AUDIT_ID", (String)"AUDIT_ID_PK2"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"USER_ID", (String)"USER_ID_PK"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFID", (String)"NOTIFID_PK"));
                break;
            }
            case 36: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELA_AssignRules"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"));
                break;
            }
            case 37: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ImportantReports"));
                this.selectQuery.addJoin(new Join("ImportantReports", "ImportantReportsGroup", new String[]{"IMP_GROUP_NAME"}, new String[]{"IMP_GROUP_NAME"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ImportantReports", (String)"IMPID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ImportantReports", (String)"IS_TRANSFORM_NEEDED"));
                break;
            }
            case 38: {
                String[] ntId = new String[]{"NOTIFID"};
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFID", (String)"NOTIF_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"ISRESOLVENEEDED"));
                this.selectQuery.addJoin(new Join("NotificationType", "UserToNotificationType", ntId, ntId, 2));
                break;
            }
            case 201: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleSuccessHistory"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID", (String)"SUCC_HISTORY_ID"));
                break;
            }
            case 204: 
            case 207: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"IS_PRIMARY"));
                break;
            }
            case 202: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
                this.selectQuery.addJoin(new Join("CorrRuleInfo", "CorrRuleCategory", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 1));
                this.selectQuery.addJoin(new Join("CorrRuleInfo", "CorrNotificationMapping", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
                this.selectQuery.addJoin(new Join("CorrNotificationMapping", "NotificationType", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID", (String)"CORR_RULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED", (String)"IS_RULE_SYS_GENERATED"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID", (String)"CORR_CATEGORY_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrNotificationMapping", (String)"RULE_ID", (String)"NOTIF_RULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrNotificationMapping", (String)"NOTIFID", (String)"ALERT_NOTIF_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"NOTIFID", (String)"NOTIF_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"STATUS", (String)"NOTIF_STATUS"));
                break;
            }
            case 208: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
                this.selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityMonitorProfile", new String[]{"PROFILE_ID"}, new String[]{"PROFILE_ID"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID", (String)"PROVIDER_RULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"DISPLAY_NAME", (String)"RULE_DISPLAY_NAME"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"IS_SYSTEMGENERATED", (String)"IS_RULE_SYS_GENERATED"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"VISIBILITY", (String)"VISIBILITY"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"PROFILE_ID", (String)"ACTIVITY_PROFILE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"DISPLAY_NAME", (String)"PROFILE_DISPLAY_NAME"));
                this.selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"VISIBILITY"), (Object)true, 0));
                break;
            }
            case 550: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrScheduledReports"));
                this.selectQuery.addJoin(new Join("CorrScheduledReports", "ELATableExportSchedules", new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "ELAExportScheduleConfigurations", new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 2));
                this.selectQuery.addJoin(new Join("CorrScheduledReports", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrScheduledReports", (String)"RULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrScheduledReports", (String)"EXPORT_ID", (String)"CORR_EXPORT_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"TYPE", (String)"RULE_TYPE"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID", (String)"CORR_RULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED", (String)"IS_RULE_SYS_GENERATED"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID", (String)"TABLE_EXPORT_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"CONFIG_ID", (String)"TABLE_EXPORTCONF_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID", (String)"EXPORT_SCHEDULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID", (String)"EXP_INSTANCE_ID"));
                break;
            }
            case 551: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELATableExportScheduleHistory"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportScheduleHistory", (String)"HISTORY_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportScheduleHistory", (String)"EXPORT_ID"));
                break;
            }
            case 702: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"IISDiscoveredSites"));
                this.selectQuery.addJoin(new Join("IISDiscoveredSites", "IISDiscoveredFilesInfo", new String[]{"SITE_ID"}, new String[]{"SITE_ID"}, 2));
                break;
            }
            case 706: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"WebServerConfiguration"));
                this.selectQuery.addJoin(new Join("WebServerConfiguration", "IISApplicationInfo", new String[]{"WEBSERVER_ID"}, new String[]{"WEBSERVER_ID"}, 2));
                this.selectQuery.addJoin(new Join("WebServerConfiguration", "AppResources", new String[]{"APPID"}, new String[]{"APPID"}, 2));
                this.selectQuery.addJoin(new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 2));
                this.selectQuery.addJoin(new Join("WebServerConfiguration", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
                break;
            }
            case 707: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"IISConfiguredSites"));
                this.selectQuery.addJoin(new Join("IISConfiguredSites", "IISLogFIleInfo", new String[]{"SITE_ID"}, new String[]{"SITE_ID"}, 2));
                this.selectQuery.addJoin(new Join("IISLogFIleInfo", "IISLogAuditDetails", new String[]{"FILE_ID"}, new String[]{"FILE_ID"}, 2));
                break;
            }
            case 708: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"IISConfiguredSites"));
                this.selectQuery.addJoin(new Join("IISConfiguredSites", "IISLogFIleInfo", new String[]{"SITE_ID"}, new String[]{"SITE_ID"}, 2));
                this.selectQuery.addJoin(new Join("IISLogFIleInfo", "IISLogAuditDetails", new String[]{"FILE_ID"}, new String[]{"FILE_ID"}, 2));
                break;
            }
            case 703: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADomainComputerDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELADomainComputerDetails", (String)"OBJECT_GUID", (String)"OBJECT_GUID"));
                break;
            }
            case 705: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAWorkgroupComputerDetails"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAWorkgroupComputerDetails", (String)"WORKGROUP_ID", (String)"WORKGROUP_ID"));
                break;
            }
            case 710: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"AppResources"));
                this.selectQuery.addJoin(new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
                this.selectQuery.addJoin(new Join("AppResources", "FormatDetails", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 1));
                break;
            }
            case 701: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAWindowsEvtFilesInfo"));
                break;
            }
            case 801: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"ScheduledReports"));
                this.selectQuery.addJoin(new Join("ScheduledReports", "ELATableExportSchedules", new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "ELAExportScheduleConfigurations", new String[]{"EXPORT_ID"}, new String[]{"EXPORT_ID"}, 2));
                this.selectQuery.addJoin(new Join("ScheduledReports", "ReportConfig", new String[]{"REPORT_ID"}, new String[]{"REPORTID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addJoin(new Join("ELATableExportSchedules", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ScheduledReports", (String)"REPORT_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ScheduledReports", (String)"EXPORT_ID", (String)"COMP_EXPORT_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTID", (String)"COMP_REPORTID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"LAST_GENERATED_REPORT"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID", (String)"TABLE_EXPORT_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"ELAExportScheduleConfigurations", (String)"CONFIG_ID", (String)"TABLE_EXPORTCONF_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID", (String)"EXPORT_SCHEDULE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID", (String)"EXP_INSTANCE_ID"));
                break;
            }
            case 460: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
                this.selectQuery.addJoin(new Join("SQLServerDetails", "AppResources", new String[]{"APPID"}, new String[]{"APPID"}, 1));
                this.selectQuery.addJoin(new Join("AppResources", "HostDetails", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"SERVER_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"STATUS"));
                break;
            }
            case 461: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"SQLServerDatabases"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SQLServerDatabases", (String)"DATABASE_ID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SQLServerDatabases", (String)"IS_ENABLED"));
                break;
            }
            case 462: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"SQLServerDiscoveredInstances"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SQLServerDiscoveredInstances", (String)"INSTANCE_ID"));
                break;
            }
            case 463: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"SQLServerColumns"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"SQLServerColumns", (String)"COLUMN_ID"));
                break;
            }
            case 720: {
                this.selectQuery = new SelectQueryImpl(Table.getTable((String)"AppResources"));
                this.selectQuery.addJoin(new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
                this.selectQuery.addJoin(new Join("AppResources", "FormatDetails", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 1));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"APPID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"FORMATID"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_NAME"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"FORMATDESC"));
                this.selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"));
                break;
            }
            default: {
                throw new IllegalArgumentException("TableID is not defined");
            }
        }
    }

    public ClinetDBTableDataAdapter(SelectQuery selectQuery, Integer tableID, Locale locale, TimeZone timeZone) {
        if (selectQuery == null) {
            throw new IllegalArgumentException("Select query cannot be null is not defined");
        }
        this.selectQuery = selectQuery;
        this.tableID = tableID;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public void addSelectColumn(List<Column> columnList) {
        List columnAdded = this.selectQuery.getSelectColumns();
        if (columnAdded != null) {
            columnList.removeAll(columnAdded);
        }
        this.selectQuery.addSelectColumns(columnList);
    }

    public void addDummyColumns(List<Column> columnList) {
        this.dummyColumn = columnList;
    }

    public void addSelectColumn(Column column) {
        this.selectQuery.addSelectColumn(column);
    }

    public void addSortColumn(SortColumn sortColumn) {
        if (this.selectQuery == null) {
            throw new IllegalAccessError("Data Adapter is not initialized properly");
        }
        this.selectQuery.addSortColumn(sortColumn);
    }

    public void addSortColumn(List<SortColumn> sortColumns) {
        if (this.selectQuery == null) {
            throw new IllegalAccessError("Data Adapter is not initialized properly");
        }
        this.selectQuery.addSortColumns(sortColumns);
    }

    public void addCriteria(Criteria criteria) throws IllegalAccessError {
        if (criteria == null) {
            return;
        }
        if (this.selectQuery == null) {
            throw new IllegalAccessError("Data Adapter is not initialized properly");
        }
        this.criteria = this.criteria == null ? criteria : this.criteria.and(criteria);
        this.selectQuery.setCriteria(this.criteria);
    }

    public void addJoin(Join join) {
        if (join == null) {
            return;
        }
        if (this.selectQuery == null) {
            throw new IllegalAccessError("Data Adapter is not initialized properly");
        }
        this.selectQuery.addJoin(join);
    }

    public void resetToDefaultCriteria(Criteria defaultCriteria) {
        if (this.selectQuery == null) {
            throw new IllegalAccessError("Data Adapter is not initialized properly");
        }
        this.criteria = defaultCriteria;
        this.selectQuery.setCriteria(this.criteria);
    }

    public JSONArray page(int limit, int offset) {
        if (this.directCount == null) {
            throw new IllegalStateException();
        }
        if (this.getTotalCount() <= 0L) {
            return null;
        }
        LinkedList<HashMap<Column, Object>> mapLinkedListFromDb = new LinkedList<HashMap<Column, Object>>();
        try {
            if ((long)offset <= this.directCount) {
                mapLinkedListFromDb.addAll(DefaultDataSource.getRows(this.selectQuery, offset, limit));
            }
            int liveResultSize = mapLinkedListFromDb.size();
            if (this.archiveAdapter != null && liveResultSize < limit) {
                int derivedLimit = limit - liveResultSize;
                int derivedOffset = offset + liveResultSize - this.directCount.intValue();
                LinkedList<HashMap<Column, Object>> archivedData = this.archiveAdapter.page(this.selectQuery, derivedOffset, derivedLimit);
                if (archivedData != null) {
                    mapLinkedListFromDb.addAll(archivedData);
                }
            }
            return this.getTransformedResult(mapLinkedListFromDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public KeyBasedSearchResult getkeyBasedSearchResult(Column column, String condnString, Column conditionColumn, Locale locale, int offset, int limit) {
        KeyBasedSearchResult mapLinkedListFromDb = null;
        try {
            mapLinkedListFromDb = DefaultDataSource.getKeyBasedSearchResult(column, condnString, this.selectQuery, conditionColumn, locale, offset, limit);
            mapLinkedListFromDb.setResultArrayForClient(this.getTransformedResult(mapLinkedListFromDb.getResultList()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapLinkedListFromDb;
    }

    private JSONArray getTransformedResult(LinkedList<HashMap<Column, Object>> mapLinkedListFromDb) throws JSONException {
        JSONArray resultJsonArray = this.dummyColumn == null ? ClientDBDataFormatter.getInstence().getTransformedData(mapLinkedListFromDb, this.locale, this.timeZone) : ClientDBDataFormatter.getInstence().getTransformedDataWithDummyValue(mapLinkedListFromDb, this.dummyColumn, this.locale, this.timeZone);
        return resultJsonArray;
    }

    public long getTotalCount() {
        if (this.directCount == null) {
            this.directCount = DBUtil.getTotalCount(this.selectQuery);
            this.archivedCount = this.archiveAdapter != null ? Long.valueOf(this.archiveAdapter.getTotalCount(this.selectQuery)) : Long.valueOf(0L);
        }
        return this.directCount + this.archivedCount;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setArchiveAdapter(ClientDBArchiveAdapter archiveAdapter) {
        this.archiveAdapter = archiveAdapter;
    }
}

