/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.datasource;

import com.manageengine.ela.server.common.client.structure.ClientTableStructure;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.data.conversion.DataConverter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ClientAbstractFormatter<T> {
    private static final Logger LOGGER = Logger.getLogger(ClientAbstractFormatter.class.getName());

    public ArrayList<T> getColumnList(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        return this.getAllColumns(tableIdentifier).get("original_columns");
    }

    public Map<String, ArrayList<T>> getAllColumns(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        return this.getAllColumns(tableIdentifier, null);
    }

    public ArrayList<T> getColumnList(TableUniqueIdentifier tableIdentifier, ArrayList<T> allowedList) throws BaseStatusCode {
        return this.getAllColumns(tableIdentifier, allowedList).get("original_columns");
    }

    public Map<String, ArrayList<T>> getAllColumns(TableUniqueIdentifier tableIdentifier, ArrayList<T> allowedList) throws BaseStatusCode {
        return this.getColumnListMap(tableIdentifier, null, allowedList);
    }

    private Map<String, ArrayList<T>> getColumnListMap(TableUniqueIdentifier tableIdentifier, ArrayList<T> skipList, ArrayList<T> allowedList) throws BaseStatusCode {
        JSONArray structure = ClientTableStructure.getColumnDefinition(tableIdentifier);
        return this.collectColumnBasedOnCriteria(structure, skipList, allowedList);
    }

    protected Map<String, ArrayList<T>> collectColumnBasedOnCriteria(JSONArray columnDefinition, ArrayList<T> skipList, ArrayList<T> allowdList) throws BaseStatusCode {
        HashMap<String, ArrayList<T>> columnDetailsMap = new HashMap<String, ArrayList<T>>();
        ArrayList<T> orgColumnList = new ArrayList<T>();
        ArrayList<T> psedoColumns = new ArrayList<T>();
        for (int index = 0; index < columnDefinition.length(); ++index) {
            try {
                Long transformID;
                T column;
                boolean isPseudoColumn;
                JSONObject singleObject = columnDefinition.getJSONObject(index);
                boolean bl = isPseudoColumn = !singleObject.isNull("IS_PSEUDO") && singleObject.getBoolean("IS_PSEUDO");
                if (!this.isValidColumn(singleObject) || !this.verifySkipListAndAllowedList(column = this.getNewColumn(singleObject), skipList, allowdList)) continue;
                Long l = transformID = singleObject.isNull("TRANSFORM_ID") ? null : Long.valueOf(singleObject.getLong("TRANSFORM_ID"));
                if (transformID != null && this.checkAndAddtransformerCache(column, transformID)) {
                    this.fillDependentColumns(transformID, orgColumnList);
                }
                if (isPseudoColumn) {
                    psedoColumns.add(column);
                    continue;
                }
                if (orgColumnList.contains(column)) continue;
                orgColumnList.add(column);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        columnDetailsMap.put("original_columns", orgColumnList);
        columnDetailsMap.put("pseudo_columns", psedoColumns);
        return columnDetailsMap;
    }

    public JSONArray getTransformedData(LinkedList<HashMap<T, Object>> table, Locale locale, TimeZone timeZone) throws JSONException {
        JSONArray resultJsonArray = new JSONArray();
        for (HashMap hashMap : table) {
            JSONObject rowJsonObject = this.transform(locale, timeZone, hashMap);
            resultJsonArray.put((Object)rowJsonObject);
        }
        return resultJsonArray;
    }

    public JSONArray getTransformedDataWithDummyValue(LinkedList<HashMap<T, Object>> table, List<T> dummy, Locale locale, TimeZone timeZone) throws JSONException {
        JSONArray resultJsonArray = new JSONArray();
        HashMap<T, Object> dummymap = new HashMap<T, Object>();
        for (T t : dummy) {
            dummymap.put(t, null);
        }
        for (HashMap hashMap : table) {
            hashMap.putAll(dummymap);
            JSONObject rowJsonObject = this.transform(locale, timeZone, hashMap);
            resultJsonArray.put((Object)rowJsonObject);
        }
        return resultJsonArray;
    }

    private JSONObject transform(Locale locale, TimeZone timeZone, HashMap<T, Object> rowHashMap) throws JSONException {
        JSONObject rowJsonObject = new JSONObject();
        HashMap<Object, Object> additionalArgs = new HashMap<Object, Object>();
        additionalArgs.put("clienttimezone", timeZone);
        additionalArgs.put("conversionLocale", locale);
        for (T key : rowHashMap.keySet()) {
            String jsonKey = this.getCustomResultKeyName(key);
            DataConverter<Object, Object> convertr = this.getTransformer(key);
            if (convertr != null) {
                try {
                    rowJsonObject.put(jsonKey, convertr.transform(rowHashMap.get(key), rowHashMap, additionalArgs));
                }
                catch (Exception exp) {
                    rowJsonObject.put(jsonKey, rowHashMap.get(key));
                    LOGGER.fine("Exception in data conversion : " + exp.getMessage());
                }
                continue;
            }
            rowJsonObject.put(jsonKey, rowHashMap.get(key));
        }
        return rowJsonObject;
    }

    protected abstract DataConverter<T, Object> getTransformer(T var1);

    protected abstract String getCustomResultKeyName(T var1);

    protected abstract boolean verifySkipListAndAllowedList(T var1, ArrayList<T> var2, ArrayList<T> var3);

    protected abstract boolean checkAndAddtransformerCache(T var1, Long var2);

    protected abstract T getNewColumn(JSONObject var1) throws JSONException;

    protected abstract boolean isValidColumn(JSONObject var1) throws JSONException;

    protected abstract void fillDependentColumns(Long var1, ArrayList<T> var2) throws BaseStatusCode;
}

