/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.datasource;

import com.adventnet.ds.query.Column;
import com.manageengine.ela.server.common.client.datasource.ClientAbstractFormatter;
import com.manageengine.ela.server.common.data.conversion.DataConverter;
import com.manageengine.ela.server.common.data.conversion.RowDataTransformer;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientDBDataFormatter
extends ClientAbstractFormatter<Column> {
    private static final Map<Column, Long> COLUMN_TRANSFORMER_CACHE = new ConcurrentHashMap<Column, Long>();
    private static ClientDBDataFormatter instence = null;
    private static final Logger LOGGER = Logger.getLogger(ClientDBDataFormatter.class.getName());

    private ClientDBDataFormatter() {
    }

    public static ClientDBDataFormatter getInstence() {
        if (instence == null) {
            instence = new ClientDBDataFormatter();
        }
        return instence;
    }

    @Override
    protected boolean checkAndAddtransformerCache(Column data, Long transformerID) {
        if (!COLUMN_TRANSFORMER_CACHE.containsKey(data)) {
            COLUMN_TRANSFORMER_CACHE.put(data, transformerID);
        }
        return true;
    }

    @Override
    protected Column getNewColumn(JSONObject singleObject) throws JSONException {
        return Column.getColumn((String)singleObject.getString("COLUMN_TABLENAME"), (String)singleObject.getString("COLUMNNAME"));
    }

    @Override
    protected boolean isValidColumn(JSONObject singleObject) throws JSONException {
        return !singleObject.isNull("COLUMN_TABLENAME") && !singleObject.getString("COLUMN_TABLENAME").isEmpty();
    }

    @Override
    protected void fillDependentColumns(Long transformID, ArrayList<Column> columnList) throws BaseStatusCode {
        DataConverter<Column, Object> transformer = RowDataTransformer.getTransformer(transformID);
        Object[] columns = transformer.getArguments();
        if (columns != null) {
            for (Object col : columns) {
                Column depdntCol;
                if (col == null || !(col instanceof Column) || columnList.contains(depdntCol = (Column)col)) continue;
                columnList.add(depdntCol);
            }
        }
    }

    @Override
    protected DataConverter<Column, Object> getTransformer(Column data) {
        Long transformer = COLUMN_TRANSFORMER_CACHE.get(data);
        if (transformer != null) {
            try {
                return RowDataTransformer.getTransformer(transformer);
            }
            catch (BaseStatusCode e) {
                LOGGER.fine("Exception in convertion method collection : " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected String getCustomResultKeyName(Column key) {
        return key.getTableAlias() + "_" + key.getColumnName();
    }

    @Override
    protected boolean verifySkipListAndAllowedList(Column column, ArrayList<Column> skipList, ArrayList<Column> allowdList) {
        return (skipList == null || !skipList.contains(column)) && (allowdList == null || allowdList.contains(column));
    }
}

