/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.datasource;

import com.manageengine.ela.server.common.client.datasource.ClientAbstractFormatter;
import com.manageengine.ela.server.common.client.datasource.FieldInfo;
import com.manageengine.ela.server.common.data.conversion.DataConverter;
import com.manageengine.ela.server.common.data.conversion.FieldBasedTransformer;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientIndexDataFormatter
extends ClientAbstractFormatter<FieldInfo<String>> {
    private static final Map<Long, Long> FIELD_TRANSFORMER_CACHE = new ConcurrentHashMap<Long, Long>();
    private static final Logger LOGGER = Logger.getLogger(ClientIndexDataFormatter.class.getName());
    private static ClientIndexDataFormatter instence = null;

    private ClientIndexDataFormatter() {
    }

    public static ClientIndexDataFormatter getInstence() {
        if (instence == null) {
            instence = new ClientIndexDataFormatter();
        }
        return instence;
    }

    @Override
    protected DataConverter<FieldInfo<String>, Object> getTransformer(FieldInfo<String> data) {
        Long transformer = FIELD_TRANSFORMER_CACHE.get(data);
        if (transformer != null) {
            try {
                return FieldBasedTransformer.getTransformer(transformer);
            }
            catch (BaseStatusCode e) {
                LOGGER.fine("Exception in convertion method collection : " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected String getCustomResultKeyName(FieldInfo<String> data) {
        return data.getFieldKey();
    }

    @Override
    protected boolean checkAndAddtransformerCache(FieldInfo<String> data, Long transformerID) {
        if (data.getFieldID() != null && !FIELD_TRANSFORMER_CACHE.containsKey(data.getFieldID())) {
            FIELD_TRANSFORMER_CACHE.put(data.getFieldID(), transformerID);
        }
        return true;
    }

    @Override
    protected FieldInfo<String> getNewColumn(JSONObject singleObject) throws JSONException {
        FieldInfo<String> info = new FieldInfo<String>();
        info.setFieldKey(singleObject.getString("COLUMNNAME"));
        info.setFieldID(singleObject.getLong("CONFIG_ID"));
        return info;
    }

    @Override
    protected boolean isValidColumn(JSONObject singleObject) throws JSONException {
        return !singleObject.isNull("COLUMNNAME") && !singleObject.getString("COLUMNNAME").isEmpty();
    }

    @Override
    @Deprecated
    protected void fillDependentColumns(Long transformID, ArrayList<FieldInfo<String>> columnList) throws BaseStatusCode {
        DataConverter<FieldInfo<String>, Object> transformer = FieldBasedTransformer.getTransformer(transformID);
        Object[] columns = transformer.getArguments();
        if (columns != null) {
            for (Object col : columns) {
                FieldInfo<String> fieldInfo;
                if (col == null || !(col instanceof String) || this.isContains(fieldInfo = new FieldInfo<String>().setFieldKey((String)col), columnList)) continue;
                columnList.add(fieldInfo);
            }
        }
    }

    @Override
    protected boolean verifySkipListAndAllowedList(FieldInfo<String> column, ArrayList<FieldInfo<String>> skipList, ArrayList<FieldInfo<String>> allowdList) {
        return (skipList == null || !this.isContains(column, skipList)) && (allowdList == null || this.isContains(column, allowdList));
    }

    private boolean isContains(FieldInfo<String> column, ArrayList<FieldInfo<String>> list) {
        for (FieldInfo<String> entry : list) {
            if (!column.getFieldKey().equals(entry.getFieldKey())) continue;
            return true;
        }
        return false;
    }
}

