/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.structure;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.client.structure.ClientStructureModel;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseTableStructure
implements ClientStructureModel {
    @Override
    public JSONObject retrieveStructure(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        try {
            SelectQuery query = this.getTableStrucutureQuery(tableIdentifier);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get(query);
            JSONObject tableDef = this.processDataObject(tableIdentifier, dataObject);
            JSONObject tableDetails = new JSONObject();
            tableDetails.put("table_properties", (Object)tableDef);
            JSONObject columnDef = new JSONObject();
            JSONArray columndefn = this.getColumnDefinition(tableIdentifier, dataObject);
            columnDef.put("COLUMNDEFINITION", (Object)columndefn);
            JSONArray customColumns = this.getAllColumns(tableIdentifier, dataObject);
            columnDef.put("CUSTOMCOLUMNS", (Object)customColumns);
            tableDetails.put("column_properties", (Object)columnDef);
            return tableDetails;
        }
        catch (BaseStatusCode baseStatusCode) {
            throw baseStatusCode;
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
        catch (JSONException e) {
            throw BaseStatusCode.getBaseStatusCode(65535);
        }
    }

    @Override
    public void customizeColumns(TableUniqueIdentifier identifier, String[] columns, boolean makeVisible) throws BaseStatusCode {
        try {
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ElaEmberColumnConfigurations");
            Criteria criteria = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"TABLE_ID"), (Object)identifier.getTableId(), 0);
            criteria = criteria.and(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"DISPLAY_KEY"), (Object)columns, 8);
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn("COLUMN_DISPLAY_TYPE", (Object)(makeVisible ? "VISIBLE" : "HIDDEN"));
            PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
    }

    protected SelectQuery getTableStrucutureQuery(TableUniqueIdentifier tableIdentifier) throws DataAccessException {
        Criteria parent = new Criteria(Column.getColumn((String)"ElaEmberTableDetails", (String)"TABLEID"), (Object)tableIdentifier.getTableId(), 0);
        SelectQueryImpl tableDetailsQuery = new SelectQueryImpl(Table.getTable((String)"ElaEmberTableDetails"));
        tableDetailsQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        tableDetailsQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"INDEX"), true));
        tableDetailsQuery.setCriteria(parent);
        tableDetailsQuery.addJoin(new Join(Table.getTable((String)"ElaEmberTableDetails"), Table.getTable((String)"ElaEmberColumnConfigurations"), new String[]{"TABLEID"}, new String[]{"TABLEID"}, 2));
        return tableDetailsQuery;
    }

    protected JSONObject processDataObject(TableUniqueIdentifier tableIdentifier, DataObject dobj) throws DataAccessException, JSONException {
        return JSONUtil.rowToJSON(dobj.getRow("ElaEmberTableDetails"));
    }

    protected JSONArray getColumnDefinition(TableUniqueIdentifier tableIdentifier, DataObject dobj) throws JSONException, DataAccessException, BaseStatusCode {
        JSONArray additionalCols;
        JSONArray columnDefinitionArray = new JSONArray();
        Criteria child = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"COLUMN_DISPLAY_TYPE"), (Object)new String[]{"VISIBLE", "FIXED"}, 8);
        Iterator rowIterator = dobj.getRows("ElaEmberColumnConfigurations", child);
        Boolean isInserted = false;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            Float index = (Float)row.get("INDEX");
            if (!isInserted.booleanValue() && index.floatValue() >= this.getCustomColumnInsertionIndex().floatValue()) {
                JSONArray additionalCols2 = this.customizeColumnDefinition(tableIdentifier, dobj);
                if (additionalCols2 != null) {
                    for (int i = 0; i < additionalCols2.length(); ++i) {
                        columnDefinitionArray.put((Object)additionalCols2.getJSONObject(i));
                    }
                }
                isInserted = true;
            }
            columnDefinitionArray.put((Object)JSONUtil.rowToJSON(row));
        }
        if (!isInserted.booleanValue() && (additionalCols = this.customizeColumnDefinition(tableIdentifier, dobj)) != null) {
            for (int i = 0; i < additionalCols.length(); ++i) {
                columnDefinitionArray.put(additionalCols.get(i));
            }
        }
        return columnDefinitionArray;
    }

    protected JSONArray getAllColumns(TableUniqueIdentifier tableIdentifier, DataObject dobj) throws DataAccessException, BaseStatusCode, JSONException {
        Criteria child = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"COLUMN_DISPLAY_TYPE"), (Object)new String[]{"VISIBLE", "HIDDEN"}, 8);
        child = child.and(new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"ISINDICATOR"), (Object)0, 0));
        Iterator rowIterator = dobj.getRows("ElaEmberColumnConfigurations", child);
        JSONArray columnDisplayName = new JSONArray();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            String colName = (String)row.get("DISPLAY_KEY");
            Long colId = (Long)row.get("CONFIG_ID");
            JSONObject colOBj = new JSONObject();
            colOBj.put("DISPLAY_NAME", (Object)ProductBundle.getInstance().getString(tableIdentifier.getLocale(), colName));
            colOBj.put("CONFIG_ID", (Object)colId);
            columnDisplayName.put((Object)colOBj);
        }
        return columnDisplayName;
    }

    protected JSONArray customizeColumnDefinition(TableUniqueIdentifier tableIdentifier, DataObject dataObject) throws BaseStatusCode {
        return null;
    }

    protected JSONArray customizeFullColumnList(TableUniqueIdentifier tableIdentifier, DataObject dataObject) throws BaseStatusCode {
        return null;
    }

    protected Float getCustomColumnInsertionIndex() {
        return Float.valueOf(0.0f);
    }
}

