/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.client.structure;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.client.structure.ClientStructureModel;
import com.manageengine.ela.server.common.client.structure.TableUniqueIdentifier;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientTableStructure {
    private static final Map<String, JSONObject> TABLESTRUCTURE_CACHE = new ConcurrentHashMap<String, JSONObject>();
    private static final Cache<String, ClientStructureModel> TABLE_STRUCTURE_MODEL_CONTAINER = new Cache();
    public static final String PSEUDO_COLUMNS = "pseudo_columns";
    public static final String ORIGINAL_COLUMNS = "original_columns";
    public static final String COLUMN_PROPERTIES = "column_properties";
    public static final String TABLE_PROPERTIES = "table_properties";
    public static final String COLUMN_DEFINITION = "COLUMNDEFINITION";
    public static final String CUSTOM_COLUMNS = "CUSTOMCOLUMNS";
    public static final String TABLE_ID = "TABLE_ID";
    private static final ReadWriteLock RWLOCK = new ReentrantReadWriteLock(true);

    public static JSONObject getTableStructure(TableUniqueIdentifier tableIdentifier) {
        JSONObject tableStructureJsonObject = new JSONObject();
        try {
            JSONObject structure = ClientTableStructure.getColumnConfigurationFromCache(tableIdentifier);
            tableStructureJsonObject.put(TABLE_ID, (Object)tableIdentifier.getTableId());
            ClientTableStructure.getLocaleTranslatedColumns(structure, tableIdentifier.getLocale());
            tableStructureJsonObject.put("structure", (Object)structure);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return tableStructureJsonObject;
    }

    public static JSONArray getColumnDefinition(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        JSONObject structure = ClientTableStructure.getColumnConfigurationFromCache(tableIdentifier);
        ClientTableStructure.getLocaleTranslatedColumns(structure, tableIdentifier.getLocale());
        try {
            if (!structure.isNull(COLUMN_DEFINITION)) {
                return structure.getJSONArray(COLUMN_DEFINITION);
            }
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(65535);
        }
        return null;
    }

    public static JSONObject getTableProperties(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        JSONObject tableProperties = new JSONObject();
        try {
            JSONObject tableCache = ClientTableStructure.getTableDetailsFromCache(tableIdentifier);
            tableProperties = tableCache.getJSONObject(TABLE_PROPERTIES);
        }
        catch (JSONException exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return tableProperties;
    }

    public static void removeTableStructureFromCache(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        TABLESTRUCTURE_CACHE.remove(tableIdentifier.getUniqueId());
    }

    public static void removeTableStructureFromCache(String uniqueID) throws BaseStatusCode {
        TABLESTRUCTURE_CACHE.remove(uniqueID);
    }

    public static void clearAllCache() {
        TABLESTRUCTURE_CACHE.clear();
    }

    public static String getStructureHandler(TableUniqueIdentifier tableIdentifier) {
        try {
            Criteria parent = new Criteria(Column.getColumn((String)"ElaEmberTableDetails", (String)"TABLEID"), (Object)tableIdentifier.getTableId(), 0);
            SelectQueryImpl tableDetailsQuery = new SelectQueryImpl(Table.getTable((String)"ElaEmberTableDetails"));
            tableDetailsQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            tableDetailsQuery.setCriteria(parent);
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)tableDetailsQuery);
            Row row = dobj.getFirstRow("ElaEmberTableDetails");
            return (String)row.get("STRUCTURE_HANDLER_CLASS");
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    private static JSONObject getBaseStructureForTable(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        ClientStructureModel model = null;
        if (TABLE_STRUCTURE_MODEL_CONTAINER.get(tableIdentifier.getUniqueId()) != null) {
            model = TABLE_STRUCTURE_MODEL_CONTAINER.get(tableIdentifier.getUniqueId());
        } else {
            String structureHandler = ClientTableStructure.getStructureHandler(tableIdentifier);
            if (structureHandler != null) {
                try {
                    Class<?> dynamicStructureClass = Class.forName(structureHandler);
                    model = (ClientStructureModel)dynamicStructureClass.newInstance();
                    TABLE_STRUCTURE_MODEL_CONTAINER.put(tableIdentifier.getUniqueId(), model);
                }
                catch (Exception exp) {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
            } else {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
        }
        return model.retrieveStructure(tableIdentifier);
    }

    private static JSONObject getColumnConfigurationFromCache(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        JSONObject structure = new JSONObject();
        try {
            JSONObject tableCache = ClientTableStructure.getTableDetailsFromCache(tableIdentifier);
            structure = tableCache.getJSONObject(COLUMN_PROPERTIES);
        }
        catch (JSONException exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return structure;
    }

    private static JSONObject getTableDetailsFromCache(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        JSONObject tableDetails = new JSONObject();
        if (TABLESTRUCTURE_CACHE.get(tableIdentifier.getUniqueId()) == null) {
            tableDetails = ClientTableStructure.collectEmberTableDetails(tableIdentifier);
            TABLESTRUCTURE_CACHE.put(tableIdentifier.getUniqueId(), tableDetails);
        } else {
            RWLOCK.readLock().lock();
            try {
                tableDetails = TABLESTRUCTURE_CACHE.get(tableIdentifier.getUniqueId());
            }
            finally {
                RWLOCK.readLock().unlock();
            }
        }
        return tableDetails;
    }

    private static JSONObject collectEmberTableDetails(TableUniqueIdentifier tableIdentifier) throws BaseStatusCode {
        RWLOCK.writeLock().lock();
        try {
            JSONObject jSONObject = ClientTableStructure.getBaseStructureForTable(tableIdentifier);
            return jSONObject;
        }
        catch (BaseStatusCode e) {
            throw e;
        }
        finally {
            RWLOCK.writeLock().unlock();
        }
    }

    private static void updateWindowsDependentColumns() {
        try {
            Criteria criteria1 = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"TABLEID"), (Object)1, 0);
            criteria1 = criteria1.and(new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"COLUMN_DISPLAY_TYPE"), (Object)"VISIBLE", 0));
            Criteria criteria2 = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"TABLEID"), (Object)4, 0);
            criteria2 = criteria2.and(new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"COLUMN_DISPLAY_TYPE"), (Object)"VISIBLE", 0));
            Criteria criteria3 = new Criteria(Column.getColumn((String)"ElaEmberColumnConfigurations", (String)"COLUMNNAME"), (Object)"NEXT_SCAN_TIME", 0);
            DataBaseReqestProcessor.executeUpdateQuery("ElaEmberColumnConfigurations", "COLUMN_DISPLAY_TYPE", "HIDDEN", criteria1.and(criteria3).or(criteria2.and(criteria3)), new boolean[0]);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void getLocaleTranslatedColumns(JSONObject tableStructure, Locale locale) {
        try {
            ProductBundle instance = ProductBundle.getInstance();
            if (tableStructure.has(COLUMN_DEFINITION)) {
                JSONArray coloumnList = tableStructure.getJSONArray(COLUMN_DEFINITION);
                for (int i = 0; i < coloumnList.length(); ++i) {
                    try {
                        String keyValue = coloumnList.getJSONObject(i).optString("DISPLAY_KEY", null);
                        if (keyValue == null || keyValue.trim().isEmpty()) continue;
                        String localeString = instance.getString(locale, keyValue);
                        localeString = localeString.equals(keyValue) ? "" : localeString;
                        coloumnList.getJSONObject(i).put("DISPLAY_NAME", (Object)localeString);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static {
        if (!ServerDetailsBean.getInstance().isWindows()) {
            ClientTableStructure.updateWindowsDependentColumns();
        }
    }
}

