/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.assignrule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.assign.AssignedToHandler;
import com.manageengine.ela.server.common.alerts.AlertsReport;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.sql.Connection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AssignRuleManager {
    public int getAvailableCriterias(ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        ProductBundle i18n = ProductBundle.getInstance();
        JSONObject temp = null;
        JSONObject result = new JSONObject();
        JSONArray exprOptions = new JSONArray();
        temp = new JSONObject();
        temp.put("value", (Object)i18n.getString("assignedrules.condition.or"));
        temp.put("id", 2);
        exprOptions.put((Object)temp);
        JSONArray propOptions = new JSONArray();
        temp = new JSONObject();
        temp.put("value", (Object)i18n.getString("assignedrules.option.devicename"));
        temp.put("id", (Object)"DeviceName");
        propOptions.put((Object)temp);
        temp = new JSONObject();
        temp.put("value", (Object)i18n.getString("assignedrules.option.devicegroup"));
        temp.put("id", (Object)"DeviceGroup");
        propOptions.put((Object)temp);
        temp = new JSONObject();
        temp.put("value", (Object)i18n.getString("assignedrules.option.alertprofile"));
        temp.put("id", (Object)"NOTIFID");
        propOptions.put((Object)temp);
        JSONArray operatorOptions = new JSONArray();
        temp = new JSONObject();
        temp.put("value", (Object)i18n.getString("assignedrules.condition.equals"));
        temp.put("id", 1);
        operatorOptions.put((Object)temp);
        JSONArray groupLists = this.getGroupList();
        JSONArray deviceLists = this.getDeviceList();
        JSONArray alertProfileLists = this.getAlertProfileList();
        JSONArray userList = AlertsReport.getUsersJSON();
        result.put("EXPROPTIONS", (Object)exprOptions);
        result.put("PROPOPTIONS", (Object)propOptions);
        result.put("OPERATOROPTIONS", (Object)operatorOptions);
        result.put("GROUPLISTS", (Object)groupLists);
        result.put("DEVICELISTS", (Object)deviceLists);
        result.put("ALERTPROFILELIST", (Object)alertProfileLists);
        result.put("USERLIST", (Object)userList);
        responseBuilder.setResponse(result);
        return 0;
    }

    private JSONArray getDeviceList() throws JSONException {
        JSONArray deviceLists = new JSONArray();
        try {
            DataObject doo = this.getDeviceDO();
            if (doo != null && !doo.isEmpty()) {
                Iterator it = doo.getRows("Hosts");
                Row r = null;
                JSONObject json = null;
                while (it.hasNext()) {
                    r = (Row)it.next();
                    json = new JSONObject();
                    json.put("value", (Object)((String)r.get("DISPLAY_NAME")));
                    json.put("id", (Object)((Long)r.get("HOST_ID")));
                    deviceLists.put((Object)json);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return deviceLists;
    }

    private JSONArray getAlertProfileList() throws JSONException {
        JSONArray profileList = new JSONArray();
        Table ntTable = Table.getTable((String)"NotificationType");
        Table unctTable = Table.getTable((String)"UserToNotificationType");
        SelectQueryImpl query = new SelectQueryImpl(ntTable);
        query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
        String[] ntId = new String[]{"NOTIFID"};
        query.addJoin(new Join(ntTable, unctTable, ntId, ntId, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1001L, 1);
        query.setCriteria(crit);
        try {
            DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (doo != null && !doo.isEmpty()) {
                Iterator itr = doo.getRows("NotificationType");
                JSONObject json = null;
                while (itr.hasNext()) {
                    json = new JSONObject();
                    Row r = (Row)itr.next();
                    json.put("id", (Object)((Long)r.get("NOTIFID")));
                    if (((Boolean)r.get("ISRESOLVENEEDED")).booleanValue()) {
                        json.put("value", (Object)ProductBundle.getInstance().getString((String)r.get("NOTIFNAME")));
                    } else {
                        json.put("value", (Object)((String)r.get("NOTIFNAME")));
                    }
                    profileList.put((Object)json);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return profileList;
    }

    private DataObject getDeviceDO() throws DataAccessException {
        return PersistenceDBUtil.getPersistence().get("Hosts", (Criteria)null);
    }

    private JSONArray getGroupList() throws JSONException {
        JSONArray groupLists = new JSONArray();
        try {
            DataObject doo = DeviceGroupUtil.getGroupDetailedDO();
            if (doo != null && !doo.isEmpty()) {
                Iterator it = doo.getRows("HostGroup");
                Row r = null;
                JSONObject json = null;
                while (it.hasNext()) {
                    r = (Row)it.next();
                    json = new JSONObject();
                    json.put("value", (Object)((String)r.get("NAME")));
                    json.put("id", (Object)((Long)r.get("ID")));
                    groupLists.put((Object)json);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return groupLists;
    }

    public int saveAssignRule(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        JSONArray selectedList = reqJsonObject.getJSONArray("SELECTEDLIST");
        String ruleName = reqJsonObject.getString("RULENAME");
        String description = reqJsonObject.optString("DESCRIPTION", null);
        Long assignTo = reqJsonObject.getLong("ASSIGNTO");
        if (this.checkBeforeSave(ruleName)) {
            return 7432;
        }
        int priority = this.getPriorityNumber();
        DataObject doo = PersistenceDBUtil.getPersistence().constructDataObject();
        Row r = new Row("ELA_AssignRules");
        r.set("RULE_NAME", (Object)ruleName);
        if (description != null && !description.trim().equals("")) {
            r.set("DESCRIPTION", (Object)description);
        }
        r.set("PRIORITY", (Object)priority);
        doo.addRow(r);
        doo = PersistenceDBUtil.getPersistence().add(doo);
        Long ruleid = (Long)doo.getFirstValue("ELA_AssignRules", "RULE_ID");
        this.fillDOwithCriteriaList(ruleid, doo, selectedList);
        Row row = new Row("ELA_AssignRulesToUser");
        row.set("RULE_ID", (Object)ruleid);
        row.set("USER_ID", (Object)assignTo);
        doo.addRow(row);
        PersistenceDBUtil.getPersistence().update(doo);
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    private boolean checkBeforeSave(String name) {
        boolean result = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELA_AssignRules"));
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_NAME"), (Object)name, 0));
            DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (!doo.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void fillDOwithCriteriaList(Long ruleid, DataObject doo, JSONArray selectedList) throws JSONException, DataAccessException {
        ProductBundle i18n = ProductBundle.getInstance();
        for (int i = 0; i < selectedList.length(); ++i) {
            JSONObject crit = selectedList.getJSONObject(i);
            String operator = crit.getString("OPERATOR");
            String field = crit.getString("FIELD");
            int condition = crit.getInt("CONDITION");
            String value = crit.getString("VALUE");
            Row row = null;
            if (field.equals("DeviceGroup")) {
                row = new Row("ELA_AssignRulesDeviceGroup");
                row.set("GROUP_ID", (Object)Long.valueOf(value));
            } else if (field.equals("DeviceName")) {
                row = new Row("ELA_AssignRulesDevice");
                row.set("DEVICE_ID", (Object)Long.valueOf(value));
            } else {
                row = new Row("ELA_AssignRulesCriteria");
                row.set("KEY", (Object)field);
                row.set("VALUE", (Object)value);
            }
            row.set("CONDITION", (Object)condition);
            row.set("ORDER", (Object)i);
            row.set("RULE_ID", (Object)ruleid);
            doo.addRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPriorityNumber() {
        int result = 0;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELA_AssignRules"));
            Column col = Column.getColumn((String)"ELA_AssignRules", (String)"PRIORITY").maximum();
            col.setColumnAlias("PRIORITY");
            query.addSelectColumn(col);
            Connection conn = null;
            DataSet ds = null;
            try {
                RelationalAPI relApi = RelationalAPI.getInstance();
                conn = relApi.getConnection();
                ds = relApi.executeQuery((Query)query, conn);
                if (ds.next()) {
                    result = ds.getInt("PRIORITY");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (ds != null) {
                        ds.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ++result;
    }

    public int updateAssignRule(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        Long ruleid = reqJsonObject.getLong("RULEID");
        JSONArray selectedList = reqJsonObject.getJSONArray("SELECTEDLIST");
        String ruleName = reqJsonObject.getString("RULENAME");
        String description = reqJsonObject.optString("DESCRIPTION", null);
        Long assignTo = reqJsonObject.getLong("ASSIGNTO");
        DataObject doo = this.getAssignRuleDO(ruleid);
        Row r = doo.getFirstRow("ELA_AssignRules");
        r.set("RULE_NAME", (Object)ruleName);
        if (description != null && !description.trim().equals("")) {
            r.set("DESCRIPTION", (Object)description);
        }
        doo.updateRow(r);
        try {
            r = doo.getFirstRow("ELA_AssignRulesToUser");
            r.set("USER_ID", (Object)assignTo);
            doo.updateRow(r);
        }
        catch (Exception e) {
            r = new Row("ELA_AssignRulesToUser");
            r.set("RULE_ID", (Object)ruleid);
            r.set("USER_ID", (Object)assignTo);
            doo.addRow(r);
        }
        doo.deleteRows("ELA_AssignRulesDevice", (Criteria)null);
        doo.deleteRows("ELA_AssignRulesDeviceGroup", (Criteria)null);
        doo.deleteRows("ELA_AssignRulesCriteria", (Criteria)null);
        this.fillDOwithCriteriaList(ruleid, doo, selectedList);
        PersistenceDBUtil.getPersistence().update(doo);
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    private DataObject getAssignRuleDO(Long ruleid) {
        try {
            Table table1 = Table.getTable((String)"ELA_AssignRules");
            Table table2 = Table.getTable((String)"ELA_AssignRulesDevice");
            Table table3 = Table.getTable((String)"ELA_AssignRulesDeviceGroup");
            Table table4 = Table.getTable((String)"ELA_AssignRulesCriteria");
            Table table5 = Table.getTable((String)"ELA_AssignRulesToUser");
            SelectQueryImpl query = new SelectQueryImpl(table1);
            String[] rulIdColumn = new String[]{"RULE_ID"};
            Join join1 = new Join(table1, table2, rulIdColumn, rulIdColumn, 1);
            Join join2 = new Join(table1, table3, rulIdColumn, rulIdColumn, 1);
            Join join3 = new Join(table1, table4, rulIdColumn, rulIdColumn, 1);
            Join join4 = new Join(table1, table5, rulIdColumn, rulIdColumn, 1);
            query.addJoin(join1);
            query.addJoin(join2);
            query.addJoin(join3);
            query.addJoin(join4);
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesDevice", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesDeviceGroup", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesCriteria", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ELA_AssignRulesToUser", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ELA_AssignRules", (String)"PRIORITY"), true));
            query.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"), (Object)ruleid, 0));
            return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getAssignRule(JSONObject reqJsonObject, ResponseBuilder responseBuilder) throws JSONException, DataAccessException {
        ProductBundle i18n = ProductBundle.getInstance();
        JSONObject result = new JSONObject();
        Long ruleid = reqJsonObject.getLong("RULEID");
        DataObject doo = this.getAssignRuleDO(ruleid);
        Row r = doo.getFirstRow("ELA_AssignRules");
        result.put("RULENAME", (Object)((String)r.get("RULE_NAME")));
        String description = (String)r.get("DESCRIPTION");
        if (description != null) {
            result.put("DESCRIPTION", (Object)description);
        } else {
            result.put("DESCRIPTION", (Object)"");
        }
        try {
            r = doo.getFirstRow("ELA_AssignRulesToUser");
            result.put("ASSIGNTO", (Object)((Long)r.get("USER_ID")));
        }
        catch (Exception e) {
            result.put("ASSIGNTO", -1L);
        }
        JSONArray selectedList = new JSONArray();
        JSONObject crit = null;
        Iterator it = doo.getRows("ELA_AssignRulesDeviceGroup");
        while (it.hasNext()) {
            r = (Row)it.next();
            crit = new JSONObject();
            crit.put("CONDITION", (Object)((Integer)r.get("CONDITION")));
            crit.put("FIELD", (Object)"DeviceGroup");
            crit.put("VALUE", (Object)((Long)r.get("GROUP_ID")));
            selectedList.put((Object)crit);
        }
        it = doo.getRows("ELA_AssignRulesDevice");
        while (it.hasNext()) {
            r = (Row)it.next();
            crit = new JSONObject();
            crit.put("CONDITION", (Object)((Integer)r.get("CONDITION")));
            crit.put("FIELD", (Object)"DeviceName");
            crit.put("VALUE", (Object)((Long)r.get("DEVICE_ID")));
            selectedList.put((Object)crit);
        }
        it = doo.getRows("ELA_AssignRulesCriteria");
        while (it.hasNext()) {
            r = (Row)it.next();
            crit = new JSONObject();
            crit.put("CONDITION", (Object)((Integer)r.get("CONDITION")));
            crit.put("FIELD", (Object)((String)r.get("KEY")));
            crit.put("VALUE", (Object)((String)r.get("VALUE")));
            selectedList.put((Object)crit);
        }
        result.put("SELECTEDLIST", (Object)selectedList);
        responseBuilder.setResponse(result);
        return 0;
    }

    public int enableAssignRule(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        JSONArray json = reqJsonObject.getJSONArray("LIST");
        String[] arr = new String[json.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = json.optString(i);
        }
        UpdateQueryImpl updateQueryImpl = new UpdateQueryImpl("ELA_AssignRules");
        updateQueryImpl.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"), (Object)arr, 8));
        updateQueryImpl.setUpdateColumn("ENABLE", (Object)true);
        PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQueryImpl);
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    public int disableAssignRule(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        JSONArray json = reqJsonObject.getJSONArray("LIST");
        String[] arr = new String[json.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = json.optString(i);
        }
        UpdateQueryImpl updateQueryImpl = new UpdateQueryImpl("ELA_AssignRules");
        updateQueryImpl.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"), (Object)arr, 8));
        updateQueryImpl.setUpdateColumn("ENABLE", (Object)false);
        PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQueryImpl);
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    public int deleteAssignRule(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        JSONArray json = reqJsonObject.getJSONArray("LIST");
        String[] arr = new String[json.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = json.optString(i);
        }
        DeleteQueryImpl deleteQuery = new DeleteQueryImpl("ELA_AssignRules");
        deleteQuery.setCriteria(new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"), (Object)arr, 8));
        PersistenceDBUtil.getPersistence().delete((DeleteQuery)deleteQuery);
        this.reOrderRules();
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    private void reOrderRules() throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELA_AssignRules"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ELA_AssignRules", (String)"PRIORITY"), true));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"*"));
        DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        Iterator it = doo.getRows("ELA_AssignRules");
        int i = 1;
        while (it.hasNext()) {
            Row r = (Row)it.next();
            r.set("PRIORITY", (Object)i);
            doo.updateRow(r);
            ++i;
        }
        PersistenceDBUtil.getPersistence().update(doo);
    }

    public int orderChange(JSONObject reqJsonObject) throws JSONException, DataAccessException {
        JSONArray json = reqJsonObject.getJSONArray("LIST");
        DataObject doo = PersistenceDBUtil.getPersistence().get("ELA_AssignRules", (Criteria)null);
        Row r = null;
        for (int i = 0; i < json.length(); ++i) {
            r = doo.getRow("ELA_AssignRules", new Criteria(Column.getColumn((String)"ELA_AssignRules", (String)"RULE_ID"), (Object)json.getLong(i), 0));
            r.set("PRIORITY", (Object)(i + 1));
            doo.updateRow(r);
        }
        PersistenceDBUtil.getPersistence().update(doo);
        AssignedToHandler.getInstance().refreshAllProfiles();
        return 0;
    }

    public int getOrder(ResponseBuilder responseBuilder) throws DataAccessException, JSONException {
        JSONArray result = new JSONArray();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELA_AssignRules"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ELA_AssignRules", (String)"PRIORITY"), true));
        query.addSelectColumn(Column.getColumn((String)"ELA_AssignRules", (String)"*"));
        DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        Iterator it = doo.getRows("ELA_AssignRules");
        JSONObject json = null;
        while (it.hasNext()) {
            Row r = (Row)it.next();
            json = new JSONObject();
            json.put("value", (Object)((String)r.get("RULE_NAME")));
            json.put("id", (Object)((Long)r.get("RULE_ID")));
            result.put((Object)json);
        }
        responseBuilder.setResponse(result);
        return 0;
    }
}

