/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.ports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.logcollector.LogCollectorProcess;
import com.adventnet.sa.server.logcollector.LogCollectorStatus;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.config.ports.PortPair;
import com.manageengine.ela.server.common.network.status.DeviceStatusValidator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ManageSyslogListenerPort {
    private static final Logger LOGGER = Logger.getLogger(ManageSyslogListenerPort.class.getName());
    private static PortPair defaultPorts = null;
    private static int max_syslog_ports = 6;

    public static boolean isValidPort(int port) {
        return port > 1 && port < 65535;
    }

    public static boolean checkPort(String protocol, int port) {
        if (protocol.equalsIgnoreCase("TCP") || protocol.equalsIgnoreCase("TLS")) {
            return DeviceStatusValidator.checkTCPPortStatus(port);
        }
        return DeviceStatusValidator.checkUDPPortStatus(port);
    }

    private static boolean isPortCountExceeded(String protocol) {
        Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PROTOCOL"), (Object)protocol, 0);
        int portCount = DBUtil.getCountInt("SysLogListenerPorts", criteria);
        return portCount >= max_syslog_ports;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkAndAddSyslogListenerPort(JSONObject reqJsonObject) throws BaseStatusCode {
        try {
            int port = reqJsonObject.getInt("PORT");
            String protocol = reqJsonObject.getString("PROTOCOL");
            if (!ManageSyslogListenerPort.isValidPort(port)) throw BaseStatusCode.getBaseStatusCode(7955);
            DataObject portDO = ManageSyslogListenerPort.getDOByCoreProtocol(protocol);
            if (!ManageSyslogListenerPort.isPortAlreadyConfigured(portDO, port)) {
                if (ManageSyslogListenerPort.isPortCountExceeded(protocol)) {
                    throw BaseStatusCode.getBaseStatusCode(7956);
                }
                if (!ManageSyslogListenerPort.checkPort(protocol, port)) {
                    throw BaseStatusCode.getBaseStatusCode(7954);
                }
            } else {
                LOGGER.log(Level.INFO, "Skipping syslog listener port as it is already configured, Protocol : " + protocol + " ;Port : " + port);
                throw BaseStatusCode.getBaseStatusCode(7957);
            }
            ManageSyslogListenerPort.addPortProtocolPair(portDO, protocol, port);
            LOGGER.log(Level.INFO, "Syslog listener port added, Protocol : " + protocol + " ;Port : " + port);
            ManageSyslogListenerPort.deferredRestartLogcollector();
            return true;
        }
        catch (BaseStatusCode e) {
            throw e;
        }
        catch (Exception e) {
            StackTraceElement[] elements = e.getStackTrace();
            String error = e.getMessage() + " " + elements[0] + "..." + elements[elements.length - 1];
            LOGGER.log(Level.FINE, "Exception while adding a port" + error);
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
    }

    public static boolean checkAndAddSyslogListenerPort(String protocol, String port) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("PROTOCOL", (Object)protocol);
            jsonObject.put("PORT", (Object)port);
            ManageSyslogListenerPort.checkAndAddSyslogListenerPort(jsonObject);
            return true;
        }
        catch (Exception e) {
            StackTraceElement[] elements = e.getStackTrace();
            String error = e.getMessage() + " " + elements[0] + "..." + elements[elements.length - 1];
            LOGGER.log(Level.FINE, "Exception while adding a port" + error);
            return false;
        }
    }

    public static boolean deleteSyslogListenerPort(JSONObject reqJsonObject) throws BaseStatusCode {
        try {
            JSONArray ids = reqJsonObject.getJSONArray("ID");
            if (ids != null && ids.length() > 0) {
                Long[] portIDs = new Long[ids.length()];
                for (int index = 0; index < ids.length(); ++index) {
                    portIDs[index] = ids.getLong(index);
                }
                Criteria basecriteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"ID"), (Object)portIDs, 8);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"SysLogListenerPorts"));
                DataObject dataObject = PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", basecriteria);
                int totalRows = dataObject.size("SysLogListenerPorts");
                totalRows = totalRows == -1 ? 0 : totalRows;
                Criteria validcriteria = basecriteria.and(Column.getColumn((String)"SysLogListenerPorts", (String)"ISDEFAULT"), (Object)false, 0);
                query = new SelectQueryImpl(Table.getTable((String)"SysLogListenerPorts"));
                dataObject = PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", validcriteria);
                int validRows = dataObject.size("SysLogListenerPorts");
                validRows = validRows == -1 ? 0 : validRows;
                Criteria disabledcriteria = validcriteria.and(Column.getColumn((String)"SysLogListenerPorts", (String)"ENABLED"), (Object)false, 0);
                query = new SelectQueryImpl(Table.getTable((String)"SysLogListenerPorts"));
                dataObject = PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", disabledcriteria);
                int disabledRows = dataObject.size("SysLogListenerPorts");
                disabledRows = disabledRows == -1 ? 0 : disabledRows;
                PersistenceDBUtil.getPersistence().delete(validcriteria);
                LOGGER.log(Level.INFO, "Syslog Listener port removed, ID : " + portIDs.toString());
                if (validRows == 0) {
                    throw BaseStatusCode.getBaseStatusCode(7961);
                }
                if (totalRows > validRows) {
                    ManageSyslogListenerPort.deferredRestartLogcollector();
                    throw BaseStatusCode.getBaseStatusCode(7962);
                }
                if (validRows == disabledRows) {
                    return false;
                }
                ManageSyslogListenerPort.deferredRestartLogcollector();
                return true;
            }
        }
        catch (BaseStatusCode e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean setSyslogListenerPortStatus(JSONObject reqJsonObject, boolean enable) {
        try {
            Long[] portIDs = ManageSyslogListenerPort.getPortIds(reqJsonObject.getJSONArray("ID"));
            if (portIDs != null) {
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("SysLogListenerPorts");
                Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"ID"), (Object)portIDs, 8);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn("ENABLED", (Object)enable);
                PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
                LOGGER.log(Level.INFO, "Syslog Listener port status enabled : " + enable + "ID : " + portIDs.toString());
                ManageSyslogListenerPort.deferredRestartLogcollector();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean setSyslogListenerPortStatus(String protocol, int port, boolean enable) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PROTOCOL"), (Object)protocol, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PORT"), (Object)port, 0));
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("SysLogListenerPorts");
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn("ENABLED", (Object)enable);
            PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
            LOGGER.log(Level.INFO, "Syslog Listener port status enabled : " + enable + "Protocol : " + protocol + " Port : " + port);
            ManageSyslogListenerPort.deferredRestartLogcollector();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isEnabledPort(String protocol, int port) {
        boolean enabled = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PROTOCOL"), (Object)protocol, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PORT"), (Object)port, 0));
            DataObject doo = DataAccess.get((String)"SysLogListenerPorts", (Criteria)criteria);
            Row confRow = doo.getFirstRow("SysLogListenerPorts");
            if (confRow != null) {
                enabled = (Boolean)confRow.get("ENABLED");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enabled;
    }

    public static boolean isDefaultPort(long id) {
        try {
            DataObject defaultPort = ManageSyslogListenerPort.getDOByID(id);
            return (Boolean)defaultPort.getFirstRow("SysLogListenerPorts").get("ISDEFAULT") == true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isPortAlreadyConfigured(DataObject portDO, int port) throws Exception {
        Iterator itr = portDO.getRows("SysLogListenerPorts");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Integer rowPort = (Integer)row.get("PORT");
            if (rowPort != port) continue;
            return true;
        }
        return false;
    }

    private static void addPortProtocolPair(DataObject portDO, String protocol, int port) throws Exception {
        Row row = new Row("SysLogListenerPorts");
        row.set("PORT", (Object)port);
        row.set("PROTOCOL", (Object)protocol);
        row.set("STATUS", (Object)0);
        portDO.addRow(row);
        PersistenceDBUtil.getPersistence().update(portDO);
    }

    private static DataObject getDOByCoreProtocol(String protocol) throws Exception {
        Criteria criteria = null;
        if (protocol.equalsIgnoreCase("TCP") || protocol.equalsIgnoreCase("TLS")) {
            String[] protocols = new String[]{"TCP", "TLS"};
            criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PROTOCOL"), (Object)protocols, 8);
        } else {
            criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"PROTOCOL"), (Object)protocol, 0);
        }
        return PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", criteria);
    }

    private static DataObject getDOByID(Long id) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"ID"), (Object)id, 0);
        return PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", criteria);
    }

    public static PortPair getDefaultPortPair() {
        if (defaultPorts == null) {
            int port = 514;
            String protocol = "UDP";
            try {
                Criteria criteria = new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"ENABLED"), (Object)true, 0);
                DataObject defaultDO = PersistenceDBUtil.getPersistence().get("SysLogListenerPorts", criteria);
                Row row = defaultDO.getFirstRow("SysLogListenerPorts");
                if (row != null) {
                    port = (Integer)row.get("PORT");
                    protocol = (String)row.get("PROTOCOL");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            defaultPorts = new PortPair(port, protocol);
        }
        return defaultPorts;
    }

    public static void resetPortStatus() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SysLogListenerPorts"));
            query.addSelectColumn(new Column("SysLogListenerPorts", "*"));
            DataObject updateDo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator itr = updateDo.getRows("SysLogListenerPorts");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                row.set("STATUS", (Object)0);
                updateDo.updateRow(row);
            }
            PersistenceDBUtil.getPersistence().update(updateDo);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.WARNING, "Reset port failed. " + e.getMessage());
        }
    }

    private static Long[] getPortIds(JSONArray ids) {
        try {
            if (ids != null && ids.length() > 0) {
                Long[] portIDs = new Long[ids.length()];
                for (int index = 0; index < ids.length(); ++index) {
                    portIDs[index] = ids.getLong(index);
                }
                return portIDs;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static JSONArray getAllPorts() {
        JSONArray ports = new JSONArray();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SysLogListenerPorts"));
            query.addSelectColumn(Column.getColumn((String)"SysLogListenerPorts", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"SysLogListenerPorts", (String)"ENABLED"), (Object)true, 0));
            DataObject updateDo = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator itr = updateDo.getRows("SysLogListenerPorts");
            while (itr.hasNext()) {
                JSONObject jPort = new JSONObject();
                Row row = (Row)itr.next();
                jPort.put("PORT", (Object)((Integer)row.get("PORT")));
                jPort.put("PROTOCOL", row.get("PROTOCOL"));
                jPort.put("STATUS", (Object)((Long)row.get("STATUS")));
                ports.put((Object)jPort);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Get all ports failed. " + e.getMessage());
        }
        return ports;
    }

    private static void deferredRestartLogcollector() {
        try {
            LogCollectorProcess.getInstance().restart(LogCollectorStatus.RESTART_SYSPORTMANAGEMENT);
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Reset log collector failed" + e.getMessage());
        }
    }
}

