/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.servicedesk;

import com.manageengine.ela.server.common.config.servicedesk.HttpPostQueue;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpPost;

public class HttpPostHandler {
    private static final Logger LOGGER = Logger.getLogger(HttpPostHandler.class.getName());
    private ConcurrentQueue<HttpPost> queue = new CommonQueueImpl<HttpPost>(new LinkedBlockingDeque());
    private static final int MAX_THREADS = 2;
    private static HttpPostHandler instance = null;
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final int MAX_PRINT_COUNT = 1000;
    private int dropPrintCount = 1;
    private int drop = 0;
    private int totaldrop = 0;

    public HttpPostHandler() {
        HttpPostQueue processor = new HttpPostQueue(this.queue);
        for (int threads = 0; threads < 2; ++threads) {
            Thread thread = processor.start();
            thread.setName("HttpPostQueue-" + threads);
        }
    }

    public static HttpPostHandler getInstance() {
        if (instance == null) {
            instance = new HttpPostHandler();
        }
        return instance;
    }

    public void add(HttpPost method) {
        try {
            if (this.queue.size() < 1000) {
                LOGGER.fine("Adding to Queue. Queue Size : " + this.queue.size());
                this.queue.add(method);
            } else {
                ++this.totaldrop;
                ++this.drop;
                if (this.drop >= this.dropPrintCount) {
                    LOGGER.info(this.drop + " Alerts are skipped for HttpPost Processing. Total Drop : " + this.totaldrop);
                    this.drop = 0;
                    if (this.dropPrintCount < 1000) {
                        this.dropPrintCount *= 2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

