/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.servicedesk;

import com.manageengine.ela.server.common.config.servicedesk.ConcurrentHttpClient;
import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpPostQueue
extends CommonQueueProcessor<HttpPost> {
    private static final Logger LOGGER = Logger.getLogger(HttpPostQueue.class.getName());
    private CloseableHttpClient httpClient = ConcurrentHttpClient.getHttpClient();
    private int failcount = 0;

    public HttpPostQueue(ConcurrentQueue<HttpPost> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    public void process(HttpPost data) {
        try {
            if (this.failcount > 3) {
                Thread.sleep(5000L);
                this.failcount = 0;
            }
            this.processPost(data);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Unable to process request : " + exp.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPost(HttpPost data) throws ClientProtocolException, IOException {
        try (CloseableHttpResponse response = null;){
            response = this.httpClient.execute((HttpUriRequest)data);
            int statuscode = response.getStatusLine().getStatusCode();
            if (statuscode != 201 && statuscode != 200) {
                ++this.failcount;
                LOGGER.info("HttpPost Failed : Response : " + response.getStatusLine().getReasonPhrase() + " ResponseCode :" + statuscode);
            } else {
                this.failcount = 0;
                LOGGER.fine("Response" + response.getStatusLine().getReasonPhrase());
            }
        }
    }
}

