/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.technician;

import com.adventnet.authentication.PasswordException;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.enterprise.AdminServerUtil;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.lc.FieldRepository;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.audit.AuditEntry;
import com.manageengine.ela.server.common.config.technician.TechnicianDiscoveryListner;
import com.manageengine.ela.server.common.config.technician.TechnicianProperties;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.delegation.DelegationRoleContainer;
import com.manageengine.ela.server.common.delegation.config.DynamicResourceDetails;
import com.manageengine.ela.server.common.delegation.config.ELADynamicResourceHandler;
import com.manageengine.ela.server.common.delegation.config.ELAStaticResourceHandler;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.domain.ScheduledDiscoveryHandler;
import com.manageengine.ela.server.common.discovery.windows.domain.ScheduledDiscoveryParams;
import com.manageengine.ela.server.common.discovery.windows.ldap.ADQueryBase;
import com.manageengine.ela.server.common.discovery.windows.ldap.BasicLdapQuery;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.ad.CommonObjectImport;
import com.manageengine.ela.server.common.schedule.config.ELABaseScheduleImpl;
import com.manageengine.ela.server.common.schedule.config.PeriodicScheduleImpl;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.common.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AddOrUpdateTechnician {
    private static final String DEFAULT_PROFILE = "Profile 2";
    private static final String DEFAULT_SERVICE = "System";

    public static boolean addNewTechnician(TechnicianProperties userProperties) throws BaseStatusCode {
        if (userProperties.getDomainName() == null || userProperties.getTechnicianName() == null || userProperties.getPassword() == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        if (TechnicianUtil.isTechnicianExists(userProperties.getTechnicianName(), userProperties.getDomainName())) {
            throw BaseStatusCode.getBaseStatusCode(7432);
        }
        try {
            Long profileID = AuthUtil.getPasswordProfileId((String)DEFAULT_PROFILE);
            Long ServiceID = AuthUtil.getServiceId((String)DEFAULT_SERVICE);
            DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
            Row row = new Row("AaaUser");
            row.set("FIRST_NAME", (Object)userProperties.getTechnicianType().getRoleString());
            dobj.addRow(row);
            Object userId = row.get("USER_ID");
            row = new Row("AaaLogin");
            row.set("NAME", (Object)userProperties.getTechnicianName().toLowerCase());
            row.set("DOMAINNAME", (Object)userProperties.getDomainName());
            dobj.addRow(row);
            row = new Row("AaaAccount");
            row.set("SERVICE_ID", (Object)ServiceID);
            row.set("ACCOUNTPROFILE_ID", (Object)profileID);
            dobj.addRow(row);
            row = new Row("AaaPassword");
            row.set("PASSWORD", (Object)userProperties.getPassword());
            row.set("PASSWDPROFILE_ID", (Object)profileID);
            dobj.addRow(row);
            row = new Row("AaaAccPassword");
            row.set("ACCOUNT_ID", dobj.getFirstRow("AaaAccount").get("ACCOUNT_ID"));
            row.set("PASSWORD_ID", dobj.getFirstRow("AaaPassword").get("PASSWORD_ID"));
            dobj.addRow(row);
            row = new Row("AaaAccOwnerProfile");
            row.set("ACCOUNT_ID", dobj.getFirstRow("AaaAccount").get("ACCOUNT_ID"));
            row.set("ALLOWED_SUBACCOUNT", (Object)-1);
            dobj.addRow(row);
            row = new Row("AaaContactInfo");
            row.set("EMAILID", (Object)userProperties.getTechnicianEmail());
            dobj.addRow(row);
            row = new Row("AaaUserContactInfo");
            row.set("USER_ID", userId);
            row.set("CONTACTINFO_ID", dobj.getFirstRow("AaaContactInfo").get("CONTACTINFO_ID"));
            dobj.addRow(row);
            try {
                boolean isAdminServerAndAdminUser;
                Row personalDetails = new Row("EventlogUsersPersonal");
                personalDetails.set("LOGIN_ID", dobj.getFirstRow("AaaLogin").get("LOGIN_ID"));
                personalDetails.set("LOCALE_ID", (Object)ResourceBundleMgr.getInstance().getUserLocaleID(Long.valueOf(TechnicianUtil.getDefaultAdminUserID())));
                dobj.addRow(personalDetails);
                DynamicResourceDetails dynamicResource = AddOrUpdateTechnician.getDynamicResourceDetails(userProperties);
                ELADynamicResourceHandler.includeViewConfigurations(dobj, dynamicResource, userId);
                ELAStaticResourceHandler.includeSuperAdminRoleConfigurtion(dobj, userId);
                boolean isAdminUser = userProperties.getTechnicianType() == DelegationRoleContainer.UserRole.ADMIN;
                boolean bl = isAdminServerAndAdminUser = isAdminUser && "true".equals(System.getProperty("isAdminServer"));
                if (isAdminServerAndAdminUser) {
                    HashMap collectorIds = AdminServerUtil.getInstance().getCollectorIdToDisplayNameMap();
                    for (Map.Entry entry : collectorIds.entrySet()) {
                        Row userResourceViewRow = new Row("UserResourceView");
                        userResourceViewRow.set("USER_ID", userId);
                        userResourceViewRow.set("VIEW_NAME", (Object)"All Devices");
                        userResourceViewRow.set("VIEW_RESOURCE", (Object)"1=1");
                        dobj.addRow(userResourceViewRow);
                        Object viewId = userResourceViewRow.get("VIEW_ID");
                        userResourceViewRow.set("DEFAULT_VIEWID", viewId);
                        Row collectorToURVMappingRow = new Row("CollectorToURVMapping");
                        collectorToURVMappingRow.set("CID", entry.getKey());
                        collectorToURVMappingRow.set("VIEW_ID", viewId);
                        collectorToURVMappingRow.set("DISPLAYNAME", (Object)((String)entry.getValue() + "_DV"));
                        dobj.addRow(collectorToURVMappingRow);
                    }
                } else {
                    row = new Row("UserResourceView");
                    row.set("USER_ID", userId);
                    row.set("VIEW_NAME", (Object)"All Devices");
                    dobj.addRow(row);
                    row.set("DEFAULT_VIEWID", dobj.getFirstRow("UserResourceView").get("VIEW_ID"));
                    if (isAdminUser) {
                        row.set("VIEW_RESOURCE", (Object)"1=1");
                    } else {
                        row.set("VIEW_RESOURCE", (Object)StringUtil.arrayToString(userProperties.getGroupIDList()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            row = new Row("AaaAuthorizedRole");
            try {
                row.set("ACCOUNT_ID", dobj.getFirstRow("AaaAccount").get("ACCOUNT_ID"));
                row.set("ROLE_ID", (Object)AuthUtil.getRoleId((String)userProperties.getTechnicianType().getRoleString()));
                dobj.addRow(row);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dobj = AuthUtil.createUserAccount((DataObject)dobj);
            userProperties.setUserID((Long)dobj.getFirstValue("AaaUser", "USER_ID"));
            TechnicianUtil.commitAuditEntry(userProperties, AuditEntry.ActionType.ADDED);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static DynamicResourceDetails getDynamicResourceDetails(TechnicianProperties userProperties) {
        DynamicResourceDetails dynamicResource = new DynamicResourceDetails();
        dynamicResource.setViewName("All Devices");
        dynamicResource.setDefault(true);
        dynamicResource.setSystemGenerated(true);
        dynamicResource.setEditable(false);
        if (userProperties.getTechnicianType() == DelegationRoleContainer.UserRole.ADMIN) {
            dynamicResource.setFullAccess(true);
        } else {
            dynamicResource.setGroupIds(Arrays.asList(userProperties.getGroupIDList()));
            dynamicResource.setFullAccess(false);
        }
        return dynamicResource;
    }

    public static boolean updateStatus(Long[] userIdList, boolean status, Long currentLoginID) {
        try {
            if (status) {
                TechnicianUtil.enableUsers(userIdList);
            } else {
                TechnicianUtil.disableUsers(userIdList, currentLoginID);
            }
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean updateTechnician(TechnicianProperties userProperties, DelegationRoleContainer.UserRole currentUserRole, Long userID, boolean isLimitedAccess) throws BaseStatusCode {
        try {
            boolean isAllowed;
            block17: {
                boolean bl = isAllowed = TechnicianUtil.isAllowedRoleUpdateOrDelete(userID, userProperties.getUserID()) && !isLimitedAccess;
                if (userProperties.getPassword() != null) {
                    try {
                        if (currentUserRole == DelegationRoleContainer.UserRole.ADMIN && userProperties.getOldPassword() == null) {
                            AuthUtil.changePasswordForUser((String)userProperties.getTechnicianName(), (String)DEFAULT_SERVICE, null, (String)userProperties.getPassword(), (String)userProperties.getDomainName());
                            break block17;
                        }
                        if (userProperties.getOldPassword() != null) {
                            AuthUtil.changePasswordForUser((String)userProperties.getTechnicianName(), (String)DEFAULT_SERVICE, (String)userProperties.getOldPassword(), (String)userProperties.getPassword(), (String)userProperties.getDomainName());
                            break block17;
                        }
                        throw BaseStatusCode.getBaseStatusCode(7428);
                    }
                    catch (PasswordException exp) {
                        throw BaseStatusCode.getBaseStatusCode(7176);
                    }
                }
            }
            if (userProperties.getTechnicianEmail() != null || userProperties.getTechnicianType() != null || userProperties.getGroupIDList() != null) {
                DataObject dobj = TechnicianUtil.getTechinicianDetailsDO(userProperties.getUserID());
                Row row = dobj.getFirstRow("AaaRole");
                DelegationRoleContainer.UserRole oldTechnicianType = DelegationRoleContainer.UserRole.getRole((String)row.get("NAME"));
                if (userProperties.getTechnicianEmail() != null) {
                    Row contactRow = dobj.getFirstRow("AaaContactInfo");
                    contactRow.set("EMAILID", (Object)userProperties.getTechnicianEmail());
                    dobj.updateRow(contactRow);
                }
                if (isAllowed && userProperties.getTechnicianType() != null && oldTechnicianType != userProperties.getTechnicianType()) {
                    Row userRow = dobj.getFirstRow("AaaUser");
                    userRow.set("FIRST_NAME", (Object)userProperties.getTechnicianType().getRoleString());
                    dobj.updateRow(userRow);
                    Row authorizedRole = dobj.getFirstRow("AaaAuthorizedRole");
                    authorizedRole.set("ROLE_ID", (Object)AuthUtil.getRoleId((String)userProperties.getTechnicianType().getRoleString()));
                    if (userProperties.getTechnicianType() == DelegationRoleContainer.UserRole.ADMIN) {
                        TechnicianUtil.changeDynamicResourceToAdminAccess(userProperties);
                    } else if (oldTechnicianType == DelegationRoleContainer.UserRole.ADMIN) {
                        TechnicianUtil.changeDynamicResourceToOperatorAccess(userProperties);
                    } else {
                        TechnicianUtil.handleDeviceGroupUpdate(userProperties);
                    }
                    UserAccessResource.removeUserCache(userProperties.getUserID());
                    dobj.updateRow(authorizedRole);
                } else if (isAllowed && userProperties.getGroupIDList() != null) {
                    TechnicianUtil.handleDeviceGroupUpdate(userProperties);
                    UserAccessResource.removeUserCache(userProperties.getUserID());
                }
                PersistenceDBUtil.getPersistence().update(dobj);
            }
            TechnicianUtil.commitAuditEntry(userProperties, AuditEntry.ActionType.MODIFIED);
            return true;
        }
        catch (BaseStatusCode statusCode) {
            throw statusCode;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean delete(Long[] longArray, Long currentUserID) throws BaseStatusCode {
        if (!TechnicianUtil.isAllowedRoleUpdateOrDelete(currentUserID, longArray)) {
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        try {
            AuditEntry auditEntry = TechnicianUtil.getAuditEntry(longArray, AuditEntry.ActionType.DELETED);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ReportConfig"));
            String[] profileName = new String[]{"PROFILENAME"};
            String[] rbbgName = new String[]{"RBBGNAME"};
            String[] reportType = new String[]{"SYSLOG", "APPLICATION", "SYSLOG-RS"};
            sq.addJoin(new Join(Table.getTable((String)"ReportConfig"), Table.getTable((String)"ReportBuildingBlockGroup"), profileName, rbbgName, 2));
            sq.setCriteria(new Criteria(Column.getColumn((String)"ReportConfig", (String)"USERID"), (Object)longArray, 8).and(new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTTYPE"), (Object)reportType, 8)));
            sq.addSelectColumn(new Column("ReportBuildingBlockGroup", "*"));
            DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)sq);
            Iterator itr = doo.getRows("ReportBuildingBlockGroup");
            while (itr.hasNext()) {
                PersistenceDBUtil.getPersistence().delete((Row)itr.next());
            }
            PersistenceDBUtil.getPersistence().delete(new Criteria(new Column("LoginToDomainMapping", "LOGINID"), (Object)longArray, 8));
            PersistenceDBUtil.getPersistence().delete(new Criteria(new Column("AaaUser", "USER_ID"), (Object)longArray, 8));
            for (Long id : longArray) {
                UserAccessResource.removeUserCache(id);
            }
            FieldRepository.deleteMapValues(longArray);
            auditEntry.commitEntry();
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean addGroupUsers(Long domainId, JSONArray groupDNs, TechnicianProperties commonProperties) throws Exception {
        return AddOrUpdateTechnician.discoverAndAddTechnicians(domainId, groupDNs, null, commonProperties);
    }

    public static boolean addOUusers(Long domainId, JSONArray ouDNs, TechnicianProperties commonProperties) {
        boolean status = true;
        for (int index = 0; index < ouDNs.length(); ++index) {
            try {
                AddOrUpdateTechnician.discoverAndAddTechnicians(domainId, null, ouDNs.getString(index), commonProperties);
                continue;
            }
            catch (Exception exp) {
                status = false;
                exp.printStackTrace();
            }
        }
        return status;
    }

    private static boolean discoverAndAddTechnicians(Long domainID, JSONArray groupDNs, String baseContext, TechnicianProperties commonProperties) throws Exception {
        JSONObject domainDetails = ADSDomainHandler.getDomainDetailsFromID((Long)domainID);
        DiscoveryParameters parameters = DiscoveryHandler.getCommonDomainDiscoveryParams(domainDetails, false, 201);
        parameters.setConfigureDefaultFileDump(false);
        parameters.setListner(new TechnicianDiscoveryListner(domainDetails, commonProperties, null));
        BasicLdapQuery userQuery = parameters.getLdapQuery();
        if (groupDNs != null) {
            JSONArray domainGroups = TechnicianUtil.getGroupPrimaryTokens(JSONUtil.toStringArray(groupDNs));
            userQuery.andQuery(ADQueryBase.getLDAPwithGroupCriteria(domainGroups));
        }
        userQuery.setBaseContext(baseContext);
        parameters.setLdapQuery(userQuery);
        DiscoveryHandler.startWindowsCustomDiscovery(parameters, false);
        return true;
    }

    public static void configureScheduledDiscovery(JSONObject reqJsonObject) throws Exception {
        Long domainID = reqJsonObject.getLong("DOMAIN_ID");
        String scheduleName = reqJsonObject.getString("SCHEDULE_NAME");
        Integer noOfDays = reqJsonObject.getInt("NUMBER_OF_DAYS");
        JSONObject inbuiltCriteria = reqJsonObject.getJSONObject("INBUILT_CRITERIA");
        ScheduledDiscoveryParams params = new ScheduledDiscoveryParams(domainID);
        params.setAdditionalInput(reqJsonObject.getJSONObject("TECHNICIAN_PROPERTIES"));
        params.setInbuiltCriteria(inbuiltCriteria);
        params.setDiscoveryListner(TechnicianDiscoveryListner.class.getCanonicalName());
        params.setImdteCall(reqJsonObject.optBoolean("EXECUTE_IMMEDIATELY", false));
        PeriodicScheduleImpl periodicSchedule = new PeriodicScheduleImpl(scheduleName, CommonObjectImport.class.getCanonicalName());
        periodicSchedule.setUnitsOfTime(ELABaseScheduleImpl.UnitofTime.HOURS);
        if (noOfDays <= 0) {
            noOfDays = 1;
        }
        periodicSchedule.setTimePeriod((long)noOfDays.intValue() * 24L);
        params.setScheduleInfo(periodicSchedule);
        ScheduledDiscoveryHandler.createScheduledDiscovery(params);
    }
}

