/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.technician;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.config.technician.AddOrUpdateTechnician;
import com.manageengine.ela.server.common.config.technician.TechnicianProperties;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.discovery.listner.ScheduleObjectDiscoveryListener;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TechnicianDiscoveryListner
implements ScheduleObjectDiscoveryListener {
    private static final Logger LOGGER = Logger.getLogger(TechnicianDiscoveryListner.class.getName());
    private TechnicianProperties commonProperties = null;
    private JSONObject domainDetails = null;
    private Row historyInfo = null;
    private DataObject domainUserStatusDO = null;

    public TechnicianDiscoveryListner(JSONObject domainDetails, JSONObject additionalInput, Row historyInfo) throws JSONException {
        this.domainDetails = domainDetails;
        this.historyInfo = historyInfo;
        if (additionalInput != null) {
            this.commonProperties = TechnicianProperties.getUserProperties(additionalInput, false);
        }
    }

    public TechnicianDiscoveryListner(JSONObject domainDetails, TechnicianProperties commonProperties, Row historyInfo) {
        this.domainDetails = domainDetails;
        this.commonProperties = commonProperties;
        this.historyInfo = historyInfo;
    }

    public void addRow(Properties adProperties) {
        Object samAcntName = adProperties.get("sAMAccountName");
        Object mailid = adProperties.get("mail");
        if (samAcntName != null) {
            String sAMAccountName = this.getOriginalString(samAcntName);
            String mail = this.getOriginalString(mailid);
            this.checkAndConfigureTechnician(sAMAccountName, mail);
        } else {
            LOGGER.info("Invalid object retured or mandatory attribute missing");
        }
    }

    private void checkAndConfigureTechnician(String name, String mail) {
        try {
            String domain = this.domainDetails.getString("DOMAIN_FLAT_NAME");
            if (!TechnicianUtil.isTechnicianExists(name, domain)) {
                if (this.commonProperties != null) {
                    this.commonProperties.setDomainName(this.domainDetails.getString("DOMAIN_FLAT_NAME"));
                    this.commonProperties.setTechnicianName(name);
                    this.commonProperties.setTechnicianEmail(mail);
                    this.commonProperties.setPassword("Firewall12");
                    AddOrUpdateTechnician.addNewTechnician(this.commonProperties);
                    this.registerImportedTechnicianInfo(this.commonProperties);
                }
            } else {
                TechnicianUtil.enablePresentUserInDO(name, this.domainUserStatusDO);
                LOGGER.log(Level.FINE, "Technician already exists {0}", name);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception occurred while processing techician {0}", name);
        }
    }

    private String getOriginalString(Object originalValue) {
        if (originalValue == null) {
            return null;
        }
        if (originalValue instanceof List) {
            return ((List)originalValue).get(0).toString();
        }
        return originalValue.toString();
    }

    public boolean isCompleted() {
        return false;
    }

    private void registerImportedTechnicianInfo(TechnicianProperties commonProperties) {
        try {
            if (this.historyInfo != null) {
                DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
                Row row = new Row("ELAUserScheduleImportHistory");
                row.set("SCHEDULE_HISTORY_ID", this.historyInfo.get("SCHEDULE_HISTORY_ID"));
                row.set("USER_ID", (Object)commonProperties.getUserID());
                dobj.addRow(row);
                PersistenceDBUtil.getPersistence().add(dobj);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception occurred while adding techician import history {0}", exp);
        }
    }

    @Override
    public void preDiscovery() {
        if (this.historyInfo != null) {
            this.domainUserStatusDO = TechnicianUtil.disableCurrentActiveTechnican(this.historyInfo);
        }
    }

    @Override
    public void postDiscovery(boolean discoveryStatus) {
        if (discoveryStatus && this.domainUserStatusDO != null) {
            try {
                PersistenceDBUtil.getPersistence().update(this.domainUserStatusDO);
            }
            catch (Exception dae) {
                LOGGER.log(Level.FINE, "Exception occurred while disabling deleted technicians {0}", dae);
            }
        }
    }
}

