/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.technician;

import com.manageengine.ela.server.common.delegation.DelegationRoleContainer;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class TechnicianProperties {
    private String technicianName = null;
    private String password = null;
    private String oldPassword = null;
    private String technicianEmail = null;
    private String domainName = null;
    private DelegationRoleContainer.UserRole technicianType = null;
    private Long userID = null;
    private Long[] groupIDList = null;
    private boolean isLocal = false;

    public static TechnicianProperties getUserProperties(JSONObject reqJsonObject, boolean isLocal) throws JSONException {
        TechnicianProperties userProperties = new TechnicianProperties();
        userProperties.setLocal(isLocal);
        return TechnicianProperties.init(userProperties, reqJsonObject);
    }

    public static TechnicianProperties getUserProperties(String name, JSONObject reqJsonObject, boolean isLocal) throws JSONException {
        TechnicianProperties userProperties = new TechnicianProperties(name);
        userProperties.setLocal(isLocal);
        return TechnicianProperties.init(userProperties, reqJsonObject);
    }

    public static TechnicianProperties getUserProperties(Long id, JSONObject reqJsonObject, boolean isLocal) throws JSONException {
        TechnicianProperties userProperties = new TechnicianProperties(id);
        userProperties.setLocal(isLocal);
        return TechnicianProperties.init(userProperties, reqJsonObject);
    }

    private static TechnicianProperties init(TechnicianProperties userProperties, JSONObject reqJsonObject) throws JSONException {
        if (userProperties.isLocal()) {
            userProperties.setDomainName("EventLog Authentication");
            userProperties.setPassword(reqJsonObject.optString("PASSWORD", null));
        } else if (reqJsonObject.has("TECHNICIAN_DOMAIN")) {
            userProperties.setDomainName(reqJsonObject.optString("TECHNICIAN_DOMAIN", null));
            userProperties.setPassword("Firewall12");
        }
        userProperties.setTechnicianType(reqJsonObject.isNull("TECHNICIAN_TYPE") ? null : DelegationRoleContainer.UserRole.getRole(reqJsonObject.getString("TECHNICIAN_TYPE")));
        userProperties.setOldPassword(reqJsonObject.optString("OLD_PASSWORD", null));
        userProperties.setTechnicianEmail(reqJsonObject.optString("TECHNICIAN_EMAILID", null));
        if (reqJsonObject.isNull("SELECTED_GROUPS")) {
            userProperties.setGroupIDList(null);
        } else {
            Long[] groupIDs = DeviceGroupUtil.getValidatedGroupIDs(reqJsonObject.getJSONArray("SELECTED_GROUPS"));
            if (groupIDs.length > 0) {
                userProperties.setGroupIDList(groupIDs);
            } else {
                userProperties.setGroupIDList(new Long[]{DeviceGroupUtil.getDefaultGroupID()});
            }
        }
        return userProperties;
    }

    private TechnicianProperties() {
    }

    private TechnicianProperties(String name) {
        this.technicianName = name;
    }

    private TechnicianProperties(Long userID) {
        this.userID = userID;
    }

    public String getTechnicianName() {
        return this.technicianName;
    }

    public void setTechnicianName(String technicianName) {
        this.technicianName = technicianName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DelegationRoleContainer.UserRole getTechnicianType() {
        return this.technicianType;
    }

    public void setTechnicianType(DelegationRoleContainer.UserRole technicianType) {
        this.technicianType = technicianType;
    }

    public Long[] getGroupIDList() {
        return this.groupIDList;
    }

    public void setGroupIDList(Long[] groupIDList) {
        this.groupIDList = groupIDList;
    }

    public String getTechnicianEmail() {
        return this.technicianEmail;
    }

    public void setTechnicianEmail(String technicianEmail) {
        this.technicianEmail = technicianEmail;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public Long getUserID() {
        return this.userID;
    }

    public void setUserID(Long userID) {
        this.userID = userID;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }
}

