/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.config.technician;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.audit.AuditEntry;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.config.technician.TechnicianProperties;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.DelegationRoleContainer;
import com.manageengine.ela.server.common.delegation.config.ELADynamicResourceHandler;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TechnicianUtil {
    private static long adminUserID = 1L;
    private static long guestUserID = 2L;
    public static final long MANAGEDSERVER_INITIAL_CRUNCHER = 1000000000L;
    private static final Logger LOGGER = Logger.getLogger(TechnicianUtil.class.getName());
    public static final String LOCAL_DOMAIN = "EventLog Authentication";
    public static final String DEFAULT_AD_USER_PASSWORD = "Firewall12";
    private static final String DEFAULT_ADMIN_PASSWORD_HASH = "Ok6/FqR5WtJY5UCLrnvjQQ==";

    public static long getMickeyAdminID() {
        Long id = TechnicianUtil.getMickeyUserID("admin", LOCAL_DOMAIN);
        return id != null ? id : 1L;
    }

    public static long getMickeyGuestID() {
        Long id = TechnicianUtil.getMickeyUserID("guest", LOCAL_DOMAIN);
        return id != null ? id : 2L;
    }

    public static long getDefaultAdminUserID() {
        return adminUserID;
    }

    public static long getDefaultguestUserID() {
        return guestUserID;
    }

    public static Long getMickeyUserID(String userName, String domainName) {
        try {
            Criteria crt = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)userName, 0);
            crt = crt.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0));
            DataObject obj = PersistenceDBUtil.getPersistence().get("AaaLogin", crt);
            return (Long)obj.getFirstValue("AaaLogin", "USER_ID");
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to find User Role", exp);
            return null;
        }
    }

    public static long getGroupCount(Object userId) throws Exception {
        UserAccessResource resource = UserAccessResource.getUserAccessResource((Long)userId);
        if (resource.checkItHasFullDataAccess()) {
            Criteria criteria = null;
            if (ServerDetailsBean.getInstance().isAdminServer()) {
                criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)1000000000L, 5);
            }
            return DBUtil.getCountLong("HostGroup", criteria);
        }
        return resource.getAllAllowedGroups().size();
    }

    public static boolean isTechnicianPermittedForCollector(Long userId, Long collectorStartID) {
        try {
            UserAccessResource resource = UserAccessResource.getUserAccessResource(userId);
            if (resource.checkItHasFullDataAccess()) {
                return true;
            }
            Set<Long> allGroups = resource.getAllAllowedGroups();
            for (Long groupID : allGroups) {
                if (groupID <= collectorStartID || groupID > collectorStartID + 1000000000L) continue;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static Object getImportedTechnicianCount(Object schedulehistoryID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAUserScheduleImportHistory", (String)"SCHEDULE_HISTORY_ID"), schedulehistoryID, 0);
        return DBUtil.getCountLong("ELAUserScheduleImportHistory", criteria);
    }

    public static void loadTechnicianNamingInfo(TechnicianProperties userProperties) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userProperties.getUserID(), 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get("AaaLogin", criteria);
            if (!dobj.isEmpty()) {
                Row loginDetails = dobj.getFirstRow("AaaLogin");
                userProperties.setDomainName((String)loginDetails.get("DOMAINNAME"));
                userProperties.setTechnicianName((String)loginDetails.get("NAME"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static String getUserType(Long userID) {
        try {
            Criteria crt = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userID, 0);
            DataObject obj = PersistenceDBUtil.getPersistence().get("AaaUser", crt);
            return (String)obj.getFirstValue("AaaUser", "FIRST_NAME");
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to find User Role", exp);
            return null;
        }
    }

    public static DelegationRoleContainer.UserRole getUserRole(Long userID) {
        return DelegationRoleContainer.UserRole.getRole(TechnicianUtil.getUserType(userID));
    }

    public static Long getUserViewID(long collectorID, long userID) {
        Long viewId = null;
        try {
            SelectQueryImpl select = new SelectQueryImpl(new Table("CollectorToURVMapping"));
            String[] jCols = new String[]{"VIEW_ID"};
            select.addSelectColumns(Arrays.asList(Column.getColumn((String)"UserResourceView", (String)"VIEW_ID"), Column.getColumn((String)"UserResourceView", (String)"USER_ID")));
            select.addSelectColumns(Arrays.asList(Column.getColumn((String)"CollectorToURVMapping", (String)"VIEW_ID"), Column.getColumn((String)"CollectorToURVMapping", (String)"CID")));
            select.addJoin(new Join("CollectorToURVMapping", "UserResourceView", jCols, jCols, 2));
            Criteria criteria = null;
            criteria = DelegationRoleContainer.UserRole.ADMIN == TechnicianUtil.getUserRole(userID) || userID == TechnicianUtil.getMickeyGuestID() ? new Criteria(Column.getColumn((String)"UserResourceView", (String)"USER_ID"), (Object)userID, 0) : new Criteria(Column.getColumn((String)"UserResourceView", (String)"USER_ID"), (Object)TechnicianUtil.getDefaultAdminUserID(), 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"CollectorToURVMapping", (String)"CID"), (Object)collectorID, 0));
            select.setCriteria(criteria);
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)select);
            viewId = (Long)dobj.getFirstValue("UserResourceView", "VIEW_ID");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return viewId;
    }

    public static DelegationRoleContainer.UserRole getTechinicianRole(Long userID) throws DataAccessException {
        List<String> tablesList = Arrays.asList("AaaUser", "AaaLogin", "AaaAccount", "AaaAuthorizedRole", "AaaRole");
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userID, 0);
        return DelegationRoleContainer.UserRole.getRole((String)PersistenceDBUtil.getPersistence().get(tablesList, criteria).getFirstRow("AaaRole").get("NAME"));
    }

    public static DataObject getTechinicianDetailsDO(Long userID) throws DataAccessException {
        List<String> tablesList = Arrays.asList("AaaUser", "AaaUserContactInfo", "AaaContactInfo", "AaaLogin", "AaaAccount", "AaaAuthorizedRole", "AaaRole");
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userID, 0);
        return PersistenceDBUtil.getPersistence().get(tablesList, criteria);
    }

    public static JSONObject getTechinicianDetailsJSON(Long userID) throws DataAccessException, JSONException, BaseStatusCode {
        DataObject dobj = TechnicianUtil.getTechinicianDetailsDO(userID);
        JSONObject technicianDetails = new JSONObject();
        technicianDetails.put("TECHNICIAN_NAME", dobj.getFirstValue("AaaLogin", "NAME"));
        technicianDetails.put("TECHNICIAN_EMAIL", dobj.getFirstValue("AaaContactInfo", "EMAILID"));
        technicianDetails.put("TECHNICIAN_ROLE", dobj.getFirstValue("AaaUser", "FIRST_NAME"));
        if (dobj.getFirstValue("AaaLogin", "DOMAINNAME").toString().equals(LOCAL_DOMAIN)) {
            technicianDetails.put("IS_LOCAL_TECHNICIAN", (Object)Boolean.TRUE);
        } else {
            technicianDetails.put("TECHNICIAN_DOMAIN", dobj.getFirstValue("AaaLogin", "DOMAINNAME"));
        }
        UserAccessResource resource = UserAccessResource.getUserAccessResource(userID);
        technicianDetails.put("IS_DEFAULT_TECHNICIAN", userID == adminUserID || userID == guestUserID);
        if (resource.checkItHasFullDataAccess()) {
            technicianDetails.put("ISALLGROUPS", (Object)Boolean.TRUE);
        } else {
            technicianDetails.put("GROUP_ID_LIST", (Object)new JSONArray(resource.getAllAllowedGroups()));
            technicianDetails.put("GROUP_LIST", (Object)DeviceGroupUtil.getGroupList(resource.getAllAllowedGroups()));
        }
        return technicianDetails;
    }

    public static JSONArray getDiscoveredUserDetails(Long domainID, String[] objectGuids) throws DataAccessException, JSONException {
        JSONArray array = new JSONArray();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainUserDetails", (String)"OBJECT_GUID"), (Object)objectGuids, 8);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELADomainUserDetails", criteria);
        Iterator itr = dobj.getRows("ELADomainUserDetails");
        while (itr.hasNext()) {
            JSONObject details = new JSONObject();
            Row row = (Row)itr.next();
            details.put("NAME", row.get("SAMACCOUNTNAME"));
            details.put("USERPRINCIPALNAME", row.get("USERPRINCIPALNAME"));
            details.put("EMAIL_ID", row.get("EMAIL_ID"));
            array.put((Object)details);
        }
        return array;
    }

    public static boolean isAllowedRoleUpdateOrDelete(Long currentUser, Long ... userIds) {
        for (Long id : userIds) {
            if (id != adminUserID && id != guestUserID && id.longValue() != currentUser.longValue()) continue;
            return false;
        }
        return true;
    }

    public static void disableUsers(Long[] userIdList, Long currentLoginID) throws DataAccessException {
        Criteria usersCriteria = new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"USER_ID"), (Object)userIdList, 8);
        Criteria adminUser = new Criteria(Column.getColumn((String)"AaaUser", (String)"FIRST_NAME"), (Object)"Administrator", 0);
        Criteria nonAdminUser = new Criteria(Column.getColumn((String)"AaaUser", (String)"FIRST_NAME"), (Object)"Administrator", 1);
        Criteria active = new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"STATUS"), (Object)"ACTIVE", 0);
        DataObject dobjNonAdmin = PersistenceDBUtil.getPersistence().get(Arrays.asList("AaaUser", "AaaUserStatus"), usersCriteria.and(nonAdminUser));
        Iterator itrNonAdmin = dobjNonAdmin.getRows("AaaUserStatus");
        while (itrNonAdmin.hasNext()) {
            Row row = (Row)itrNonAdmin.next();
            row.set("STATUS", (Object)"DISABLED");
            dobjNonAdmin.updateRow(row);
        }
        PersistenceDBUtil.getPersistence().update(dobjNonAdmin);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AaaUser"));
        query.addJoin(new Join("AaaUser", "AaaUserStatus", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
        query.addSelectColumn(Column.getColumn(null, (String)"*").count());
        query.setCriteria(adminUser.and(active));
        long enabledAdminCout = DBUtil.getTotalCount((SelectQuery)query);
        DataObject dobjAdmin = PersistenceDBUtil.getPersistence().get(Arrays.asList("AaaUser", "AaaUserStatus"), usersCriteria.and(adminUser));
        Iterator itrAdmin = dobjAdmin.getRows("AaaUserStatus");
        while (itrAdmin.hasNext() && enabledAdminCout > 1L) {
            Row row = (Row)itrAdmin.next();
            if (currentLoginID.longValue() == ((Long)row.get("USER_ID")).longValue()) continue;
            UserAccessResource.removeUserCache((long)((Long)row.get("USER_ID")));
            row.set("STATUS", (Object)"DISABLED");
            dobjAdmin.updateRow(row);
            --enabledAdminCout;
        }
        PersistenceDBUtil.getPersistence().update(dobjAdmin);
    }

    public static void enableUsers(Long[] userIdList) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"USER_ID"), (Object)userIdList, 8);
        DataBaseReqestProcessor.executeUpdateQuery("AaaUserStatus", "STATUS", "ACTIVE", criteria, new boolean[0]);
    }

    public static Long[] checkOtherTechnicianAndgetValidgroups(DataObject existingResource, Long ... requestedGrp) throws DataAccessException {
        LinkedList<Long> requestedList = new LinkedList<Long>(Arrays.asList(requestedGrp));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"IS_SYSTEMGENERATED"), (Object)Boolean.TRUE, 0);
        Iterator itr = existingResource.getRows("ELATechnicianViewConfig", criteria);
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Criteria viewIDCriteria = new Criteria(Column.getColumn((String)"ELAViewGroupMapping", (String)"VIEW_ID"), row.get("VIEW_ID"), 0);
            Iterator group = existingResource.getRows("ELAViewGroupMapping", viewIDCriteria);
            int totalHitcount = 0;
            ArrayList<Long> configuredGroup = new ArrayList<Long>();
            while (group.hasNext()) {
                Long groupID = (Long)((Row)group.next()).get("GROUP_ID");
                if (requestedList.contains(groupID)) {
                    ++totalHitcount;
                }
                configuredGroup.add(groupID);
            }
            if (totalHitcount != configuredGroup.size()) continue;
            requestedList.removeAll(configuredGroup);
        }
        return requestedList.toArray(new Long[requestedList.size()]);
    }

    public static void handleNewGroupUpdateFromGrpMgmnt(UserAccessResource access, Long ... groupID) throws DataAccessException, JSONException, BaseStatusCode {
        if (!access.checkItHasFullDataAccess()) {
            DataObject dobj = RoleInfoUtil.getTechnicianGroupMapping(access.getUserID(), RoleInfoUtil.DEFAULT_VIEW_ID);
            ELADynamicResourceHandler.handleAddorDeleteGroupID(dobj, groupID, null);
        }
    }

    public static void handleDeleteGroupFromGroupMgmnt(DataObject dobj, Long ... groupID) throws DataAccessException, JSONException, BaseStatusCode {
        ELADynamicResourceHandler.handleAddorDeleteGroupID(dobj, null, groupID);
    }

    public static void handleDeviceGroupUpdate(TechnicianProperties userProperties) throws DataAccessException, JSONException, BaseStatusCode {
        HashSet<Long> mofdifiedList = new HashSet<Long>(Arrays.asList(userProperties.getGroupIDList()));
        DataObject dobj = RoleInfoUtil.getTechnicianGroupMapping(userProperties.getUserID(), null);
        Iterator<?> deviceGroupInfo = RoleInfoUtil.getTechnicianSelectedViewGroupMapping(dobj, RoleInfoUtil.DEFAULT_VIEW_ID);
        HashSet<Long> existingGroupList = new HashSet<Long>();
        HashSet<Long> newGroupList = new HashSet<Long>();
        while (deviceGroupInfo.hasNext()) {
            Row row = (Row)deviceGroupInfo.next();
            existingGroupList.add((Long)row.get("GROUP_ID"));
        }
        for (Long id : mofdifiedList) {
            if (existingGroupList.contains(id)) {
                existingGroupList.remove(id);
                continue;
            }
            newGroupList.add(id);
        }
        Long[] newIDs = newGroupList.toArray(new Long[newGroupList.size()]);
        Long[] deletedIds = existingGroupList.toArray(new Long[existingGroupList.size()]);
        TechnicianUtil.handleAddOrUpdateGroupMapping(userProperties.getUserID(), dobj, newIDs, deletedIds);
    }

    private static void handleAddOrUpdateGroupMapping(Long userID, DataObject dobj, Long[] newIDs, Long[] deletedIds) {
        try {
            DataObject result = ELADynamicResourceHandler.handleAddorDeleteGroupID(dobj, newIDs, deletedIds);
            TechnicianUtil.applyUserResourceViewConfiguration(result, userID);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void changeDynamicResourceToOperatorAccess(TechnicianProperties userProperties) throws DataAccessException, BaseStatusCode, JSONException {
        DataObject dobj = RoleInfoUtil.getTechnicianGroupMapping(userProperties.getUserID(), null);
        DataObject result = ELADynamicResourceHandler.changeDynamicResourceToOperatorAccess(dobj, userProperties.getGroupIDList());
        TechnicianUtil.applyUserResourceViewConfiguration(result, userProperties.getUserID());
    }

    public static void changeDynamicResourceToAdminAccess(TechnicianProperties userProperties) throws DataAccessException, BaseStatusCode {
        TechnicianUtil.updateAdminResourceView(userProperties);
        ELADynamicResourceHandler.changeDynamicResourceToAdminAccess(userProperties.getUserID());
    }

    public static JSONObject getCachedGlobalData(Long loginID) throws JSONException, DataAccessException {
        JSONObject cache = new JSONObject();
        try {
            String globalData;
            Row row = TechnicianUtil.getUserPersonalInfo(loginID);
            if (row != null && (globalData = (String)row.get("EMBER_CONFIGCACHE")) != null) {
                cache = new JSONObject(globalData);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return cache;
    }

    public static void commitGlobalData(JSONObject json, Long loginID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"EventlogUsersPersonal", (String)"LOGIN_ID"), (Object)loginID, 0);
        DataBaseReqestProcessor.executeUpdateQuery("EventlogUsersPersonal", "EMBER_CONFIGCACHE", json.toString(), criteria, new boolean[0]);
    }

    public static Row getUserPersonalInfo(Long loginID) throws DataAccessException {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"EventlogUsersPersonal", (String)"LOGIN_ID"), (Object)loginID, 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get("EventlogUsersPersonal", criteria);
            return dobj.getFirstRow("EventlogUsersPersonal");
        }
        catch (Exception exp) {
            return null;
        }
    }

    private static String getPasswordHashForUser(Long userID) throws DataAccessException {
        List<String> tablesList = Arrays.asList("AaaUser", "AaaLogin", "AaaAccount", "AaaAccPassword", "AaaPassword");
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userID, 0);
        DataObject dobj = PersistenceDBUtil.getPersistence().get(tablesList, criteria);
        return (String)dobj.getFirstValue("AaaPassword", "PASSWORD");
    }

    public static boolean doesAdminHaveDefPassword() {
        try {
            return TechnicianUtil.getPasswordHashForUser(TechnicianUtil.getMickeyAdminID()).equals(DEFAULT_ADMIN_PASSWORD_HASH);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getNumberOfUsers() {
        return DBUtil.getCountInt("AaaUser", null);
    }

    public static boolean isTechnicianExists(String name, String domainFlatName) {
        Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)name, 0);
        return DBUtil.getCountInt("AaaLogin", criteria = criteria.and(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainFlatName, 0)) > 0;
    }

    public static JSONArray findScheduledInformation(JSONArray groupInfo) throws DataAccessException, BaseStatusCode, JSONException {
        return TechnicianUtil.getGroupPrimaryTokens(JSONUtil.toStringArray(groupInfo));
    }

    public static JSONArray getGroupPrimaryTokens(String[] dn) throws DataAccessException, BaseStatusCode, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainGroupDetails", (String)"DISTINGUISHEDNAME"), (Object)dn, 8);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELADomainGroupDetails", criteria);
        if (dobj.isEmpty()) {
            if (dn.length != 0) {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            return null;
        }
        JSONArray array = new JSONArray();
        Iterator itr = dobj.getRows("ELADomainGroupDetails");
        while (itr.hasNext()) {
            JSONObject details = new JSONObject();
            Row row = (Row)itr.next();
            details.put("DISTINGUISHEDNAME", row.get("DISTINGUISHEDNAME"));
            details.put("PRIMARY_GROUP_TOKEN", row.get("PRIMARY_GROUP_TOKEN"));
            details.put("OPERATION", (Object)"OR");
            array.put((Object)details);
        }
        return array;
    }

    public static DataObject disableCurrentActiveTechnican(Row historyInfo) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELADiscoveryScheduleHistory", (String)"SCHEDULE_CONFIG_ID"), historyInfo.get("SCHEDULE_CONFIG_ID"), 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"STATUS"), (Object)"ACTIVE", 0));
            DataObject dobj = PersistenceDBUtil.getPersistence().get(Arrays.asList("ELADiscoveryScheduleHistory", "ELAUserScheduleImportHistory", "AaaUser", "AaaLogin", "AaaUserStatus"), criteria);
            Iterator iterator = dobj.getRows("AaaUserStatus");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("STATUS", (Object)"DISABLED");
                dobj.updateRow(row);
            }
            return dobj;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static void enablePresentUserInDO(String name, DataObject dobj) {
        if (dobj != null) {
            try {
                Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)name, 0);
                Join join = new Join("AaaLogin", "AaaUserStatus", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2);
                Row row = dobj.getRow("AaaUserStatus", criteria, join);
                if (row != null) {
                    row.set("STATUS", (Object)"ACTIVE");
                    dobj.updateRow(row);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    public static void commitAuditEntry(TechnicianProperties userProperties, AuditEntry.ActionType actionType) {
        new AuditEntry(AuditEntry.ResourceType.TECHNICIAN, actionType, userProperties.getTechnicianName()).commitEntry();
    }

    public static AuditEntry getAuditEntry(Long[] technicianIDs, AuditEntry.ActionType actionType) {
        AuditEntry entry = new AuditEntry(AuditEntry.ResourceType.TECHNICIAN, actionType);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)technicianIDs, 8));
            dobj.getRows("AaaLogin").forEachRemaining(row -> entry.addResource((String)((Row)row).get("NAME")));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return entry;
    }

    @Deprecated
    private static Criteria getDefaultResourceViewCriteria(long userID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"UserResourceView", (String)"USER_ID"), (Object)userID, 0);
        return criteria.and(new Criteria(Column.getColumn((String)"UserResourceView", (String)"VIEW_NAME"), (Object)"All Devices", 0));
    }

    @Deprecated
    static void updateAdminResourceView(TechnicianProperties userProperties) throws DataAccessException {
        DataBaseReqestProcessor.executeUpdateQuery("UserResourceView", "VIEW_RESOURCE", "1=1", TechnicianUtil.getDefaultResourceViewCriteria(userProperties.getUserID()), new boolean[0]);
    }

    @Deprecated
    static void applyUserResourceViewConfiguration(DataObject dobj, Long userID) throws DataAccessException, JSONException {
        Iterator itr = dobj.getRows("ELATechnicianViewConfig");
        Criteria criteria = new Criteria(Column.getColumn((String)"UserResourceView", (String)"USER_ID"), (Object)userID, 0);
        DataObject depricatedTableDO = PersistenceDBUtil.getPersistence().get("UserResourceView", criteria);
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Criteria viewNameCriteria = new Criteria(Column.getColumn((String)"UserResourceView", (String)"VIEW_NAME"), row.get("VIEW_NAME"), 0);
            Row depricatedresource = depricatedTableDO.getRow("UserResourceView", viewNameCriteria);
            String resourceView = null;
            if (((Boolean)row.get("IS_FULLACCESS")).booleanValue()) {
                resourceView = "1=1";
            } else {
                Criteria viewIDCriteria = new Criteria(Column.getColumn((String)"ELAViewGroupMapping", (String)"VIEW_ID"), row.get("VIEW_ID"), 0);
                Iterator groupMapping = dobj.getRows("ELAViewGroupMapping", viewIDCriteria);
                StringBuffer buffer = new StringBuffer();
                while (groupMapping.hasNext()) {
                    Row mappingGroup = (Row)groupMapping.next();
                    if (buffer.length() == 0) {
                        buffer.append(mappingGroup.get("GROUP_ID").toString());
                        continue;
                    }
                    buffer.append(",").append(mappingGroup.get("GROUP_ID").toString());
                }
                resourceView = buffer.toString();
            }
            if (resourceView.length() == 0) {
                resourceView = "-2";
            }
            depricatedresource.set("VIEW_RESOURCE", (Object)resourceView);
            depricatedTableDO.updateRow(depricatedresource);
        }
        PersistenceDBUtil.getPersistence().update(depricatedTableDO);
    }

    static {
        adminUserID = TechnicianUtil.getMickeyAdminID();
        guestUserID = TechnicianUtil.getMickeyGuestID();
    }
}

