/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.credential;

public class Credential {
    private Long credentialID = null;
    private String domain = null;
    private String machineName = null;
    private String username = null;
    private String password = null;

    Credential() {
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain != null ? domain.trim() : domain;
    }

    void setMachineName(String machineName) {
        this.machineName = machineName != null ? machineName.trim() : machineName;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getUserName() {
        return this.username;
    }

    void setUserName(String username) {
        this.username = username != null ? username.trim() : username;
    }

    public String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public String getUserNameWithDomain() {
        if (this.domain != null) {
            return this.domain + "\\" + this.username;
        }
        return this.username;
    }

    public void reSetUserNameFormat() {
        this.resolveDomainAndUserName();
        if (this.username != null) {
            if (this.domain != null) {
                this.username = this.domain + "\\" + this.username;
            } else if (this.machineName != null) {
                this.username = this.machineName + "\\" + this.username;
            }
        }
    }

    public void resolveDomainAndUserName() {
        if (this.username != null && !this.username.isEmpty()) {
            String customDomain = null;
            if (this.username.contains("@")) {
                customDomain = this.username.substring(this.username.indexOf("@") + 1, this.username.length());
                this.username = this.username.substring(0, this.username.indexOf("@"));
            } else if (this.username.contains("\\")) {
                customDomain = this.username.substring(0, this.username.indexOf("\\"));
                this.username = this.username.substring(this.username.indexOf("\\") + 1, this.username.length());
            } else if (this.username.contains("/")) {
                customDomain = this.username.substring(0, this.username.indexOf("/"));
                this.username = this.username.substring(this.username.indexOf("\\") + 1, this.username.length());
            }
            if (this.domain == null || this.domain.isEmpty()) {
                this.domain = customDomain;
            }
        }
    }

    public Long getCredentialID() {
        return this.credentialID;
    }

    public void setCredentialID(Long credentialID) {
        this.credentialID = credentialID;
    }

    public boolean isValidCredential() {
        return this.username != null && this.password != null;
    }
}

