/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.credential;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class CredentialHandler {
    public static Credential getCredentialFromDomainID(Long domainID) throws JSONException {
        JSONObject domainDetails = ADSDomainHandler.getDomainDetailsFromID((Long)domainID);
        if (!domainDetails.isNull("CREDENTIAL_ID")) {
            return CredentialHandler.getADSCredential(domainDetails.getLong("CREDENTIAL_ID"), true);
        }
        return new Credential();
    }

    public static Credential getCredentialFromWrkGrupID(Long workgroupID) throws JSONException {
        JSONObject workgroupDetails = WorkgroupHandler.getWorkGroupDetails(workgroupID);
        if (!workgroupDetails.isNull("CREDENTIAL_ID")) {
            return CredentialHandler.getADSCredential(workgroupDetails.getLong("CREDENTIAL_ID"), false);
        }
        return new Credential();
    }

    public static Credential getCustomCredential(JSONObject reqJsonObject) throws JSONException {
        Credential instance = new Credential();
        if (!reqJsonObject.isNull("IS_AUTH_REQUIRED") && reqJsonObject.optString("IS_AUTH_REQUIRED").equalsIgnoreCase("FALSE")) {
            return instance;
        }
        instance.setMachineName(CredentialHandler.getValue(reqJsonObject.optString("COMPUTER_NAME", null)));
        instance.setDomain(CredentialHandler.getValue(reqJsonObject.optString("DOMAIN_NAME", null)));
        instance.setPassword(reqJsonObject.optString("PASSWORD", null));
        instance.setUserName(CredentialHandler.getValue(reqJsonObject.optString("USERNAME", null)));
        return instance;
    }

    public static Credential getCustomCredential(String username, String password, String domain, String machineName) {
        Credential instance = new Credential();
        if (CredentialHandler.isValidString(username)) {
            instance.setPassword(password);
            instance.setUserName(username);
        }
        if (CredentialHandler.isValidString(domain)) {
            instance.setDomain(domain);
        }
        if (CredentialHandler.isValidString(machineName)) {
            instance.setMachineName(machineName);
        }
        return instance;
    }

    public static Credential getADSCredential(Long adsCredentialID, boolean isDomain) throws JSONException {
        JSONObject credential = ADSDomainHandler.getCredential((Long)adsCredentialID);
        Credential instance = new Credential();
        if (credential != null) {
            if (isDomain) {
                instance.setDomain(credential.optString("DOMAIN_NAME", null));
            }
            instance.setUserName(credential.optString("USER_NAME", null));
            instance.setPassword(credential.optString("PASSWORD", null));
        }
        return instance;
    }

    public static void setCredentialParameters(Credential instance, String domain, String username, String password) {
        instance.setDomain(domain);
        instance.setUserName(username);
        instance.setPassword(password);
    }

    public static void deleteCredential(Long[] cred) throws DataAccessException {
        PersistenceDBUtil.getPersistence().delete(new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)cred, 8));
    }

    public static Credential getELACredential(Long credentialID) throws DataAccessException {
        return CredentialHandler.getELACredential(credentialID, true);
    }

    public static Credential getELACredential(Long credentialID, boolean isEncrypted) throws DataAccessException {
        Credential instance = new Credential();
        Row credential = CredentialHandler.getCredentailRow(credentialID);
        if (credential != null) {
            instance.setDomain((String)credential.get("DOMAIN_NAME"));
            instance.setUserName((String)credential.get("USERNAME"));
            if (!isEncrypted) {
                instance.setPassword(EnDecryptImplSingleton.getInstance().decrypt((String)credential.get("PASSWORD")));
            } else {
                instance.setPassword((String)credential.get("PASSWORD"));
            }
        }
        return instance;
    }

    public static Credential findCredential(DataObject dobj) throws DataAccessException, JSONException {
        if (dobj.containsTable(ADSDomainHandler.tableName)) {
            return CredentialHandler.getADSCredential((Long)dobj.getFirstValue(ADSDomainHandler.tableName, "CREDENTIAL_ID"), true);
        }
        if (dobj.containsTable("ELAWorkgroupConfiguration")) {
            return CredentialHandler.getADSCredential((Long)dobj.getFirstValue("ELAWorkgroupConfiguration", "CREDENTIAL_ID"), false);
        }
        return new Credential();
    }

    public static void createNewCredentialEntry(Credential cred) throws DataAccessException {
        cred.resolveDomainAndUserName();
        CredentialHandler.createNewCredentialEntry(cred, true);
    }

    public static void createNewCredentialEntry(Credential cred, boolean isEncrypted) throws DataAccessException {
        Row row = new Row("ELACredentials");
        row.set("USERNAME", (Object)cred.getUserName());
        if (isEncrypted) {
            row.set("PASSWORD", (Object)cred.getPassword());
        } else {
            row.set("PASSWORD", (Object)EnDecryptImplSingleton.getInstance().encrypt(cred.getPassword()));
        }
        row.set("DOMAIN_NAME", (Object)cred.getDomain());
        row = DBUtil.createNewRowGETDO(row, new boolean[0]).getFirstRow("ELACredentials");
        cred.setCredentialID((Long)row.get("CREDENTIAL_ID"));
    }

    public static void updateCredentialEntry(Credential cred) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)cred.getCredentialID(), 0);
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("USERNAME", cred.getUserName());
        details.put("PASSWORD", cred.getPassword());
        details.put("DOMAIN_NAME", cred.getDomain());
        DataBaseReqestProcessor.executeUpdateQuery("ELACredentials", details, criteria, new boolean[0]);
    }

    private static Row getCredentailRow(Long credentialID) throws DataAccessException {
        return CredentialHandler.getCredentailDO(credentialID).getFirstRow("ELACredentials");
    }

    private static DataObject getCredentailDO(Long credentialID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)credentialID, 0);
        return PersistenceDBUtil.getPersistence().get("ELACredentials", criteria);
    }

    private static boolean isValidString(String str) {
        return str != null && !str.isEmpty();
    }

    private static String getValue(String value) {
        if (value != null) {
            return value.trim();
        }
        return null;
    }
}

