/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion;

import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.client.datasource.FieldInfo;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.data.conversion.DataConverter;
import com.manageengine.ela.server.common.data.conversion.DefaultDataTransformer;
import com.manageengine.ela.server.common.data.conversion.TransformerDataCollector;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;

public class FieldBasedTransformer
extends TransformerDataCollector
implements DataConverter<FieldInfo<String>, Object> {
    private static final Logger LOGGER = Logger.getLogger(DefaultDataTransformer.class.getName());
    private static final Cache<Long, DataConverter<FieldInfo<String>, Object>> CACHE = new Cache();

    private FieldBasedTransformer(Long transformId) throws BaseStatusCode {
        super(transformId);
    }

    public static DataConverter<FieldInfo<String>, Object> getTransformer(Long transformerID) throws BaseStatusCode {
        FieldBasedTransformer transformer = CACHE.get(transformerID);
        if (transformer == null) {
            transformer = new FieldBasedTransformer(transformerID);
            CACHE.put(transformerID, transformer);
        }
        return transformer;
    }

    @Override
    public Object transform(Object value, Map<FieldInfo<String>, Object> data, Map<Object, Object> additionalArgs) {
        if (this.transFormerDefaultArguments != null) {
            additionalArgs.put(ConversionConstants.DEFAULT_ARGS, this.transFormerDefaultArguments);
        }
        if (super.getClassName() != null && super.getMethodName() != null) {
            try {
                Class<?> dynamicClass = Class.forName(super.getClassName());
                Method dynamicMethod = dynamicClass.getDeclaredMethod(super.getMethodName(), Object.class, Map.class, Map.class);
                return dynamicMethod.invoke(dynamicClass.newInstance(), value, data, additionalArgs);
            }
            catch (Exception exp) {
                LOGGER.fine("Exception in transformer : " + exp.getMessage());
            }
        }
        return value;
    }
}

