/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion;

import com.adventnet.ds.query.Column;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.google.common.base.Strings;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.data.conversion.util.ProgressbarTransformUtil;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.ember.transformer.config.TransformMethodHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportTransformMethodHandler {
    private static final Column FORMAT_ID_COLUMN = Column.getColumn((String)"ELAImportLogConfigurations", (String)"FORMAT_LOCALE_MAP_ID");
    private static final Column DEVICE_ID_COLUMN = Column.getColumn((String)"AppResources", (String)"HOSTID");
    private static final Column LOG_START_TIME_COLUMN = Column.getColumn((String)"ELAImportLogAudit", (String)"LOG_START_TIME");
    private static final Column LOG_END_TIME_COLUMN = Column.getColumn((String)"ELAImportLogAudit", (String)"LOG_END_TIME");
    private static final Column IMPORT_STATUS_MSG_COLUMN = Column.getColumn((String)"ELAImportLogConfigurations", (String)"CUSTOM_STATUS_MSG");
    private static final Column IMPORT_ID_COLUMN = Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_ID", (String)"IMPORT_ID_PK");
    private static final Column APP_ID_COLUMN = Column.getColumn((String)"AppResources", (String)"APPID", (String)"APP_ID_PK");
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
    private static final Column SOURCE_ID_COLUMN = Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID");
    private static final List<String> DAY_LIST = Arrays.asList("ela.importlog.sunday", "ela.importlog.monday", "ela.importlog.tuesday", "ela.importlog.wednesday", "ela.importlog.thursday", "ela.importlog.friday", "ela.importlog.saturday");
    private static final Column FILENAME_COLUMN = Column.getColumn((String)"ELAImportSourceConfigurations", (String)"FILE_NAME");

    public String convertMilliToTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long millis;
        if (obj == null || obj.toString().equals("0")) {
            return null;
        }
        try {
            millis = Long.parseLong(obj.toString());
        }
        catch (NumberFormatException ignored) {
            return "-";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        long milliseconds = millis % 1000L;
        String result = "";
        if (days > 0L) {
            result = result + days + " Day(s) ";
        }
        if (hours > 0L) {
            result = result + hours + " Hr(s) ";
        }
        if (minutes > 0L) {
            result = result + minutes + " Min(s) ";
        }
        if (seconds > 0L) {
            result = result + seconds + " Sec(s) ";
        }
        if (milliseconds > 0L) {
            result = result + milliseconds + " ms ";
        }
        return result;
    }

    public String timeStampToDate(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null || obj.toString().equals("0")) {
            return null;
        }
        Timestamp timestamp = Timestamp.valueOf(obj.toString());
        return new TransformMethodHandler().convertToDate(timestamp.getTime(), row, additionalArgs);
    }

    public String getLogFormatName(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws DataAccessException {
        if (obj == null) {
            return null;
        }
        Long formatId = Long.parseLong(obj.toString());
        if (formatId == -1L) {
            return "Yet to resolve";
        }
        String fileName = (String)row.get(FILENAME_COLUMN);
        if (fileName.toLowerCase().endsWith(".evtx") || fileName.toLowerCase().endsWith(".evt")) {
            return "Windows Event Log";
        }
        return FormatIdentifier.getFormatDesc(Long.parseLong(obj.toString()));
    }

    public String getSize(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        int unit = 1024;
        Long bytes = Long.parseLong(obj.toString());
        if (bytes < (long)unit) {
            return bytes + " Bytes";
        }
        int exp = (int)(Math.log(bytes.longValue()) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes.longValue() / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public Object getLogFileDirectory(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long exportId = (Long)row.get(defaultArgs[0]);
        if (exportId == -1L || Strings.isNullOrEmpty((String)obj.toString())) {
            return null;
        }
        return obj;
    }

    public Object getImportProtocol(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long exportId = (Long)row.get(defaultArgs[0]);
        boolean isLinuxShare = (Boolean)row.get(defaultArgs[1]);
        if (exportId == -1L || isLinuxShare || Strings.isNullOrEmpty((String)obj.toString())) {
            return null;
        }
        return obj;
    }

    public Object getImportStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        JSONObject progressBarObject = ImportTransformMethodHandler.getProgressBarJSONObject(obj, locale, row);
        try {
            if (progressBarObject != null) {
                progressBarObject.put("STATUS_TYPE", obj);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return progressBarObject;
    }

    public Object getImportInterval(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException, BaseStatusCode {
        Long sourceId = NumberUtils.toLong((String)String.valueOf(row.get(SOURCE_ID_COLUMN)));
        JSONObject returnObject = new JSONObject();
        returnObject.put("sourceId", (Object)sourceId);
        if (obj == null) {
            return returnObject.put("msg", (Object)ImportTransformMethodHandler.resolveI18N("ela.importlog.one_time_import"));
        }
        StringBuilder stringBuilder = new StringBuilder(ImportTransformMethodHandler.resolveI18N("ela.importlog.Import") + " ");
        try {
            Long importId = (Long)row.get(IMPORT_ID_COLUMN);
            if (importId != null) {
                JSONObject intervalJsonObject = ImportUtils.getIntervalJSON(importId);
                ScheduleUtil.Frequency frequency = ScheduleUtil.Frequency.getFrequency(intervalJsonObject.getInt("FREQUENCY"));
                if (frequency == ScheduleUtil.Frequency.ONCE || frequency == ScheduleUtil.Frequency.EVERY && intervalJsonObject.getLong("EVERY_MINUTES") == -1L) {
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.only_once"));
                } else if (frequency == ScheduleUtil.Frequency.EVERY) {
                    Long min;
                    Long hour;
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.every")).append(" ");
                    if (intervalJsonObject.has("HOURS") && (hour = Long.valueOf(NumberUtils.toLong((String)intervalJsonObject.getString("HOURS")))) > 0L) {
                        stringBuilder.append(hour).append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.hours"));
                    }
                    if (intervalJsonObject.has("EVERY_MINUTES") && (min = Long.valueOf(NumberUtils.toLong((String)intervalJsonObject.getString("EVERY_MINUTES")))) > 0L) {
                        stringBuilder.append(min).append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.minutes"));
                    }
                } else if (frequency == ScheduleUtil.Frequency.HOURLY) {
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.hour"));
                    if (intervalJsonObject.has("MINUTES")) {
                        stringBuilder.append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.at")).append(" ");
                        Long min = NumberUtils.toLong((String)intervalJsonObject.getString("MINUTES"));
                        stringBuilder.append(String.format("%02d", min)).append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.minutes"));
                    }
                } else if (frequency == ScheduleUtil.Frequency.DAILY) {
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.daily_at")).append(" ");
                    if (intervalJsonObject.has("HOURS")) {
                        Long hour = NumberUtils.toLong((String)intervalJsonObject.getString("HOURS"));
                        stringBuilder.append(String.format("%02d", hour)).append(":");
                    } else {
                        stringBuilder.append("00:");
                    }
                    if (intervalJsonObject.has("MINUTES")) {
                        Long min = NumberUtils.toLong((String)intervalJsonObject.getString("MINUTES"));
                        stringBuilder.append(String.format("%02d", min));
                    } else {
                        stringBuilder.append("00");
                    }
                } else if (frequency == ScheduleUtil.Frequency.WEEKLY) {
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.every_week")).append(" ");
                    if (intervalJsonObject.has("DAY_OF_WEEK")) {
                        Long day = intervalJsonObject.getLong("DAY_OF_WEEK");
                        if (day > 0L) {
                            stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.on")).append(" ").append(ImportTransformMethodHandler.resolveI18N(DAY_LIST.get(day.intValue() - 1)));
                        }
                        if (intervalJsonObject.has("HOURS") || intervalJsonObject.has("MINUTES")) {
                            stringBuilder.append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.at")).append(" ");
                            if (intervalJsonObject.has("HOURS")) {
                                Long hour = NumberUtils.toLong((String)intervalJsonObject.getString("HOURS"));
                                stringBuilder.append(String.format("%02d", hour)).append(":");
                            } else {
                                stringBuilder.append("00:");
                            }
                            if (intervalJsonObject.has("MINUTES")) {
                                Long min = NumberUtils.toLong((String)intervalJsonObject.getString("MINUTES"));
                                stringBuilder.append(String.format("%02d", min));
                            } else {
                                stringBuilder.append("00");
                            }
                        }
                    }
                } else if (frequency == ScheduleUtil.Frequency.MONTHLY) {
                    stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.every_month")).append(" ");
                    if (intervalJsonObject.has("DATE_OF_MONTH")) {
                        Long day = NumberUtils.toLong((String)intervalJsonObject.getString("DATE_OF_MONTH"));
                        if (day > 0L) {
                            stringBuilder.append(ImportTransformMethodHandler.resolveI18N("ela.importlog.on_day")).append(" ").append(day).append(" ");
                        }
                        if (intervalJsonObject.has("HOURS") || intervalJsonObject.has("MINUTES")) {
                            stringBuilder.append(" ").append(ImportTransformMethodHandler.resolveI18N("ela.importlog.at")).append(" ");
                            if (intervalJsonObject.has("HOURS")) {
                                Long hour = NumberUtils.toLong((String)intervalJsonObject.getString("HOURS"));
                                stringBuilder.append(String.format("%02d", hour)).append(":");
                            } else {
                                stringBuilder.append("00:");
                            }
                            if (intervalJsonObject.has("MINUTES")) {
                                Long min = NumberUtils.toLong((String)intervalJsonObject.getString("MINUTES"));
                                stringBuilder.append(String.format("%02d", min));
                            } else {
                                stringBuilder.append("00");
                            }
                        }
                    }
                }
            }
        }
        catch (DataAccessException | JSONException e) {
            e.printStackTrace();
        }
        return returnObject.put("msg", (Object)stringBuilder.toString());
    }

    public Object getReportStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long formatId = (Long)row.get(defaultArgs[5]);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        ResponseBuilder responseBuilder = new ResponseBuilder();
        String statusMsg = ProductBundle.getInstance().getString(locale, "ember_import_open_report");
        try {
            JSONObject response = new JSONObject();
            response.put("STATUS_MSG", (Object)statusMsg);
            try {
                response.put("URL", (Object)FormatIdentifier.getReportUrl(FormatIdentifier.getFormatDesc(formatId)));
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            responseBuilder.setResponse(response);
            return responseBuilder.getResponseJson();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDisplayName(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws DataAccessException {
        if (obj == null) {
            return null;
        }
        Long deviceId = Long.parseLong(obj.toString());
        String deviceName = null;
        try {
            deviceName = DeviceUtil.getDeviceName(deviceId).getDeviceDisplayName();
        }
        catch (BaseStatusCode baseStatusCode) {
            baseStatusCode.printStackTrace();
        }
        return deviceName;
    }

    public JSONObject getFileNameJson(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        Long startTime = (Long)row.get(LOG_START_TIME_COLUMN);
        Long endTime = (Long)row.get(LOG_END_TIME_COLUMN);
        Object clientTimeZone = additionalArgs.get("clienttimezone");
        String fileName = (String)row.get(FILENAME_COLUMN);
        boolean isEvt = fileName.toLowerCase().endsWith(".evtx") || fileName.toLowerCase().endsWith(".evt");
        SIMPLE_DATE_FORMAT.setTimeZone((TimeZone)clientTimeZone);
        String startTimeStr = startTime != null ? SIMPLE_DATE_FORMAT.format(new Date(startTime)) : null;
        String endTimeStr = endTime != null ? SIMPLE_DATE_FORMAT.format(new Date(endTime + 3600000L)) : null;
        try {
            Long formatID = NumberUtils.toLong((String)String.valueOf(row.get(FORMAT_ID_COLUMN)), (long)0L);
            Long deviceID = NumberUtils.toLong((String)String.valueOf(row.get(DEVICE_ID_COLUMN)), (long)0L);
            Long reportId = FormatIdentifier.getReportID(formatID);
            String reportTable = FormatIdentifier.getReportTableName(reportId);
            if (reportTable == null) {
                reportTable = "ela_import_app_reports_hr_trend_sa";
            }
            JSONObject reportParam = new JSONObject().put("FORMAT_ID", (Object)reportId).put("HRTRENDTABLE", (Object)FormatIdentifier.getTrendTableName(reportId)).put("REPORTTABLENAME", (Object)reportTable).put("FORMAT_NAME", (Object)(isEvt ? "Windows" : FormatIdentifier.getFormatName(formatID))).put("FORMAT_DESC", (Object)(isEvt ? "Windows Event Log" : FormatIdentifier.getFormatDesc(formatID))).put("APP_ID", row.get(APP_ID_COLUMN)).put("DEVICE_NAME", (Object)DeviceUtil.getDeviceName(deviceID).getDeviceDisplayName()).put("DEVICE_ID", (Object)deviceID).put("START_TIME", (Object)startTimeStr).put("END_TIME", (Object)endTimeStr).put("START_TIME_UNIX", startTime == null ? null : Long.valueOf(startTime - 3600000L)).put("END_TIME_UNIX", endTime == null ? null : Long.valueOf(endTime + 3600000L));
            ResponseBuilder responseBuilder = new ResponseBuilder();
            responseBuilder.setResponse(reportParam);
            return responseBuilder.getResponseJson().put("IS_USER_DEFINED", FormatIdentifier.isUserDefined(formatID)).put("FILE_NAME", obj);
        }
        catch (Exception e) {
            return new JSONObject().put("IS_USER_DEFINED", true).put("FILE_NAME", obj);
        }
    }

    public static String resolveI18N(String key) {
        return ProductBundle.getInstance().getString(key);
    }

    private static JSONObject getProgressBarJSONObject(Object obj, Locale locale, Map<Column, Object> row) {
        ResponseBuilder responseBuilder = new ResponseBuilder();
        try {
            Long statusId = Long.parseLong(obj.toString());
            Long sourceId = NumberUtils.toLong((String)String.valueOf(row.get(SOURCE_ID_COLUMN)));
            if (statusId.equals(12194L)) {
                responseBuilder.setCustomStatusMsg("ember_import_waiting");
                return null;
            }
            if (statusId.equals(12195L)) {
                Column contentSizeColumn = Column.getColumn((String)"ELAImportLogAudit", (String)"CONTENT_SIZE");
                Float percentage = Float.valueOf(NumberUtils.toFloat((String)String.valueOf(row.get(contentSizeColumn))));
                responseBuilder.setCustomStatusMsg(percentage.intValue() + "%" + " " + ImportTransformMethodHandler.resolveI18N("ela.importlog.completed"));
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                return ProgressbarTransformUtil.getImportingStatusObject(sourceId, message, percentage.floatValue());
            }
            if (statusId.equals(12193L)) {
                responseBuilder.setCustomStatusMsg("ember_import_disabled");
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                return ProgressbarTransformUtil.getFailureStatusObject(sourceId, message, null);
            }
            if (statusId.equals(12196L)) {
                responseBuilder.setCustomStatusMsg("ember_import_success");
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                return ProgressbarTransformUtil.getSuccessStatusObject(sourceId, message, null, null);
            }
            if (statusId.equals(12197L)) {
                responseBuilder.setCustomStatusMsg("ember_import_failure");
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                String statusKeyMsg = (String)row.get(IMPORT_STATUS_MSG_COLUMN);
                String tooltipTextMessage = null;
                if (!Strings.isNullOrEmpty((String)statusKeyMsg)) {
                    responseBuilder.setCustomStatusMsg(statusKeyMsg);
                    tooltipTextMessage = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                }
                return ProgressbarTransformUtil.getFailureStatusObject(sourceId, message, tooltipTextMessage);
            }
            if (statusId.equals(12145L)) {
                responseBuilder.setCustomStatusMsg("ember_import_processing");
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                return ProgressbarTransformUtil.getProcessingStatusObject(sourceId, message, message);
            }
            if (statusId.equals(12033L)) {
                responseBuilder.setCustomStatusMsg("ember_import_format_mismatch");
                String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
                return ProgressbarTransformUtil.getFormatMismatchStatusObject(sourceId, message, message).put("FORMAT_MISMATCH_PARAMS", (Object)ImportUtils.getMisMatchFormatDetails(sourceId));
            }
            responseBuilder.setCustomStatusMsg("ember_import_failure");
            String message = responseBuilder.resolveStatusMsg(locale).getResponseJson().getString("STATUS_MSG");
            return ProgressbarTransformUtil.getFailureStatusObject(sourceId, message, null);
        }
        catch (DataAccessException | JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAuditTableStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj.toString().equals(String.valueOf(12196L))) {
            return ImportTransformMethodHandler.resolveI18N("ela.importlog.success");
        }
        if (obj.toString().equals(String.valueOf(12197L)) || obj.toString().equals(String.valueOf(12200L))) {
            return ImportTransformMethodHandler.resolveI18N("ela.importlog.failed");
        }
        return null;
    }
}

