/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion;

import com.adventnet.ds.query.Column;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.data.conversion.DataConverter;
import com.manageengine.ela.server.common.data.conversion.TransformerDataCollector;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public class RowDataTransformer
extends TransformerDataCollector
implements DataConverter<Column, Object> {
    private static final Logger LOGGER = Logger.getLogger(RowDataTransformer.class.getName());
    private static final Cache<Long, DataConverter<Column, Object>> CACHE = new Cache();

    public static DataConverter<Column, Object> getTransformer(Long transformerID) throws BaseStatusCode {
        RowDataTransformer transformer = CACHE.get(transformerID);
        if (transformer == null) {
            transformer = new RowDataTransformer(transformerID);
            CACHE.put(transformerID, transformer);
        }
        return transformer;
    }

    private RowDataTransformer(Long transformId) throws BaseStatusCode {
        super(transformId);
    }

    @Override
    public Object transform(Object value, Map<Column, Object> data, Map<Object, Object> additionalArgs) {
        if (this.transFormerDefaultArguments != null) {
            additionalArgs.put(ConversionConstants.DEFAULT_ARGS, this.transFormerDefaultArguments);
        }
        if (super.getClassName() != null && super.getMethodName() != null) {
            try {
                Class<?> dynamicClass = Class.forName(super.getClassName());
                Method dynamicMethod = dynamicClass.getDeclaredMethod(super.getMethodName(), Object.class, Map.class, Map.class);
                return dynamicMethod.invoke(dynamicClass.newInstance(), value, data, additionalArgs);
            }
            catch (Exception exp) {
                LOGGER.fine("Exception in transformer : " + exp.getMessage());
            }
        }
        return value;
    }

    @Override
    protected void setTransFormerDefaultArguments(String[] transFormerDefaultArguments) {
        this.transFormerDefaultArguments = RowDataTransformer.getColumns(transFormerDefaultArguments);
    }

    private static Column[] getColumns(String[] strings) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String string : strings) {
            String[] parts = string.split("\\.", -1);
            if (parts.length != 2) continue;
            Column column = Column.getColumn((String)parts[0], (String)parts[1]);
            columns.add(column);
        }
        return columns.toArray(new Column[0]);
    }
}

