/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion;

import com.adventnet.ds.query.Column;
import com.adventnet.la.util.ProductBundle;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;

public class TransformMethodHandler {
    private static final Logger LOGGER = Logger.getLogger(TransformMethodHandler.class.getName());

    public Object convertToErrorStatusWithLink(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long statusCode;
        boolean isLiveCollection = false;
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        ResponseBuilder builder = new ResponseBuilder();
        try {
            statusCode = Long.valueOf(obj.toString());
        }
        catch (Exception e) {
            statusCode = 0L;
            LOGGER.log(Level.FINE, "Exception in data conversion");
        }
        LogCollectionStatus logCollectionstatus = this.getLogcollectionStatus(row, defaultArgs[0]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[2]);
        isLiveCollection = this.isLiveLogcollection(row, defaultArgs[1]);
        try {
            if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(9500));
            } else if (logCollectionstatus == LogCollectionStatus.DISABLED) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(4097));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.device.disabled");
            } else if (logCollectionstatus == LogCollectionStatus.SCANNING) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.devicescanning");
            } else if (logCollectionstatus == LogCollectionStatus.PING) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.deviceping");
            } else if (statusCode == 0L) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                if (isLiveCollection) {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.event.listening");
                } else {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.event.succcess");
                }
            } else {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(statusCode));
            }
        }
        catch (JSONException exp) {
            LOGGER.log(Level.FINE, "Exception in status update" + (Object)((Object)exp));
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public Object findDeviceGroupAction(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        ResponseBuilder builder = new ResponseBuilder();
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        long groupID = Long.parseLong(row.get(defaultArgs[0]).toString());
        if (groupID == DeviceGroupUtil.getDefaultGroupID()) {
            builder.addKeyPair("EDIT_ENABLED", Boolean.FALSE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.FALSE);
            builder.addKeyPair("NAME_ENABLED", Boolean.FALSE);
        } else if (groupID == DeviceGroupUtil.getWindowsGroupID() || groupID == DeviceGroupUtil.getUnixGroupID()) {
            builder.addKeyPair("EDIT_ENABLED", Boolean.TRUE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.FALSE);
            builder.addKeyPair("NAME_ENABLED", Boolean.FALSE);
        } else {
            builder.addKeyPair("EDIT_ENABLED", Boolean.TRUE);
            builder.addKeyPair("NAME_ENABLED", Boolean.TRUE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.TRUE);
        }
        return builder.getResponseJson();
    }

    public Object getDeviceCountFromGroup(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object groupID = row.get(defaultArgs[0]);
        return DeviceGroupUtil.getDeviceCount(groupID);
    }

    public Object convertDeviceType(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        LogSourceCategoryContainer.DeviceCategory category = LogSourceCategoryContainer.DeviceCategory.getCategory(obj.toString());
        if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
            return LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY.getCategoryName();
        }
        return category.getCategoryName();
    }

    public String convertToDate(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        long dateInMilliSec = 0L;
        SimpleDateFormat dateFormat = this.getDateFormat(additionalArgs, "MMM dd yyyy HH:mm");
        try {
            dateInMilliSec = Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in convertToDate" + e);
        }
        Date resultDate = new Date(dateInMilliSec);
        return dateFormat.format(resultDate);
    }

    public boolean isDeviceActive(Object object, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return !object.toString().equals("0");
    }

    public boolean isAgent(Object slid, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long sysEvtcolid = ServerDetailsBean.getInstance().getSysEvtColID();
        return sysEvtcolid != null && !slid.toString().equals(sysEvtcolid.toString());
    }

    public String getMonitorInterval(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        String result = null;
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        boolean isLiveCollection = this.isLiveLogcollection(row, defaultArgs[0]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[1]);
        try {
            result = category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN ? ProductBundle.getInstance().getString("ela.statuscode.displaytext.device.unknown.monitorinterval") : (!isLiveCollection ? String.valueOf(mins) + " " + ProductBundle.getInstance().getString("ela.discovery.display.unit.mins") : ProductBundle.getInstance().getString("ela.statuscode.displaytext.event.realtime"));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in getMonitorInterval" + e);
        }
        return result;
    }

    public Object getNextScanTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        ResponseBuilder builder = new ResponseBuilder();
        Object collectorID = row.get(defaultArgs[2]);
        boolean isLiveCollection = this.isLiveLogcollection(row, defaultArgs[3]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[5]);
        LogCollectionStatus logCollectionstatus = this.getLogcollectionStatus(row, defaultArgs[4]);
        if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.unknown.getnextscantime");
        } else if (logCollectionstatus == LogCollectionStatus.DISABLED) {
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.disabled.nextscan");
        } else if (isLiveCollection) {
            builder.addKeyPair("PINGNOW", "true");
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.live.nextscan");
        } else {
            if (collectorID != null && collectorID.toString().equals(String.valueOf(ServerDetailsBean.getInstance().getSysEvtColID()))) {
                builder.addKeyPair("SCANNOW", "true");
            }
            Calendar resultDate = this.getCalender(additionalArgs);
            SimpleDateFormat dateFormat = this.getDateFormat(additionalArgs, "MMM dd yyyy HH:mm");
            try {
                long dateInMilliSec = Long.parseLong(row.get(defaultArgs[0]).toString());
                resultDate.setTimeInMillis(dateInMilliSec);
            }
            catch (NumberFormatException e) {
                try {
                    resultDate.setTime(dateFormat.parse(row.get(defaultArgs[0]).toString()));
                }
                catch (ParseException e1) {
                    LOGGER.log(Level.FINE, "Exception while calculating next scan time");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while calculating next scan time interval");
            }
            resultDate.add(12, Integer.parseInt(row.get(defaultArgs[1]).toString()));
            try {
                if (resultDate.getTimeInMillis() <= System.currentTimeMillis()) {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.devicenextscanstatus");
                } else {
                    dateFormat.setCalendar(resultDate);
                    builder.setCustomStatusMsg(dateFormat.format(resultDate.getTime()));
                }
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINE, "Exception while calculating next scan time status update");
            }
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public String getNameFromDN(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        String distndName = obj.toString();
        try {
            return distndName.substring(distndName.indexOf("=") + 1, distndName.indexOf(","));
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception in DN 2 Name conversion");
            return distndName;
        }
    }

    private SimpleDateFormat getDateFormat(Map<Object, Object> additionalArgs, String format) {
        Object clientTimeZone = additionalArgs.get("clienttimezone");
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (clientTimeZone != null && clientTimeZone instanceof TimeZone) {
            TimeZone tz = (TimeZone)clientTimeZone;
            dateFormat.setTimeZone(tz);
        }
        return dateFormat;
    }

    private Calendar getCalender(Map<Object, Object> additionalArgs) {
        GregorianCalendar resultDate = new GregorianCalendar();
        Object clientTimeZone = additionalArgs.get("clienttimezone");
        if (clientTimeZone != null && clientTimeZone instanceof TimeZone) {
            TimeZone tz = (TimeZone)clientTimeZone;
            ((Calendar)resultDate).setTimeZone(tz);
        }
        return resultDate;
    }

    private boolean isLiveLogcollection(Map<Column, Object> row, Column key) {
        try {
            Object status = row.get(key);
            return status != null && NumberUtils.isNumber((String)status.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in parameter convertion");
            return false;
        }
    }

    private LogSourceCategoryContainer.DeviceCategory getDeviceCategory(Map<Column, Object> row, Column key) {
        return DeviceUtil.getDeviceCategory(row.get(key));
    }

    private LogCollectionStatus getLogcollectionStatus(Map<Column, Object> row, Column key) {
        return DeviceUtil.getLogCollectionStatus(row.get(key));
    }
}

