/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;

public class TransformerDataCollector {
    private String className = null;
    private String methodName = null;
    protected Object[] transFormerDefaultArguments = null;

    protected TransformerDataCollector(Long transformId) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ElaTransformConfigurations", (String)"TRANSFORM_ID"), (Object)transformId, 0);
            DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("ElaTransformConfigurations", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("ElaTransformConfigurations");
                this.setClassName(row.get("CLASS").toString());
                this.setMethodName(row.get("METHOD").toString());
                if (row.get("DEFAULT_ARGS") != null) {
                    this.setTransFormerDefaultArguments(row.get("DEFAULT_ARGS").toString().split(","));
                }
            }
        }
        catch (DataAccessException e) {
            throw BaseStatusCode.getBaseStatusCode(7431);
        }
    }

    public String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getTransFormerDefaultArguments() {
        return this.transFormerDefaultArguments;
    }

    protected void setTransFormerDefaultArguments(String[] transFormerDefaultArguments) {
        this.transFormerDefaultArguments = transFormerDefaultArguments;
    }

    public Object[] getArguments() {
        if (this.transFormerDefaultArguments != null && this.transFormerDefaultArguments.length > 0) {
            return this.transFormerDefaultArguments;
        }
        return null;
    }
}

