/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.data.conversion.util;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressbarTransformUtil {
    public static JSONObject getSuccessStatusObject(Long fileId, String msg, String subMsg, JSONObject params) throws JSONException {
        JSONObject content = ProgressbarTransformUtil.getContentJsonObject(msg, subMsg, null, null);
        JSONObject progress = ProgressbarTransformUtil.getProgessJsonObject(false, 100.0f);
        return ProgressbarTransformUtil.progressBarStatusObject(content, null, progress, null);
    }

    public static JSONObject getImportingStatusObject(Long fileId, String msg, float percentage) throws JSONException {
        JSONObject content = ProgressbarTransformUtil.getContentJsonObject(msg, null, null, null);
        JSONObject progress = ProgressbarTransformUtil.getProgessJsonObject(true, percentage);
        return ProgressbarTransformUtil.progressBarStatusObject(content, null, progress, null);
    }

    public static JSONObject getFailureStatusObject(Long fileId, String msg, String subMsg) throws JSONException {
        JSONObject content = ProgressbarTransformUtil.getContentJsonObject(msg, subMsg, "openTroubleshoot", null);
        JSONObject progress = ProgressbarTransformUtil.getProgessJsonObject(false, 0.0f);
        return ProgressbarTransformUtil.progressBarStatusObject(content, null, progress, null);
    }

    private static JSONObject progressBarStatusObject(JSONObject content, JSONObject style, JSONObject progress, JSONObject ... icons) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (content != null) {
            jsonObject.put("content", (Object)content);
        }
        if (style != null) {
            jsonObject.put("style", (Object)style);
        }
        if (progress != null) {
            jsonObject.put("progress", (Object)progress);
        }
        if (icons != null && icons.length > 0) {
            JSONArray iconsArray = new JSONArray();
            for (JSONObject icon : icons) {
                iconsArray.put((Object)icon);
            }
            jsonObject.put("icons", (Object)iconsArray);
        }
        return jsonObject;
    }

    private static JSONObject getContentJsonObject(String msg, String subMsg, String actionName, JSONObject actionParams) throws JSONException {
        return new JSONObject().put("message", (Object)msg).put("sub_msg", (Object)subMsg);
    }

    private static JSONObject getProgessJsonObject(boolean isShowing, float percentage) throws JSONException {
        return new JSONObject().put("show", isShowing).put("percentage", (double)percentage);
    }

    public static JSONObject getProcessingStatusObject(Long fileId, String msg, String subMsg) throws JSONException {
        JSONObject content = ProgressbarTransformUtil.getContentJsonObject(msg, null, null, null);
        JSONObject progress = ProgressbarTransformUtil.getProgessJsonObject(false, 0.0f);
        return ProgressbarTransformUtil.progressBarStatusObject(content, null, progress, null);
    }

    public static JSONObject getFormatMismatchStatusObject(Long fileId, String message, String message1) throws JSONException {
        JSONObject actionParams = new JSONObject().put("FILE_ID", (Object)fileId);
        JSONObject content = ProgressbarTransformUtil.getContentJsonObject(message, null, "openFormatMismatch", actionParams);
        JSONObject progress = ProgressbarTransformUtil.getProgessJsonObject(false, 0.0f);
        return ProgressbarTransformUtil.progressBarStatusObject(content, null, progress, null);
    }
}

