/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database;

import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBCleanupProcessor
implements Task {
    private static final Logger LOGGER = Logger.getLogger(DBCleanupProcessor.class.getName());
    private static final List<Task> TASK_LIST = Collections.synchronizedList(new ArrayList());
    private static final Lock LOCK = new ReentrantLock();

    public static void registerCleanupTask(Task task) {
        LOCK.lock();
        try {
            TASK_LIST.add(task);
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void removeCleanupTask(Task task) {
        LOCK.lock();
        try {
            TASK_LIST.remove(task);
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext taskContext) {
        LOCK.lock();
        try {
            LOGGER.log(Level.INFO, "DB Cold data cleanup process started. Number of tasks = {0}", TASK_LIST.size());
            for (Task task : TASK_LIST) {
                task.executeTask(taskContext);
            }
            LOGGER.log(Level.INFO, "DB Cold data cleanup completed.");
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception occurred during processing cold data {0}", exp.getMessage());
        }
        finally {
            LOCK.unlock();
        }
    }

    public void stopTask() {
        LOCK.lock();
        try {
            for (Task task : TASK_LIST) {
                task.stopTask();
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception occurred during processing cold data {0}", exp.getMessage());
        }
        finally {
            LOCK.unlock();
        }
    }
}

