/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database;

import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.handlers.DataBaseHandlerFactory;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.io.file.FileHandler;
import java.util.logging.Logger;

public class DataBaseBulkUploader
extends ConcurrentQueueProcessor<String> {
    private static final Logger LOGGER = Logger.getLogger(DataBaseBulkUploader.class.getName());
    private BulkUploadDetailsBean bean = null;
    private static DataBaseSpecificActions handler = null;

    public DataBaseBulkUploader(ConcurrentQueue<String> queue, BulkUploadDetailsBean bean) {
        super(queue);
        this.bean = bean;
    }

    @Override
    public void postInvoke() {
        super.postInvoke();
        LOGGER.info("DataBaseBulkUploader Exited process ");
    }

    @Override
    public void process(String data) throws Exception {
        this.processFile(handler, data);
    }

    private void processFile(DataBaseSpecificActions handler, String file) throws InterruptedException {
        try {
            boolean uploadStatus = true;
            String query = handler.loadDumpDataQuery(this.bean, file);
            LOGGER.info("Going to process Query :" + handler.getDebugDumpQuery(query));
            if (query != null) {
                uploadStatus = handler.dumpData(query);
            }
            if (uploadStatus) {
                LOGGER.info("Dump Query SuccessFully processed :" + handler.getDebugDumpQuery(query));
                if (this.bean.isDeleteAfterDump()) {
                    FileHandler.deleteFile(file);
                }
            } else {
                LOGGER.info("Dump Query Failed :" + handler.getDebugDumpQuery(query));
            }
        }
        catch (IllegalArgumentException exp) {
            LOGGER.info("Exception while file processing : " + exp.getMessage());
        }
    }

    static {
        handler = DataBaseHandlerFactory.getInstance().getDataBaseHandler();
    }
}

