/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DataBaseBulkUploader;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.handlers.DataBaseHandlerFactory;
import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.logging.Logger;

public class DatabaseBulkUploadHandler {
    private static final Logger LOGGER = Logger.getLogger(DatabaseBulkUploadHandler.class.getName());

    public static void clearOldComputerEntries(String tableName, String columnName, Object identityOrUniqueKey) throws DataAccessException {
        LOGGER.info("clearOldComputerEntries called for table :" + tableName);
        long time = System.currentTimeMillis();
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)columnName), identityOrUniqueKey, 0);
        DBUtil.deleteExistingRows(tableName, criteria, false);
        LOGGER.info("Time taken to flush old Data :" + (System.currentTimeMillis() - time));
    }

    public static CommonQueueProcessor<String> createNewBulkUploader(ConcurrentQueue<String> queue, String targetTableName, String columnOrder) {
        DataBaseSpecificActions handler = DataBaseHandlerFactory.getInstance().getDataBaseHandler();
        BulkUploadDetailsBean bean = new BulkUploadDetailsBean();
        DatabaseBulkUploadHandler.loadDetailsBean(bean, targetTableName, columnOrder);
        bean.setFieldTerminator(handler.getFieldDelimiter());
        bean.setLineTerminator(ServerDetailsBean.getLineSeparator());
        bean.setEncloseChar(handler.getEncloseChar());
        return DatabaseBulkUploadHandler.createNewBulkUploader(queue, bean);
    }

    public static CommonQueueProcessor<String> createNewBulkUploader(ConcurrentQueue<String> queue, BulkUploadDetailsBean bean) {
        DataBaseBulkUploader uploader = new DataBaseBulkUploader(queue, bean);
        Thread thred = uploader.start();
        thred.setName(DataBaseBulkUploader.class.getName());
        return uploader;
    }

    public static void loadDetailsBean(BulkUploadDetailsBean bean, String targetTableName, String columnOrder) {
        bean.setColumnOrder(columnOrder);
        bean.setTableName(targetTableName);
    }
}

