/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.util.StringUtil;
import java.net.URI;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class DefaultDatabaseHandler
implements DataBaseSpecificActions {
    protected String dbName = null;
    protected String dbPort = null;
    protected String dbServer = null;
    protected String userName = null;
    protected String password = null;
    protected String connectionURL = null;
    protected String instanceName = null;
    protected String domain = null;
    protected final ReentrantLock lock = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(DefaultDatabaseHandler.class.getName());

    public DefaultDatabaseHandler() {
        this.init();
    }

    public DataBaseSpecificActions init() {
        Properties dbProp = PersistenceInitializer.getDefaultDBProps();
        this.connectionURL = dbProp.getProperty("url");
        this.connectionURL = this.connectionURL.replaceAll(" ", "");
        try {
            URI uri = new URI(this.connectionURL.substring(10));
            if (uri.getHost() == null || uri.getPort() == -1) {
                throw new Exception("URI parsing fails.going to parse manually");
            }
            this.dbServer = uri.getHost();
            this.dbPort = Integer.toString(uri.getPort());
            this.dbName = uri.getPath().substring(1);
            if (this.dbName.contains(";")) {
                this.dbName = this.dbName.substring(0, this.dbName.indexOf(";"));
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while database Initialization :" + e.getMessage());
            this.dbServer = this.connectionURL.substring(this.connectionURL.indexOf("://") + 3);
            this.dbName = this.dbServer.substring(this.dbServer.indexOf("/") + 1);
            if (this.dbName.contains(";")) {
                this.dbName = this.dbName.substring(0, this.dbName.indexOf(";"));
            }
            if (this.dbServer.indexOf(":") != -1) {
                this.dbPort = this.dbServer.substring(this.dbServer.indexOf(":") + 1, this.dbServer.indexOf("/"));
                this.dbServer = this.dbServer.substring(0, this.dbServer.indexOf(":"));
            }
            this.dbServer = this.dbServer.substring(0, this.dbServer.indexOf("/"));
        }
        this.userName = dbProp.getProperty("username");
        this.password = dbProp.getProperty("password");
        return this;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getServer() {
        return this.dbServer;
    }

    @Override
    public String getDataBaseName() {
        return this.dbName;
    }

    @Override
    public String getPort() {
        return this.dbPort;
    }

    @Override
    public String getConnectionURL() {
        return this.connectionURL;
    }

    @Override
    public String getFieldDelimiter() {
        return "\t";
    }

    @Override
    public String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    @Override
    public String getEscapedString(String value) {
        String quotedString = StringUtil.getEscapedString(value);
        return quotedString;
    }

    @Override
    public String getDebugDumpQuery(String query) {
        return query;
    }

    @Override
    public String getNullValue() {
        return "\\N";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQuery(String sql) {
        boolean status = true;
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        try {
            con = rapi.getConnection();
            stmt = con.createStatement();
            LOGGER.fine("Dumping the file with sql : " + sql);
            int recordCount = stmt.executeUpdate(sql);
            LOGGER.info("Uploaded recordCount : " + recordCount);
        }
        catch (Exception exp) {
            try {
                status = false;
                LOGGER.info("Exception while execute query : " + exp.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeStmtAndConnection(stmt, con);
                throw throwable;
            }
            DBUtil.closeStmtAndConnection(stmt, con);
        }
        DBUtil.closeStmtAndConnection(stmt, con);
        return status;
    }

    public String justify(String data) {
        String result = "";
        if (data != null) {
            result = data;
        }
        return result;
    }
}

