/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database;

import com.adventnet.db.api.RelationalAPI;
import java.sql.Connection;
import java.sql.Statement;

public class PGSQLServerFunctions {
    public static String sqlFunctionDecryptSCharCheck = "DROP FUNCTION IF EXISTS decryptschar(bytea,text);";
    public static String sqlFunctionDecryptSChar = "CREATE FUNCTION decryptschar(data bytea, key text) RETURNS citext AS $BODY$ BEGIN RETURN pgp_sym_decrypt(data, key,'s2k-mode=1,cipher-algo=aes256'); EXCEPTION WHEN external_routine_invocation_exception THEN RAISE DEBUG USING MESSAGE = format('Decryption failed: SQLSTATE %s, Msg: %s',SQLSTATE,SQLERRM), HINT = 'pgp_sym_decrypt() failed; Either the data is corrupt or the Encryption key is wrong', ERRCODE = 'external_routine_invocation_exception'; RETURN NULL; END; $BODY$ LANGUAGE plpgsql VOLATILE";
    public static String sqlFunctionDecryptSBlobCheck = "DROP FUNCTION IF EXISTS decryptsblob(bytea,text);";
    public static String sqlFunctionDecryptSBlob = "CREATE FUNCTION decryptsblob(data bytea, key text) RETURNS bytea AS $BODY$ BEGIN RETURN pgp_sym_decrypt_bytea(data, key,'s2k-mode=1,cipher-algo=aes256'); EXCEPTION WHEN external_routine_invocation_exception THEN RAISE DEBUG USING MESSAGE = format('Decryption failed: SQLSTATE %s, Msg: %s',SQLSTATE,SQLERRM), HINT = 'pgp_sym_decrypt_bytea() failed; Either the data is corrupt or the Encryption key is wrong', ERRCODE = 'external_routine_invocation_exception'; RETURN NULL; END; $BODY$   LANGUAGE plpgsql VOLATILE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSQLFunctions() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        Statement pstmt1 = null;
        Statement pstmt2 = null;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            stmt = conn.createStatement();
            stmt.execute(sqlFunctionDecryptSCharCheck);
            stmt.execute(sqlFunctionDecryptSChar);
            stmt.execute(sqlFunctionDecryptSBlobCheck);
            stmt.execute(sqlFunctionDecryptSBlob);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (pstmt1 != null) {
                pstmt1.close();
            }
            if (pstmt2 != null) {
                pstmt2.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

